/*   
 *   This is part of Remote System Call (RSC) Library.
 *
 *   nr_to_rsc.h: __NR_* to __RSC_* constants conversion header 
 *   
 *   Copyright (C) 2007 Andrea Forni
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License, version 2, as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 */
#ifndef __NR_TO_RSC_HEADER__
#define __NR_TO_RSC_HEADER__
#include <stdlib.h>
#include "rsc_consts.h"

/* SYS_ values are equal in each architecture,
 * so a single table is sufficent. */
#define SYS_TO_RSC_SIZE	((sizeof(sys_to_rsc))/(sizeof(int32_t)))
int32_t sys_to_rsc[] = {
	/* 0. Isn't used */ __RSC_ERROR,
	/* 1. SYS_SOCKET */ __RSC_socket,
	/* 2. SYS_BIND	*/ __RSC_bind,
	/* 3. SYS_CONNECT */ __RSC_connect,
	/* 4. SYS_LISTEN */ __RSC_listen,
	/* 5. SYS_ACCEPT */ __RSC_accept,
	/* 6. SYS_GETSOCKNAME */ __RSC_getsockname,
	/* 7. SYS_GETPEERNAME */ __RSC_getpeername,
	/* 8. SYS_SOCKETPAIR */ __RSC_socketpair,
	/* 9. SYS_SEND */ __RSC_send,
	/* 10. SYS_RECV */ __RSC_recv,
	/* 11. SYS_SENDTO */ __RSC_sendto,
	/* 12. SYS_RECVFROM */ __RSC_recvfrom,
	/* 13. SYS_SHUTDOWN */ __RSC_shutdown,
	/* 14. SYS_SETSOCKOPT */ __RSC_setsockopt,
	/* 15. SYS_GETSOCKOPT */ __RSC_getsockopt,
	/* 16. SYS_SENDMSG */ __RSC_sendmsg,
	/* 17 SYS_RECVMSG */ __RSC_recvmsg
};
 
#define  X86_TO_RSC_SIZE	((sizeof(x86_to_rsc))/(sizeof(enum rsc_constant)))
enum rsc_constant x86_to_rsc[] = {
	/* 0. __NR_restart_syscall */ __RSC_restart_syscall,
	/* 1. __NR_exit */ __RSC_exit,
	/* 2. __NR_fork */ __RSC_fork,
	/* 3. __NR_read */ __RSC_read,
	/* 4. __NR_write */ __RSC_write,
	/* 5. __NR_open */ __RSC_open,
	/* 6. __NR_close */ __RSC_close,
	/* 7. __NR_waitpid */ __RSC_waitpid,
	/* 8. __NR_creat */ __RSC_creat,
	/* 9. __NR_link */ __RSC_link,
	/* 10. __NR_unlink */ __RSC_unlink,
	/* 11. __NR_execve */ __RSC_execve,
	/* 12. __NR_chdir */ __RSC_chdir,
	/* 13. __NR_time */ __RSC_time,
	/* 14. __NR_mknod */ __RSC_mknod,
	/* 15. __NR_chmod */ __RSC_chmod,
	/* 16. __NR_lchown */ __RSC_lchown,
	/* 17. __NR_break */ __RSC_break,
	/* 18. __NR_oldstat */ __RSC_oldstat,
	/* 19. __NR_lseek */ __RSC_lseek,
	/* 20. __NR_getpid */ __RSC_getpid,
	/* 21. __NR_mount */ __RSC_mount,
	/* 22. __NR_umount */ __RSC_umount,
	/* 23. __NR_setuid */ __RSC_setuid,
	/* 24. __NR_getuid */ __RSC_getuid,
	/* 25. __NR_stime */ __RSC_stime,
	/* 26. __NR_ptrace */ __RSC_ptrace,
	/* 27. __NR_alarm */ __RSC_alarm,
	/* 28. __NR_oldfstat */ __RSC_oldfstat,
	/* 29. __NR_pause */ __RSC_pause,
	/* 30. __NR_utime */ __RSC_utime,
	/* 31. __NR_stty */ __RSC_stty,
	/* 32. __NR_gtty */ __RSC_gtty,
	/* 33. __NR_access */ __RSC_access,
	/* 34. __NR_nice */ __RSC_nice,
	/* 35. __NR_ftime */ __RSC_ftime,
	/* 36. __NR_sync */ __RSC_sync,
	/* 37. __NR_kill */ __RSC_kill,
	/* 38. __NR_rename */ __RSC_rename,
	/* 39. __NR_mkdir */ __RSC_mkdir,
	/* 40. __NR_rmdir */ __RSC_rmdir,
	/* 41. __NR_dup */ __RSC_dup,
	/* 42. __NR_pipe */ __RSC_pipe,
	/* 43. __NR_times */ __RSC_times,
	/* 44. __NR_prof */ __RSC_prof,
	/* 45. __NR_brk */ __RSC_brk,
	/* 46. __NR_setgid */ __RSC_setgid,
	/* 47. __NR_getgid */ __RSC_getgid,
	/* 48. __NR_signal */ __RSC_signal,
	/* 49. __NR_geteuid */ __RSC_geteuid,
	/* 50. __NR_getegid */ __RSC_getegid,
	/* 51. __NR_acct */ __RSC_acct,
	/* 52. __NR_umount2 */ __RSC_umount2,
	/* 53. __NR_lock */ __RSC_lock,
	/* 54. __NR_ioctl */ __RSC_ioctl,
	/* 55. __NR_fcntl */ __RSC_fcntl,
	/* 56. __NR_mpx */ __RSC_mpx,
	/* 57. __NR_setpgid */ __RSC_setpgid,
	/* 58. __NR_ulimit */ __RSC_ulimit,
	/* 59. __NR_oldolduname */ __RSC_oldolduname,
	/* 60. __NR_umask */ __RSC_umask,
	/* 61. __NR_chroot */ __RSC_chroot,
	/* 62. __NR_ustat */ __RSC_ustat,
	/* 63. __NR_dup2 */ __RSC_dup2,
	/* 64. __NR_getppid */ __RSC_getppid,
	/* 65. __NR_getpgrp */ __RSC_getpgrp,
	/* 66. __NR_setsid */ __RSC_setsid,
	/* 67. __NR_sigaction */ __RSC_sigaction,
	/* 68. __NR_sgetmask */ __RSC_sgetmask,
	/* 69. __NR_ssetmask */ __RSC_ssetmask,
	/* 70. __NR_setreuid */ __RSC_setreuid,
	/* 71. __NR_setregid */ __RSC_setregid,
	/* 72. __NR_sigsuspend */ __RSC_sigsuspend,
	/* 73. __NR_sigpending */ __RSC_sigpending,
	/* 74. __NR_sethostname */ __RSC_sethostname,
	/* 75. __NR_setrlimit */ __RSC_setrlimit,
	/* 76. __NR_getrlimit */ __RSC_getrlimit,
	/* 77. __NR_getrusage */ __RSC_getrusage,
	/* 78. __NR_gettimeofday */ __RSC_gettimeofday,
	/* 79. __NR_settimeofday */ __RSC_settimeofday,
	/* 80. __NR_getgroups */ __RSC_getgroups,
	/* 81. __NR_setgroups */ __RSC_setgroups,
	/* 82. __NR_select */ __RSC_select,
	/* 83. __NR_symlink */ __RSC_symlink,
	/* 84. __NR_oldlstat */ __RSC_oldlstat,
	/* 85. __NR_readlink */ __RSC_readlink,
	/* 86. __NR_uselib */ __RSC_uselib,
	/* 87. __NR_swapon */ __RSC_swapon,
	/* 88. __NR_reboot */ __RSC_reboot,
	/* 89. __NR_readdir */ __RSC_readdir,
	/* 90. __NR_mmap */ __RSC_mmap,
	/* 91. __NR_munmap */ __RSC_munmap,
	/* 92. __NR_truncate */ __RSC_truncate,
	/* 93. __NR_ftruncate */ __RSC_ftruncate,
	/* 94. __NR_fchmod */ __RSC_fchmod,
	/* 95. __NR_fchown */ __RSC_fchown,
	/* 96. __NR_getpriority */ __RSC_getpriority,
	/* 97. __NR_setpriority */ __RSC_setpriority,
	/* 98. __NR_profil */ __RSC_profil,
	/* 99. __NR_statfs */ __RSC_statfs,
	/* 100. __NR_fstatfs */ __RSC_fstatfs,
	/* 101. __NR_ioperm */ __RSC_ioperm,
	/* 102. __NR_socketcall */ __RSC_socketcall,
	/* 103. __NR_syslog */ __RSC_syslog,
	/* 104. __NR_setitimer */ __RSC_setitimer,
	/* 105. __NR_getitimer */ __RSC_getitimer,
	/* 106. __NR_stat */ __RSC_stat,
	/* 107. __NR_lstat */ __RSC_lstat,
	/* 108. __NR_fstat */ __RSC_fstat,
	/* 109. __NR_olduname */ __RSC_olduname,
	/* 110. __NR_iopl */ __RSC_iopl,
	/* 111. __NR_vhangup */ __RSC_vhangup,
	/* 112. __NR_idle */ __RSC_idle,
	/* 113. __NR_vm86old */ __RSC_vm86old,
	/* 114. __NR_wait4 */ __RSC_wait4,
	/* 115. __NR_swapoff */ __RSC_swapoff,
	/* 116. __NR_sysinfo */ __RSC_sysinfo,
	/* 117. __NR_ipc */ __RSC_ipc,
	/* 118. __NR_fsync */ __RSC_fsync,
	/* 119. __NR_sigreturn */ __RSC_sigreturn,
	/* 120. __NR_clone */ __RSC_clone,
	/* 121. __NR_setdomainname */ __RSC_setdomainname,
	/* 122. __NR_uname */ __RSC_uname,
	/* 123. __NR_modify_ldt */ __RSC_modify_ldt,
	/* 124. __NR_adjtimex */ __RSC_adjtimex,
	/* 125. __NR_mprotect */ __RSC_mprotect,
	/* 126. __NR_sigprocmask */ __RSC_sigprocmask,
	/* 127. __NR_create_module */ __RSC_create_module,
	/* 128. __NR_init_module */ __RSC_init_module,
	/* 129. __NR_delete_module */ __RSC_delete_module,
	/* 130. __NR_get_kernel_syms */ __RSC_get_kernel_syms,
	/* 131. __NR_quotactl */ __RSC_quotactl,
	/* 132. __NR_getpgid */ __RSC_getpgid,
	/* 133. __NR_fchdir */ __RSC_fchdir,
	/* 134. __NR_bdflush */ __RSC_bdflush,
	/* 135. __NR_sysfs */ __RSC_sysfs,
	/* 136. __NR_personality */ __RSC_personality,
	/* 137. __NR_afs_syscall */ __RSC_afs_syscall,
	/* 138. __NR_setfsuid */ __RSC_setfsuid,
	/* 139. __NR_setfsgid */ __RSC_setfsgid,
	/* 140. __NR__llseek */ __RSC__llseek,
	/* 141. __NR_getdents */ __RSC_getdents,
	/* 142. __NR__newselect */ __RSC__newselect,
	/* 143. __NR_flock */ __RSC_flock,
	/* 144. __NR_msync */ __RSC_msync,
	/* 145. __NR_readv */ __RSC_readv,
	/* 146. __NR_writev */ __RSC_writev,
	/* 147. __NR_getsid */ __RSC_getsid,
	/* 148. __NR_fdatasync */ __RSC_fdatasync,
	/* 149. __NR__sysctl */ __RSC__sysctl,
	/* 150. __NR_mlock */ __RSC_mlock,
	/* 151. __NR_munlock */ __RSC_munlock,
	/* 152. __NR_mlockall */ __RSC_mlockall,
	/* 153. __NR_munlockall */ __RSC_munlockall,
	/* 154. __NR_sched_setparam */ __RSC_sched_setparam,
	/* 155. __NR_sched_getparam */ __RSC_sched_getparam,
	/* 156. __NR_sched_setscheduler */ __RSC_sched_setscheduler,
	/* 157. __NR_sched_getscheduler */ __RSC_sched_getscheduler,
	/* 158. __NR_sched_yield */ __RSC_sched_yield,
	/* 159. __NR_sched_get_priority_max */ __RSC_sched_get_priority_max,
	/* 160. __NR_sched_get_priority_min */ __RSC_sched_get_priority_min,
	/* 161. __NR_sched_rr_get_interval */ __RSC_sched_rr_get_interval,
	/* 162. __NR_nanosleep */ __RSC_nanosleep,
	/* 163. __NR_mremap */ __RSC_mremap,
	/* 164. __NR_setresuid */ __RSC_setresuid,
	/* 165. __NR_getresuid */ __RSC_getresuid,
	/* 166. __NR_vm86 */ __RSC_vm86,
	/* 167. __NR_query_module */ __RSC_query_module,
	/* 168. __NR_poll */ __RSC_poll,
	/* 169. __NR_nfsservctl */ __RSC_nfsservctl,
	/* 170. __NR_setresgid */ __RSC_setresgid,
	/* 171. __NR_getresgid */ __RSC_getresgid,
	/* 172. __NR_prctl */ __RSC_prctl,
	/* 173. __NR_rt_sigreturn */ __RSC_rt_sigreturn,
	/* 174. __NR_rt_sigaction */ __RSC_rt_sigaction,
	/* 175. __NR_rt_sigprocmask */ __RSC_rt_sigprocmask,
	/* 176. __NR_rt_sigpending */ __RSC_rt_sigpending,
	/* 177. __NR_rt_sigtimedwait */ __RSC_rt_sigtimedwait,
	/* 178. __NR_rt_sigqueueinfo */ __RSC_rt_sigqueueinfo,
	/* 179. __NR_rt_sigsuspend */ __RSC_rt_sigsuspend,
	/* 180. __NR_pread64 */ __RSC_pread64,
	/* 181. __NR_pwrite64 */ __RSC_pwrite64,
	/* 182. __NR_chown */ __RSC_chown,
	/* 183. __NR_getcwd */ __RSC_getcwd,
	/* 184. __NR_capget */ __RSC_capget,
	/* 185. __NR_capset */ __RSC_capset,
	/* 186. __NR_sigaltstack */ __RSC_sigaltstack,
	/* 187. __NR_sendfile */ __RSC_sendfile,
	/* 188. __NR_getpmsg */ __RSC_getpmsg,
	/* 189. __NR_putpmsg */ __RSC_putpmsg,
	/* 190. __NR_vfork */ __RSC_vfork,
	/* 191. __NR_ugetrlimit */ __RSC_ugetrlimit,
	/* 192. __NR_mmap2 */ __RSC_mmap2,
	/* 193. __NR_truncate64 */ __RSC_truncate64,
	/* 194. __NR_ftruncate64 */ __RSC_ftruncate64,
	/* 195. __NR_stat64 */ __RSC_stat64,
	/* 196. __NR_lstat64 */ __RSC_lstat64,
	/* 197. __NR_fstat64 */ __RSC_fstat64,
	/* 198. __NR_lchown32 */ __RSC_lchown32,
	/* 199. __NR_getuid32 */ __RSC_getuid32,
	/* 200. __NR_getgid32 */ __RSC_getgid32,
	/* 201. __NR_geteuid32 */ __RSC_geteuid32,
	/* 202. __NR_getegid32 */ __RSC_getegid32,
	/* 203. __NR_setreuid32 */ __RSC_setreuid32,
	/* 204. __NR_setregid32 */ __RSC_setregid32,
	/* 205. __NR_getgroups32 */ __RSC_getgroups32,
	/* 206. __NR_setgroups32 */ __RSC_setgroups32,
	/* 207. __NR_fchown32 */ __RSC_fchown32,
	/* 208. __NR_setresuid32 */ __RSC_setresuid32,
	/* 209. __NR_getresuid32 */ __RSC_getresuid32,
	/* 210. __NR_setresgid32 */ __RSC_setresgid32,
	/* 211. __NR_getresgid32 */ __RSC_getresgid32,
	/* 212. __NR_chown32 */ __RSC_chown32,
	/* 213. __NR_setuid32 */ __RSC_setuid32,
	/* 214. __NR_setgid32 */ __RSC_setgid32,
	/* 215. __NR_setfsuid32 */ __RSC_setfsuid32,
	/* 216. __NR_setfsgid32 */ __RSC_setfsgid32,
	/* 217. __NR_pivot_root */ __RSC_pivot_root,
	/* 218. __NR_mincore */ __RSC_mincore,
	/* 219. __NR_madvise1 */ __RSC_madvise1,
	/* 220. __NR_getdents64 */ __RSC_getdents64,
	/* 221. __NR_fcntl64 */ __RSC_fcntl64,
	/* 222. NOT USED */ __RSC_ERROR,
	/* 223. NOT USED */ __RSC_ERROR,
	/* 224. __NR_gettid */ __RSC_gettid,
	/* 225. __NR_readahead */ __RSC_readahead,
	/* 226. __NR_setxattr */ __RSC_setxattr,
	/* 227. __NR_lsetxattr */ __RSC_lsetxattr,
	/* 228. __NR_fsetxattr */ __RSC_fsetxattr,
	/* 229. __NR_getxattr */ __RSC_getxattr,
	/* 230. __NR_lgetxattr */ __RSC_lgetxattr,
	/* 231. __NR_fgetxattr */ __RSC_fgetxattr,
	/* 232. __NR_listxattr */ __RSC_listxattr,
	/* 233. __NR_llistxattr */ __RSC_llistxattr,
	/* 234. __NR_flistxattr */ __RSC_flistxattr,
	/* 235. __NR_removexattr */ __RSC_removexattr,
	/* 236. __NR_lremovexattr */ __RSC_lremovexattr,
	/* 237. __NR_fremovexattr */ __RSC_fremovexattr,
	/* 238. __NR_tkill */ __RSC_tkill,
	/* 239. __NR_sendfile64 */ __RSC_sendfile64,
	/* 240. __NR_futex */ __RSC_futex,
	/* 241. __NR_sched_setaffinity */ __RSC_sched_setaffinity,
	/* 242. __NR_sched_getaffinity */ __RSC_sched_getaffinity,
	/* 243. __NR_set_thread_area */ __RSC_set_thread_area,
	/* 244. __NR_get_thread_area */ __RSC_get_thread_area,
	/* 245. __NR_io_setup */ __RSC_io_setup,
	/* 246. __NR_io_destroy */ __RSC_io_destroy,
	/* 247. __NR_io_getevents */ __RSC_io_getevents,
	/* 248. __NR_io_submit */ __RSC_io_submit,
	/* 249. __NR_io_cancel */ __RSC_io_cancel,
	/* 250. __NR_fadvise64 */ __RSC_fadvise64,
	/* 251. NOT USED */ __RSC_ERROR,
	/* 252. __NR_exit_group */ __RSC_exit_group,
	/* 253. __NR_lookup_dcookie */ __RSC_lookup_dcookie,
	/* 254. __NR_epoll_create */ __RSC_epoll_create,
	/* 255. __NR_epoll_ctl */ __RSC_epoll_ctl,
	/* 256. __NR_epoll_wait */ __RSC_epoll_wait,
	/* 257. __NR_remap_file_pages */ __RSC_remap_file_pages,
	/* 258. __NR_set_tid_address */ __RSC_set_tid_address,
	/* 259. __NR_timer_create */ __RSC_timer_create,
	/* 260. __NR_timer_settime */ __RSC_timer_settime,
	/* 261. __NR_timer_gettime */ __RSC_timer_gettime,
	/* 262. __NR_timer_getoverrun */ __RSC_timer_getoverrun,
	/* 263. __NR_timer_delete */ __RSC_timer_delete,
	/* 264. __NR_clock_settime */ __RSC_clock_settime,
	/* 265. __NR_clock_gettime */ __RSC_clock_gettime,
	/* 266. __NR_clock_getres */ __RSC_clock_getres,
	/* 267. __NR_clock_nanosleep */ __RSC_clock_nanosleep,
	/* 268. __NR_statfs64 */ __RSC_statfs64,
	/* 269. __NR_fstatfs64 */ __RSC_fstatfs64,
	/* 270. __NR_tgkill */ __RSC_tgkill,
	/* 271. __NR_utimes */ __RSC_utimes,
	/* 272. __NR_fadvise64_64 */ __RSC_fadvise64_64,
	/* 273. __NR_vserver */ __RSC_vserver,
	/* 274. __NR_mbind */ __RSC_mbind,
	/* 275. __NR_get_mempolicy */ __RSC_get_mempolicy,
	/* 276. __NR_set_mempolicy */ __RSC_set_mempolicy,
	/* 277. __NR_mq_open */ __RSC_mq_open,
	/* 278. __NR_mq_unlink */ __RSC_mq_unlink,
	/* 279. __NR_mq_timedsend */ __RSC_mq_timedsend,
	/* 280. __NR_mq_timedreceive */ __RSC_mq_timedreceive,
	/* 281. __NR_mq_notify */ __RSC_mq_notify,
	/* 282. __NR_mq_getsetattr */ __RSC_mq_getsetattr,
	/* 283. __NR_sys_kexec_load */ __RSC_sys_kexec_load,
	/* 284. __NR_waitid */ __RSC_waitid,
	/* 285. NOT USED */ __RSC_ERROR,
	/* 286. __NR_add_key */ __RSC_add_key,
	/* 287. __NR_request_key */ __RSC_request_key,
	/* 288. __NR_keyctl */ __RSC_keyctl
};

#define  X86_64_TO_RSC_SIZE	((sizeof(x86_64_to_rsc))/(sizeof(enum rsc_constant)))
enum rsc_constant x86_64_to_rsc[] = {
	/* 0. __NR_read */ __RSC_read,
	/* 1. __NR_write */ __RSC_write,
	/* 2. __NR_open */ __RSC_open,
	/* 3. __NR_close */ __RSC_close,
	/* 4. __NR_stat */ __RSC_stat,
	/* 5. __NR_fstat */ __RSC_fstat,
	/* 6. __NR_lstat */ __RSC_lstat,
	/* 7. __NR_poll */ __RSC_poll,
	/* 8. __NR_lseek */ __RSC_lseek,
	/* 9. __NR_mmap */ __RSC_mmap,
	/* 10. __NR_mprotect */ __RSC_mprotect,
	/* 11. __NR_munmap */ __RSC_munmap,
	/* 12. __NR_brk */ __RSC_brk,
	/* 13. __NR_rt_sigaction */ __RSC_rt_sigaction,
	/* 14. __NR_rt_sigprocmask */ __RSC_rt_sigprocmask,
	/* 15. __NR_rt_sigreturn */ __RSC_rt_sigreturn,
	/* 16. __NR_ioctl */ __RSC_ioctl,
	/* 17. __NR_pread64 */ __RSC_pread64,
	/* 18. __NR_pwrite64 */ __RSC_pwrite64,
	/* 19. __NR_readv */ __RSC_readv,
	/* 20. __NR_writev */ __RSC_writev,
	/* 21. __NR_access */ __RSC_access,
	/* 22. __NR_pipe */ __RSC_pipe,
	/* 23. __NR_select */ __RSC_select,
	/* 24. __NR_sched_yield */ __RSC_sched_yield,
	/* 25. __NR_mremap */ __RSC_mremap,
	/* 26. __NR_msync */ __RSC_msync,
	/* 27. __NR_mincore */ __RSC_mincore,
	/* 28. __NR_madvise */ __RSC_madvise,
	/* 29. __NR_shmget */ __RSC_shmget,
	/* 30. __NR_shmat */ __RSC_shmat,
	/* 31. __NR_shmctl */ __RSC_shmctl,
	/* 32. __NR_dup */ __RSC_dup,
	/* 33. __NR_dup2 */ __RSC_dup2,
	/* 34. __NR_pause */ __RSC_pause,
	/* 35. __NR_nanosleep */ __RSC_nanosleep,
	/* 36. __NR_getitimer */ __RSC_getitimer,
	/* 37. __NR_alarm */ __RSC_alarm,
	/* 38. __NR_setitimer */ __RSC_setitimer,
	/* 39. __NR_getpid */ __RSC_getpid,
	/* 40. __NR_sendfile */ __RSC_sendfile,
	/* 41. __NR_socket */ __RSC_socket,
	/* 42. __NR_connect */ __RSC_connect,
	/* 43. __NR_accept */ __RSC_accept,
	/* 44. __NR_sendto */ __RSC_sendto,
	/* 45. __NR_recvfrom */ __RSC_recvfrom,
	/* 46. __NR_sendmsg */ __RSC_sendmsg,
	/* 47. __NR_recvmsg */ __RSC_recvmsg,
	/* 48. __NR_shutdown */ __RSC_shutdown,
	/* 49. __NR_bind */ __RSC_bind,
	/* 50. __NR_listen */ __RSC_listen,
	/* 51. __NR_getsockname */ __RSC_getsockname,
	/* 52. __NR_getpeername */ __RSC_getpeername,
	/* 53. __NR_socketpair */ __RSC_socketpair,
	/* 54. __NR_setsockopt */ __RSC_setsockopt,
	/* 55. __NR_getsockopt */ __RSC_getsockopt,
	/* 56. __NR_clone */ __RSC_clone,
	/* 57. __NR_fork */ __RSC_fork,
	/* 58. __NR_vfork */ __RSC_vfork,
	/* 59. __NR_execve */ __RSC_execve,
	/* 60. __NR_exit */ __RSC_exit,
	/* 61. __NR_wait4 */ __RSC_wait4,
	/* 62. __NR_kill */ __RSC_kill,
	/* 63. __NR_uname */ __RSC_uname,
	/* 64. __NR_semget */ __RSC_semget,
	/* 65. __NR_semop */ __RSC_semop,
	/* 66. __NR_semctl */ __RSC_semctl,
	/* 67. __NR_shmdt */ __RSC_shmdt,
	/* 68. __NR_msgget */ __RSC_msgget,
	/* 69. __NR_msgsnd */ __RSC_msgsnd,
	/* 70. __NR_msgrcv */ __RSC_msgrcv,
	/* 71. __NR_msgctl */ __RSC_msgctl,
	/* 72. __NR_fcntl */ __RSC_fcntl,
	/* 73. __NR_flock */ __RSC_flock,
	/* 74. __NR_fsync */ __RSC_fsync,
	/* 75. __NR_fdatasync */ __RSC_fdatasync,
	/* 76. __NR_truncate */ __RSC_truncate,
	/* 77. __NR_ftruncate */ __RSC_ftruncate,
	/* 78. __NR_getdents */ __RSC_getdents,
	/* 79. __NR_getcwd */ __RSC_getcwd,
	/* 80. __NR_chdir */ __RSC_chdir,
	/* 81. __NR_fchdir */ __RSC_fchdir,
	/* 82. __NR_rename */ __RSC_rename,
	/* 83. __NR_mkdir */ __RSC_mkdir,
	/* 84. __NR_rmdir */ __RSC_rmdir,
	/* 85. __NR_creat */ __RSC_creat,
	/* 86. __NR_link */ __RSC_link,
	/* 87. __NR_unlink */ __RSC_unlink,
	/* 88. __NR_symlink */ __RSC_symlink,
	/* 89. __NR_readlink */ __RSC_readlink,
	/* 90. __NR_chmod */ __RSC_chmod,
	/* 91. __NR_fchmod */ __RSC_fchmod,
	/* 92. __NR_chown */ __RSC_chown,
	/* 93. __NR_fchown */ __RSC_fchown,
	/* 94. __NR_lchown */ __RSC_lchown,
	/* 95. __NR_umask */ __RSC_umask,
	/* 96. __NR_gettimeofday */ __RSC_gettimeofday,
	/* 97. __NR_getrlimit */ __RSC_getrlimit,
	/* 98. __NR_getrusage */ __RSC_getrusage,
	/* 99. __NR_sysinfo */ __RSC_sysinfo,
	/* 100. __NR_times */ __RSC_times,
	/* 101. __NR_ptrace */ __RSC_ptrace,
	/* 102. __NR_getuid */ __RSC_getuid,
	/* 103. __NR_syslog */ __RSC_syslog,
	/* 104. __NR_getgid */ __RSC_getgid,
	/* 105. __NR_setuid */ __RSC_setuid,
	/* 106. __NR_setgid */ __RSC_setgid,
	/* 107. __NR_geteuid */ __RSC_geteuid,
	/* 108. __NR_getegid */ __RSC_getegid,
	/* 109. __NR_setpgid */ __RSC_setpgid,
	/* 110. __NR_getppid */ __RSC_getppid,
	/* 111. __NR_getpgrp */ __RSC_getpgrp,
	/* 112. __NR_setsid */ __RSC_setsid,
	/* 113. __NR_setreuid */ __RSC_setreuid,
	/* 114. __NR_setregid */ __RSC_setregid,
	/* 115. __NR_getgroups */ __RSC_getgroups,
	/* 116. __NR_setgroups */ __RSC_setgroups,
	/* 117. __NR_setresuid */ __RSC_setresuid,
	/* 118. __NR_getresuid */ __RSC_getresuid,
	/* 119. __NR_setresgid */ __RSC_setresgid,
	/* 120. __NR_getresgid */ __RSC_getresgid,
	/* 121. __NR_getpgid */ __RSC_getpgid,
	/* 122. __NR_setfsuid */ __RSC_setfsuid,
	/* 123. __NR_setfsgid */ __RSC_setfsgid,
	/* 124. __NR_getsid */ __RSC_getsid,
	/* 125. __NR_capget */ __RSC_capget,
	/* 126. __NR_capset */ __RSC_capset,
	/* 127. __NR_rt_sigpending */ __RSC_rt_sigpending,
	/* 128. __NR_rt_sigtimedwait */ __RSC_rt_sigtimedwait,
	/* 129. __NR_rt_sigqueueinfo */ __RSC_rt_sigqueueinfo,
	/* 130. __NR_rt_sigsuspend */ __RSC_rt_sigsuspend,
	/* 131. __NR_sigaltstack */ __RSC_sigaltstack,
	/* 132. __NR_utime */ __RSC_utime,
	/* 133. __NR_mknod */ __RSC_mknod,
	/* 134. __NR_uselib */ __RSC_uselib,
	/* 135. __NR_personality */ __RSC_personality,
	/* 136. __NR_ustat */ __RSC_ustat,
	/* 137. __NR_statfs */ __RSC_statfs,
	/* 138. __NR_fstatfs */ __RSC_fstatfs,
	/* 139. __NR_sysfs */ __RSC_sysfs,
	/* 140. __NR_getpriority */ __RSC_getpriority,
	/* 141. __NR_setpriority */ __RSC_setpriority,
	/* 142. __NR_sched_setparam */ __RSC_sched_setparam,
	/* 143. __NR_sched_getparam */ __RSC_sched_getparam,
	/* 144. __NR_sched_setscheduler */ __RSC_sched_setscheduler,
	/* 145. __NR_sched_getscheduler */ __RSC_sched_getscheduler,
	/* 146. __NR_sched_get_priority_max */ __RSC_sched_get_priority_max,
	/* 147. __NR_sched_get_priority_min */ __RSC_sched_get_priority_min,
	/* 148. __NR_sched_rr_get_interval */ __RSC_sched_rr_get_interval,
	/* 149. __NR_mlock */ __RSC_mlock,
	/* 150. __NR_munlock */ __RSC_munlock,
	/* 151. __NR_mlockall */ __RSC_mlockall,
	/* 152. __NR_munlockall */ __RSC_munlockall,
	/* 153. __NR_vhangup */ __RSC_vhangup,
	/* 154. __NR_modify_ldt */ __RSC_modify_ldt,
	/* 155. __NR_pivot_root */ __RSC_pivot_root,
	/* 156. __NR__sysctl */ __RSC__sysctl,
	/* 157. __NR_prctl */ __RSC_prctl,
	/* 158. __NR_arch_prctl */ __RSC_arch_prctl,
	/* 159. __NR_adjtimex */ __RSC_adjtimex,
	/* 160. __NR_setrlimit */ __RSC_setrlimit,
	/* 161. __NR_chroot */ __RSC_chroot,
	/* 162. __NR_sync */ __RSC_sync,
	/* 163. __NR_acct */ __RSC_acct,
	/* 164. __NR_settimeofday */ __RSC_settimeofday,
	/* 165. __NR_mount */ __RSC_mount,
	/* 166. __NR_umount2 */ __RSC_umount2,
	/* 167. __NR_swapon */ __RSC_swapon,
	/* 168. __NR_swapoff */ __RSC_swapoff,
	/* 169. __NR_reboot */ __RSC_reboot,
	/* 170. __NR_sethostname */ __RSC_sethostname,
	/* 171. __NR_setdomainname */ __RSC_setdomainname,
	/* 172. __NR_iopl */ __RSC_iopl,
	/* 173. __NR_ioperm */ __RSC_ioperm,
	/* 174. __NR_create_module */ __RSC_create_module,
	/* 175. __NR_init_module */ __RSC_init_module,
	/* 176. __NR_delete_module */ __RSC_delete_module,
	/* 177. __NR_get_kernel_syms */ __RSC_get_kernel_syms,
	/* 178. __NR_query_module */ __RSC_query_module,
	/* 179. __NR_quotactl */ __RSC_quotactl,
	/* 180. __NR_nfsservctl */ __RSC_nfsservctl,
	/* 181. __NR_getpmsg */ __RSC_getpmsg,
	/* 182. __NR_putpmsg */ __RSC_putpmsg,
	/* 183. __NR_afs_syscall */ __RSC_afs_syscall,
	/* 184. __NR_tuxcall */ __RSC_tuxcall,
	/* 185. __NR_security */ __RSC_security,
	/* 186. __NR_gettid */ __RSC_gettid,
	/* 187. __NR_readahead */ __RSC_readahead,
	/* 188. __NR_setxattr */ __RSC_setxattr,
	/* 189. __NR_lsetxattr */ __RSC_lsetxattr,
	/* 190. __NR_fsetxattr */ __RSC_fsetxattr,
	/* 191. __NR_getxattr */ __RSC_getxattr,
	/* 192. __NR_lgetxattr */ __RSC_lgetxattr,
	/* 193. __NR_fgetxattr */ __RSC_fgetxattr,
	/* 194. __NR_listxattr */ __RSC_listxattr,
	/* 195. __NR_llistxattr */ __RSC_llistxattr,
	/* 196. __NR_flistxattr */ __RSC_flistxattr,
	/* 197. __NR_removexattr */ __RSC_removexattr,
	/* 198. __NR_lremovexattr */ __RSC_lremovexattr,
	/* 199. __NR_fremovexattr */ __RSC_fremovexattr,
	/* 200. __NR_tkill */ __RSC_tkill,
	/* 201. __NR_time */ __RSC_time,
	/* 202. __NR_futex */ __RSC_futex,
	/* 203. __NR_sched_setaffinity */ __RSC_sched_setaffinity,
	/* 204. __NR_sched_getaffinity */ __RSC_sched_getaffinity,
	/* 205. __NR_set_thread_area */ __RSC_set_thread_area,
	/* 206. __NR_io_setup */ __RSC_io_setup,
	/* 207. __NR_io_destroy */ __RSC_io_destroy,
	/* 208. __NR_io_getevents */ __RSC_io_getevents,
	/* 209. __NR_io_submit */ __RSC_io_submit,
	/* 210. __NR_io_cancel */ __RSC_io_cancel,
	/* 211. __NR_get_thread_area */ __RSC_get_thread_area,
	/* 212. __NR_lookup_dcookie */ __RSC_lookup_dcookie,
	/* 213. __NR_epoll_create */ __RSC_epoll_create,
	/* 214. __NR_epoll_ctl_old */ __RSC_epoll_ctl_old,
	/* 215. __NR_epoll_wait_old */ __RSC_epoll_wait_old,
	/* 216. __NR_remap_file_pages */ __RSC_remap_file_pages,
	/* 217. __NR_getdents64 */ __RSC_getdents64,
	/* 218. __NR_set_tid_address */ __RSC_set_tid_address,
	/* 219. __NR_restart_syscall */ __RSC_restart_syscall,
	/* 220. __NR_semtimedop */ __RSC_semtimedop,
	/* 221. __NR_fadvise64 */ __RSC_fadvise64,
	/* 222. __NR_timer_create */ __RSC_timer_create,
	/* 223. __NR_timer_settime */ __RSC_timer_settime,
	/* 224. __NR_timer_gettime */ __RSC_timer_gettime,
	/* 225. __NR_timer_getoverrun */ __RSC_timer_getoverrun,
	/* 226. __NR_timer_delete */ __RSC_timer_delete,
	/* 227. __NR_clock_settime */ __RSC_clock_settime,
	/* 228. __NR_clock_gettime */ __RSC_clock_gettime,
	/* 229. __NR_clock_getres */ __RSC_clock_getres,
	/* 230. __NR_clock_nanosleep */ __RSC_clock_nanosleep,
	/* 231. __NR_exit_group */ __RSC_exit_group,
	/* 232. __NR_epoll_wait */ __RSC_epoll_wait,
	/* 233. __NR_epoll_ctl */ __RSC_epoll_ctl,
	/* 234. __NR_tgkill */ __RSC_tgkill,
	/* 235. __NR_utimes */ __RSC_utimes,
	/* 236. __NR_vserver */ __RSC_vserver,
	/* 237. __NR_mbind */ __RSC_mbind,
	/* 238. __NR_set_mempolicy */ __RSC_set_mempolicy,
	/* 239. __NR_get_mempolicy */ __RSC_get_mempolicy,
	/* 240. __NR_mq_open */ __RSC_mq_open,
	/* 241. __NR_mq_unlink */ __RSC_mq_unlink,
	/* 242. __NR_mq_timedsend */ __RSC_mq_timedsend,
	/* 243. __NR_mq_timedreceive */ __RSC_mq_timedreceive,
	/* 244. __NR_mq_notify */ __RSC_mq_notify,
	/* 245. __NR_mq_getsetattr */ __RSC_mq_getsetattr,
	/* 246. __NR_kexec_load */ __RSC_kexec_load,
	/* 247. __NR_waitid */ __RSC_waitid,
	/* 248. __NR_add_key */ __RSC_add_key,
	/* 249. __NR_request_key */ __RSC_request_key,
	/* 250. __NR_keyctl */ __RSC_keyctl
};

#define  PPC_TO_RSC_SIZE	((sizeof(ppc_to_rsc))/(sizeof(enum rsc_constant)))
enum rsc_constant ppc_to_rsc[] = {
	/* 0. __NR_restart_syscall */ __RSC_restart_syscall,
	/* 1. __NR_exit */ __RSC_exit,
	/* 2. __NR_fork */ __RSC_fork,
	/* 3. __NR_read */ __RSC_read,
	/* 4. __NR_write */ __RSC_write,
	/* 5. __NR_open */ __RSC_open,
	/* 6. __NR_close */ __RSC_close,
	/* 7. __NR_waitpid */ __RSC_waitpid,
	/* 8. __NR_creat */ __RSC_creat,
	/* 9. __NR_link */ __RSC_link,
	/* 10. __NR_unlink */ __RSC_unlink,
	/* 11. __NR_execve */ __RSC_execve,
	/* 12. __NR_chdir */ __RSC_chdir,
	/* 13. __NR_time */ __RSC_time,
	/* 14. __NR_mknod */ __RSC_mknod,
	/* 15. __NR_chmod */ __RSC_chmod,
	/* 16. __NR_lchown */ __RSC_lchown,
	/* 17. __NR_break */ __RSC_break,
	/* 18. __NR_oldstat */ __RSC_oldstat,
	/* 19. __NR_lseek */ __RSC_lseek,
	/* 20. __NR_getpid */ __RSC_getpid,
	/* 21. __NR_mount */ __RSC_mount,
	/* 22. __NR_umount */ __RSC_umount,
	/* 23. __NR_setuid */ __RSC_setuid,
	/* 24. __NR_getuid */ __RSC_getuid,
	/* 25. __NR_stime */ __RSC_stime,
	/* 26. __NR_ptrace */ __RSC_ptrace,
	/* 27. __NR_alarm */ __RSC_alarm,
	/* 28. __NR_oldfstat */ __RSC_oldfstat,
	/* 29. __NR_pause */ __RSC_pause,
	/* 30. __NR_utime */ __RSC_utime,
	/* 31. __NR_stty */ __RSC_stty,
	/* 32. __NR_gtty */ __RSC_gtty,
	/* 33. __NR_access */ __RSC_access,
	/* 34. __NR_nice */ __RSC_nice,
	/* 35. __NR_ftime */ __RSC_ftime,
	/* 36. __NR_sync */ __RSC_sync,
	/* 37. __NR_kill */ __RSC_kill,
	/* 38. __NR_rename */ __RSC_rename,
	/* 39. __NR_mkdir */ __RSC_mkdir,
	/* 40. __NR_rmdir */ __RSC_rmdir,
	/* 41. __NR_dup */ __RSC_dup,
	/* 42. __NR_pipe */ __RSC_pipe,
	/* 43. __NR_times */ __RSC_times,
	/* 44. __NR_prof */ __RSC_prof,
	/* 45. __NR_brk */ __RSC_brk,
	/* 46. __NR_setgid */ __RSC_setgid,
	/* 47. __NR_getgid */ __RSC_getgid,
	/* 48. __NR_signal */ __RSC_signal,
	/* 49. __NR_geteuid */ __RSC_geteuid,
	/* 50. __NR_getegid */ __RSC_getegid,
	/* 51. __NR_acct */ __RSC_acct,
	/* 52. __NR_umount2 */ __RSC_umount2,
	/* 53. __NR_lock */ __RSC_lock,
	/* 54. __NR_ioctl */ __RSC_ioctl,
	/* 55. __NR_fcntl */ __RSC_fcntl,
	/* 56. __NR_mpx */ __RSC_mpx,
	/* 57. __NR_setpgid */ __RSC_setpgid,
	/* 58. __NR_ulimit */ __RSC_ulimit,
	/* 59. __NR_oldolduname */ __RSC_oldolduname,
	/* 60. __NR_umask */ __RSC_umask,
	/* 61. __NR_chroot */ __RSC_chroot,
	/* 62. __NR_ustat */ __RSC_ustat,
	/* 63. __NR_dup2 */ __RSC_dup2,
	/* 64. __NR_getppid */ __RSC_getppid,
	/* 65. __NR_getpgrp */ __RSC_getpgrp,
	/* 66. __NR_setsid */ __RSC_setsid,
	/* 67. __NR_sigaction */ __RSC_sigaction,
	/* 68. __NR_sgetmask */ __RSC_sgetmask,
	/* 69. __NR_ssetmask */ __RSC_ssetmask,
	/* 70. __NR_setreuid */ __RSC_setreuid,
	/* 71. __NR_setregid */ __RSC_setregid,
	/* 72. __NR_sigsuspend */ __RSC_sigsuspend,
	/* 73. __NR_sigpending */ __RSC_sigpending,
	/* 74. __NR_sethostname */ __RSC_sethostname,
	/* 75. __NR_setrlimit */ __RSC_setrlimit,
	/* 76. __NR_getrlimit */ __RSC_getrlimit,
	/* 77. __NR_getrusage */ __RSC_getrusage,
	/* 78. __NR_gettimeofday */ __RSC_gettimeofday,
	/* 79. __NR_settimeofday */ __RSC_settimeofday,
	/* 80. __NR_getgroups */ __RSC_getgroups,
	/* 81. __NR_setgroups */ __RSC_setgroups,
	/* 82. __NR_select */ __RSC_select,
	/* 83. __NR_symlink */ __RSC_symlink,
	/* 84. __NR_oldlstat */ __RSC_oldlstat,
	/* 85. __NR_readlink */ __RSC_readlink,
	/* 86. __NR_uselib */ __RSC_uselib,
	/* 87. __NR_swapon */ __RSC_swapon,
	/* 88. __NR_reboot */ __RSC_reboot,
	/* 89. __NR_readdir */ __RSC_readdir,
	/* 90. __NR_mmap */ __RSC_mmap,
	/* 91. __NR_munmap */ __RSC_munmap,
	/* 92. __NR_truncate */ __RSC_truncate,
	/* 93. __NR_ftruncate */ __RSC_ftruncate,
	/* 94. __NR_fchmod */ __RSC_fchmod,
	/* 95. __NR_fchown */ __RSC_fchown,
	/* 96. __NR_getpriority */ __RSC_getpriority,
	/* 97. __NR_setpriority */ __RSC_setpriority,
	/* 98. __NR_profil */ __RSC_profil,
	/* 99. __NR_statfs */ __RSC_statfs,
	/* 100. __NR_fstatfs */ __RSC_fstatfs,
	/* 101. __NR_ioperm */ __RSC_ioperm,
	/* 102. __NR_socketcall */ __RSC_socketcall,
	/* 103. __NR_syslog */ __RSC_syslog,
	/* 104. __NR_setitimer */ __RSC_setitimer,
	/* 105. __NR_getitimer */ __RSC_getitimer,
	/* 106. __NR_stat */ __RSC_stat,
	/* 107. __NR_lstat */ __RSC_lstat,
	/* 108. __NR_fstat */ __RSC_fstat,
	/* 109. __NR_olduname */ __RSC_olduname,
	/* 110. __NR_iopl */ __RSC_iopl,
	/* 111. __NR_vhangup */ __RSC_vhangup,
	/* 112. __NR_idle */ __RSC_idle,
	/* 113. __NR_vm86 */ __RSC_vm86,
	/* 114. __NR_wait4 */ __RSC_wait4,
	/* 115. __NR_swapoff */ __RSC_swapoff,
	/* 116. __NR_sysinfo */ __RSC_sysinfo,
	/* 117. __NR_ipc */ __RSC_ipc,
	/* 118. __NR_fsync */ __RSC_fsync,
	/* 119. __NR_sigreturn */ __RSC_sigreturn,
	/* 120. __NR_clone */ __RSC_clone,
	/* 121. __NR_setdomainname */ __RSC_setdomainname,
	/* 122. __NR_uname */ __RSC_uname,
	/* 123. __NR_modify_ldt */ __RSC_modify_ldt,
	/* 124. __NR_adjtimex */ __RSC_adjtimex,
	/* 125. __NR_mprotect */ __RSC_mprotect,
	/* 126. __NR_sigprocmask */ __RSC_sigprocmask,
	/* 127. __NR_create_module */ __RSC_create_module,
	/* 128. __NR_init_module */ __RSC_init_module,
	/* 129. __NR_delete_module */ __RSC_delete_module,
	/* 130. __NR_get_kernel_syms */ __RSC_get_kernel_syms,
	/* 131. __NR_quotactl */ __RSC_quotactl,
	/* 132. __NR_getpgid */ __RSC_getpgid,
	/* 133. __NR_fchdir */ __RSC_fchdir,
	/* 134. __NR_bdflush */ __RSC_bdflush,
	/* 135. __NR_sysfs */ __RSC_sysfs,
	/* 136. __NR_personality */ __RSC_personality,
	/* 137. __NR_afs_syscall */ __RSC_afs_syscall,
	/* 138. __NR_setfsuid */ __RSC_setfsuid,
	/* 139. __NR_setfsgid */ __RSC_setfsgid,
	/* 140. __NR__llseek */ __RSC__llseek,
	/* 141. __NR_getdents */ __RSC_getdents,
	/* 142. __NR__newselect */ __RSC__newselect,
	/* 143. __NR_flock */ __RSC_flock,
	/* 144. __NR_msync */ __RSC_msync,
	/* 145. __NR_readv */ __RSC_readv,
	/* 146. __NR_writev */ __RSC_writev,
	/* 147. __NR_getsid */ __RSC_getsid,
	/* 148. __NR_fdatasync */ __RSC_fdatasync,
	/* 149. __NR__sysctl */ __RSC__sysctl,
	/* 150. __NR_mlock */ __RSC_mlock,
	/* 151. __NR_munlock */ __RSC_munlock,
	/* 152. __NR_mlockall */ __RSC_mlockall,
	/* 153. __NR_munlockall */ __RSC_munlockall,
	/* 154. __NR_sched_setparam */ __RSC_sched_setparam,
	/* 155. __NR_sched_getparam */ __RSC_sched_getparam,
	/* 156. __NR_sched_setscheduler */ __RSC_sched_setscheduler,
	/* 157. __NR_sched_getscheduler */ __RSC_sched_getscheduler,
	/* 158. __NR_sched_yield */ __RSC_sched_yield,
	/* 159. __NR_sched_get_priority_max */ __RSC_sched_get_priority_max,
	/* 160. __NR_sched_get_priority_min */ __RSC_sched_get_priority_min,
	/* 161. __NR_sched_rr_get_interval */ __RSC_sched_rr_get_interval,
	/* 162. __NR_nanosleep */ __RSC_nanosleep,
	/* 163. __NR_mremap */ __RSC_mremap,
	/* 164. __NR_setresuid */ __RSC_setresuid,
	/* 165. __NR_getresuid */ __RSC_getresuid,
	/* 166. __NR_query_module */ __RSC_query_module,
	/* 167. __NR_poll */ __RSC_poll,
	/* 168. __NR_nfsservctl */ __RSC_nfsservctl,
	/* 169. __NR_setresgid */ __RSC_setresgid,
	/* 170. __NR_getresgid */ __RSC_getresgid,
	/* 171. __NR_prctl */ __RSC_prctl,
	/* 172. __NR_rt_sigreturn */ __RSC_rt_sigreturn,
	/* 173. __NR_rt_sigaction */ __RSC_rt_sigaction,
	/* 174. __NR_rt_sigprocmask */ __RSC_rt_sigprocmask,
	/* 175. __NR_rt_sigpending */ __RSC_rt_sigpending,
	/* 176. __NR_rt_sigtimedwait */ __RSC_rt_sigtimedwait,
	/* 177. __NR_rt_sigqueueinfo */ __RSC_rt_sigqueueinfo,
	/* 178. __NR_rt_sigsuspend */ __RSC_rt_sigsuspend,
	/* 179. __NR_pread64 */ __RSC_pread64,
	/* 180. __NR_pwrite64 */ __RSC_pwrite64,
	/* 181. __NR_chown */ __RSC_chown,
	/* 182. __NR_getcwd */ __RSC_getcwd,
	/* 183. __NR_capget */ __RSC_capget,
	/* 184. __NR_capset */ __RSC_capset,
	/* 185. __NR_sigaltstack */ __RSC_sigaltstack,
	/* 186. __NR_sendfile */ __RSC_sendfile,
	/* 187. __NR_getpmsg */ __RSC_getpmsg,
	/* 188. __NR_putpmsg */ __RSC_putpmsg,
	/* 189. __NR_vfork */ __RSC_vfork,
	/* 190. __NR_ugetrlimit */ __RSC_ugetrlimit,
	/* 191. __NR_readahead */ __RSC_readahead,
	/* 192. __NR_mmap2 */ __RSC_mmap2,
	/* 193. __NR_truncate64 */ __RSC_truncate64,
	/* 194. __NR_ftruncate64 */ __RSC_ftruncate64,
	/* 195. __NR_stat64 */ __RSC_stat64,
	/* 196. __NR_lstat64 */ __RSC_lstat64,
	/* 197. __NR_fstat64 */ __RSC_fstat64,
	/* 198. __NR_pciconfig_read */ __RSC_pciconfig_read,
	/* 199. __NR_pciconfig_write */ __RSC_pciconfig_write,
	/* 200. __NR_pciconfig_iobase */ __RSC_pciconfig_iobase,
	/* 201. __NR_multiplexer */ __RSC_multiplexer,
	/* 202. __NR_getdents64 */ __RSC_getdents64,
	/* 203. __NR_pivot_root */ __RSC_pivot_root,
	/* 204. __NR_fcntl64 */ __RSC_fcntl64,
	/* 205. __NR_madvise */ __RSC_madvise,
	/* 206. __NR_mincore */ __RSC_mincore,
	/* 207. __NR_gettid */ __RSC_gettid,
	/* 208. __NR_tkill */ __RSC_tkill,
	/* 209. __NR_setxattr */ __RSC_setxattr,
	/* 210. __NR_lsetxattr */ __RSC_lsetxattr,
	/* 211. __NR_fsetxattr */ __RSC_fsetxattr,
	/* 212. __NR_getxattr */ __RSC_getxattr,
	/* 213. __NR_lgetxattr */ __RSC_lgetxattr,
	/* 214. __NR_fgetxattr */ __RSC_fgetxattr,
	/* 215. __NR_listxattr */ __RSC_listxattr,
	/* 216. __NR_llistxattr */ __RSC_llistxattr,
	/* 217. __NR_flistxattr */ __RSC_flistxattr,
	/* 218. __NR_removexattr */ __RSC_removexattr,
	/* 219. __NR_lremovexattr */ __RSC_lremovexattr,
	/* 220. __NR_fremovexattr */ __RSC_fremovexattr,
	/* 221. __NR_futex */ __RSC_futex,
	/* 222. __NR_sched_setaffinity */ __RSC_sched_setaffinity,
	/* 223. __NR_sched_getaffinity */ __RSC_sched_getaffinity,
	/* 224. NOT USED */ __RSC_ERROR,
	/* 225. __NR_tuxcall */ __RSC_tuxcall,
	/* 226. __NR_sendfile64 */ __RSC_sendfile64,
	/* 227. __NR_io_setup */ __RSC_io_setup,
	/* 228. __NR_io_destroy */ __RSC_io_destroy,
	/* 229. __NR_io_getevents */ __RSC_io_getevents,
	/* 230. __NR_io_submit */ __RSC_io_submit,
	/* 231. __NR_io_cancel */ __RSC_io_cancel,
	/* 232. __NR_set_tid_address */ __RSC_set_tid_address,
	/* 233. __NR_fadvise64 */ __RSC_fadvise64,
	/* 234. __NR_exit_group */ __RSC_exit_group,
	/* 235. __NR_lookup_dcookie */ __RSC_lookup_dcookie,
	/* 236. __NR_epoll_create */ __RSC_epoll_create,
	/* 237. __NR_epoll_ctl */ __RSC_epoll_ctl,
	/* 238. __NR_epoll_wait */ __RSC_epoll_wait,
	/* 239. __NR_remap_file_pages */ __RSC_remap_file_pages,
	/* 240. __NR_timer_create */ __RSC_timer_create,
	/* 241. __NR_timer_settime */ __RSC_timer_settime,
	/* 242. __NR_timer_gettime */ __RSC_timer_gettime,
	/* 243. __NR_timer_getoverrun */ __RSC_timer_getoverrun,
	/* 244. __NR_timer_delete */ __RSC_timer_delete,
	/* 245. __NR_clock_settime */ __RSC_clock_settime,
	/* 246. __NR_clock_gettime */ __RSC_clock_gettime,
	/* 247. __NR_clock_getres */ __RSC_clock_getres,
	/* 248. __NR_clock_nanosleep */ __RSC_clock_nanosleep,
	/* 249. __NR_swapcontext */ __RSC_swapcontext,
	/* 250. __NR_tgkill */ __RSC_tgkill,
	/* 251. __NR_utimes */ __RSC_utimes,
	/* 252. __NR_statfs64 */ __RSC_statfs64,
	/* 253. __NR_fstatfs64 */ __RSC_fstatfs64,
	/* 254. __NR_fadvise64_64 */ __RSC_fadvise64_64
};

#endif /* __NR_TO_RSC_HEADER__ */
