/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "source.h"
#include "utils.h"

static SourceLine *source_start=NULL, *source_end=NULL;

SourceLine *SOURCE_new( char *opcode, char parm[][MAX_PARAM_LEN] )
{
	SourceLine *n = (SourceLine *) malloc(sizeof(SourceLine));
	int i;

	strcpy( n->opcode, opcode );
	for (i=0; parm[i][0]!='\0'; i++)
		strcpy( n->parm[i], parm[i] );
	n->nparm=i;
	n->function=NULL;
	n->label=NULL;
	SOURCE_add_line(n);
	return n;
}

void SOURCE_add_line( SourceLine *n )
{
	n->next = NULL;
	n->prev = source_end;

	if ( source_end )
		source_end->next = n;
	source_end = n;

	if ( !source_start ) source_start = n;
}

void SOURCE_load( FILE *file )
{
	char opcode[MAX_OPCODE_LEN];
	char parms[5][MAX_PARAM_LEN];
	int i;
	
	do
		freadline( opcode,MAX_OPCODE_LEN,file );
	while ( strcmp(opcode,"BEGIN") );
	freadline( opcode,MAX_OPCODE_LEN,file );

	loop
	{
		freadline( opcode,MAX_OPCODE_LEN,file );
		if ( !strcmp(opcode,"END") )
			break;
		i=0;
		do {
			freadline( parms[i],MAX_PARAM_LEN,file );
		} while (parms[i++][0]!='\0');
		SOURCE_new(opcode,parms);
	}
}

void SOURCE_set_label(SourceLine *s, Label *l)
{	s->label = l; }

Label *SOURCE_get_label(SourceLine *s)
{	return s->label; }

void SOURCE_set_function(SourceLine *s, Function *f)
{	s->function = f; }

Function *SOURCE_get_function(SourceLine *s)
{	return s->function; }

SourceLine *SOURCE_start()
{	return source_start; }

SourceLine *SOURCE_end()
{	return source_end; }

SourceLine *SOURCE_next(SourceLine *l)
{	return l->next; }

SourceLine *SOURCE_prev(SourceLine *l)
{	return l->prev; }

int SOURCE_is_opcode(SourceLine *l, char *opcode)
{	return !strcmp(l->opcode,opcode); }

int SOURCE_is_parm(SourceLine *l, char *parm, int n)
{	return !strcmp(l->parm[n], parm); }

char *SOURCE_get_opcode(SourceLine *l)
{	return l->opcode; }

char *SOURCE_get_parm(SourceLine *l, int n)
{	return l->parm[n]; }

int SOURCE_get_parm_count(SourceLine *l)
{	return l->nparm; }

