/* armeb-linux.elf-entry.h
   created from armeb-linux.elf-entry.bin, 16295 (0x3fa7) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_ARMEB_LINUX_ELF_ENTRY_SIZE    16295
#define STUB_ARMEB_LINUX_ELF_ENTRY_ADLER32 0xcad35b5a
#define STUB_ARMEB_LINUX_ELF_ENTRY_CRC32   0xc07dcf2e

unsigned char stub_armeb_linux_elf_entry[16295] = {
127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
  0,  0, 23,244,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,   /* 0x  20 */
  0, 23,  0, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  30 */
226, 79,192, 24,232,156, 12,  6,224,138,160, 12,224,139,176, 12,   /* 0x  40 */
225,160,  0,  2,224, 76,144,  1,226,129, 26,  1,233, 45,  0,  7,   /* 0x  50 */
227,160, 32,  7,227,160, 48, 50,227,224, 64,  0,239,144,  0,192,   /* 0x  60 */
227,112, 10,  1, 42,255,255,254,232,185,  1,254,225, 89,  0, 10,   /* 0x  70 */
232,160,  1,254, 58,  0,  0, 15,224, 64, 64,  9,226,143, 80, 80,   /* 0x  80 */
225,160,224,  0,224,133, 80,  4,225,160,  0,  5,224,137, 16,  4,   /* 0x  90 */
227,160, 32,  0,239,159,  0,  2,229,156,144,  0,226, 73,144,140,   /* 0x  a0 */
224, 76,160,  9,224,138,160,  4,229,155,  0,  8,233, 45, 64,  1,   /* 0x  b0 */
229,155, 48,  0,226,139,  0, 12,229,155, 16,  4,225,160, 32, 14,   /* 0x  c0 */
229,141, 48,  8,226,141, 48,  8,225,160,224, 15,225,160,240,  5,   /* 0x  d0 */
232,189,128,  2,233, 45, 64,252,224,129,112,  0,227,224, 80,  0,   /* 0x  e0 */
227,160, 65,  2,234,  0,  0, 20,232,189,  0, 24,224, 64,  0,  7,   /* 0x  f0 */
224, 66, 32,  3,229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,   /* 0x 100 */
224,131, 16,  2,227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,   /* 0x 110 */
232,189,128,240,228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,   /* 0x 120 */
225,160,240, 14,228,208, 48,  1,228,194, 48,  1,224,148, 64,  4,   /* 0x 130 */
 11,  0,  0, 14, 42,  0,  0, 18,227,160, 16,  1,234,  0,  0, 29,   /* 0x 140 */
226, 65, 16,  1,224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,   /* 0x 150 */
224,148, 64,  4, 11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4,   /* 0x 160 */
 11,  0,  0, 14, 58,  0,  0, 25,226, 81, 48,  3,227,160, 16,  0,   /* 0x 170 */
 58,  0,  0, 45,228,208, 80,  1,225,133, 84,  3,225,240, 80,  5,   /* 0x 180 */
 10,  0,  0,  3,225,176, 80,197, 42,  0,  0, 60,234,  0,  0, 48,   /* 0x 190 */
224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 60,227,160, 16,  1,   /* 0x 1a0 */
224,148, 64,  4, 11,  0,  0, 14, 42,  0,  0, 60,224,148, 64,  4,   /* 0x 1b0 */
 11,  0,  0, 14,224,161, 16,  1,224,148, 64,  4, 11,  0,  0, 14,   /* 0x 1c0 */
 58,  0,  0, 52,226,129, 16,  4,234,  0,  0, 64,224,148, 64,  4,   /* 0x 1d0 */
 11,  0,  0, 14,224,161, 16,  1,226,129, 16,  2,227,117, 12,  5,   /* 0x 1e0 */
 50,129, 16,  1,224,130, 48,  1,229, 83, 48,  1,231,210, 48,  5,   /* 0x 1f0 */
228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 68,234,  0,  0, 20,   /* 0x 200 */
233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,   /* 0x 210 */
234,  0,  0, 20,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,   /* 0x 220 */
229,132, 32,  0,225,160, 64,  0,225,160,  0,  3,224,131, 16,  2,   /* 0x 230 */
227,160, 32,  0,239,159,  0,  2,225,160,  0,  4,232,189,128,240,   /* 0x 240 */
228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,225,160,240, 14,   /* 0x 250 */
228,208, 48,  1,228,194, 48,  1,224,148, 64,  4, 11,  0,  0, 14,   /* 0x 260 */
 42,  0,  0, 18,227,160, 16,  1,234,  0,  0, 29,226, 65, 16,  1,   /* 0x 270 */
224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4,   /* 0x 280 */
 11,  0,  0, 14,224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14,   /* 0x 290 */
 58,  0,  0, 25,226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 44,   /* 0x 2a0 */
228,208, 80,  1,225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,   /* 0x 2b0 */
225,176, 80,197,234,  0,  0, 46,224,148, 64,  4, 11,  0,  0, 14,   /* 0x 2c0 */
224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14,224,177, 16,  1,   /* 0x 2d0 */
 26,  0,  0, 59,227,160, 16,  1,224,148, 64,  4, 11,  0,  0, 14,   /* 0x 2e0 */
224,177, 16,  1,224,148, 64,  4, 11,  0,  0, 14, 58,  0,  0, 52,   /* 0x 2f0 */
226,129, 16,  2,226,129, 16,  1,227,117, 12,  5, 50,129, 16,  1,   /* 0x 300 */
229,210, 48,  0,231,210, 48,  5,228,194, 48,  1,226, 81, 16,  1,   /* 0x 310 */
 26,  0,  0, 63,234,  0,  0, 20,224,129, 16,  0,233, 45, 64, 62,   /* 0x 320 */
227,224, 80,  0,227,160, 65,  2,234,  0,  0, 29,232,189,  0, 26,   /* 0x 330 */
224, 64,  0,  1,224, 66, 32,  3,229,132, 32,  0,225,160, 64,  0,   /* 0x 340 */
225,160,  0,  3,224,131, 16,  2,227,160, 32,  0,239,159,  0,  2,   /* 0x 350 */
225,160,  0,  4,232,189,128, 48,224,148, 64,  4, 17,160,240, 14,   /* 0x 360 */
228,208, 64,  1,224,164, 64,  4,225,176, 76,  4,225,160,240, 14,   /* 0x 370 */
227,160, 16,  1,225,160,192, 14,235,  0,  0, 14,224,177, 16,  1,   /* 0x 380 */
235,  0,  0, 14, 58,  0,  0, 22,225,160,240, 12,228,208, 48,  1,   /* 0x 390 */
228,194, 48,  1,235,  0,  0, 14, 42,  0,  0, 27,235,  0,  0, 20,   /* 0x 3a0 */
226, 81, 48,  3,227,160, 16,  0, 58,  0,  0, 39,228,208, 80,  1,   /* 0x 3b0 */
225,133, 84,  3,225,240, 80,  5, 10,  0,  0,  3,235,  0,  0, 14,   /* 0x 3c0 */
224,177, 16,  1,235,  0,  0, 14,224,177, 16,  1, 26,  0,  0, 46,   /* 0x 3d0 */
235,  0,  0, 20,226,129, 16,  2,227,117, 12, 13, 50,129, 16,  1,   /* 0x 3e0 */
231,210, 48,  5,226, 81, 16,  1,228,194, 48,  1, 42,  0,  0, 48,   /* 0x 3f0 */
234,  0,  0, 29,229,221,192,  0,227, 92,  0, 14, 26,255,255,254,   /* 0x 400 */
233, 45, 72, 12,229,208,176,  0,227,160,204,  6,225,160,177,171,   /* 0x 410 */
225,160,203, 28,225,160,176, 13,226,140,205, 58,224, 77,208, 12,   /* 0x 420 */
229,147,192,  0,229,141, 48,  8,229,141,192,  4,229,141, 32,  0,   /* 0x 430 */
226,141, 48, 12,227,160,192,  0,228,131,192,  4,225, 83,  0, 11,   /* 0x 440 */
 26,  0,  0, 15,226,141, 48, 12,226, 65, 32,  2,225,160, 16,  0,   /* 0x 450 */
228,209,192,  1,226, 12,192,  7,229,205,192, 18,228,209,192,  1,   /* 0x 460 */
225,160,  2, 44,229,205,  0, 17,226, 12,192, 15,229,205,192, 16,   /* 0x 470 */
226,141,  0, 16,235,  0,  0, 40,225,160,208, 11,225,160, 48,  0,   /* 0x 480 */
232,189,  0,  3,229,145, 16,  0,224,129, 16,  0,227,160, 32,  0,   /* 0x 490 */
239,159,  0,  2,225,160,  0,  3,232,189,136,  0,233, 45, 79,240,   /* 0x 4a0 */
226, 77,208, 48,229,141, 48,  0,229,208, 48,  0,229,208, 80,  2,   /* 0x 4b0 */
229,208,224,  1,229,157,192,  0,229,141, 48, 20,229,157, 48, 92,   /* 0x 4c0 */
227,160, 64,  0,229,140, 64,  0,229,131, 64,  0,229,157,192, 20,   /* 0x 4d0 */
229,208, 48,  1,224,140, 48,  3,227,160,204,  3,225,160,195, 28,   /* 0x 4e0 */
227,160, 48,  1,225,160,238, 19,225,160, 53, 19,226,140,206,115,   /* 0x 4f0 */
226, 67, 48,  1,226, 78,224,  1,226,128,  0,  4,226,140,192,  6,   /* 0x 500 */
229,141, 16,  4,229,141, 48, 12,229,141,224, 16,229,141,  0,  8,   /* 0x 510 */
234,  0,  0, 31,229,157,  0,  8,227,160, 27,  1,225,131, 16,176,   /* 0x 520 */
225, 84,  0, 12,225,160, 48,132,226,132, 64,  1, 26,  0,  0, 28,   /* 0x 530 */
229,157, 48,  4,227,160, 96,  0,224,131,144,  2,225,160,224,  3,   /* 0x 540 */
225,160, 32,  6,229,157, 80,  4,224,101, 48,  9,225, 82,  0,  3,   /* 0x 550 */
226,142,224,  1, 10,  0,  2, 73,231,210, 48,  5,226,130, 32,  1,   /* 0x 560 */
227, 82,  0,  5,225,131,100,  6, 26,  0,  0, 40,227,160,176,  0,   /* 0x 570 */
227,160,192,  1,225,160,112, 11,227,224,  0,  0,229,141,192, 44,   /* 0x 580 */
229,141,176, 24,229,141,192, 28,229,141,192, 32,229,141,192, 36,   /* 0x 590 */
234,  0,  2, 57,227,224,132,255,225, 80,  0,  8,138,  0,  0, 68,   /* 0x 5a0 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160,  4,  0,   /* 0x 5b0 */
225,131,100,  6,229,157, 16, 12,229,157, 32, 24,224, 11,160,  1,   /* 0x 5c0 */
225,160, 18,  2,224,138, 48,  1,225,160, 80,131,229,157, 48,  8,   /* 0x 5d0 */
225,147,192,181,225,160, 53,160,224,  4,  3,156,225, 86,  0,  4,   /* 0x 5e0 */
 42,  0,  0,185,229,157,  0, 20,226, 96, 48,  8,225,160, 51, 87,   /* 0x 5f0 */
229,157, 16, 16,224, 11, 32,  1,224,131, 48, 18,229,157,  0,  8,   /* 0x 600 */
227,160, 44,  6,224, 34,  2,147,229,157, 16, 24,226,108, 59,  2,   /* 0x 610 */
227, 81,  0,  6,224,140, 50,195,226,130,142,230,225,128, 48,181,   /* 0x 620 */
226,136,128, 12,209,160,  0,  4,211,160, 16,  1,218,  0,  0,164,   /* 0x 630 */
229,157, 32, 44,229,157, 80, 84,224, 98, 48, 11,231,213,112,  3,   /* 0x 640 */
225,160,  0,  4,227,160, 16,  1,225,160,112,135,226,  7, 92,  1,   /* 0x 650 */
225,160,160,129,224,136, 48,133,224,131, 48, 10,227, 80,  4,  1,   /* 0x 660 */
226,131, 76,  2,226,129,192,  1, 42,  0,  0,119,225, 94,  0,  9,   /* 0x 670 */
225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,   /* 0x 680 */
225,212, 48,176,225,160, 37,160,224,129, 16, 12,224, 12,  2,147,   /* 0x 690 */
226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,   /* 0x 6a0 */
 42,  0,  0,135,227, 85,  0,  0,225,160,  0, 12,225,196, 32,176,   /* 0x 6b0 */
225,160, 16, 10, 10,  0,  0,140,225,160,  0, 12,234,  0,  0,164,   /* 0x 6c0 */
227, 85,  0,  0,225,196, 48,176,224,108, 96,  6,224,108,  0,  0,   /* 0x 6d0 */
 10,  0,  0,164,227, 81,  0,255,202,  0,  0,168,234,  0,  0,105,   /* 0x 6e0 */
227, 80,  4,  1,224,129, 16,  3, 42,  0,  0,151,225, 94,  0,  9,   /* 0x 6f0 */
225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,   /* 0x 700 */
225,152, 48,180,225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,   /* 0x 710 */
225, 86,  0, 12,224, 67, 82,163,224,131, 50,194, 49,136, 48,180,   /* 0x 720 */
 33,136, 80,180,224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12,   /* 0x 730 */
 32,108, 96,  6,227, 81,  0,255,225,160, 64,129,226,129, 48,  1,   /* 0x 740 */
218,  0,  0,143,229,157,192, 24,226,  1,112,255,227, 92,  0,  3,   /* 0x 750 */
229,157, 16, 84,211,160, 32,  0,231,193,112, 11,226,139,176,  1,   /* 0x 760 */
213,141, 32, 24,218,  0,  2, 57,229,157, 48, 24,227, 83,  0,  9,   /* 0x 770 */
197,157, 80, 24,210, 67, 48,  3,194, 69, 80,  6,213,141, 48, 24,   /* 0x 780 */
197,141, 80, 24,234,  0,  2, 57,224, 76, 50,172,224,100, 32,  0,   /* 0x 790 */
229,157,192,  8,225, 82,  0,  8,225,140, 48,181,224,100, 96,  6,   /* 0x 7a0 */
138,  0,  0,197,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 7b0 */
225,160, 36,  2,225,131,100,  6,229,157,  0,  8,229,157, 48, 24,   /* 0x 7c0 */
224,128,112,131,226,135, 13,  6,225,208,192,176,225,160, 53,162,   /* 0x 7d0 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,225,229,157, 32, 24,   /* 0x 7e0 */
229,157, 80,  8,227, 82,  0,  6,226,108, 59,  2,226,133, 30,102,   /* 0x 7f0 */
195,160, 32,  3,229,157, 80, 32,211,160, 32,  0,224,140, 50,195,   /* 0x 800 */
229,141, 32, 24,229,157,192, 28,229,157, 32, 44,229,141, 80, 36,   /* 0x 810 */
226,129, 16,  4,225,160, 80,  4,229,141,192, 32,229,141, 32, 28,   /* 0x 820 */
225,192, 48,176,234,  0,  1, 98,224,100, 32,  2,224, 76, 50,172,   /* 0x 830 */
225, 82,  0,  8,225,192, 48,176,224,100, 96,  6,138,  0,  0,236,   /* 0x 840 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,   /* 0x 850 */
225,131,100,  6,226,135, 95,102,225,213,192,176,225,160, 53,162,   /* 0x 860 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 26,226,108, 59,  2,   /* 0x 870 */
224,140, 50,195,225, 84,  0,  8,225,197, 48,176,138,  0,  0,252,   /* 0x 880 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 68,  4,   /* 0x 890 */
225,131,100,  6,229,157, 80,  8,224,133, 48,129,224,131, 48,138,   /* 0x 8a0 */
226,131, 30, 30,225,209,192,176,225,160, 53,164,224,  2,  3,156,   /* 0x 8b0 */
225, 86,  0,  2, 32, 98, 96,  6, 32, 76, 50,172, 32, 98, 80,  4,   /* 0x 8c0 */
 42,  0,  1, 50,226,108, 59,  2,224,140, 50,195,227, 91,  0,  0,   /* 0x 8d0 */
225,193, 48,176, 10,  0,  2, 73,229,157,192, 44,229,157, 16, 24,   /* 0x 8e0 */
229,157,  0, 84,224,108, 48, 11,231,208,112,  3,227, 81,  0,  6,   /* 0x 8f0 */
195,160, 16, 11,211,160, 16,  9,229,141, 16, 24,231,192,112, 11,   /* 0x 900 */
225,160,  0,  2,226,139,176,  1,234,  0,  2, 57,224,100, 32,  2,   /* 0x 910 */
224, 76, 50,172,225, 82,  0,  8,225,197, 48,176,224,100, 96,  6,   /* 0x 920 */
138,  0,  1, 37,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x 930 */
225,160, 36,  2,225,131,100,  6,226,135, 30, 27,225,209,192,176,   /* 0x 940 */
225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 52,   /* 0x 950 */
229,157, 80, 44,226,108, 59,  2,229,157, 32, 28,224,140, 50,195,   /* 0x 960 */
229,141, 80, 28,225,160, 80,  4,229,141, 32, 44,225,193, 48,176,   /* 0x 970 */
234,  0,  1, 90,224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,   /* 0x 980 */
225,193, 48,176,224,100, 96,  6,138,  0,  1, 63,225, 94,  0,  9,   /* 0x 990 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,   /* 0x 9a0 */
226,135, 31,114,225,209,192,176,225,160, 53,162,224,  4,  3,156,   /* 0x 9b0 */
225, 86,  0,  4, 42,  0,  1, 78,226,108, 59,  2,229,157, 32, 32,   /* 0x 9c0 */
224,140, 50,195,229,157,  0, 44,229,157,192, 28,225,160, 80,  4,   /* 0x 9d0 */
229,141,192, 32,229,141,  0, 28,234,  0,  1, 49,224, 76, 50,172,   /* 0x 9e0 */
225,193, 48,176,229,157,192, 44,226,141, 16, 32,232,145,  0, 10,   /* 0x 9f0 */
224,100, 80,  2,229,157, 32, 28,229,141, 16, 36,229,141, 32, 32,   /* 0x a00 */
229,141,192, 28,229,141, 48, 44,224,100, 96,  6,229,157, 32, 24,   /* 0x a10 */
229,157,  0,  8,227, 82,  0,  6,195,160, 32, 11,211,160, 32,  8,   /* 0x a20 */
226,128, 30,166,229,141, 32, 24,226,129, 16,  8,227,224,116,255,   /* 0x a30 */
225, 85,  0,  7,138,  0,  1,106,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x a40 */
228,222, 48,  1,225,160, 84,  5,225,131,100,  6,225,209,192,176,   /* 0x a50 */
225,160, 53,165,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,120,   /* 0x a60 */
224,129, 34, 10,226,108, 59,  2,224,140, 50,195,226,130, 80,  4,   /* 0x a70 */
225,160,  0,  4,227,160,160,  3,227,160,128,  0,225,193, 48,176,   /* 0x a80 */
234,  0,  1,152,224,100, 32,  5,224, 76, 50,172,225, 82,  0,  7,   /* 0x a90 */
224,100, 96,  6,225,193, 48,176,138,  0,  1,131,225, 94,  0,  9,   /* 0x aa0 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,   /* 0x ab0 */
225,209,192,178,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,   /* 0x ac0 */
 42,  0,  1,145,224,129, 34, 10,226,108, 59,  2,224,140, 50,195,   /* 0x ad0 */
226,130, 95, 65,225,160,  0,  4,227,160,160,  3,227,160,128,  8,   /* 0x ae0 */
225,193, 48,178,234,  0,  1,152,224, 76, 50,172,225,193, 48,178,   /* 0x af0 */
224,100, 96,  6,224,100,  0,  2,226,129, 95,129,227,160,160,  8,   /* 0x b00 */
227,160,128, 16,225,160,112, 10,227,160, 16,  1,226,129, 48,  1,   /* 0x b10 */
227, 80,  4,  1,225,160, 64,129,224,129, 16,  3, 42,  0,  1,164,   /* 0x b20 */
225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,   /* 0x b30 */
225,131,100,  6,225,149, 48,180,225,160, 37,160,224, 12,  2,147,   /* 0x b40 */
226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,   /* 0x b50 */
224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12, 49,133, 32,180,   /* 0x b60 */
 32,108, 96,  6, 33,133, 48,180,226, 87,112,  1, 26,  0,  1,154,   /* 0x b70 */
227,160, 32,  1,224, 65, 58, 18,229,157, 80, 24,224,131, 48,  8,   /* 0x b80 */
227, 85,  0,  3,229,141, 48, 40,202,  0,  2, 36,229,157,192,  8,   /* 0x b90 */
227, 83,  0,  3,163,160, 48,  3,224,140, 51,131,226,131, 94, 54,   /* 0x ba0 */
225,160,112,  2,227,160,128,  6,226,135, 48,  1,227, 80,  4,  1,   /* 0x bb0 */
225,160, 64,135,224,135,112,  3, 42,  0,  1,203,225, 94,  0,  9,   /* 0x bc0 */
225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,   /* 0x bd0 */
225,149, 48,180,225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,   /* 0x be0 */
225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,224,108,  0,  0,   /* 0x bf0 */
 49,160,112,  4, 49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6,   /* 0x c00 */
 33,133, 48,180,226, 88,128,  1, 26,  0,  1,193,226, 71, 32, 64,   /* 0x c10 */
227, 82,  0,  3,209,160, 80,  2,218,  0,  2, 30,225,160, 64,194,   /* 0x c20 */
227, 82,  0, 13,226,  2, 48,  1,226, 68,112,  1,227,131,192,  2,   /* 0x c30 */
194, 68, 64,  5,193,160, 32,  8,202,  0,  1,237,225,160, 87, 28,   /* 0x c40 */
229,157, 16,  8,224,129, 48,133,224, 67, 48,130,226,131, 78, 85,   /* 0x c50 */
226,132, 64, 14,234,  0,  2,  1,227, 80,  4,  1,226,130, 32,  1,   /* 0x c60 */
 42,  0,  1,245,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,   /* 0x c70 */
228,222, 48,  1,225,131,100,  6,225,160,  0,160,225, 86,  0,  0,   /* 0x c80 */
225,160,192,140, 32, 96, 96,  6, 35,140,192,  1,225, 82,  0,  4,   /* 0x c90 */
 26,  0,  1,237,229,157, 32,  8,226,130, 77, 25,226,132, 64,  4,   /* 0x ca0 */
225,160, 82, 12,227,160,112,  4,227,160,160,  1,225,160,128, 10,   /* 0x cb0 */
227, 80,  4,  1,225,160, 16,136,226,136,192,  1, 42,  0,  2, 12,   /* 0x cc0 */
225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,   /* 0x cd0 */
225,131,100,  6,225,148, 48,177,225,160, 37,160,224,136,128, 12,   /* 0x ce0 */
224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,   /* 0x cf0 */
224, 67, 50,163, 33,133, 80, 10, 49,160,128,  1, 49,160,  0, 12,   /* 0x d00 */
 49,132, 32,177, 33,132, 48,177, 32,108, 96,  6, 32,108,  0,  0,   /* 0x d10 */
226, 87,112,  1,225,160,160,138, 26,  0,  2,  3,226,149, 80,  1,   /* 0x d20 */
229,141, 80, 44, 10,  0,  2, 60,229,157, 48, 24,226,131, 48,  7,   /* 0x d30 */
229,141, 48, 24,229,157, 80, 44,225, 85,  0, 11,138,  0,  2, 73,   /* 0x d40 */
229,157,192, 40,229,157, 16, 84,224,101, 48, 11,226,140, 32,  2,   /* 0x d50 */
224,129, 64,  3,224,129,192, 11,226, 82, 32,  1,229,157, 80, 88,   /* 0x d60 */
  3,160, 48,  0, 19,160, 48,  1,226,139,176,  1,225, 91,  0,  5,   /* 0x d70 */
 35,160, 48,  0, 50,  3, 48,  1,228,212,112,  1,227, 83,  0,  0,   /* 0x d80 */
228,204,112,  1, 26,  0,  2, 45,229,157,192, 88,225, 91,  0, 12,   /* 0x d90 */
 58,  0,  0, 60,227, 80,  4,  1, 42,  0,  2, 65,225, 94,  0,  9,   /* 0x da0 */
 10,  0,  2, 73,226,142,224,  1,229,157,  0,  4,229,157, 16,  0,   /* 0x db0 */
229,157, 32, 92,224, 96, 48, 14,227,160,  0,  0,229,129, 48,  0,   /* 0x dc0 */
229,130,176,  0,234,  0,  2, 74,227,160,  0,  1,226,141,208, 48,   /* 0x dd0 */
232,189,143,240,233, 45, 79,240,226, 77,208, 48,229,141, 48,  0,   /* 0x de0 */
229,208, 48,  0,229,208, 80,  2,229,208,224,  1,229,157,192,  0,   /* 0x df0 */
229,141, 48, 20,229,157, 48, 92,227,160, 64,  0,229,140, 64,  0,   /* 0x e00 */
229,131, 64,  0,229,157,192, 20,229,208, 48,  1,224,140, 48,  3,   /* 0x e10 */
227,160,204,  3,225,160,195, 28,227,160, 48,  1,225,160,238, 19,   /* 0x e20 */
225,160, 53, 19,226,140,206,115,226, 67, 48,  1,226, 78,224,  1,   /* 0x e30 */
226,128,  0,  4,226,140,192,  6,229,141, 16,  4,229,141, 48, 12,   /* 0x e40 */
229,141,224, 16,229,141,  0,  8,234,  0,  0, 31,229,157,  0,  8,   /* 0x e50 */
227,160, 27,  1,225,131, 16,176,225, 84,  0, 12,225,160, 48,132,   /* 0x e60 */
226,132, 64,  1, 26,  0,  0, 28,229,157, 48,  4,227,160, 96,  0,   /* 0x e70 */
224,131,144,  2,225,160,224,  3,225,160, 32,  6,229,157, 80,  4,   /* 0x e80 */
224,101, 48,  9,225, 82,  0,  3,226,142,224,  1, 10,  0,  2, 73,   /* 0x e90 */
231,210, 48,  5,226,130, 32,  1,227, 82,  0,  5,225,131,100,  6,   /* 0x ea0 */
 26,  0,  0, 40,227,160,176,  0,227,160,192,  1,225,160,112, 11,   /* 0x eb0 */
227,224,  0,  0,229,141,192, 44,229,141,176, 24,229,141,192, 28,   /* 0x ec0 */
229,141,192, 32,229,141,192, 36,234,  0,  2, 57,227,224,132,255,   /* 0x ed0 */
225, 80,  0,  8,138,  0,  0, 68,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x ee0 */
228,222, 48,  1,225,160,  4,  0,225,131,100,  6,229,157, 16, 12,   /* 0x ef0 */
229,157, 32, 24,224, 11,160,  1,225,160, 18,  2,224,138, 48,  1,   /* 0x f00 */
225,160, 80,131,229,157, 48,  8,225,147,192,181,225,160, 53,160,   /* 0x f10 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,185,229,157,  0, 20,   /* 0x f20 */
226, 96, 48,  8,225,160, 51, 87,229,157, 16, 16,224, 11, 32,  1,   /* 0x f30 */
224,131, 48, 18,229,157,  0,  8,227,160, 44,  6,224, 34,  2,147,   /* 0x f40 */
229,157, 16, 24,226,108, 59,  2,227, 81,  0,  6,224,140, 50,195,   /* 0x f50 */
226,130,142,230,225,128, 48,181,226,136,128, 12,209,160,  0,  4,   /* 0x f60 */
211,160, 16,  1,218,  0,  0,164,229,157, 32, 44,229,157, 80, 84,   /* 0x f70 */
224, 98, 48, 11,231,213,112,  3,225,160,  0,  4,227,160, 16,  1,   /* 0x f80 */
225,160,112,135,226,  7, 92,  1,225,160,160,129,224,136, 48,133,   /* 0x f90 */
224,131, 48, 10,227, 80,  4,  1,226,131, 76,  2,226,129,192,  1,   /* 0x fa0 */
 42,  0,  0,119,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,   /* 0x fb0 */
228,222, 48,  1,225,131,100,  6,225,212, 48,176,225,160, 37,160,   /* 0x fc0 */
224,129, 16, 12,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,   /* 0x fd0 */
224,131, 34,194,224, 67, 50,163, 42,  0,  0,135,227, 85,  0,  0,   /* 0x fe0 */
225,160,  0, 12,225,196, 32,176,225,160, 16, 10, 10,  0,  0,140,   /* 0x ff0 */
225,160,  0, 12,234,  0,  0,164,227, 85,  0,  0,225,196, 48,176,   /* 0x1000 */
224,108, 96,  6,224,108,  0,  0, 10,  0,  0,164,227, 81,  0,255,   /* 0x1010 */
202,  0,  0,168,234,  0,  0,105,227, 80,  4,  1,224,129, 16,  3,   /* 0x1020 */
 42,  0,  0,151,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,   /* 0x1030 */
228,222, 48,  1,225,131,100,  6,225,152, 48,180,225,160, 37,160,   /* 0x1040 */
224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224, 67, 82,163,   /* 0x1050 */
224,131, 50,194, 49,136, 48,180, 33,136, 80,180,224,108,  0,  0,   /* 0x1060 */
 49,160, 16,  4, 49,160,  0, 12, 32,108, 96,  6,227, 81,  0,255,   /* 0x1070 */
225,160, 64,129,226,129, 48,  1,218,  0,  0,143,229,157,192, 24,   /* 0x1080 */
226,  1,112,255,227, 92,  0,  3,229,157, 16, 84,211,160, 32,  0,   /* 0x1090 */
231,193,112, 11,226,139,176,  1,213,141, 32, 24,218,  0,  2, 57,   /* 0x10a0 */
229,157, 48, 24,227, 83,  0,  9,197,157, 80, 24,210, 67, 48,  3,   /* 0x10b0 */
194, 69, 80,  6,213,141, 48, 24,197,141, 80, 24,234,  0,  2, 57,   /* 0x10c0 */
224, 76, 50,172,224,100, 32,  0,229,157,192,  8,225, 82,  0,  8,   /* 0x10d0 */
225,140, 48,181,224,100, 96,  6,138,  0,  0,197,225, 94,  0,  9,   /* 0x10e0 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,   /* 0x10f0 */
229,157,  0,  8,229,157, 48, 24,224,128,112,131,226,135, 13,  6,   /* 0x1100 */
225,208,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,   /* 0x1110 */
 42,  0,  0,225,229,157, 32, 24,229,157, 80,  8,227, 82,  0,  6,   /* 0x1120 */
226,108, 59,  2,226,133, 30,102,195,160, 32,  3,229,157, 80, 32,   /* 0x1130 */
211,160, 32,  0,224,140, 50,195,229,141, 32, 24,229,157,192, 28,   /* 0x1140 */
229,157, 32, 44,229,141, 80, 36,226,129, 16,  4,225,160, 80,  4,   /* 0x1150 */
229,141,192, 32,229,141, 32, 28,225,192, 48,176,234,  0,  1, 98,   /* 0x1160 */
224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,225,192, 48,176,   /* 0x1170 */
224,100, 96,  6,138,  0,  0,236,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x1180 */
228,222, 48,  1,225,160, 36,  2,225,131,100,  6,226,135, 95,102,   /* 0x1190 */
225,213,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,   /* 0x11a0 */
 42,  0,  1, 26,226,108, 59,  2,224,140, 50,195,225, 84,  0,  8,   /* 0x11b0 */
225,197, 48,176,138,  0,  0,252,225, 94,  0,  9, 10,  0,  2, 73,   /* 0x11c0 */
228,222, 48,  1,225,160, 68,  4,225,131,100,  6,229,157, 80,  8,   /* 0x11d0 */
224,133, 48,129,224,131, 48,138,226,131, 30, 30,225,209,192,176,   /* 0x11e0 */
225,160, 53,164,224,  2,  3,156,225, 86,  0,  2, 32, 98, 96,  6,   /* 0x11f0 */
 32, 76, 50,172, 32, 98, 80,  4, 42,  0,  1, 50,226,108, 59,  2,   /* 0x1200 */
224,140, 50,195,227, 91,  0,  0,225,193, 48,176, 10,  0,  2, 73,   /* 0x1210 */
229,157,192, 44,229,157, 16, 24,229,157,  0, 84,224,108, 48, 11,   /* 0x1220 */
231,208,112,  3,227, 81,  0,  6,195,160, 16, 11,211,160, 16,  9,   /* 0x1230 */
229,141, 16, 24,231,192,112, 11,225,160,  0,  2,226,139,176,  1,   /* 0x1240 */
234,  0,  2, 57,224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,   /* 0x1250 */
225,197, 48,176,224,100, 96,  6,138,  0,  1, 37,225, 94,  0,  9,   /* 0x1260 */
 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,225,131,100,  6,   /* 0x1270 */
226,135, 30, 27,225,209,192,176,225,160, 53,162,224,  4,  3,156,   /* 0x1280 */
225, 86,  0,  4, 42,  0,  1, 52,229,157, 80, 44,226,108, 59,  2,   /* 0x1290 */
229,157, 32, 28,224,140, 50,195,229,141, 80, 28,225,160, 80,  4,   /* 0x12a0 */
229,141, 32, 44,225,193, 48,176,234,  0,  1, 90,224,100, 32,  2,   /* 0x12b0 */
224, 76, 50,172,225, 82,  0,  8,225,193, 48,176,224,100, 96,  6,   /* 0x12c0 */
138,  0,  1, 63,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x12d0 */
225,160, 36,  2,225,131,100,  6,226,135, 31,114,225,209,192,176,   /* 0x12e0 */
225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 78,   /* 0x12f0 */
226,108, 59,  2,229,157, 32, 32,224,140, 50,195,229,157,  0, 44,   /* 0x1300 */
229,157,192, 28,225,160, 80,  4,229,141,192, 32,229,141,  0, 28,   /* 0x1310 */
234,  0,  1, 49,224, 76, 50,172,225,193, 48,176,229,157,192, 44,   /* 0x1320 */
226,141, 16, 32,232,145,  0, 10,224,100, 80,  2,229,157, 32, 28,   /* 0x1330 */
229,141, 16, 36,229,141, 32, 32,229,141,192, 28,229,141, 48, 44,   /* 0x1340 */
224,100, 96,  6,229,157, 32, 24,229,157,  0,  8,227, 82,  0,  6,   /* 0x1350 */
195,160, 32, 11,211,160, 32,  8,226,128, 30,166,229,141, 32, 24,   /* 0x1360 */
226,129, 16,  8,227,224,116,255,225, 85,  0,  7,138,  0,  1,106,   /* 0x1370 */
225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 84,  5,   /* 0x1380 */
225,131,100,  6,225,209,192,176,225,160, 53,165,224,  4,  3,156,   /* 0x1390 */
225, 86,  0,  4, 42,  0,  1,120,224,129, 34, 10,226,108, 59,  2,   /* 0x13a0 */
224,140, 50,195,226,130, 80,  4,225,160,  0,  4,227,160,160,  3,   /* 0x13b0 */
227,160,128,  0,225,193, 48,176,234,  0,  1,152,224,100, 32,  5,   /* 0x13c0 */
224, 76, 50,172,225, 82,  0,  7,224,100, 96,  6,225,193, 48,176,   /* 0x13d0 */
138,  0,  1,131,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,   /* 0x13e0 */
225,160, 36,  2,225,131,100,  6,225,209,192,178,225,160, 53,162,   /* 0x13f0 */
224,  4,  3,156,225, 86,  0,  4, 42,  0,  1,145,224,129, 34, 10,   /* 0x1400 */
226,108, 59,  2,224,140, 50,195,226,130, 95, 65,225,160,  0,  4,   /* 0x1410 */
227,160,160,  3,227,160,128,  8,225,193, 48,178,234,  0,  1,152,   /* 0x1420 */
224, 76, 50,172,225,193, 48,178,224,100, 96,  6,224,100,  0,  2,   /* 0x1430 */
226,129, 95,129,227,160,160,  8,227,160,128, 16,225,160,112, 10,   /* 0x1440 */
227,160, 16,  1,226,129, 48,  1,227, 80,  4,  1,225,160, 64,129,   /* 0x1450 */
224,129, 16,  3, 42,  0,  1,164,225, 94,  0,  9,225,160,  4,  0,   /* 0x1460 */
 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,149, 48,180,   /* 0x1470 */
225,160, 37,160,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,   /* 0x1480 */
224,131, 34,194,224, 67, 50,163,224,108,  0,  0, 49,160, 16,  4,   /* 0x1490 */
 49,160,  0, 12, 49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,   /* 0x14a0 */
226, 87,112,  1, 26,  0,  1,154,227,160, 32,  1,224, 65, 58, 18,   /* 0x14b0 */
229,157, 80, 24,224,131, 48,  8,227, 85,  0,  3,229,141, 48, 40,   /* 0x14c0 */
202,  0,  2, 36,229,157,192,  8,227, 83,  0,  3,163,160, 48,  3,   /* 0x14d0 */
224,140, 51,131,226,131, 94, 54,225,160,112,  2,227,160,128,  6,   /* 0x14e0 */
226,135, 48,  1,227, 80,  4,  1,225,160, 64,135,224,135,112,  3,   /* 0x14f0 */
 42,  0,  1,203,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,   /* 0x1500 */
228,222, 48,  1,225,131,100,  6,225,149, 48,180,225,160, 37,160,   /* 0x1510 */
224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,   /* 0x1520 */
224, 67, 50,163,224,108,  0,  0, 49,160,112,  4, 49,160,  0, 12,   /* 0x1530 */
 49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,226, 88,128,  1,   /* 0x1540 */
 26,  0,  1,193,226, 71, 32, 64,227, 82,  0,  3,209,160, 80,  2,   /* 0x1550 */
218,  0,  2, 30,225,160, 64,194,227, 82,  0, 13,226,  2, 48,  1,   /* 0x1560 */
226, 68,112,  1,227,131,192,  2,194, 68, 64,  5,193,160, 32,  8,   /* 0x1570 */
202,  0,  1,237,225,160, 87, 28,229,157, 16,  8,224,129, 48,133,   /* 0x1580 */
224, 67, 48,130,226,131, 78, 85,226,132, 64, 14,234,  0,  2,  1,   /* 0x1590 */
227, 80,  4,  1,226,130, 32,  1, 42,  0,  1,245,225, 94,  0,  9,   /* 0x15a0 */
225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,   /* 0x15b0 */
225,160,  0,160,225, 86,  0,  0,225,160,192,140, 32, 96, 96,  6,   /* 0x15c0 */
 35,140,192,  1,225, 82,  0,  4, 26,  0,  1,237,229,157, 32,  8,   /* 0x15d0 */
226,130, 77, 25,226,132, 64,  4,225,160, 82, 12,227,160,112,  4,   /* 0x15e0 */
227,160,160,  1,225,160,128, 10,227, 80,  4,  1,225,160, 16,136,   /* 0x15f0 */
226,136,192,  1, 42,  0,  2, 12,225, 94,  0,  9,225,160,  4,  0,   /* 0x1600 */
 10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,148, 48,177,   /* 0x1610 */
225,160, 37,160,224,136,128, 12,224, 12,  2,147,226, 99, 43,  2,   /* 0x1620 */
225, 86,  0, 12,224,131, 34,194,224, 67, 50,163, 33,133, 80, 10,   /* 0x1630 */
 49,160,128,  1, 49,160,  0, 12, 49,132, 32,177, 33,132, 48,177,   /* 0x1640 */
 32,108, 96,  6, 32,108,  0,  0,226, 87,112,  1,225,160,160,138,   /* 0x1650 */
 26,  0,  2,  3,226,149, 80,  1,229,141, 80, 44, 10,  0,  2, 60,   /* 0x1660 */
229,157, 48, 24,226,131, 48,  7,229,141, 48, 24,229,157, 80, 44,   /* 0x1670 */
225, 85,  0, 11,138,  0,  2, 73,229,157,192, 40,229,157, 16, 84,   /* 0x1680 */
224,101, 48, 11,226,140, 32,  2,224,129, 64,  3,224,129,192, 11,   /* 0x1690 */
226, 82, 32,  1,229,157, 80, 88,  3,160, 48,  0, 19,160, 48,  1,   /* 0x16a0 */
226,139,176,  1,225, 91,  0,  5, 35,160, 48,  0, 50,  3, 48,  1,   /* 0x16b0 */
228,212,112,  1,227, 83,  0,  0,228,204,112,  1, 26,  0,  2, 45,   /* 0x16c0 */
229,157,192, 88,225, 91,  0, 12, 58,  0,  0, 60,227, 80,  4,  1,   /* 0x16d0 */
 42,  0,  2, 65,225, 94,  0,  9, 10,  0,  2, 73,226,142,224,  1,   /* 0x16e0 */
229,157,  0,  4,229,157, 16,  0,229,157, 32, 92,224, 96, 48, 14,   /* 0x16f0 */
227,160,  0,  0,229,129, 48,  0,229,130,176,  0,234,  0,  2, 74,   /* 0x1700 */
227,160,  0,  1,226,141,208, 48,232,189,143,240,227,160, 32, 30,   /* 0x1710 */
226,143, 16, 12,227,160,  0,  2,239,144,  0,  4,227,160,  0,127,   /* 0x1720 */
239,144,  0,  1, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82,   /* 0x1730 */
 79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100, 46,   /* 0x1740 */
 10,  0,116,109,112, 47, 97,114,109,101, 98, 45,108,105,110,117,   /* 0x1750 */
120, 46,101,108,102, 45,101,110,116,114,121, 46, 98,105,110, 58,   /* 0x1760 */
 32, 32, 32, 32, 32,102,105,108,101, 32,102,111,114,109, 97,116,   /* 0x1770 */
 32,101,108,102, 51, 50, 45, 98,105,103, 97,114,109, 10, 10, 83,   /* 0x1780 */
101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,   /* 0x1790 */
101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32,   /* 0x17a0 */
 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x17b0 */
 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,   /* 0x17c0 */
102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32,   /* 0x17d0 */
 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32,   /* 0x17e0 */
 32, 48, 48, 48, 48, 48, 48, 98, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x17f0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1800 */
 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1810 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x1820 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82, 86,   /* 0x1830 */
 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1840 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1850 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101,   /* 0x1860 */
 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1870 */
 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32,   /* 0x1880 */
 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48,   /* 0x1890 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x18a0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x18b0 */
 48, 48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,   /* 0x18c0 */
 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,   /* 0x18d0 */
 32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x18e0 */
 32, 48, 48, 48, 48, 48, 49, 50, 99, 32, 32, 48, 48, 48, 48, 48,   /* 0x18f0 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1900 */
 48, 48, 48, 48, 48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,   /* 0x1910 */
 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,   /* 0x1920 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86,   /* 0x1930 */
 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x1940 */
 49, 49, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x1950 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 49,   /* 0x1960 */
 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x1970 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x1980 */
 76, 89, 10, 32, 32, 53, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,   /* 0x1990 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,100, 99, 32, 32, 48,   /* 0x19a0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x19b0 */
 48, 32, 32, 48, 48, 48, 48, 48, 51, 50, 56, 32, 32, 50, 42, 42,   /* 0x19c0 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x19d0 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54,   /* 0x19e0 */
 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48,   /* 0x19f0 */
 48, 48, 48, 48, 48, 97, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x1a00 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1a10 */
 48, 48, 52, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x1a20 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x1a30 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95,   /* 0x1a40 */
 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 51,   /* 0x1a50 */
 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1a60 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 97, 99, 32,   /* 0x1a70 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1a80 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1a90 */
 10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32,   /* 0x1aa0 */
 32, 32, 32, 48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48, 48,   /* 0x1ab0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1ac0 */
 32, 48, 48, 48, 48, 48,100,101, 52, 32, 32, 50, 42, 42, 48, 32,   /* 0x1ad0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1ae0 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 76,   /* 0x1af0 */
 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48,   /* 0x1b00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1b10 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x1b20 */
 55, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1b30 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,   /* 0x1b40 */
 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32,   /* 0x1b50 */
 48, 48, 48, 48, 48, 48, 51, 54, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b60 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1b70 */
 48, 48, 49, 55, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x1b80 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1b90 */
 10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32, 32,   /* 0x1ba0 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1bb0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1bc0 */
 32, 48, 48, 48, 48, 49, 55, 53, 50, 32, 32, 50, 42, 42, 48, 32,   /* 0x1bd0 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x1be0 */
 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,   /* 0x1bf0 */
 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1c00 */
100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48,   /* 0x1c10 */
 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 48, 48,   /* 0x1c20 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x1c30 */
 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,   /* 0x1c40 */
 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x1c50 */
 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48,   /* 0x1c60 */
 48, 48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x1c70 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,   /* 0x1c80 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10,   /* 0x1c90 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1ca0 */
 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,   /* 0x1cb0 */
 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,   /* 0x1cc0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1cd0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,   /* 0x1ce0 */
 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x1cf0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1d00 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,   /* 0x1d10 */
 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,   /* 0x1d20 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1d30 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48,   /* 0x1d40 */
 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10,   /* 0x1d50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1d60 */
 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48,   /* 0x1d70 */
 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48,   /* 0x1d80 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,   /* 0x1d90 */
 95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,   /* 0x1da0 */
 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1db0 */
 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73,   /* 0x1dc0 */
 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84,   /* 0x1dd0 */
 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x1de0 */
 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48,   /* 0x1df0 */
 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10,   /* 0x1e00 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1e10 */
 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1e20 */
 65, 68, 82, 77, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x1e30 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x1e40 */
 48, 48, 48, 48, 32, 76, 69, 78, 70, 10, 48, 48, 48, 48, 48, 48,   /* 0x1e50 */
 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,   /* 0x1e60 */
  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 80, 82, 48, 10, 48,   /* 0x1e70 */
 48, 48, 48, 48, 48, 48, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,   /* 0x1e80 */
 69, 76, 70, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e90 */
 48, 32, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1ea0 */
 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,  9,   /* 0x1eb0 */
 48, 48, 48, 48, 48, 49, 50, 99, 32,117, 99,108, 95,110,114,118,   /* 0x1ec0 */
 50,101, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10,   /* 0x1ed0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70,   /* 0x1ee0 */
 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 49, 49, 56, 32,   /* 0x1ef0 */
117, 99,108, 95,110,114,118, 50,100, 95,100,101, 99,111,109,112,   /* 0x1f00 */
114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1f10 */
103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48, 48,   /* 0x1f20 */
 48, 48, 48, 48,100, 99, 32,117, 99,108, 95,110,114,118, 50, 98,   /* 0x1f30 */
 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48,   /* 0x1f40 */
 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,   /* 0x1f50 */
 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1f60 */
 32,101,110,100, 95,100,101, 99,111,109,112,114,101,115,115, 10,   /* 0x1f70 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32,   /* 0x1f80 */
 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48,   /* 0x1f90 */
 48, 48, 32, 99,112,114, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,   /* 0x1fa0 */
 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,   /* 0x1fb0 */
 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83,   /* 0x1fc0 */
 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,   /* 0x1fd0 */
 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,   /* 0x1fe0 */
 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,   /* 0x1ff0 */
 50, 32, 32, 32, 32, 32, 32, 32, 65, 68, 82, 77, 10, 48, 48, 48,   /* 0x2000 */
 48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,   /* 0x2010 */
 50, 32, 32, 32, 32, 32, 32, 32, 76, 69, 78, 70, 10, 48, 48, 48,   /* 0x2020 */
 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51,   /* 0x2030 */
 50, 32, 32, 32, 32, 32, 32, 32, 67, 80, 82, 48, 10, 48, 48, 48,   /* 0x2040 */
 48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x2050 */
 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,   /* 0x2060 */
 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x2070 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,   /* 0x2080 */
 65, 73, 78, 88, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x2090 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,   /* 0x20a0 */
 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x20b0 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x20c0 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32,   /* 0x20d0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x20e0 */
 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 53, 99,   /* 0x20f0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2100 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 54,   /* 0x2110 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2120 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2130 */
 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2140 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2150 */
 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2160 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2170 */
 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2180 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x2190 */
 48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x21a0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x21b0 */
 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x21c0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,   /* 0x21d0 */
 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x21e0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,   /* 0x21f0 */
 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2200 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,   /* 0x2210 */
 10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x2220 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2230 */
 69, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77,   /* 0x2240 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2250 */
 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 48, 32, 82, 95, 65, 82,   /* 0x2260 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2270 */
 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65,   /* 0x2280 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x2290 */
 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95,   /* 0x22a0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x22b0 */
 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82,   /* 0x22c0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x22d0 */
 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,100, 99, 32,   /* 0x22e0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x22f0 */
 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101, 56,   /* 0x2300 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2310 */
 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101,   /* 0x2320 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2330 */
 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x2340 */
102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2350 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,   /* 0x2360 */
 48,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2370 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,   /* 0x2380 */
 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2390 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,   /* 0x23a0 */
 48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x23b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 10, 82,   /* 0x23c0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x23d0 */
 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79,   /* 0x23e0 */
 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,   /* 0x23f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,   /* 0x2400 */
 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2410 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,   /* 0x2420 */
 10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x2430 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2440 */
 68, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77,   /* 0x2450 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2460 */
 50, 68, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82,   /* 0x2470 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x2480 */
 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65,   /* 0x2490 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,   /* 0x24a0 */
 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95,   /* 0x24b0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x24c0 */
 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82,   /* 0x24d0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x24e0 */
 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32,   /* 0x24f0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2500 */
 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 99,   /* 0x2510 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2520 */
 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 97,   /* 0x2530 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2540 */
 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x2550 */
 98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2560 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,   /* 0x2570 */
 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2580 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,   /* 0x2590 */
 48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x25a0 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,   /* 0x25b0 */
 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x25c0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,   /* 0x25d0 */
 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x25e0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,   /* 0x25f0 */
 48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2600 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,   /* 0x2610 */
 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2620 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,   /* 0x2630 */
 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x2640 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2650 */
 68, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77,   /* 0x2660 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2670 */
 50, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x2680 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,   /* 0x2690 */
 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x26a0 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x26b0 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95,   /* 0x26c0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x26d0 */
 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82,   /* 0x26e0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x26f0 */
 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32,   /* 0x2700 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2710 */
 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 54, 99,   /* 0x2720 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2730 */
 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 55,   /* 0x2740 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x2750 */
 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,   /* 0x2760 */
 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2770 */
 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,   /* 0x2780 */
 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2790 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,   /* 0x27a0 */
 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x27b0 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,   /* 0x27c0 */
 48, 48, 48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x27d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,   /* 0x27e0 */
 48, 48, 48, 48, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x27f0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,   /* 0x2800 */
 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x2810 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,   /* 0x2820 */
 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2830 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,   /* 0x2840 */
 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x2850 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,   /* 0x2860 */
 66, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77,   /* 0x2870 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,   /* 0x2880 */
 50, 66, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82,   /* 0x2890 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,   /* 0x28a0 */
 86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,   /* 0x28b0 */
 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,   /* 0x28c0 */
 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,   /* 0x28d0 */
 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x28e0 */
 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,   /* 0x28f0 */
 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x2900 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,   /* 0x2910 */
 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x2920 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x2930 */
 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32,   /* 0x2940 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x2950 */
 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69,   /* 0x2960 */
 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,   /* 0x2970 */
 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x2980 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x2990 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x29a0 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65,   /* 0x29b0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x29c0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x29d0 */
 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x29e0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x29f0 */
 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2a00 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2a10 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,   /* 0x2a20 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2a30 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2a40 */
 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2a50 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2a60 */
 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77,   /* 0x2a70 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2a80 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56,   /* 0x2a90 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2aa0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2ab0 */
 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2ac0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2ad0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65,   /* 0x2ae0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2af0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,   /* 0x2b00 */
 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2b10 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2b20 */
 48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2b30 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2b40 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82,   /* 0x2b50 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2b60 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2b70 */
 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2b80 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2b90 */
 48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77,   /* 0x2ba0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2bb0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52,   /* 0x2bc0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2bd0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2be0 */
 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2bf0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2c00 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65,   /* 0x2c10 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2c20 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,   /* 0x2c30 */
 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2c40 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2c50 */
 48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2c60 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2c70 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82,   /* 0x2c80 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2c90 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2ca0 */
 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2cb0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2cc0 */
 48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77,   /* 0x2cd0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2ce0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52,   /* 0x2cf0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2d00 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2d10 */
 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2d20 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2d30 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65,   /* 0x2d40 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2d50 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,   /* 0x2d60 */
 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2d70 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2d80 */
 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2d90 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2da0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82,   /* 0x2db0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2dc0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2dd0 */
 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2de0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2df0 */
 48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77,   /* 0x2e00 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2e10 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,101, 56,   /* 0x2e20 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2e30 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2e40 */
 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2e50 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2e60 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65,   /* 0x2e70 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2e80 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,   /* 0x2e90 */
 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2ea0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2eb0 */
 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2ec0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x2ed0 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82,   /* 0x2ee0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x2ef0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x2f00 */
 48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x2f10 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x2f20 */
 48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77,   /* 0x2f30 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x2f40 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52,101, 99,   /* 0x2f50 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x2f60 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x2f70 */
 48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x2f80 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x2f90 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65,   /* 0x2fa0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2fb0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53,   /* 0x2fc0 */
 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x2fd0 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x2fe0 */
 48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x2ff0 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3000 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82,   /* 0x3010 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3020 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3030 */
 48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3040 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x3050 */
 48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77,   /* 0x3060 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3070 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 53,102, 99,   /* 0x3080 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3090 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x30a0 */
 48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x30b0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x30c0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65,   /* 0x30d0 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x30e0 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54,   /* 0x30f0 */
 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3100 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3110 */
 48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3120 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3130 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82,   /* 0x3140 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3150 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3160 */
 48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x3170 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x3180 */
 48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77,   /* 0x3190 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x31a0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99,   /* 0x31b0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x31c0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x31d0 */
 48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x31e0 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x31f0 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65,   /* 0x3200 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3210 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55,   /* 0x3220 */
 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3230 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3240 */
 48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3250 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3260 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82,   /* 0x3270 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x3280 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x3290 */
 48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x32a0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x32b0 */
 48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77,   /* 0x32c0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x32d0 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 55,102, 52,   /* 0x32e0 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x32f0 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3300 */
 48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3310 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3320 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65,   /* 0x3330 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3340 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,   /* 0x3350 */
 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,   /* 0x3360 */
 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,   /* 0x3370 */
 48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,   /* 0x3380 */
 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,   /* 0x3390 */
 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82,   /* 0x33a0 */
 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,   /* 0x33b0 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,   /* 0x33c0 */
 48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,   /* 0x33d0 */
 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x33e0 */
 48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77,   /* 0x33f0 */
 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,   /* 0x3400 */
 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 56,102, 99,   /* 0x3410 */
 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,   /* 0x3420 */
 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,   /* 0x3430 */
 48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,   /* 0x3440 */
 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x3450 */
 67, 49, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65,   /* 0x3460 */
 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x3470 */
 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,   /* 0x3480 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x3490 */
 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10,   /* 0x34a0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x34b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x34c0 */
 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x34d0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x34e0 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32,   /* 0x34f0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3500 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3510 */
 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3520 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3530 */
 50, 48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82,   /* 0x3540 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3550 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102,   /* 0x3560 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3570 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3580 */
 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3590 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x35a0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95,   /* 0x35b0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x35c0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x35d0 */
 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x35e0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x35f0 */
 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x3600 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3610 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32,   /* 0x3620 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3630 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3640 */
 48, 48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3650 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3660 */
 50, 48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82,   /* 0x3670 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3680 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49,   /* 0x3690 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x36a0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x36b0 */
 48, 48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x36c0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x36d0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95,   /* 0x36e0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x36f0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3700 */
 50, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3710 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3720 */
 10, 48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95,   /* 0x3730 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3740 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32,   /* 0x3750 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3760 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3770 */
 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3780 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3790 */
 50, 48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82,   /* 0x37a0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x37b0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99,   /* 0x37c0 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x37d0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x37e0 */
 48, 48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x37f0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3800 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95,   /* 0x3810 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3820 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3830 */
 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3840 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3850 */
 10, 48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3860 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3870 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32,   /* 0x3880 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3890 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x38a0 */
 48, 48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x38b0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x38c0 */
 50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82,   /* 0x38d0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x38e0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99,   /* 0x38f0 */
 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3900 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3910 */
 48, 48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3920 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3930 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95,   /* 0x3940 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3950 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3960 */
 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3970 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3980 */
 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x3990 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x39a0 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32,   /* 0x39b0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x39c0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x39d0 */
 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x39e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x39f0 */
 50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82,   /* 0x3a00 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3a10 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98,   /* 0x3a20 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3a30 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3a40 */
 48, 48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3a50 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3a60 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95,   /* 0x3a70 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3a80 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3a90 */
 52,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3aa0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3ab0 */
 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x3ac0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3ad0 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32,   /* 0x3ae0 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3af0 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3b00 */
 48, 48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3b10 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3b20 */
 50, 48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82,   /* 0x3b30 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3b40 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99,   /* 0x3b50 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3b60 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3b70 */
 48, 48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3b80 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3b90 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95,   /* 0x3ba0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3bb0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3bc0 */
 54, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3bd0 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3be0 */
 10, 48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95,   /* 0x3bf0 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3c00 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32,   /* 0x3c10 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3c20 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3c30 */
 48, 48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3c40 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3c50 */
 50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82,   /* 0x3c60 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3c70 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100,   /* 0x3c80 */
 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3c90 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3ca0 */
 48, 48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3cb0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3cc0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95,   /* 0x3cd0 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3ce0 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3cf0 */
 55, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3d00 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3d10 */
 10, 48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3d20 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3d30 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32,   /* 0x3d40 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3d50 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3d60 */
 48, 48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3d70 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3d80 */
 50, 48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82,   /* 0x3d90 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3da0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99,   /* 0x3db0 */
 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3dc0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3dd0 */
 48, 48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3de0 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3df0 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95,   /* 0x3e00 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3e10 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3e20 */
 56, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3e30 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3e40 */
 10, 48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95,   /* 0x3e50 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3e60 */
 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32,   /* 0x3e70 */
 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,   /* 0x3e80 */
 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,   /* 0x3e90 */
 48, 48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,   /* 0x3ea0 */
 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,   /* 0x3eb0 */
 50, 48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82,   /* 0x3ec0 */
 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,   /* 0x3ed0 */
 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101,   /* 0x3ee0 */
 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,   /* 0x3ef0 */
 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,   /* 0x3f00 */
 48, 48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,   /* 0x3f10 */
 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,   /* 0x3f20 */
 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95,   /* 0x3f30 */
 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x3f40 */
 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,   /* 0x3f50 */
 57, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,   /* 0x3f60 */
 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,   /* 0x3f70 */
 10, 48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95,   /* 0x3f80 */
 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,   /* 0x3f90 */
 95, 68, 69, 67, 50, 48, 10                                        /* 0x3fa0 */
};
