/* i086-dos16.com.h
   created from i086-dos16.com.bin, 6080 (0x17c0) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_I086_DOS16_COM_SIZE    6080
#define STUB_I086_DOS16_COM_ADLER32 0x8b03419f
#define STUB_I086_DOS16_COM_CRC32   0xe4b9c118

unsigned char stub_i086_dos16_com[6080] = {
127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
 72,  2,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,   /* 0x  20 */
 46,  0, 43,  0,129,252,  0,  0,119,  2,205, 32,185,  0,  0,190,   /* 0x  30 */
  0,  0,191,  0,  0,187,  0,128,253,243,164,252,135,247,131,238,   /* 0x  40 */
  0, 25,237, 87, 87,233,255,255, 85, 80, 88, 33,161,216,208,213,   /* 0x  50 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,164,232,   /* 0x  60 */
 11,  0,114,250, 65,232,  6,  0,227, 21,227, 20,115,  6,131,233,   /* 0x  70 */
  3,114,  6,136,204,172,247,208,149, 49,201,232,  6,  0, 17,201,   /* 0x  80 */
117,  8, 65,232,  6,  0,115,251, 65, 65, 65,129,253,  0,243,131,   /* 0x  90 */
209,  1,141,  3,150,243,164,150,235,  0,232,  2,  0, 17,201,  1,   /* 0x  a0 */
219,117,  4,173, 17,192,147,195, 94,185,  0,  0,172, 44,232, 60,   /* 0x  b0 */
  1,119,249,193,  4,  8, 41, 52,139, 28,134,223, 41,243,137, 28,   /* 0x  c0 */
173,226,  3,176,232,176,233, 95,185,  0,  0,242,174,117, 20,117,   /* 0x  d0 */
  2,193,  5,  8, 41, 61,139, 29,134,223, 41,251,137, 29,175,235,   /* 0x  e0 */
  3,195,116,109,112, 47,105, 48, 56, 54, 45,100,111,115, 49, 54,   /* 0x  f0 */
 46, 99,111,109, 46, 98,105,110, 58, 32, 32, 32, 32, 32,102,105,   /* 0x 100 */
108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45,   /* 0x 110 */
105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10,   /* 0x 120 */
 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x 130 */
 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32,   /* 0x 140 */
 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32,   /* 0x 150 */
 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32,   /* 0x 160 */
 70,108, 97,103,115, 10, 32, 32, 48, 32, 67, 79, 77, 77, 65, 73,   /* 0x 170 */
 78, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,100,   /* 0x 180 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 190 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32,   /* 0x 1a0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 1b0 */
 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,   /* 0x 1c0 */
 32, 32, 49, 32, 67, 79, 77, 83, 66, 66, 66, 80, 32, 32, 32, 32,   /* 0x 1d0 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48,   /* 0x 1e0 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x 1f0 */
 48, 48, 48, 48, 48, 48, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32,   /* 0x 200 */
 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x 210 */
 76, 89, 10, 32, 32, 50, 32, 67, 79, 77, 80, 83, 72, 68, 73, 32,   /* 0x 220 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48,   /* 0x 230 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 240 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 51, 32, 32, 50, 42, 42,   /* 0x 250 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x 260 */
 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 67, 79, 77, 67, 65, 76,   /* 0x 270 */
 76, 84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49,   /* 0x 280 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 290 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 52, 32, 32,   /* 0x 2a0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 2b0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 67, 79, 77,   /* 0x 2c0 */
 77, 65, 73, 78, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x 2d0 */
 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x 2e0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53,   /* 0x 2f0 */
 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x 300 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x 310 */
 76, 89, 10, 32, 32, 53, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32,   /* 0x 320 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 54, 32, 32, 48,   /* 0x 330 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 340 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 56, 32, 32, 50, 42, 42,   /* 0x 350 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,   /* 0x 360 */
 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 67, 79, 77, 67, 85, 84,   /* 0x 370 */
 80, 79, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x 380 */
 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,   /* 0x 390 */
 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54,101, 32, 32,   /* 0x 3a0 */
 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,   /* 0x 3b0 */
 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 78, 82, 86,   /* 0x 3c0 */
 50, 66, 49, 54, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,   /* 0x 3d0 */
 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,   /* 0x 3e0 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54,   /* 0x 3f0 */
101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,   /* 0x 400 */
 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,   /* 0x 410 */
 76, 89, 10, 32, 32, 56, 32, 78, 82, 86, 68, 68, 79, 78, 69, 32,   /* 0x 420 */
 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,   /* 0x 430 */
 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 440 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 56, 32, 32, 50, 42, 42,   /* 0x 450 */
 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,   /* 0x 460 */
 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57,   /* 0x 470 */
 32, 78, 82, 86, 68, 82, 69, 84, 85, 32, 32, 32, 32, 32, 32, 48,   /* 0x 480 */
 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x 490 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x 4a0 */
 48, 48, 48, 55, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x 4b0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x 4c0 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78, 82, 86, 68, 69,   /* 0x 4d0 */
 67, 79, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,   /* 0x 4e0 */
101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x 4f0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 99, 32,   /* 0x 500 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x 510 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 520 */
 10, 32, 49, 49, 32, 78, 82, 86, 76, 69, 68, 48, 48, 32, 32, 32,   /* 0x 530 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32, 48, 48, 48,   /* 0x 540 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 550 */
 32, 48, 48, 48, 48, 48, 48, 57, 97, 32, 32, 50, 42, 42, 48, 32,   /* 0x 560 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x 570 */
 78, 76, 89, 10, 32, 49, 50, 32, 78, 82, 86, 71, 84, 68, 48, 48,   /* 0x 580 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32,   /* 0x 590 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 5a0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 98, 32, 32, 50, 42,   /* 0x 5b0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 5c0 */
 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78, 82, 86, 68, 69,   /* 0x 5d0 */
 67, 79, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,   /* 0x 5e0 */
 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x 5f0 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 50, 32,   /* 0x 600 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x 610 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 620 */
 10, 32, 49, 52, 32, 67, 65, 76, 76, 84, 82, 49, 54, 32, 32, 32,   /* 0x 630 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48,   /* 0x 640 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 650 */
 32, 48, 48, 48, 48, 48, 48, 98, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x 660 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x 670 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 67,   /* 0x 680 */
 84, 49, 54, 73, 50, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x 690 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 6a0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x 6b0 */
 48, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x 6c0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,   /* 0x 6d0 */
 54, 32, 67, 84, 49, 54, 83, 85, 66, 48, 32, 32, 32, 32, 32, 32,   /* 0x 6e0 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 6f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x 700 */
 48, 48, 48, 48, 99, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x 710 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 720 */
 10, 32, 49, 55, 32, 67, 84, 49, 54, 73, 48, 56, 54, 32, 32, 32,   /* 0x 730 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48,   /* 0x 740 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 750 */
 32, 48, 48, 48, 48, 48, 48, 99, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x 760 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x 770 */
 78, 76, 89, 10, 32, 49, 56, 32, 67, 65, 76, 76, 84, 82, 73, 50,   /* 0x 780 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32,   /* 0x 790 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 7a0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 48, 32, 32, 50, 42,   /* 0x 7b0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 7c0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,   /* 0x 7d0 */
 57, 32, 67, 84, 49, 54, 69, 56, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x 7e0 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 7f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x 800 */
 48, 48, 48, 48,100, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x 810 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x 820 */
 10, 32, 50, 48, 32, 67, 84, 49, 54, 69, 57, 48, 48, 32, 32, 32,   /* 0x 830 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,   /* 0x 840 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x 850 */
 32, 48, 48, 48, 48, 48, 48,100, 53, 32, 32, 50, 42, 42, 48, 32,   /* 0x 860 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x 870 */
 78, 76, 89, 10, 32, 50, 49, 32, 67, 65, 76, 76, 84, 82, 73, 53,   /* 0x 880 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32,   /* 0x 890 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 8a0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 55, 32, 32, 50, 42,   /* 0x 8b0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x 8c0 */
 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,   /* 0x 8d0 */
 50, 32, 67, 84, 49, 54, 74, 69, 78, 68, 32, 32, 32, 32, 32, 32,   /* 0x 8e0 */
 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 8f0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x 900 */
 48, 48, 48, 48,100,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,   /* 0x 910 */
 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,   /* 0x 920 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 67, 84, 49, 54,   /* 0x 930 */
 74, 85, 76, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x 940 */
 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x 950 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100,102,   /* 0x 960 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x 970 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x 980 */
 89, 10, 32, 50, 52, 32, 67, 84, 49, 54, 73, 50, 56, 55, 32, 32,   /* 0x 990 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,   /* 0x 9a0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x 9b0 */
 32, 32, 48, 48, 48, 48, 48, 48,101, 49, 32, 32, 50, 42, 42, 48,   /* 0x 9c0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x 9d0 */
 79, 78, 76, 89, 10, 32, 50, 53, 32, 67, 84, 49, 54, 83, 85, 66,   /* 0x 9e0 */
 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,   /* 0x 9f0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x a00 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 52, 32, 32, 50,   /* 0x a10 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x a20 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 67, 84, 49, 54,   /* 0x a30 */
 73, 48, 56, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x a40 */
 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x a50 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 54,   /* 0x a60 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x a70 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 55, 32, 67,   /* 0x a80 */
 65, 76, 76, 84, 82, 73, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x a90 */
 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x aa0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x ab0 */
 48,101,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x ac0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x ad0 */
 79, 78, 76, 89, 10, 32, 50, 56, 32, 67, 79, 82, 69, 84, 85, 82,   /* 0x ae0 */
 78, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x af0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x b00 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102, 49, 32, 32, 50,   /* 0x b10 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x b20 */
 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84,   /* 0x b30 */
 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x b40 */
 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48,  9,   /* 0x b50 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 49, 54,   /* 0x b60 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x b70 */
100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,  9, 48, 48, 48, 48,   /* 0x b80 */
 48, 48, 48, 48, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48, 48,   /* 0x b90 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x ba0 */
 65, 76, 76, 84, 82, 49, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x bb0 */
 32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 48, 48, 48, 48, 48, 48,   /* 0x bc0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,   /* 0x bd0 */
 82, 73, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,   /* 0x be0 */
 76, 84, 82, 73, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x bf0 */
 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 73, 54,  9,   /* 0x c00 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 73,   /* 0x c10 */
 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x c20 */
100, 32, 32, 67, 79, 77, 77, 65, 73, 78, 49,  9, 48, 48, 48, 48,   /* 0x c30 */
 48, 48, 48, 48, 32, 67, 79, 77, 77, 65, 73, 78, 49, 10, 48, 48,   /* 0x c40 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x c50 */
 79, 77, 83, 66, 66, 66, 80,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x c60 */
 32, 67, 79, 77, 83, 66, 66, 66, 80, 10, 48, 48, 48, 48, 48, 48,   /* 0x c70 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 79, 77, 80, 83,   /* 0x c80 */
 72, 68, 73,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77,   /* 0x c90 */
 80, 83, 72, 68, 73, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x ca0 */
 32, 32, 32, 32,100, 32, 32, 67, 79, 77, 67, 65, 76, 76, 84,  9,   /* 0x cb0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77, 67, 65, 76, 76,   /* 0x cc0 */
 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x cd0 */
100, 32, 32, 67, 79, 77, 77, 65, 73, 78, 50,  9, 48, 48, 48, 48,   /* 0x ce0 */
 48, 48, 48, 48, 32, 67, 79, 77, 77, 65, 73, 78, 50, 10, 48, 48,   /* 0x cf0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85,   /* 0x d00 */
 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x d10 */
 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,   /* 0x d20 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 79, 77, 67, 85,   /* 0x d30 */
 84, 80, 79,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77,   /* 0x d40 */
 67, 85, 84, 80, 79, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x d50 */
 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 68, 79, 78, 69,  9,   /* 0x d60 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 68, 79, 78,   /* 0x d70 */
 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x d80 */
100, 32, 32, 78, 82, 86, 68, 82, 69, 84, 85,  9, 48, 48, 48, 48,   /* 0x d90 */
 48, 48, 48, 48, 32, 78, 82, 86, 68, 82, 69, 84, 85, 10, 48, 48,   /* 0x da0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,   /* 0x db0 */
 82, 86, 68, 69, 67, 79, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x dc0 */
 32, 78, 82, 86, 68, 69, 67, 79, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x dd0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 76, 69,   /* 0x de0 */
 68, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,   /* 0x df0 */
 76, 69, 68, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x e00 */
 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 71, 84, 68, 48, 48,  9,   /* 0x e10 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 71, 84, 68, 48,   /* 0x e20 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x e30 */
100, 32, 32, 67, 84, 49, 54, 73, 50, 56, 54,  9, 48, 48, 48, 48,   /* 0x e40 */
 48, 48, 48, 48, 32, 67, 84, 49, 54, 73, 50, 56, 54, 10, 48, 48,   /* 0x e50 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x e60 */
 84, 49, 54, 83, 85, 66, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x e70 */
 32, 67, 84, 49, 54, 83, 85, 66, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x e80 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73,   /* 0x e90 */
 48, 56, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49,   /* 0x ea0 */
 54, 73, 48, 56, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x eb0 */
 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 73, 50,  9,   /* 0x ec0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 73,   /* 0x ed0 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x ee0 */
100, 32, 32, 67, 84, 49, 54, 69, 56, 48, 48,  9, 48, 48, 48, 48,   /* 0x ef0 */
 48, 48, 48, 48, 32, 67, 84, 49, 54, 69, 56, 48, 48, 10, 48, 48,   /* 0x f00 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x f10 */
 84, 49, 54, 69, 57, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x f20 */
 32, 67, 84, 49, 54, 69, 57, 48, 48, 10, 48, 48, 48, 48, 48, 48,   /* 0x f30 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 74,   /* 0x f40 */
 69, 78, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49,   /* 0x f50 */
 54, 74, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x f60 */
 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 74, 85, 76, 50,  9,   /* 0x f70 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 74, 85, 76,   /* 0x f80 */
 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x f90 */
100, 32, 32, 67, 84, 49, 54, 73, 50, 56, 55,  9, 48, 48, 48, 48,   /* 0x fa0 */
 48, 48, 48, 48, 32, 67, 84, 49, 54, 73, 50, 56, 55, 10, 48, 48,   /* 0x fb0 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,   /* 0x fc0 */
 84, 49, 54, 83, 85, 66, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x fd0 */
 32, 67, 84, 49, 54, 83, 85, 66, 49, 10, 48, 48, 48, 48, 48, 48,   /* 0x fe0 */
 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73,   /* 0x ff0 */
 48, 56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49,   /* 0x1000 */
 54, 73, 48, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,   /* 0x1010 */
 32, 32, 32, 32,100, 32, 32, 67, 79, 82, 69, 84, 85, 82, 78,  9,   /* 0x1020 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 82, 69, 84, 85, 82,   /* 0x1030 */
 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,   /* 0x1040 */
 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1050 */
 48, 32,115,112, 95,108,105,109,105,116, 10, 48, 48, 48, 48, 48,   /* 0x1060 */
 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,   /* 0x1070 */
 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,121,116,101,115,   /* 0x1080 */
 95,116,111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1090 */
 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,   /* 0x10a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,112,121, 95,115,111,   /* 0x10b0 */
117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,   /* 0x10c0 */
 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,   /* 0x10d0 */
 48, 48, 48, 48, 32, 99,111,112,121, 95,100,101,115,116,105,110,   /* 0x10e0 */
 97,116,105,111,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x10f0 */
 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,   /* 0x1100 */
 48, 48, 48, 48, 48, 32,110,101,103, 95,101, 95,108,101,110, 10,   /* 0x1110 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1120 */
 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1130 */
 99, 97,108,108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10,   /* 0x1140 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x1150 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 79, 77, 77, 65, 73, 78,   /* 0x1160 */
 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x1170 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x1180 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,   /* 0x1190 */
 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x11a0 */
115,112, 95,108,105,109,105,116, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x11b0 */
 57, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,   /* 0x11c0 */
 32, 32, 32, 32, 98,121,116,101,115, 95,116,111, 95, 99,111,112,   /* 0x11d0 */
121, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54,   /* 0x11e0 */
 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,   /* 0x11f0 */
121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48,   /* 0x1200 */
102, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,   /* 0x1210 */
 32, 32, 32, 32, 99,111,112,121, 95,100,101,115,116,105,110, 97,   /* 0x1220 */
116,105,111,110, 10, 48, 48, 48, 48, 48, 48, 49, 99, 32, 82, 95,   /* 0x1230 */
 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1240 */
110,101,103, 95,101, 95,108,101,110, 10, 10, 82, 69, 76, 79, 67,   /* 0x1250 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x1260 */
 82, 32, 91, 67, 79, 77, 77, 65, 73, 78, 50, 93, 58, 10, 79, 70,   /* 0x1270 */
 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,   /* 0x1280 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,   /* 0x1290 */
 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x12a0 */
 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49,   /* 0x12b0 */
 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x12c0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50,   /* 0x12d0 */
 66, 49, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x12e0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x12f0 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,   /* 0x1300 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,   /* 0x1310 */
 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48, 48, 48, 48,   /* 0x1320 */
 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32,   /* 0x1330 */
 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10,   /* 0x1340 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x1350 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 68, 79, 78,   /* 0x1360 */
 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,   /* 0x1370 */
 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,   /* 0x1380 */
 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,   /* 0x1390 */
 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x13a0 */
 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65,   /* 0x13b0 */
 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,   /* 0x13c0 */
 32, 91, 78, 82, 86, 68, 82, 69, 84, 85, 93, 58, 10, 79, 70, 70,   /* 0x13d0 */
 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,   /* 0x13e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,   /* 0x13f0 */
 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,   /* 0x1400 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79,   /* 0x1410 */
 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,   /* 0x1420 */
 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 69,   /* 0x1430 */
 67, 79, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x1440 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1450 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,   /* 0x1460 */
 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,   /* 0x1470 */
 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 48, 48, 48, 48, 48,   /* 0x1480 */
 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32,   /* 0x1490 */
 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 48,   /* 0x14a0 */
 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67,   /* 0x14b0 */
 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67,   /* 0x14c0 */
 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,   /* 0x14d0 */
 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68,   /* 0x14e0 */
 69, 67, 79, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,   /* 0x14f0 */
 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1500 */
 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55,   /* 0x1510 */
 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,   /* 0x1520 */
 32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 10, 82, 69, 76,   /* 0x1530 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x1540 */
 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 54, 93, 58, 10,   /* 0x1550 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x1560 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x1570 */
 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,   /* 0x1580 */
 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,108,108,   /* 0x1590 */
116,114,105, 99,107, 95, 99, 97,108,108,115, 10, 10, 82, 69, 76,   /* 0x15a0 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x15b0 */
 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 50, 93, 58, 10,   /* 0x15c0 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x15d0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x15e0 */
 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,   /* 0x15f0 */
 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76,   /* 0x1600 */
 84, 82, 49, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x1610 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,   /* 0x1620 */
 76, 76, 84, 82, 73, 53, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x1630 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1640 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x1650 */
 48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32,   /* 0x1660 */
 32, 32, 32, 32, 32, 99, 97,108,108,116,114,105, 99,107, 95, 99,   /* 0x1670 */
 97,108,108,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x1680 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84,   /* 0x1690 */
 49, 54, 74, 69, 78, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,   /* 0x16a0 */
 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x16b0 */
 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,   /* 0x16c0 */
 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,   /* 0x16d0 */
 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82,   /* 0x16e0 */
 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,   /* 0x16f0 */
 83, 32, 70, 79, 82, 32, 91, 67, 84, 49, 54, 74, 85, 76, 50, 93,   /* 0x1700 */
 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,   /* 0x1710 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,   /* 0x1720 */
 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,   /* 0x1730 */
 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65,   /* 0x1740 */
 76, 76, 84, 82, 73, 54, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,   /* 0x1750 */
 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,   /* 0x1760 */
 67, 65, 76, 76, 84, 82, 73, 54, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x1770 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x1780 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x1790 */
 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,   /* 0x17a0 */
 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 73, 53, 10    /* 0x17b0 */
};
