/* powerpc-linux.kernel.vmlinux.h
   created from powerpc-linux.kernel.vmlinux.bin, 8823 (0x2277) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2007 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2007 Laszlo Molnar
   Copyright (C) 2000-2007 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <mfx@users.sourceforge.net>          <ml1050@users.sourceforge.net>
 */


#define STUB_POWERPC_LINUX_KERNEL_VMLINUX_SIZE    8823
#define STUB_POWERPC_LINUX_KERNEL_VMLINUX_ADLER32 0xf9f4e72f
#define STUB_POWERPC_LINUX_KERNEL_VMLINUX_CRC32   0x2ccf6e01

unsigned char stub_powerpc_linux_kernel_vmlinux[8823] = {
127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x   0 */
  0,  1,  0, 20,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x  10 */
  0,  0, 24,164,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,   /* 0x  20 */
  0, 23,  0, 20, 72,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,   /* 0x  30 */
  0,  0,  0,  0, 40,  6,  0,208, 76,130,  0, 32, 84,132,240,191,   /* 0x  40 */
 77,130,  0, 32, 60,  0,  0, 16,124,  4,  0, 64, 65,128,  0,  8,   /* 0x  50 */
124,  4,  3,120, 56,165,  1, 32,124,103, 27,120, 56, 99,255,252,   /* 0x  60 */
124,137,  3,166, 72,  0,  0, 28, 84, 75,  2,186,125, 99, 88, 80,   /* 0x  70 */
125,107, 58, 20, 81, 98,  1,186,144, 67,  0,  0, 78, 64,  0, 32,   /* 0x  80 */
132, 67,  0,  4, 84, 75, 85,190,124, 11, 40, 64, 65,162,255,220,   /* 0x  90 */
 66,  0,255,240, 78,128,  0, 32,124,  0, 41,236,125,168,  2,166,   /* 0x  a0 */
 40,  7,  0,  2, 64,130,  0,228,144,166,  0,  0,124,132, 26, 20,   /* 0x  b0 */
 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255, 56,165,255,255,   /* 0x  c0 */
 57, 64,255,255, 72,  0,  0,180,124,  9,  0, 64,125, 41, 72, 20,   /* 0x  d0 */
 76,162,  0, 32, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,   /* 0x  e0 */
124,  9,  0, 64,125, 41, 73, 20, 78,128,  0, 32,141,  3,  0,  1,   /* 0x  f0 */
157,  5,  0,  1, 75,255,255,213, 65,129,255,244, 56,224,  0,  1,   /* 0x 100 */
 75,255,255,201,124,231, 57, 21, 75,255,255,193, 65,160,255,244,   /* 0x 110 */
 52,231,255,253, 57,  0,  0,  0, 65,128,  0, 20,140, 67,  0,  1,   /* 0x 120 */
 84,231, 64, 46,124,234, 16,249, 65,130,  0,  0, 75,255,255,157,   /* 0x 130 */
125,  8, 65, 21, 75,255,255,149,125,  8, 65, 21, 56,224,  0,  1,   /* 0x 140 */
 64,130,  0, 28, 56,224,  0,  3, 57,  0,  0,  1, 75,255,255,125,   /* 0x 150 */
125,  8, 65, 21, 75,255,255,117, 65,160,255,244, 32, 74,242,255,   /* 0x 160 */
125,  8, 57, 20,124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,   /* 0x 170 */
157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,124,  7, 41,236,   /* 0x 180 */
124,  7, 26, 44, 75,255,255,112,124,  0, 41,236,125,168,  2,166,   /* 0x 190 */
 40,  7,  0,  5, 64,130,  1, 32,144,166,  0,  0,124,132, 26, 20,   /* 0x 1a0 */
 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255, 56,165,255,255,   /* 0x 1b0 */
 57, 64,255,255, 72,  0,  0,240, 57, 32,  0,  1,125, 41, 28, 44,   /* 0x 1c0 */
 56, 99,  0,  4,124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1,   /* 0x 1d0 */
 78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,   /* 0x 1e0 */
125, 41, 74, 20, 65,162,255,213, 65,129,255,236, 56,224,  0,  1,   /* 0x 1f0 */
 72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21, 65,162,255,189,   /* 0x 200 */
124,231, 57, 21,125, 41, 72, 21, 65,162,255,177,124,231, 57, 21,   /* 0x 210 */
124,  9,  0, 64,125, 41, 74, 20, 65,162,255,161, 65,160,255,216,   /* 0x 220 */
 57,  0,  0,  0, 52,231,255,253, 84,231, 64, 46, 65,128,  0, 24,   /* 0x 230 */
140, 67,  0,  1,124,234, 16,249,125, 74, 14,112, 65,130,  0,  0,   /* 0x 240 */
 72,  0,  0, 12,125, 41, 72, 21, 65,162,255,113,125,  8, 65, 21,   /* 0x 250 */
125, 41, 72, 21, 65,162,255,101,125,  8, 65, 21, 64,130,  0, 40,   /* 0x 260 */
 57,  0,  0,  1,125, 41, 72, 21, 65,162,255, 81,125,  8, 65, 21,   /* 0x 270 */
124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 65, 65,160,255,232,   /* 0x 280 */
 57,  8,  0,  2, 32,234,250,255, 57,  8,  0,  1,125,  8,  1,148,   /* 0x 290 */
124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,   /* 0x 2a0 */
 66,  0,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,   /* 0x 2b0 */
 75,255,255, 44,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  8,   /* 0x 2c0 */
 64,130,  1, 60,144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,   /* 0x 2d0 */
 61, 32,128,  0, 56, 99,255,255, 56,165,255,255, 57, 64,255,255,   /* 0x 2e0 */
 72,  0,  1, 12, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,   /* 0x 2f0 */
124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,   /* 0x 300 */
141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20,   /* 0x 310 */
 65,162,255,213, 65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20,   /* 0x 320 */
 56,231,255,255,125, 41, 72, 21, 65,162,255,189,124,231, 57, 20,   /* 0x 330 */
125, 41, 72, 21, 65,162,255,177,124,231, 57, 20,124,  9,  0, 64,   /* 0x 340 */
125, 41, 74, 20, 65,162,255,161, 65,160,255,216, 57,  0,  0,  0,   /* 0x 350 */
 52,231,255,253, 84,231, 64, 46, 65,128,  0, 32,140, 67,  0,  1,   /* 0x 360 */
124,234, 16,249,125, 74, 14,112, 65,130,  0,  0,112, 66,  0,  1,   /* 0x 370 */
 65,162,  0, 80, 72,  0,  0, 20,124,  9,  0, 64,125, 41, 74, 20,   /* 0x 380 */
 65,162,255,101, 65,161,  0, 60, 57,  0,  0,  1,124,  9,  0, 64,   /* 0x 390 */
125, 41, 74, 20, 65,162,255, 81, 65,161,  0, 40,125, 41, 72, 21,   /* 0x 3a0 */
 65,162,255, 69,125,  8, 65, 20,124,  9,  0, 64,125, 41, 74, 20,   /* 0x 3b0 */
 65,162,255, 53, 65,160,255,232, 57,  8,  0,  2, 72,  0,  0, 16,   /* 0x 3c0 */
125, 41, 72, 21, 65,162,255, 33,125,  8, 65, 20, 32,234,250,255,   /* 0x 3d0 */
 57,  8,  0,  2,125,  8,  1,148,124,234, 42, 20,125,  9,  3,166,   /* 0x 3e0 */
141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248, 56,224,  1,  0,   /* 0x 3f0 */
124,  7, 41,236,124,  7, 26, 44, 75,255,255, 16, 40,  7,  0, 14,   /* 0x 400 */
 64,130,  0, 16,124,  8,  2,166,124,201, 51,120,129,  6,  0,  0,   /* 0x 410 */
124,167, 43,120, 56,164,255,254, 56,131,  0,  2,144,  1,  0,  8,   /* 0x 420 */
136,  3,  0,  0, 84, 11,232,254, 84,  2,  7,126, 56, 96,250,  0,   /* 0x 430 */
124, 99, 88, 48, 56, 99,241,132,124, 38, 11,120,124, 33, 26, 20,   /* 0x 440 */
 84, 33,  0, 52, 56,  0,  0,  0,124,195, 51,120,144,  9,  0,  0,   /* 0x 450 */
148,  3,255,252,124,  1, 24, 64, 65,128,255,248,144,193,  0,  0,   /* 0x 460 */
136,  4,255,255, 56,193,  0,  8, 56, 97,  0, 12, 84, 11,225, 62,   /* 0x 470 */
 84,  0,  7, 62,152, 67,  0,  2,153, 99,  0,  1,152,  3,  0,  0,   /* 0x 480 */
124,  8,  2,166,148, 33,255,160,189,193,  0, 24,144,  1,  0,100,   /* 0x 490 */
 59, 32,  0,  0,137, 67,  0,  2,137, 99,  0,  1,138, 67,  0,  0,   /* 0x 4a0 */
147, 38,  0,  0,147, 41,  0,  0,136,  3,  0,  1,125, 40,  3,166,   /* 0x 4b0 */
124, 18,  2, 20, 57, 32,  3,  0,125, 41,  0, 48, 56,  9,  7, 54,   /* 0x 4c0 */
127,153,  0, 64, 57, 32,  0,  1,125, 43, 88, 48,125, 41, 80, 48,   /* 0x 4d0 */
 57, 41,255,255, 57,107,255,255,145, 33,  0,  8,124,206, 51,120,   /* 0x 4e0 */
124,147, 35,120,124,245, 59,120,125, 20, 67,120,145, 97,  0, 12,   /* 0x 4f0 */
 59,  3,  0,  4, 59,224,  0,  0, 58,224,  0,  0, 59, 64,  0,  1,   /* 0x 500 */
 58, 32,  0,  1, 58,  0,  0,  1, 57,224,  0,  1, 57, 32,  0,  0,   /* 0x 510 */
 64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60,   /* 0x 520 */
125,120,  3, 46, 57, 41,  0,  1, 66,  0,255,244,127,179, 42, 20,   /* 0x 530 */
126,108,155,120, 56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,   /* 0x 540 */
127,140,232,  0, 57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46,   /* 0x 550 */
 65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120,   /* 0x 560 */
 64,153,255,224,127,153,160, 64, 64,156,  8,100, 62,192,  0,255,   /* 0x 570 */
 98,214,255,255,128,  1,  0,  8,127,136,176, 64,127, 35,  0, 56,   /* 0x 580 */
 86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,   /* 0x 590 */
127,140,232,  0, 65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46,   /* 0x 5a0 */
124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,124,230,194, 46,   /* 0x 5b0 */
 85,  0,170,254,125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,   /* 0x 5c0 */
128,  1,  0, 12, 47,151,  0,  6,127, 41,  0, 56, 32, 18,  0,  8,   /* 0x 5d0 */
127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20, 29, 41,  6,  0,   /* 0x 5e0 */
 32,  7,  8,  0,124,  0, 46,112,124,  7,  2, 20,125, 56, 74, 20,   /* 0x 5f0 */
124,  6,195, 46,125, 72, 83,120, 56,201, 14,108, 56, 96,  0,  1,   /* 0x 600 */
 64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,127,245,  0,174,   /* 0x 610 */
 99,123,255,255, 87,255,  8, 60, 87,252,  5,238,127,136,216, 64,   /* 0x 620 */
 87,128,  8, 60, 84,100,  8, 60,124,  6,  2, 20,127, 12,232,  0,   /* 0x 630 */
 84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,   /* 0x 640 */
136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,   /* 0x 650 */
161,103,  2,  0, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,   /* 0x 660 */
127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,   /* 0x 670 */
 47, 28,  0,  0,125,105, 88, 80,124,131, 35,120,125, 10, 64, 80,   /* 0x 680 */
 64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24,   /* 0x 690 */
 72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1,   /* 0x 6a0 */
 65,154,  0, 12, 47,131,  0,255, 64,157,255,108, 47,131,  0,255,   /* 0x 6b0 */
 65,157,  0,132, 63,224,  0,255, 99,255,255,255,127,136,248, 64,   /* 0x 6c0 */
 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,227, 59,120,   /* 0x 6d0 */
 65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46,   /* 0x 6e0 */
 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,   /* 0x 6f0 */
125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,   /* 0x 700 */
 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,   /* 0x 710 */
 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,   /* 0x 720 */
124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255,   /* 0x 730 */
 64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,127,249,169,174,   /* 0x 740 */
 59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120,   /* 0x 750 */
 47,151,  0,  9, 65,157,  0, 12, 58,247,255,253, 72,  0,  6,104,   /* 0x 760 */
 58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80,127,136,176, 64,   /* 0x 770 */
 84,224,217,126,124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,   /* 0x 780 */
124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,127,140,232,  0,   /* 0x 790 */
 65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,   /* 0x 7a0 */
 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,128, 85,  0,170,254,   /* 0x 7b0 */
125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64, 32, 11,  8,  0,   /* 0x 7c0 */
 47,151,  0,  6,124,  0, 46,112,124, 11,  2, 20,176,  7,  1,128,   /* 0x 7d0 */
126, 15,131,120,125, 72, 83,120,126, 48,139,120, 56,  0,  0,  0,   /* 0x 7e0 */
127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120,   /* 0x 7f0 */
 56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80,127,136,176, 64,   /* 0x 800 */
 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128,   /* 0x 810 */
 65,157,  0, 32,127,140,232,  0, 65,158,  5,212,137, 44,  0,  0,   /* 0x 820 */
 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,   /* 0x 830 */
161,103,  1,152, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,   /* 0x 840 */
 64,156,  0,188, 32, 11,  8,  0,127,138,176, 64,124,  0, 46,112,   /* 0x 850 */
 86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,   /* 0x 860 */
176,  7,  1,152,125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,   /* 0x 870 */
127,140,232,  0, 65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46,   /* 0x 880 */
124,  5, 75,120, 85, 72, 64, 46, 57,140,  0,  1,161,103,  1,224,   /* 0x 890 */
 85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72,   /* 0x 8a0 */
 32, 11,  8,  0, 47,153,  0,  0,124,  0, 46,112,124, 11,  2, 20,   /* 0x 8b0 */
176,  7,  1,224,125, 72, 83,120, 65,158,  5, 52, 47,151,  0,  6,   /* 0x 8c0 */
 57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,   /* 0x 8d0 */
127,245,  0,174,125, 55, 75,120,127,249,169,174, 59, 57,  0,  1,   /* 0x 8e0 */
 72,  0,  4,228, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,   /* 0x 8f0 */
125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80,   /* 0x 900 */
127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,   /* 0x 910 */
176,  7,  1,152, 65,157,  0, 32,127,140,232,  0, 65,158,  4,208,   /* 0x 920 */
137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,   /* 0x 930 */
 57,140,  0,  1,161,103,  1,176, 85,  0,170,254,125, 64, 89,214,   /* 0x 940 */
127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,   /* 0x 950 */
124, 11,  2, 20,125, 72, 83,120,126, 41,139,120,176,  7,  1,176,   /* 0x 960 */
 72,  0,  0,140,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,   /* 0x 970 */
124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,   /* 0x 980 */
127,140,232,  0, 65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46,   /* 0x 990 */
124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,200,   /* 0x 9a0 */
 85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,   /* 0x 9b0 */
 32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,   /* 0x 9c0 */
126,  9,131,120,176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,   /* 0x 9d0 */
124,  0, 88, 80,125,233,123,120,176,  7,  1,200,124,170, 40, 80,   /* 0x 9e0 */
125, 10, 64, 80,126, 15,131,120,126, 48,139,120,127, 81,211,120,   /* 0x 9f0 */
125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8,   /* 0x a00 */
 56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,127,136,176, 64,   /* 0x a10 */
 65,157,  0, 32,127,140,232,  0, 65,158,  3,212,137, 44,  0,  0,   /* 0x a20 */
 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,   /* 0x a30 */
161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,   /* 0x a40 */
 64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,   /* 0x a50 */
124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4,   /* 0x a60 */
 59,128,  0,  0, 59, 96,  0,  3,176,  6,  0,  0, 72,  0,  0,156,   /* 0x a70 */
125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,   /* 0x a80 */
124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,127,140,232,  0,   /* 0x a90 */
 65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,   /* 0x aa0 */
 85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  2, 85,  0,170,254,   /* 0x ab0 */
125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0,   /* 0x ac0 */
 84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,   /* 0x ad0 */
125, 72, 83,120, 56,137,  1,  4, 59,128,  0,  8, 59, 96,  0,  3,   /* 0x ae0 */
176,  6,  0,  2, 72,  0,  0, 36, 85, 96,217,126,124,  0, 88, 80,   /* 0x af0 */
124,170, 40, 80,176,  6,  0,  2,125, 10, 64, 80, 56,134,  2,  4,   /* 0x b00 */
 59,128,  0, 16, 59, 96,  0,  8,127,105,  3,166, 63,224,  0,255,   /* 0x b10 */
 99,255,255,255, 56, 96,  0,  1,127,136,248, 64, 84,103,  8, 60,   /* 0x b20 */
127, 12,232,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,   /* 0x b30 */
 65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,   /* 0x b40 */
125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,125, 64, 89,214,   /* 0x b50 */
 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,   /* 0x b60 */
124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,   /* 0x b70 */
125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80,   /* 0x b80 */
 56,103,  0,  1,125,100, 59, 46, 66,  0,255,144, 56,  0,  0,  1,   /* 0x b90 */
 47,151,  0,  3,124,  0,216, 48,124, 96, 24, 80,124, 99,226, 20,   /* 0x ba0 */
 65,157,  1,232, 47,131,  0,  3, 58,247,  0,  7,124,105, 27,120,   /* 0x bb0 */
 64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48,125, 56, 74, 20,   /* 0x bc0 */
 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166, 63,224,  0,255,   /* 0x bd0 */
 99,255,255,255, 56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,   /* 0x be0 */
127, 12,232,  0, 84,169, 64, 46,124,228, 59,120, 65,157,  0, 24,   /* 0x bf0 */
 65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,   /* 0x c00 */
125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,   /* 0x c10 */
 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,   /* 0x c20 */
124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,   /* 0x c30 */
125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,   /* 0x c40 */
 56,135,  0,  1,125,102, 59, 46, 66,  0,255,144, 56,132,255,192,   /* 0x c50 */
 47,132,  0,  3,124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,   /* 0x c60 */
124,137, 14,112, 84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,   /* 0x c70 */
125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48, 87, 73,  8, 60,   /* 0x c80 */
125, 56, 74, 20, 84,128,  8, 60,125, 32, 72, 80, 56,201,  5, 94,   /* 0x c90 */
 72,  0,  0,100, 57, 41,255,251,125, 41,  3,166, 61, 96,  0,255,   /* 0x ca0 */
 97,107,255,255,127,136, 88, 64,127, 12,232,  0, 84,169, 64, 46,   /* 0x cb0 */
 87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0,   /* 0x cc0 */
 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,   /* 0x cd0 */
127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1,   /* 0x ce0 */
 66,  0,255,196, 56,  0,  0,  4,124,  9,  3,166, 87, 90, 32, 54,   /* 0x cf0 */
 56,216,  6, 68, 60,128,  0,255, 96,132,255,255, 59,128,  0,  1,   /* 0x d00 */
 59,224,  0,  1,127,136, 32, 64, 87,231,  8, 60,127, 12,232,  0,   /* 0x d10 */
 84,169, 64, 46,124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,   /* 0x d20 */
136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,   /* 0x d30 */
125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,   /* 0x d40 */
127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,   /* 0x d50 */
125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,   /* 0x d60 */
124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,   /* 0x d70 */
125,102, 59, 46,127, 90,227,120, 87,156,  8, 60, 66,  0,255,136,   /* 0x d80 */
 55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64, 56, 99,  0,  2,   /* 0x d90 */
 65,157,  0, 92,124, 26,200, 80,127,245,  0,174, 56, 99,255,255,   /* 0x da0 */
127,249,169,174, 59, 57,  0,  1, 49, 99,255,255,125, 43, 25, 16,   /* 0x db0 */
124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57,   /* 0x dc0 */
 64,130,255,212,127,153,160, 64, 65,156,247,172, 60,  0,  0,255,   /* 0x dd0 */
 96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,127,140,232,  0,   /* 0x de0 */
 56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1,   /* 0x df0 */
 72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80,   /* 0x e00 */
144, 14,  0,  0, 56, 96,  0,  0,147, 41,  0,  0,128,  1,  0,100,   /* 0x e10 */
185,193,  0, 24,124,  8,  3,166, 56, 33,  0, 96,124,  8,  2,166,   /* 0x e20 */
148, 33,255,160,189,193,  0, 24,144,  1,  0,100, 59, 32,  0,  0,   /* 0x e30 */
137, 67,  0,  2,137, 99,  0,  1,138, 67,  0,  0,147, 38,  0,  0,   /* 0x e40 */
147, 41,  0,  0,136,  3,  0,  1,125, 40,  3,166,124, 18,  2, 20,   /* 0x e50 */
 57, 32,  3,  0,125, 41,  0, 48, 56,  9,  7, 54,127,153,  0, 64,   /* 0x e60 */
 57, 32,  0,  1,125, 43, 88, 48,125, 41, 80, 48, 57, 41,255,255,   /* 0x e70 */
 57,107,255,255,145, 33,  0,  8,124,206, 51,120,124,147, 35,120,   /* 0x e80 */
124,245, 59,120,125, 20, 67,120,145, 97,  0, 12, 59,  3,  0,  4,   /* 0x e90 */
 59,224,  0,  0, 58,224,  0,  0, 59, 64,  0,  1, 58, 32,  0,  1,   /* 0x ea0 */
 58,  0,  0,  1, 57,224,  0,  1, 57, 32,  0,  0, 64,156,  0, 28,   /* 0x eb0 */
124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60,125,120,  3, 46,   /* 0x ec0 */
 57, 41,  0,  1, 66,  0,255,244,127,179, 42, 20,126,108,155,120,   /* 0x ed0 */
 56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,127,140,232,  0,   /* 0x ee0 */
 57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,   /* 0x ef0 */
136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120, 64,153,255,224,   /* 0x f00 */
127,153,160, 64, 64,156,  8,100, 62,192,  0,255, 98,214,255,255,   /* 0x f10 */
128,  1,  0,  8,127,136,176, 64,127, 35,  0, 56, 86,224, 32, 54,   /* 0x f20 */
124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,127,140,232,  0,   /* 0x f30 */
 65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,   /* 0x f40 */
 85,  8, 64, 46, 57,140,  0,  1,124,230,194, 46, 85,  0,170,254,   /* 0x f50 */
125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12,   /* 0x f60 */
 47,151,  0,  6,127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,   /* 0x f70 */
125, 41,144, 48,125, 41,  2, 20, 29, 41,  6,  0, 32,  7,  8,  0,   /* 0x f80 */
124,  0, 46,112,124,  7,  2, 20,125, 56, 74, 20,124,  6,195, 46,   /* 0x f90 */
125, 72, 83,120, 56,201, 14,108, 56, 96,  0,  1, 64,157,  0,180,   /* 0x fa0 */
124, 26,200, 80, 63, 96,  0,255,127,245,  0,174, 99,123,255,255,   /* 0x fb0 */
 87,255,  8, 60, 87,252,  5,238,127,136,216, 64, 87,128,  8, 60,   /* 0x fc0 */
 84,100,  8, 60,124,  6,  2, 20,127, 12,232,  0, 84,169, 64, 46,   /* 0x fd0 */
124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0,   /* 0x fe0 */
 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,161,103,  2,  0,   /* 0x ff0 */
 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,   /* 0x1000 */
124,  0, 46,112, 85,105,217,126,124, 11,  2, 20, 47, 28,  0,  0,   /* 0x1010 */
125,105, 88, 80,124,131, 35,120,125, 10, 64, 80, 64,156,  0, 20,   /* 0x1020 */
176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,   /* 0x1030 */
177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12,   /* 0x1040 */
 47,131,  0,255, 64,157,255,108, 47,131,  0,255, 65,157,  0,132,   /* 0x1050 */
 63,224,  0,255, 99,255,255,255,127,136,248, 64, 84,103,  8, 60,   /* 0x1060 */
127, 12,232,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,   /* 0x1070 */
 65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,   /* 0x1080 */
125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,   /* 0x1090 */
 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,   /* 0x10a0 */
124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,   /* 0x10b0 */
125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,   /* 0x10c0 */
125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255, 64,157,255,140,   /* 0x10d0 */
 47,151,  0,  3, 84,127,  6, 62,127,249,169,174, 59, 57,  0,  1,   /* 0x10e0 */
 65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9,   /* 0x10f0 */
 65,157,  0, 12, 58,247,255,253, 72,  0,  6,104, 58,247,255,250,   /* 0x1100 */
 72,  0,  6, 96,125, 10, 64, 80,127,136,176, 64, 84,224,217,126,   /* 0x1110 */
124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,   /* 0x1120 */
124,248, 74, 20, 65,157,  0, 32,127,140,232,  0, 65,158,  6, 92,   /* 0x1130 */
137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,   /* 0x1140 */
 57,140,  0,  1,161,103,  1,128, 85,  0,170,254,125, 64, 89,214,   /* 0x1150 */
127,133, 80, 64, 64,156,  0, 64, 32, 11,  8,  0, 47,151,  0,  6,   /* 0x1160 */
124,  0, 46,112,124, 11,  2, 20,176,  7,  1,128,126, 15,131,120,   /* 0x1170 */
125, 72, 83,120,126, 48,139,120, 56,  0,  0,  0,127, 81,211,120,   /* 0x1180 */
 64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100,   /* 0x1190 */
 72,  0,  2, 24,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,   /* 0x11a0 */
124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,   /* 0x11b0 */
127,140,232,  0, 65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,   /* 0x11c0 */
124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,152,   /* 0x11d0 */
 85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0,188,   /* 0x11e0 */
 32, 11,  8,  0,127,138,176, 64,124,  0, 46,112, 86,233, 40, 52,   /* 0x11f0 */
124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,   /* 0x1200 */
125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,127,140,232,  0,   /* 0x1210 */
 65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,   /* 0x1220 */
 85, 72, 64, 46, 57,140,  0,  1,161,103,  1,224, 85,  0,170,254,   /* 0x1230 */
125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72, 32, 11,  8,  0,   /* 0x1240 */
 47,153,  0,  0,124,  0, 46,112,124, 11,  2, 20,176,  7,  1,224,   /* 0x1250 */
125, 72, 83,120, 65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9,   /* 0x1260 */
 64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,127,245,  0,174,   /* 0x1270 */
125, 55, 75,120,127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228,   /* 0x1280 */
 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,125, 10, 64, 80,   /* 0x1290 */
176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80,127,136,176, 64,   /* 0x12a0 */
 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152,   /* 0x12b0 */
 65,157,  0, 32,127,140,232,  0, 65,158,  4,208,137, 44,  0,  0,   /* 0x12c0 */
 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,   /* 0x12d0 */
161,103,  1,176, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,   /* 0x12e0 */
 64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,   /* 0x12f0 */
125, 72, 83,120,126, 41,139,120,176,  7,  1,176, 72,  0,  0,140,   /* 0x1300 */
125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,   /* 0x1310 */
124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,127,140,232,  0,   /* 0x1320 */
 65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,   /* 0x1330 */
 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,200, 85,  0,170,254,   /* 0x1340 */
125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,   /* 0x1350 */
124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,126,  9,131,120,   /* 0x1360 */
176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,124,  0, 88, 80,   /* 0x1370 */
125,233,123,120,176,  7,  1,200,124,170, 40, 80,125, 10, 64, 80,   /* 0x1380 */
126, 15,131,120,126, 48,139,120,127, 81,211,120,125, 58, 75,120,   /* 0x1390 */
 47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,   /* 0x13a0 */
124, 23,  3,120, 56,216, 10,104,127,136,176, 64, 65,157,  0, 32,   /* 0x13b0 */
127,140,232,  0, 65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,   /* 0x13c0 */
124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  0,   /* 0x13d0 */
 85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,   /* 0x13e0 */
 32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,   /* 0x13f0 */
124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4, 59,128,  0,  0,   /* 0x1400 */
 59, 96,  0,  3,176,  6,  0,  0, 72,  0,  0,156,125, 10, 64, 80,   /* 0x1410 */
127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,   /* 0x1420 */
176,  6,  0,  0, 65,157,  0, 32,127,140,232,  0, 65,158,  3, 92,   /* 0x1430 */
137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,   /* 0x1440 */
 57,140,  0,  1,161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,   /* 0x1450 */
127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,   /* 0x1460 */
125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,   /* 0x1470 */
 56,137,  1,  4, 59,128,  0,  8, 59, 96,  0,  3,176,  6,  0,  2,   /* 0x1480 */
 72,  0,  0, 36, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,   /* 0x1490 */
176,  6,  0,  2,125, 10, 64, 80, 56,134,  2,  4, 59,128,  0, 16,   /* 0x14a0 */
 59, 96,  0,  8,127,105,  3,166, 63,224,  0,255, 99,255,255,255,   /* 0x14b0 */
 56, 96,  0,  1,127,136,248, 64, 84,103,  8, 60,127, 12,232,  0,   /* 0x14c0 */
 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24, 65,154,  2,188,   /* 0x14d0 */
136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,   /* 0x14e0 */
125,100, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,   /* 0x14f0 */
127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,   /* 0x1500 */
125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,   /* 0x1510 */
124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,103,  0,  1,   /* 0x1520 */
125,100, 59, 46, 66,  0,255,144, 56,  0,  0,  1, 47,151,  0,  3,   /* 0x1530 */
124,  0,216, 48,124, 96, 24, 80,124, 99,226, 20, 65,157,  1,232,   /* 0x1540 */
 47,131,  0,  3, 58,247,  0,  7,124,105, 27,120, 64,157,  0,  8,   /* 0x1550 */
 57, 32,  0,  3, 85, 41, 56, 48,125, 56, 74, 20, 56,201,  3, 96,   /* 0x1560 */
 57, 32,  0,  6,125, 41,  3,166, 63,224,  0,255, 99,255,255,255,   /* 0x1570 */
 56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,127, 12,232,  0,   /* 0x1580 */
 84,169, 64, 46,124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,   /* 0x1590 */
136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,   /* 0x15a0 */
125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,   /* 0x15b0 */
127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,   /* 0x15c0 */
125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,   /* 0x15d0 */
124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,   /* 0x15e0 */
125,102, 59, 46, 66,  0,255,144, 56,132,255,192, 47,132,  0,  3,   /* 0x15f0 */
124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,124,137, 14,112,   /* 0x1600 */
 84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,125,105,  3,166,   /* 0x1610 */
 65,157,  0, 32,127, 90, 88, 48, 87, 73,  8, 60,125, 56, 74, 20,   /* 0x1620 */
 84,128,  8, 60,125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100,   /* 0x1630 */
 57, 41,255,251,125, 41,  3,166, 61, 96,  0,255, 97,107,255,255,   /* 0x1640 */
127,136, 88, 64,127, 12,232,  0, 84,169, 64, 46, 87, 90,  8, 60,   /* 0x1650 */
 65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46,   /* 0x1660 */
 57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,127,133, 64, 64,   /* 0x1670 */
 65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196,   /* 0x1680 */
 56,  0,  0,  4,124,  9,  3,166, 87, 90, 32, 54, 56,216,  6, 68,   /* 0x1690 */
 60,128,  0,255, 96,132,255,255, 59,128,  0,  1, 59,224,  0,  1,   /* 0x16a0 */
127,136, 32, 64, 87,231,  8, 60,127, 12,232,  0, 84,169, 64, 46,   /* 0x16b0 */
124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0,   /* 0x16c0 */
 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,   /* 0x16d0 */
 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,   /* 0x16e0 */
124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,   /* 0x16f0 */
125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,   /* 0x1700 */
 72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,   /* 0x1710 */
127, 90,227,120, 87,156,  8, 60, 66,  0,255,136, 55, 90,  0,  1,   /* 0x1720 */
 65,130,  0, 72,127,154,200, 64, 56, 99,  0,  2, 65,157,  0, 92,   /* 0x1730 */
124, 26,200, 80,127,245,  0,174, 56, 99,255,255,127,249,169,174,   /* 0x1740 */
 59, 57,  0,  1, 49, 99,255,255,125, 43, 25, 16,124, 20,200, 16,   /* 0x1750 */
124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,   /* 0x1760 */
127,153,160, 64, 65,156,247,172, 60,  0,  0,255, 96,  0,255,255,   /* 0x1770 */
127,136,  0, 64, 65,157,  0, 32,127,140,232,  0, 56, 96,  0,  1,   /* 0x1780 */
 65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28,   /* 0x1790 */
 57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80,144, 14,  0,  0,   /* 0x17a0 */
 56, 96,  0,  0,147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,   /* 0x17b0 */
124,  8,  3,166, 56, 33,  0, 96,128, 33,  0,  0,128,  1,  0,  8,   /* 0x17c0 */
124,  8,  3,166, 78,128,  0, 32, 85, 80, 88, 33,161,216,208,213,   /* 0x17d0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   /* 0x17e0 */
  0,  0,  0,  0,  0,  0,  0, 45,116,109,112, 47,112,111,119,101,   /* 0x17f0 */
114,112, 99, 45,108,105,110,117,120, 46,107,101,114,110,101,108,   /* 0x1800 */
 46,118,109,108,105,110,117,120, 46, 98,105,110, 58, 32, 32, 32,   /* 0x1810 */
 32, 32,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,   /* 0x1820 */
102, 51, 50, 45,112,111,119,101,114,112, 99, 10, 10, 83,101, 99,   /* 0x1830 */
116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32,   /* 0x1840 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32,   /* 0x1850 */
 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,   /* 0x1860 */
 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32,   /* 0x1870 */
 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48,   /* 0x1880 */
 32, 76, 73, 78, 85, 88, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48,   /* 0x1890 */
 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x18a0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x18b0 */
 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,   /* 0x18c0 */
 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,   /* 0x18d0 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 73, 78, 85, 88,   /* 0x18e0 */
 48, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,   /* 0x18f0 */
 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1900 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 99, 32,   /* 0x1910 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1920 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1930 */
 10, 32, 32, 50, 32, 76, 73, 78, 85, 88, 48, 50, 48, 32, 32, 32,   /* 0x1940 */
 32, 32, 32, 48, 48, 48, 48, 48, 48, 54, 52, 32, 32, 48, 48, 48,   /* 0x1950 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1960 */
 32, 48, 48, 48, 48, 48, 48, 52, 52, 32, 32, 50, 42, 42, 48, 32,   /* 0x1970 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,   /* 0x1980 */
 78, 76, 89, 10, 32, 32, 51, 32, 76, 73, 78, 85, 88, 48, 51, 48,   /* 0x1990 */
 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,   /* 0x19a0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x19b0 */
 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 56, 32, 32, 50, 42,   /* 0x19c0 */
 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,   /* 0x19d0 */
 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66,   /* 0x19e0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,102,   /* 0x19f0 */
 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,   /* 0x1a00 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 56, 32,   /* 0x1a10 */
 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,   /* 0x1a20 */
 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,   /* 0x1a30 */
 10, 32, 32, 53, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32,   /* 0x1a40 */
 32, 32, 32, 48, 48, 48, 48, 48, 49, 50, 99, 32, 32, 48, 48, 48,   /* 0x1a50 */
 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1a60 */
 32, 48, 48, 48, 48, 48, 49, 57, 56, 32, 32, 50, 42, 42, 48, 32,   /* 0x1a70 */
 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,   /* 0x1a80 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 78,   /* 0x1a90 */
 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1aa0 */
 48, 48, 49, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1ab0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1ac0 */
 50, 99, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1ad0 */
 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,   /* 0x1ae0 */
 79, 78, 76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65, 32, 32, 32,   /* 0x1af0 */
 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1b00 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1b10 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 48, 99, 32, 32, 50,   /* 0x1b20 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1b30 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 76, 90, 77, 65,   /* 0x1b40 */
 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1b50 */
 56, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1b60 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 48, 99,   /* 0x1b70 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1b80 */
 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,   /* 0x1b90 */
 89, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,   /* 0x1ba0 */
 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 57, 99, 32, 32, 48, 48,   /* 0x1bb0 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1bc0 */
 32, 32, 48, 48, 48, 48, 48, 52, 57, 48, 32, 32, 50, 42, 42, 48,   /* 0x1bd0 */
 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,   /* 0x1be0 */
 79, 78, 76, 89, 10, 32, 49, 48, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x1bf0 */
 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 57, 99, 32,   /* 0x1c00 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,   /* 0x1c10 */
 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101, 50, 99, 32, 32, 50,   /* 0x1c20 */
 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,   /* 0x1c30 */
 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 76, 90, 77, 65,   /* 0x1c40 */
 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,   /* 0x1c50 */
 49, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,   /* 0x1c60 */
 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 99, 56,   /* 0x1c70 */
 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,   /* 0x1c80 */
 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 85,   /* 0x1c90 */
 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48,   /* 0x1ca0 */
 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1cb0 */
 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,   /* 0x1cc0 */
 55,100, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,   /* 0x1cd0 */
 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89,   /* 0x1ce0 */
 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48,   /* 0x1cf0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78,   /* 0x1d00 */
 85, 88, 48, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,   /* 0x1d10 */
 73, 78, 85, 88, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1d20 */
 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 51,   /* 0x1d30 */
 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88,   /* 0x1d40 */
 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x1d50 */
 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9,   /* 0x1d60 */
 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69,   /* 0x1d70 */
 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,   /* 0x1d80 */
 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 48, 48,  9, 48, 48,   /* 0x1d90 */
 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10,   /* 0x1da0 */
 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,   /* 0x1db0 */
 32, 76, 73, 78, 85, 88, 48, 49, 48,  9, 48, 48, 48, 48, 48, 48,   /* 0x1dc0 */
 48, 48, 32, 76, 73, 78, 85, 88, 48, 49, 48, 10, 48, 48, 48, 48,   /* 0x1dd0 */
 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,   /* 0x1de0 */
 50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50,   /* 0x1df0 */
 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1e00 */
100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e10 */
 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48,   /* 0x1e20 */
 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48,   /* 0x1e30 */
 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48,   /* 0x1e40 */
 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,   /* 0x1e50 */
 90, 77, 65,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,   /* 0x1e60 */
 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1e70 */
100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48,   /* 0x1e80 */
 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,   /* 0x1e90 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1ea0 */
100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48,   /* 0x1eb0 */
 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,   /* 0x1ec0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1ed0 */
100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48,   /* 0x1ee0 */
 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,   /* 0x1ef0 */
 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,   /* 0x1f00 */
100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48,   /* 0x1f10 */
 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48,   /* 0x1f20 */
 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,   /* 0x1f30 */
 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,   /* 0x1f40 */
108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,   /* 0x1f50 */
 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,   /* 0x1f60 */
 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,   /* 0x1f70 */
101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,   /* 0x1f80 */
 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,   /* 0x1f90 */
 48, 48, 48, 48, 48, 48, 32,101,111,102, 95,110,114,118, 10, 10,   /* 0x1fa0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x1fb0 */
 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 48, 48,   /* 0x1fc0 */
 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,   /* 0x1fd0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,   /* 0x1fe0 */
 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 80,   /* 0x1ff0 */
 80, 67, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 32, 32, 76,   /* 0x2000 */
 73, 78, 85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 52,   /* 0x2010 */
 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32,   /* 0x2020 */
 32, 32, 32, 76, 73, 78, 85, 88, 48, 50, 48, 10, 10, 82, 69, 76,   /* 0x2030 */
 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,   /* 0x2040 */
 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 49, 48, 93, 58, 10,   /* 0x2050 */
 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,   /* 0x2060 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,   /* 0x2070 */
 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 80, 80, 67, 95,   /* 0x2080 */
 65, 68, 68, 82, 51, 50, 32, 32, 32, 32, 32, 32,102,105,108,116,   /* 0x2090 */
101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,   /* 0x20a0 */
 48, 52, 32, 82, 95, 80, 80, 67, 95, 65, 68, 68, 82, 51, 50, 32,   /* 0x20b0 */
 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,   /* 0x20c0 */
 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,   /* 0x20d0 */
 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58,   /* 0x20e0 */
 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,   /* 0x20f0 */
 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,   /* 0x2100 */
 69, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 80, 80, 67,   /* 0x2110 */
 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32,101,111,102,   /* 0x2120 */
 95,110,114,118, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,   /* 0x2130 */
 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,   /* 0x2140 */
 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,   /* 0x2150 */
 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2160 */
 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32,   /* 0x2170 */
 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,   /* 0x2180 */
 32, 32,101,111,102, 95,110,114,118, 10, 10, 82, 69, 76, 79, 67,   /* 0x2190 */
 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,   /* 0x21a0 */
 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69,   /* 0x21b0 */
 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x21c0 */
 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,   /* 0x21d0 */
 48, 48, 98, 52, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52,   /* 0x21e0 */
 32, 32, 32, 32, 32, 32, 32,101,111,102, 95,110,114,118, 10, 10,   /* 0x21f0 */
 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,   /* 0x2200 */
 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70,   /* 0x2210 */
 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,   /* 0x2220 */
 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,   /* 0x2230 */
 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,   /* 0x2240 */
 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32,   /* 0x2250 */
 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48,   /* 0x2260 */
 48, 48, 48, 48, 49, 48, 10                                        /* 0x2270 */
};
