/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#include "gtk_pairs.h"
#include "pairsModeling/externalGtkPairsExtensions.h"
#include "gtk_main.h"
#include "extraGtkFunctions/gtk_colorComboBoxWidget.h"
#include "renderingBackend/visu_windowInterface.h"
#include "gtk_renderingWindowWidget.h"

#include "interface.h"
#include "support.h"

#include "visu_tools.h"
#include "visu_object.h"
#include "visu_data.h"
#include "visu_pairs.h"


GtkWidget *vboxPairsDialog;
GtkWidget *specificWindow;


/* Current pair list is out of date. */
static gboolean pairsNeedBuild;


struct specBuildFunc_struct
{
  GtkPairsBuildWidgetsFunc area;
  GtkPairsGetValuesAsLabelFunc label;
  GtkPairsSetValuesFunc selected;
};

static GtkWidget *gtkPairs_treeView;
static GtkWidget *widgetColor;
static GtkWidget *hboxCheckWidgets;
static GtkWidget *comboFilter, *btAdd, *btRemove;
static gulong widgetColorSignalId;

static gulong gtkPairs_spinMinSignalId, gtkPairs_spinMaxSignalId;
static GtkWidget *gtkPairs_spinMin, *gtkPairs_spinMax;

/* This enum is used to access the column
   of the liststore have the data of pairs. */
enum
  {
    GTK_PAIRS_COLUMN_DRAWN,
    GTK_PAIRS_COLUMN_LABEL_ELE1,
    GTK_PAIRS_COLUMN_LABEL_ELE2,
/*     GTK_PAIRS_COLUMN_LABEL_DISTANCE, */
    GTK_PAIRS_COLUMN_DISTANCE_FROM,
    GTK_PAIRS_COLUMN_DISTANCE_TO,
    GTK_PAIRS_COLUMN_PIXBUF_COLOR,
    GTK_PAIRS_COLUMN_LABEL_USER,
    GTK_PAIRS_COLUMN_PRINT_LENGTH,
    GTK_PAIRS_COLUMN_POINTER_TO_LINK,
    GTK_PAIRS_COLUMN_POINTER_TO_ELE1,
    GTK_PAIRS_COLUMN_POINTER_TO_ELE2,
    N_GTK_PAIRS_COLUMN
  };
static GtkTreeStore *pairsTreeStore;
/* The list store that controls the drawing of the pairs data. */
static GtkTreeModel *pairsFilter, *pairsSortable;
static GtkTreeSelection *pairsSelection;

/* Combobox model. */
GtkListStore *gtkPairs_comboModel;
enum
  {
    GTK_PAIRS_COLUMN_PAIRS_ICON, /* A pixmap to represent the pairs */
    GTK_PAIRS_COLUMN_PAIRS_NAME, /* The label shown */
    GTK_PAIRS_COLUMN_PAIRS_POINTER,  /* Pointer to the pairs extension. */
    GTK_PAIRS_COLUMN_PAIRS_SPEC_BUILD,  /* Pointer to the pairs specBuildFunc_struct. */
    N_GTK_PAIRS_METHODS_PAIRS
  };
GtkWidget *gtkPairs_comboWidget;


GtkPairsSetValuesFunc currentSignalSelectedFunc;

/* Local routines. */
void addLabelToColorCombo(GtkListStore *list, GtkTreeIter *iter, Color* color);
static void minMaxChanged(GtkSpinButton *spin, GtkTreeSelection *tree, int minMax);
static void addPairAllData(GtkPairsGetValuesAsLabelFunc labelFunc,
			   VisuElement *ele1, VisuElement *ele2);
static GtkPairsGetValuesAsLabelFunc getLabelFunc();

/* Callbacks. */
static void onGtkPairsDrawnToggled(GtkCellRendererToggle *cell_renderer,
				   gchar *path, gpointer user_data);
static void onDistanceValueEdited(GtkCellRendererText *cellrenderertext,
				  gchar *path, gchar *text, gpointer user_data);
static void onGtkPairsLengthToggled(GtkCellRendererToggle *cell_renderer,
				    gchar *path, gpointer user_data);
static void selectionChanged(GtkTreeSelection *tree, gpointer data);
static void minChanged(GtkSpinButton *spin, gpointer userData);
static void maxChanged(GtkSpinButton *spin, gpointer userData);
static void pairsMethodChanged(GtkComboBox *combobox, gpointer userData);
static void filterChanged(GtkComboBox *combobox, gpointer userData);
static void colorChanged(ColorComboBox *colorWd, Color *color, gpointer userData);
static void onDataReady(GObject *obj, VisuData *dataObj, gpointer data);
static void rebuildPairsOnResources(GObject *obj, VisuData *dataObj, gpointer bool);
static gboolean pairsRowIsVisible(GtkTreeModel *model, GtkTreeIter *iter,
				  gpointer data);
static void onBtAdd(GtkButton *button, gpointer user_data);
static void onBtRemove(GtkButton *button, gpointer user_data);
static void onDistanceAutoSet(GtkButton *button, gpointer data);

#define GTK_PAIRS_HELP_TEXT _("Modifications, as color or wire width, are applied only to selected rows. Use <control> to select more than one row at a time.")

/* Create the label for the distance, need to free result. */
gchar* createDistanceLabel(VisuPairData *data);
/* Create the area for specific widgets of current rendering pairs method. */
void setSpecificArea(struct specBuildFunc_struct *specBuild);

/* Connect the signal and initialise values. */
void gtkPairsInit()
{
  GList *pnt;
  int i;
  struct specBuildFunc_struct *specBuild;
  GtkTreeIter iter;

  specificWindow = (GtkWidget*)0;
  currentSignalSelectedFunc = (GtkPairsSetValuesFunc)0;

  /* Create the listModel for pairs method*/
  gtkPairs_comboModel = gtk_list_store_new(N_GTK_PAIRS_METHODS_PAIRS,
					   GDK_TYPE_PIXBUF,
					   G_TYPE_STRING,
					   G_TYPE_POINTER,
					   G_TYPE_POINTER);
  gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(gtkPairs_comboModel),
				       GTK_PAIRS_COLUMN_PAIRS_NAME, GTK_SORT_ASCENDING);
  i = 0;
  pnt = visuPairExtensionGet_allMethods();
  while(pnt)
    {
      if (listGtkPairsInitFunc[i] && listGtkPairsBuildFunc[i] &&
	  listGtkPairsLabelFunc[i] && listGtkPairsSignalFunc[i])
	{
	  listGtkPairsInitFunc[i]();
	  specBuild = g_malloc(sizeof(struct specBuildFunc_struct));
	  specBuild->area = listGtkPairsBuildFunc[i];
	  specBuild->label = listGtkPairsLabelFunc[i];
	  specBuild->selected = listGtkPairsSignalFunc[i];
	  gtk_list_store_append(gtkPairs_comboModel, &iter);
	  gtk_list_store_set(gtkPairs_comboModel, &iter,
			     GTK_PAIRS_COLUMN_PAIRS_ICON, (GdkPixbuf*)0,
			     GTK_PAIRS_COLUMN_PAIRS_NAME, ((PairsExtension*)pnt->data)->printName,
			     GTK_PAIRS_COLUMN_PAIRS_POINTER, pnt->data,
			     GTK_PAIRS_COLUMN_PAIRS_SPEC_BUILD, (gpointer)specBuild,
			     -1);
	}
      i++;
      pnt = g_list_next(pnt);
    }
}

void gtkPairsBuild_window(GtkMain *main)
{
  GtkWidget *wd, *hbox, *image;
  GtkWidget *viewport;
  PairsExtension* pairs, *tmpPairs;
  GtkWidget *label;
  GtkObject *adj;

  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  GtkTreeIter iter;
  gboolean validIter;
  struct specBuildFunc_struct *specBuild;
  char* markup;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  /* Create the listModel for pairs data*/
  pairsTreeStore = gtk_tree_store_new(N_GTK_PAIRS_COLUMN, G_TYPE_BOOLEAN,
				      G_TYPE_STRING, G_TYPE_STRING,
				      G_TYPE_FLOAT, G_TYPE_FLOAT,
				      GDK_TYPE_PIXBUF, G_TYPE_STRING,
				      G_TYPE_BOOLEAN, G_TYPE_POINTER,
				      G_TYPE_POINTER, G_TYPE_POINTER);
  gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(pairsTreeStore),
				       GTK_PAIRS_COLUMN_LABEL_ELE1,
				       GTK_SORT_ASCENDING);

  main->pairsDialog = create_pairsDialog();
  gtk_window_set_type_hint(GTK_WINDOW(main->pairsDialog),
			   GDK_WINDOW_TYPE_HINT_UTILITY);
  
  gtk_widget_set_name(main->pairsDialog, "message");

  wd = lookup_widget(main->pairsDialog, "labelTitlePairs");
  gtk_widget_set_name(wd, "message_title");

  wd = lookup_widget(main->pairsDialog, "labelInfoPairs");
  gtk_widget_set_name(wd, "label_info");
  markup = g_markup_printf_escaped("<span size=\"smaller\">%s</span>",
				   GTK_PAIRS_HELP_TEXT);
  gtk_label_set_markup(GTK_LABEL(wd), markup);
  g_free(markup);

  viewport = lookup_widget(main->pairsDialog, "viewport1");
  gtk_widget_set_name(viewport, "message_viewport");

  wd = gtk_bin_get_child(GTK_BIN(viewport));
  if (wd)
    gtk_widget_destroy(wd);

  /* Create the TreeView to represent the pairs data. */
  gtkPairs_treeView = gtk_tree_view_new();
  g_object_set(G_OBJECT(gtkPairs_treeView), "rules-hint", TRUE, NULL);
  pairsSelection = gtk_tree_view_get_selection(GTK_TREE_VIEW(gtkPairs_treeView));
  gtk_widget_show(gtkPairs_treeView);
  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(gtkPairs_treeView), TRUE);
  gtk_container_add(GTK_CONTAINER(viewport), gtkPairs_treeView);

  vboxPairsDialog = lookup_widget(main->pairsDialog, "vboxPairsDialog");

  /* Create a filter for the treeview. */
  pairsFilter = gtk_tree_model_filter_new(GTK_TREE_MODEL(pairsTreeStore), NULL);
  pairsSortable = gtk_tree_model_sort_new_with_model(GTK_TREE_MODEL(pairsFilter));

  /* Set parameters for the tree */
  gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(gtkPairs_treeView)),
			      GTK_SELECTION_MULTIPLE);
  gtk_tree_view_set_model(GTK_TREE_VIEW(gtkPairs_treeView), pairsSortable);

  /* Create a filter selector for the shown pairs. */
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vboxPairsDialog), hbox, FALSE, FALSE, 0);

  label = gtk_label_new(_("Show pairs with: "));
  gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

  comboFilter = gtk_combo_box_new_text();
  gtk_box_pack_start(GTK_BOX(hbox), comboFilter, FALSE, FALSE, 0);
  g_signal_connect(G_OBJECT(comboFilter), "changed",
		   G_CALLBACK(filterChanged), (gpointer)pairsFilter);
  gtk_tree_model_filter_set_visible_func(GTK_TREE_MODEL_FILTER(pairsFilter),
					 pairsRowIsVisible, (gpointer)comboFilter,
					 (GtkDestroyNotify)0);

  btRemove = gtk_button_new();
  gtk_widget_set_sensitive(btRemove, FALSE);
  image = gtk_image_new_from_stock(GTK_STOCK_REMOVE, GTK_ICON_SIZE_BUTTON);
  gtk_container_add(GTK_CONTAINER(btRemove), image);
  gtk_box_pack_end(GTK_BOX(hbox), btRemove, FALSE, FALSE, 0);  
  g_signal_connect(G_OBJECT(btRemove), "clicked",
		   G_CALLBACK(onBtRemove), (gpointer)0);
  gtk_tooltips_set_tip(tooltips, btRemove,
		       _("Remove a link definition."), NULL);

  btAdd = gtk_button_new();
  image = gtk_image_new_from_stock(GTK_STOCK_ADD, GTK_ICON_SIZE_BUTTON);
  gtk_container_add(GTK_CONTAINER(btAdd), image);
  gtk_box_pack_end(GTK_BOX(hbox), btAdd, FALSE, FALSE, 3);  
  g_signal_connect(G_OBJECT(btAdd), "clicked",
		   G_CALLBACK(onBtAdd), (gpointer)0);
  gtk_tooltips_set_tip(tooltips, btAdd,
		       _("Add a new link definition using (0.,0.) if"
			 " it does not already exist."), NULL);

  label = gtk_label_new(_("Manage links: "));
  gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
  gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);

  gtk_widget_show_all(hbox);

  /* Create the part for the link parameters. */
  label = gtk_label_new(_("<b>Link parameters:</b>"));
  gtk_label_set_use_markup(GTK_LABEL(label), TRUE);
  gtk_misc_set_alignment(GTK_MISC(label), 0., 0.5);
  gtk_box_pack_start(GTK_BOX(vboxPairsDialog), label, FALSE, FALSE, 5);

  gtk_widget_show_all(label);

  /* Create widgets that apply to all checked pairs. */
  hboxCheckWidgets = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_sensitive(hboxCheckWidgets, FALSE);
  gtk_box_pack_start (GTK_BOX (vboxPairsDialog), hboxCheckWidgets, FALSE, FALSE, 0);

  label = gtk_label_new(_("From: "));
  gtk_box_pack_start(GTK_BOX(hboxCheckWidgets), label, TRUE, TRUE, 0);
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
  adj = gtk_adjustment_new(0, 0, 100, 0.1, 0.5, 10);
  gtkPairs_spinMin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 3);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(gtkPairs_spinMin), TRUE);
  gtk_box_pack_start(GTK_BOX(hboxCheckWidgets), gtkPairs_spinMin, FALSE, FALSE, 0);

  label = gtk_label_new(_(" to: "));
  gtk_box_pack_start(GTK_BOX(hboxCheckWidgets), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
  adj = gtk_adjustment_new(0, 0, 100, 0.1, 0.5, 10);
  gtkPairs_spinMax = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 1, 3);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(gtkPairs_spinMax), TRUE);
  gtk_box_pack_start(GTK_BOX(hboxCheckWidgets), gtkPairs_spinMax, FALSE, FALSE, 0);

  wd = gtk_button_new_with_mnemonic(_("_Auto set"));
  gtk_box_pack_start(GTK_BOX(hboxCheckWidgets), wd, FALSE, FALSE, 3);
  g_signal_connect(G_OBJECT(wd), "clicked",
		   G_CALLBACK(onDistanceAutoSet), (gpointer)0);

  label = gtk_label_new (_("Color: "));
  gtk_box_pack_start (GTK_BOX (hboxCheckWidgets), label, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

  widgetColor = colorComboBox_new(FALSE);
  gtk_box_pack_start(GTK_BOX(hboxCheckWidgets), widgetColor, FALSE, FALSE, 0);

  gtk_widget_show_all(hboxCheckWidgets);

  /* Render the associated tree */
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Ele."), renderer,
						     "text", GTK_PAIRS_COLUMN_LABEL_ELE1,
						     NULL);
  gtk_tree_view_column_set_sort_column_id(column, GTK_PAIRS_COLUMN_LABEL_ELE1);
  gtk_tree_view_column_set_sort_indicator(column, TRUE);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Ele."), renderer,
						     "text", GTK_PAIRS_COLUMN_LABEL_ELE2,
						     NULL);
  gtk_tree_view_column_set_sort_column_id(column, GTK_PAIRS_COLUMN_LABEL_ELE2);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);

  renderer = gtk_cell_renderer_toggle_new ();
  g_signal_connect(G_OBJECT(renderer), "toggled",
		   G_CALLBACK(onGtkPairsDrawnToggled), (gpointer)0);
  column = gtk_tree_view_column_new_with_attributes ("", renderer,
						     "active", GTK_PAIRS_COLUMN_DRAWN,
						     NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);

  renderer = gtk_cell_renderer_text_new();
  g_object_set(G_OBJECT(renderer), "editable", TRUE, "foreground", "blue", NULL);
  g_signal_connect(G_OBJECT(renderer), "edited", G_CALLBACK(onDistanceValueEdited),
		   GINT_TO_POINTER(GTK_PAIRS_COLUMN_DISTANCE_FROM));
  column = gtk_tree_view_column_new_with_attributes(_("From"), renderer, "text",
						    GTK_PAIRS_COLUMN_DISTANCE_FROM,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);
  renderer = gtk_cell_renderer_text_new();
  g_object_set(G_OBJECT(renderer), "editable", TRUE, "foreground", "blue", NULL);
  g_signal_connect(G_OBJECT(renderer), "edited", G_CALLBACK(onDistanceValueEdited),
		   GINT_TO_POINTER(GTK_PAIRS_COLUMN_DISTANCE_TO));
  column = gtk_tree_view_column_new_with_attributes(_("To"), renderer, "text",
						    GTK_PAIRS_COLUMN_DISTANCE_TO,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);

  renderer = gtk_cell_renderer_toggle_new ();
  g_signal_connect(G_OBJECT(renderer), "toggled",
		   G_CALLBACK(onGtkPairsLengthToggled), (gpointer)0);
  column = gtk_tree_view_column_new_with_attributes (_("Length"), renderer, "active",
						     GTK_PAIRS_COLUMN_PRINT_LENGTH,
						     NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);

  renderer = gtk_cell_renderer_pixbuf_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Color"), renderer,
						     "pixbuf", GTK_PAIRS_COLUMN_PIXBUF_COLOR,
						     NULL);
  image = gtk_image_new_from_stock(GTK_STOCK_SELECT_COLOR,
				   GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show(image);
  gtk_tree_view_column_set_widget(column, image);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Specific values"), renderer,
						     "text", GTK_PAIRS_COLUMN_LABEL_USER,
						     NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(gtkPairs_treeView), column);

  /* We create the tree widget that show the methods. */
  gtkPairs_comboWidget = gtk_combo_box_new();
  renderer = gtk_cell_renderer_pixbuf_new();
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(gtkPairs_comboWidget), renderer, FALSE);
  gtk_cell_layout_add_attribute(GTK_CELL_LAYOUT(gtkPairs_comboWidget), renderer, "pixbuf",
				GTK_PAIRS_COLUMN_PAIRS_ICON);
  renderer = gtk_cell_renderer_text_new();
  gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(gtkPairs_comboWidget), renderer, FALSE);
  gtk_cell_layout_add_attribute(GTK_CELL_LAYOUT(gtkPairs_comboWidget), renderer, "text",
				GTK_PAIRS_COLUMN_PAIRS_NAME);
  gtk_widget_show(gtkPairs_comboWidget);

  g_signal_connect(G_OBJECT(gtkPairs_comboWidget), "changed",
		   G_CALLBACK(pairsMethodChanged), (gpointer)0);

  gtk_combo_box_set_model(GTK_COMBO_BOX(gtkPairs_comboWidget),
			  GTK_TREE_MODEL(gtkPairs_comboModel));

  wd = lookup_widget(main->pairsDialog, "hboxPairsModel");
  pairs = visuPairExtensionGet_current();
  if (!visuPairExtensionGet_allMethods())
    {
      gtk_list_store_append(gtkPairs_comboModel, &iter);
      /* Entry of the pairs combo box : no method is available. */
      gtk_list_store_set(gtkPairs_comboModel, &iter,
			 GTK_PAIRS_COLUMN_PAIRS_ICON, (GdkPixbuf*)0,
			 GTK_PAIRS_COLUMN_PAIRS_NAME, _("No method available to draw pairs..."),
			 GTK_PAIRS_COLUMN_PAIRS_POINTER, (gpointer)0,
			 -1);
    }
  validIter = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(gtkPairs_comboModel), &iter);
  while (validIter)
    {
      gtk_tree_model_get(GTK_TREE_MODEL(gtkPairs_comboModel), &iter,
			 GTK_PAIRS_COLUMN_PAIRS_POINTER, &tmpPairs,
			 GTK_PAIRS_COLUMN_PAIRS_SPEC_BUILD, &specBuild,
			 -1);
      if (pairs == tmpPairs)
	{
	  gtk_combo_box_set_active_iter(GTK_COMBO_BOX(gtkPairs_comboWidget), &iter);
	  validIter = FALSE;
	}
      else
	validIter = gtk_tree_model_iter_next(GTK_TREE_MODEL(gtkPairs_comboModel), &iter);
    }
  gtk_box_pack_start(GTK_BOX(wd), gtkPairs_comboWidget, TRUE, TRUE, 0);
  

  /* Connect local signals. */
  g_signal_connect(G_OBJECT(gtk_tree_view_get_selection(GTK_TREE_VIEW(gtkPairs_treeView))),
		   "changed", G_CALLBACK(selectionChanged), (gpointer)0);
  widgetColorSignalId = g_signal_connect(G_OBJECT(widgetColor), "color-selected",
					 G_CALLBACK(colorChanged), (gpointer)0);
  gtkPairs_spinMinSignalId = g_signal_connect(G_OBJECT(gtkPairs_spinMin), "value_changed",
					      G_CALLBACK(minChanged),
					      (gpointer)gtk_tree_view_get_selection(GTK_TREE_VIEW(gtkPairs_treeView)));
  gtkPairs_spinMaxSignalId = g_signal_connect(G_OBJECT(gtkPairs_spinMax), "value_changed",
					      G_CALLBACK(maxChanged),
					      (gpointer)gtk_tree_view_get_selection(GTK_TREE_VIEW(gtkPairs_treeView)));

  /* Set the flag that indicates that interior is not built yet. */
  pairsNeedBuild = TRUE;

  g_signal_connect(G_OBJECT(visu), "dataReadyForRendering",
		   G_CALLBACK(onDataReady), (gpointer)main);
  g_signal_connect(G_OBJECT(visu), "resourcesLoaded",
		   G_CALLBACK(rebuildPairsOnResources), (gpointer)main);

  DBG_fprintf(stderr, "Gtk Pairs : Pairs are first built.\n");
}

static void addPairData(GtkTreeIter *iter, GtkPairsGetValuesAsLabelFunc labelFunc,
			VisuPairData *data)
{
  gboolean drawn;
  Color *color;
  GdkPixbuf *pixColor;
  gchar *label;

  /* Add the VisuPairData to the liststore. */
  drawn = visuPairGet_drawn(data);
  /* 	  lblDist = createDistanceLabel(data); */
  color = visuPairGet_linkProperty(data, "color");
  pixColor = colorComboBoxGet_pixbufFromColor(COLOR_COMBOX(widgetColor),
					      color);
  if (labelFunc)
    label = labelFunc(data);
  else
    label = (gchar*)0;
  gtk_tree_store_set(pairsTreeStore, iter,
		     GTK_PAIRS_COLUMN_DRAWN, drawn,
		     GTK_PAIRS_COLUMN_DISTANCE_FROM,
		     visuPairGet_distance(data, PAIRS_MIN),
		     GTK_PAIRS_COLUMN_DISTANCE_TO,
		     visuPairGet_distance(data, PAIRS_MAX),
		     GTK_PAIRS_COLUMN_PIXBUF_COLOR, pixColor,
		     GTK_PAIRS_COLUMN_LABEL_USER, label,
		     GTK_PAIRS_COLUMN_PRINT_LENGTH,
		     visuPairGet_printLength(data),
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, (gpointer)data,
		     -1);
  if (label)
    g_free(label);
}

static void addPairAllData(GtkPairsGetValuesAsLabelFunc labelFunc,
			   VisuElement *ele1, VisuElement *ele2)
{
  gboolean first;
  GList *tmpLst;
  GtkTreeIter iter, iterParent;

  first = TRUE;
  for (tmpLst = visuPairGet_links(ele1, ele2);
       tmpLst; tmpLst = g_list_next(tmpLst))
    {
      if (first)
	{
	  DBG_fprintf(stderr, " | pairs %s - %s (%p).\n",
		      ele1->name, ele2->name, tmpLst->data);

	  gtk_tree_store_append(pairsTreeStore, &iter, (GtkTreeIter*)0);
	  iterParent = iter;
	  gtk_tree_store_set(pairsTreeStore, &iterParent,
			     GTK_PAIRS_COLUMN_LABEL_ELE1, ele1->name,
			     GTK_PAIRS_COLUMN_LABEL_ELE2, ele2->name,
			     GTK_PAIRS_COLUMN_POINTER_TO_ELE1, ele1,
			     GTK_PAIRS_COLUMN_POINTER_TO_ELE2, ele2,
			     -1);
	  first = FALSE;
	  addPairData(&iterParent, labelFunc, (VisuPairData*)tmpLst->data);
	}
      else
	{
	  gtk_tree_store_append(pairsTreeStore, &iter, &iterParent);
	  addPairData(&iter, labelFunc, (VisuPairData*)tmpLst->data);
	}
    }
}

static GtkPairsGetValuesAsLabelFunc getLabelFunc()
{
  GtkTreeIter iter;
  gboolean validIter;
  struct specBuildFunc_struct *specBuild;

  /* We get the specific methods for turning pair information to
     string. */
  validIter = gtk_combo_box_get_active_iter(GTK_COMBO_BOX(gtkPairs_comboWidget),
					    &iter);
  g_return_val_if_fail(validIter, (GtkPairsGetValuesAsLabelFunc)0);

  specBuild = (struct specBuildFunc_struct*)0;
  gtk_tree_model_get(GTK_TREE_MODEL(gtkPairs_comboModel), &iter,
		     GTK_PAIRS_COLUMN_PAIRS_SPEC_BUILD, &specBuild,
		     -1);
  if (specBuild)
    return specBuild->label;
  else
    return (GtkPairsGetValuesAsLabelFunc)0;
}

void gtkPairsBuild_pairs(GtkMain *main, VisuData *dataObj, gboolean force)
{
  gboolean visible;
  GtkTreeModel *model;
  VisuDataIter iter1, iter2;
  GtkTreeIter iter;
  gboolean validIter;
  GtkPairsGetValuesAsLabelFunc labelFunc;

  DBG_fprintf(stderr, "Gtk Pairs: build the list of pairs.\n");

  /* Not show and not force, so we do nothing. */
  g_object_get(G_OBJECT(main->pairsDialog), "visible", &visible, NULL);
  if (!force && (!main->pairsDialog || !visible))
    {
      DBG_fprintf(stderr, "Gtk Pairs : Pairs become out of date.\n");
      pairsNeedBuild = TRUE;
      return;
    }

  /* We are visible, or forced but we are up to date, so we return. */
  if (!pairsNeedBuild)
    return;

  pairsNeedBuild = FALSE;

  /* We free the list of pairs. */
  gtk_tree_store_clear(pairsTreeStore);
  /* We empty the filter for rebuild. */
  model = gtk_combo_box_get_model(GTK_COMBO_BOX(comboFilter));
  gtk_list_store_clear(GTK_LIST_STORE(model));
  /* We add the default value. */
  gtk_combo_box_append_text(GTK_COMBO_BOX(comboFilter), _("all elements"));
  gtk_combo_box_set_active(GTK_COMBO_BOX(comboFilter), 0);

  /* If there is no data, we return. */
  if (!dataObj)
    return;

  labelFunc = getLabelFunc();
  visuDataIter_new(dataObj, &iter1);
  visuDataIter_new(dataObj, &iter2);
  for(visuDataIter_start(dataObj, &iter1); iter1.element;
      visuDataIter_nextElement(dataObj, &iter1))
    {
      for(visuDataIter_start(dataObj, &iter2);
	  iter2.element && iter2.iElement <= iter1.iElement ;
	  visuDataIter_nextElement(dataObj, &iter2))
	addPairAllData(labelFunc, iter1.element, iter2.element);
      /* Rebuild the filter. */
      gtk_combo_box_append_text(GTK_COMBO_BOX(comboFilter), iter1.element->name);
    }
  gtk_tree_view_expand_all(GTK_TREE_VIEW(gtkPairs_treeView));
  /* If we have only one element, we make the filter insensitive. */
  gtk_widget_set_sensitive(comboFilter, (dataObj->ntype > 1));
  /* We select the first link, if any. */
  validIter = gtk_tree_model_get_iter_first(pairsSortable, &iter);
  if (validIter)
    gtk_tree_selection_select_iter(pairsSelection, &iter);

  DBG_fprintf(stderr, "Gtk Pairs: Pairs are rebuilt.\n");
}
static void rebuildPairsOnResources(GObject *obj _U_, VisuData *dataObj,
				    gpointer data)
{
  DBG_fprintf(stderr, "Gtk Pairs: caught the 'resourcesLoaded' signal.\n");
  pairsNeedBuild = TRUE;
  /* Update the viewport with the first list element only. */
  if (dataObj)
    gtkPairsBuild_pairs(GTK_MAIN(data), dataObj, FALSE);

  /* TODO: Update the pair specific area. */
}
static void onDataReady(GObject *obj _U_, VisuData *dataObj, gpointer data)
{
  DBG_fprintf(stderr, "Gtk Pairs: caught the 'dataReadyForRendering' signal.\n");
  pairsNeedBuild = TRUE;
  gtkPairsBuild_pairs(GTK_MAIN(data), dataObj, FALSE);
}

gchar* createDistanceLabel(VisuPairData *data)
{
  GString *label;

  g_return_val_if_fail(data, (gchar*)0);

  label = g_string_new("");
  g_string_printf(label, _("from %7.3f to %7.3f"),
		  data->minMax[PAIRS_MIN],
		  data->minMax[PAIRS_MAX]);
  return g_string_free(label, FALSE);
}

void setSpecificArea(struct specBuildFunc_struct *specBuild)
{
  GtkPairsBuildWidgetsFunc buildSpecific;
  GtkWidget *wdlabel;


  /* change the specific area. */
  DBG_fprintf(stderr, "Gtk Pairs : previous specific widget : %d\n",
	      GPOINTER_TO_INT(specificWindow));
  if (specificWindow)
    gtk_widget_destroy(specificWindow);

  if (specBuild)
    buildSpecific = specBuild->area;
  else
    buildSpecific = (GtkPairsBuildWidgetsFunc)0;
  DBG_fprintf(stderr, "Gtk Pairs : method to build specific widgets : %d\n",
	      GPOINTER_TO_INT(buildSpecific));
  if (buildSpecific)
    specificWindow = buildSpecific();
  else
    {
      wdlabel = gtk_label_new(_("No parameters for these kinds of pairs."));
      specificWindow = wdlabel;
    }
  gtk_box_pack_start(GTK_BOX(vboxPairsDialog), specificWindow, FALSE, FALSE, 10);
  gtk_widget_show(specificWindow);
}

void gtkPairsIter_startSelected(GtkPairsIter *iter)
{
  g_return_if_fail(iter);

  iter->data = (VisuPairData*)0;

  iter->selected = gtk_tree_selection_get_selected_rows(pairsSelection, NULL);
  if (!iter->selected)
    return;

  iter->current = iter->selected;
  gtkPairsIter_nextSelected(iter);
}
void gtkPairsIter_nextSelected(GtkPairsIter *iter)
{
  gboolean validIter;
  GtkTreeIter iterFilter;

  g_return_if_fail(iter && iter->selected);

  iter->data = (VisuPairData*)0;

  if (!iter->current)
    {
      g_list_free(iter->selected);
      return;
    }

  validIter = gtk_tree_model_get_iter(GTK_TREE_MODEL(pairsFilter), &iterFilter,
				      (GtkTreePath*)iter->current->data);
  gtk_tree_path_free((GtkTreePath*)iter->current->data);
  if (!validIter)
    {
      g_warning("Wrong 'path' variable in 'gtkPairsIter_startSelected' method.\n");
      return;
    }
  gtk_tree_model_filter_convert_iter_to_child_iter
    (GTK_TREE_MODEL_FILTER(pairsFilter), &(iter->iter), &iterFilter);

  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &(iter->iter),
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &(iter->data),
		     -1);
  
  iter->current = g_list_next(iter->current);
}

void gtkPairsSet_specificLabels(GtkTreeIter *iter, const gchar *label)
{
  gtk_tree_store_set(pairsTreeStore, iter,
		     GTK_PAIRS_COLUMN_LABEL_USER, label,
		     -1);
}


/*************/
/* Callbacks */
/*************/

static void colorChanged(ColorComboBox *colorWd, Color *color, gpointer userData _U_)
{
  int res;
  GtkPairsIter iter;
  GdkPixbuf *pixColor;

  pixColor = colorComboBoxGet_selectedPixbuf(colorWd);
  res = 0;
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
      res = visuPairSet_color(iter.data, color) || res;
      gtk_tree_store_set(pairsTreeStore, &(iter.iter),
			 GTK_PAIRS_COLUMN_PIXBUF_COLOR, pixColor,
			 -1);
    }
  if (res)
    gtkPairs_createPairs();
}
static void minChanged(GtkSpinButton *spin, gpointer userData)
{
  minMaxChanged(spin, GTK_TREE_SELECTION(userData), PAIRS_MIN);
}
static void maxChanged(GtkSpinButton *spin, gpointer userData)
{
  minMaxChanged(spin, GTK_TREE_SELECTION(userData), PAIRS_MAX);
}
static void filterChanged(GtkComboBox *combobox, gpointer userData)
{
  DBG_fprintf(stderr, "Gtk Pairs: change the filter to '%d'.\n",
	      gtk_combo_box_get_active(GTK_COMBO_BOX(combobox)));

  gtk_tree_model_filter_refilter(GTK_TREE_MODEL_FILTER(userData));
}
static gboolean pairsRowIsVisible(GtkTreeModel *model, GtkTreeIter *iter,
				  gpointer data)
{
  gchar *name1, *name2;
  gchar *label;
  gboolean visible;
  GtkTreeIter iterParent;

  if (gtk_combo_box_get_active(GTK_COMBO_BOX(data)) == 0)
    return TRUE;

  if (!gtk_tree_model_iter_parent(model, &iterParent, iter))
    iterParent = *iter;
  gtk_tree_model_get(model, &iterParent,
		     GTK_PAIRS_COLUMN_LABEL_ELE1, &name1,
		     GTK_PAIRS_COLUMN_LABEL_ELE2, &name2,
		     -1);
#if GTK_MINOR_VERSION > 5
  label = gtk_combo_box_get_active_text(GTK_COMBO_BOX(data));
#else
  if (gtk_combo_box_get_active_iter(GTK_COMBO_BOX(data), &iterParent))
    gtk_tree_model_get(gtk_combo_box_get_model(GTK_COMBO_BOX(data)),
		       &iterParent, 0, &label, -1);
  else
    label = "error";
#endif
  visible = !strcmp(label, name1) || !strcmp(label, name2);
  DBG_fprintf(stderr, "Gtk Pairs: set visibility for '%s' '%s': %d\n",
	  name1, name2, visible);

  g_free(label);
  g_free(name1);
  g_free(name2);  
  return visible;
}
static void pairsMethodChanged(GtkComboBox *combobox, gpointer userData _U_)
{
  gchar *label;
  VisuPairData *data;
  struct specBuildFunc_struct *specBuild;
  GtkTreeIter iter, iterParent;
  gboolean validIter, valid;
  PairsExtension *pairsMethod;

  validIter = gtk_combo_box_get_active_iter(combobox, &iter);
  g_return_if_fail(validIter);

  specBuild = (struct specBuildFunc_struct*)0;
  gtk_tree_model_get(GTK_TREE_MODEL(gtkPairs_comboModel), &iter,
		     GTK_PAIRS_COLUMN_PAIRS_POINTER, &pairsMethod,
		     GTK_PAIRS_COLUMN_PAIRS_SPEC_BUILD, &specBuild,
		     -1);

  DBG_fprintf(stderr, "Gtk Pairs : set combobox to '%s'.\n", pairsMethod->name);

  /* change the specific area. */
  setSpecificArea(specBuild);

  /* change the label area. */
  DBG_fprintf(stderr, "Gtk Pairs : changing specific labels.\n");
  if (specBuild && specBuild->label)
    {
      validIter = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(pairsTreeStore),
						&iterParent);
      while (validIter)
	{
	  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
			     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &data,
			     -1);
	  label = specBuild->label(data);
	  gtk_tree_store_set(pairsTreeStore, &iterParent,
			     GTK_PAIRS_COLUMN_LABEL_USER, label,
			     -1);
	  g_free(label);
	  valid = gtk_tree_model_iter_children(GTK_TREE_MODEL(pairsTreeStore),
					       &iter, &iterParent);
	  while (valid)
	    {
	      gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iter,
				 GTK_PAIRS_COLUMN_POINTER_TO_LINK, &data,
				 -1);
	      label = specBuild->label(data);
	      gtk_tree_store_set(pairsTreeStore, &iter,
				 GTK_PAIRS_COLUMN_LABEL_USER, label,
				 -1);
	      g_free(label);
	      valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(pairsTreeStore),
					       &iter);
	    }
	  validIter = gtk_tree_model_iter_next(GTK_TREE_MODEL(pairsTreeStore),
					       &iterParent);
	}
    }
  /* Change the pointer on the current method that signals
     to specific area that a new data has been checked. */
  currentSignalSelectedFunc = specBuild->selected;

  if (visuPairExtensionSet(pairsMethod))
    gtkPairs_createPairs();
}
static void onGtkPairsDrawnToggled(GtkCellRendererToggle *cell_renderer _U_,
				   gchar *path, gpointer user_data _U_)
{
  gboolean valid, drawn;
  GtkTreeIter iter, iterFilter;
  gboolean res;
  VisuPairData *pdata;

  valid = gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(pairsFilter),
					      &iterFilter, path);
  g_return_if_fail(valid);

  gtk_tree_model_filter_convert_iter_to_child_iter
    (GTK_TREE_MODEL_FILTER(pairsFilter), &iter, &iterFilter);
  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iter,
		     GTK_PAIRS_COLUMN_DRAWN, &drawn,
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &pdata,
		     -1);
  gtk_tree_store_set(pairsTreeStore, &iter,
		     GTK_PAIRS_COLUMN_DRAWN, !drawn,
		     -1);
  res = visuPairSet_drawn(pdata, !drawn);

  if (res)
    gtkPairs_createPairs();
}
static void onGtkPairsLengthToggled(GtkCellRendererToggle *cell_renderer _U_,
				    gchar *path, gpointer user_data _U_)
{
  gboolean valid, length;
  GtkTreeIter iter, iterFilter;
  gboolean res;
  VisuPairData *pdata;

  valid = gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(pairsFilter),
					      &iterFilter, path);
  g_return_if_fail(valid);

  gtk_tree_model_filter_convert_iter_to_child_iter
    (GTK_TREE_MODEL_FILTER(pairsFilter), &iter, &iterFilter);
  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iter,
		     GTK_PAIRS_COLUMN_PRINT_LENGTH, &length,
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &pdata,
		     -1);
  gtk_tree_store_set(pairsTreeStore, &iter,
		     GTK_PAIRS_COLUMN_PRINT_LENGTH, !length,
		     -1);
  res = visuPairSet_printLength(pdata, !length);

  if (res)
    gtkPairs_createPairs();
}
static void onDistanceValueEdited(GtkCellRendererText *cellrenderertext _U_,
				  gchar *path, gchar *text, gpointer user_data)
{
  gboolean valid;
  GtkTreeIter iter;
  float value;
  char *error;
  VisuPairData *pdata;
  int res, id;

  DBG_fprintf(stderr, "Gtk Pairs: distance (%d) edited '%s'.\n",
	      GPOINTER_TO_INT(user_data), text);

  g_return_if_fail(GPOINTER_TO_INT(user_data) == GTK_PAIRS_COLUMN_DISTANCE_FROM ||
		   GPOINTER_TO_INT(user_data) == GTK_PAIRS_COLUMN_DISTANCE_TO);

  valid = gtk_tree_model_get_iter_from_string(GTK_TREE_MODEL(pairsTreeStore),
					      &iter, path);
  g_return_if_fail(valid);
  
  value = (float)strtod(text, &error);
  g_return_if_fail(!(value == 0. && error == text));

  gtk_tree_store_set(pairsTreeStore, &iter,
		     GPOINTER_TO_INT(user_data), value,
		     -1);

  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iter,
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &pdata,
		     -1);
  id = (GPOINTER_TO_INT(user_data) == GTK_PAIRS_COLUMN_DISTANCE_TO)?
    PAIRS_MAX:PAIRS_MIN;
  res = visuPairSet_distance(pdata, value, id);
  if (GPOINTER_TO_INT(user_data) == GTK_PAIRS_COLUMN_DISTANCE_FROM)
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gtkPairs_spinMin), value);
  else
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gtkPairs_spinMax), value);

  if (res)
    gtkPairs_createPairs();
}
static void minMaxChanged(GtkSpinButton *spin, GtkTreeSelection *tree _U_, int minMax)
{
  int res, id;
  float value;
  GtkPairsIter iter;

  value = (float)gtk_spin_button_get_value(spin);
  res = 0;
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
      res = visuPairSet_distance(iter.data, value, minMax) || res;
      id = (minMax == PAIRS_MIN)?GTK_PAIRS_COLUMN_DISTANCE_FROM:
	GTK_PAIRS_COLUMN_DISTANCE_TO;
      gtk_tree_store_set(pairsTreeStore, &(iter.iter), id, value, -1);
    }
  if (res)
    gtkPairs_createPairs();
}
static void selectionChanged(GtkTreeSelection *tree _U_, gpointer data _U_)
{
  gboolean select, isChild, hasChild;
  Color *color;
  GtkPairsIter iter;
  GtkTreeIter iterParent;

  DBG_fprintf(stderr, "Gtk Pairs: selection changed.\n");
  select = FALSE;
  isChild = FALSE;
  hasChild = FALSE;
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
      select = TRUE;
      /* Modify the values with the last selected iter. */
      if (!iter.current)
	{
	  /* Set the min/max values */
	  g_signal_handler_block(G_OBJECT(gtkPairs_spinMin),
				 gtkPairs_spinMinSignalId);
	  g_signal_handler_block(G_OBJECT(gtkPairs_spinMax),
				 gtkPairs_spinMaxSignalId);
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(gtkPairs_spinMin),
				    iter.data->minMax[PAIRS_MIN]);
	  gtk_spin_button_set_value(GTK_SPIN_BUTTON(gtkPairs_spinMax),
				    iter.data->minMax[PAIRS_MAX]);
	  g_signal_handler_unblock(G_OBJECT(gtkPairs_spinMax),
				   gtkPairs_spinMaxSignalId);
	  g_signal_handler_unblock(G_OBJECT(gtkPairs_spinMin),
				   gtkPairs_spinMinSignalId);
	      
	  /* Set the color */
	  color = (Color*)visuPairGet_linkProperty(iter.data, "color");
	  if (color)
	    {
	      g_signal_handler_block(G_OBJECT(widgetColor), widgetColorSignalId);
	      colorComboBoxSet_selectionByColor(COLOR_COMBOX(widgetColor), color);
	      g_signal_handler_unblock(G_OBJECT(widgetColor), widgetColorSignalId);
	    }

	  /* Set the user label */
	  if (currentSignalSelectedFunc)
	    currentSignalSelectedFunc(iter.data);

	  isChild = gtk_tree_model_iter_parent(GTK_TREE_MODEL(pairsTreeStore),
						&iterParent, &(iter.iter));
	  hasChild = gtk_tree_model_iter_has_child(GTK_TREE_MODEL(pairsTreeStore),
						   &(iter.iter));
	}
    }

  /* Set sensitive or not the modifing widgets. */
  gtk_widget_set_sensitive(hboxCheckWidgets, select);
  gtk_widget_set_sensitive(btAdd, select);
  gtk_widget_set_sensitive(btRemove, select && (isChild || hasChild));
}
static void onDistanceAutoSet(GtkButton *button _U_, gpointer data _U_)
{
  GtkPairsIter iter;
  GtkTreeIter iterParent;
  VisuPair *pair;
  VisuElement *ele1, *ele2;
  VisuPairDistribution *dd;
  RenderingWindow *window;
  VisuData *dataObj;
  float start, stop, min;
  int i;
  gboolean rebuild;

  rebuild = FALSE;
  g_signal_handler_block(G_OBJECT(gtkPairs_spinMin), gtkPairs_spinMinSignalId);
  g_signal_handler_block(G_OBJECT(gtkPairs_spinMax), gtkPairs_spinMaxSignalId);
  start = -1.f;
  stop = -1.f;
  for (gtkPairsIter_startSelected(&iter); iter.data;
       gtkPairsIter_nextSelected(&iter))
    {
  
      /* Get the ancestor of this iter. */
      if (!gtk_tree_model_iter_parent(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
				      &(iter.iter)))
	iterParent = iter.iter;

      /* Get the two elements and the corresponding pair. */
      gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
			 GTK_PAIRS_COLUMN_POINTER_TO_ELE1, &ele1,
			 GTK_PAIRS_COLUMN_POINTER_TO_ELE2, &ele2,
			 -1);
      pair = visuPairGet_pair(ele1, ele2);

      window = RENDERING_WINDOW(visuRenderingWindowGet_current());
      g_return_if_fail(window);
      dataObj = renderingWindowGet_visuData(window);
      dd = visuPairGet_distanceDistribution(pair, dataObj, -1.f, -1.f);
      g_return_if_fail(dd);

      start = -1.f;
      stop = -1.f;
      min = MIN(0.5f * dd->nNodesEle1, 0.5f * dd->nNodesEle2);
      for (i = 0 ; i < dd->nValues; i++)
	{
	  if (dd->histo[i] >= min)
	    start = dd->stepValue * i;
	  if (start > 0.f && dd->histo[i] < min)
	    {
	      stop = dd->stepValue * i;
	      break;
	    }
	}

      if (start > 0.f && stop > 0.f)
	{
	  gtk_tree_store_set(pairsTreeStore, &(iter.iter),
			     GTK_PAIRS_COLUMN_DISTANCE_FROM, start,
			     GTK_PAIRS_COLUMN_DISTANCE_TO, stop,
			     -1);

	  rebuild = visuPairSet_distance(iter.data, start, PAIRS_MIN) | rebuild;
	  rebuild = visuPairSet_distance(iter.data, stop, PAIRS_MAX) | rebuild;
	}
    }
  if (start > 0.f)
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gtkPairs_spinMin), start);
  if (stop > 0.f)
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(gtkPairs_spinMax), stop);
  g_signal_handler_unblock(G_OBJECT(gtkPairs_spinMin), gtkPairs_spinMinSignalId);
  g_signal_handler_unblock(G_OBJECT(gtkPairs_spinMax), gtkPairs_spinMaxSignalId);

  if (rebuild)
    gtkPairs_createPairs();
}
static void onBtAdd(GtkButton *button _U_, gpointer user_data _U_)
{
  GtkPairsIter iter;
  GtkTreeIter iterParent, iterChild;
  VisuElement *ele1, *ele2;
  VisuPairData *data, *dataRef;
  float minMax[2] = {0.f, 0.f};
  gboolean valid;
  struct specBuildFunc_struct *specBuild;
  GtkPairsGetValuesAsLabelFunc labelFunc;

  /* Go to last iter. */
  for (gtkPairsIter_startSelected(&iter); iter.current;
       gtkPairsIter_nextSelected(&iter));
  
  /* Get the ancestor of this iter. */
  if (!gtk_tree_model_iter_parent(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
				  &(iter.iter)))
    iterParent = iter.iter;

  /* Get the two elements. */
  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
		     GTK_PAIRS_COLUMN_POINTER_TO_ELE1, &ele1,
		     GTK_PAIRS_COLUMN_POINTER_TO_ELE2, &ele2,
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &dataRef,
		     -1);

  /* Get a new data. */
  data = visuPairGet_link(ele1, ele2, minMax);

  /* Check that this data is not already in the tree. */
  if (data == dataRef)
    return;
  valid = gtk_tree_model_iter_children(GTK_TREE_MODEL(pairsTreeStore),
				       &iterChild, &iterParent);
  while (valid)
    {
      gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iterChild,
			 GTK_PAIRS_COLUMN_POINTER_TO_LINK, &dataRef,
			 -1);
      if (data == dataRef)
	return;
      valid = gtk_tree_model_iter_next(GTK_TREE_MODEL(pairsTreeStore), &iterChild);
    }

  /* Ok, add this new data to the tree. */
  valid = gtk_combo_box_get_active_iter(GTK_COMBO_BOX(gtkPairs_comboWidget),
					&iterChild);
  g_return_if_fail(valid);
  specBuild = (struct specBuildFunc_struct*)0;
  gtk_tree_model_get(GTK_TREE_MODEL(gtkPairs_comboModel), &iterChild,
		     GTK_PAIRS_COLUMN_PAIRS_SPEC_BUILD, &specBuild,
		     -1);
  if (specBuild)
    labelFunc = specBuild->label;
  else
    labelFunc = (GtkPairsGetValuesAsLabelFunc)0;
  gtk_tree_store_append(pairsTreeStore, &iterChild, &iterParent);
  addPairData(&iterChild, labelFunc, data);
  gtk_tree_view_expand_all(GTK_TREE_VIEW(gtkPairs_treeView));

  gtkPairs_createPairs();
}
static void onBtRemove(GtkButton *button _U_, gpointer user_data _U_)
{
  GtkPairsIter iter;
  GtkTreeIter iterParent;
  VisuPairData *data;
  VisuElement *ele1, *ele2;
  gboolean rebuild;

  /* Go to last iter. */
  for (gtkPairsIter_startSelected(&iter); iter.current;
       gtkPairsIter_nextSelected(&iter));
  
  /* Get the ancestor of this iter. */
  if (!gtk_tree_model_iter_parent(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
				  &(iter.iter)))
    {
      rebuild = TRUE;
      iterParent = iter.iter;
    }
  else
    rebuild = FALSE;

  /* Get the two elements. */
  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &iterParent,
		     GTK_PAIRS_COLUMN_POINTER_TO_ELE1, &ele1,
		     GTK_PAIRS_COLUMN_POINTER_TO_ELE2, &ele2,
		     -1);

  gtk_tree_model_get(GTK_TREE_MODEL(pairsTreeStore), &(iter.iter),
		     GTK_PAIRS_COLUMN_POINTER_TO_LINK, &data,
		     -1);

  /* Remove the data. */
  visuPairRemove_link(ele1, ele2, data);
  gtk_tree_store_remove(pairsTreeStore, &(iter.iter));
  
  /* Recreate the entry if parent was removed. */
  if (rebuild)
    addPairAllData(getLabelFunc(), ele1, ele2);

  gtkPairs_createPairs();
}

void gtkPairs_createPairs()
{
  RenderingWindow *window;

  window = RENDERING_WINDOW(visuRenderingWindowGet_current());
  g_return_if_fail(window);
  if (visuPairBuild(renderingWindowGet_visuData(window)))
    g_idle_add(visuObjectRedraw, (gpointer)0);
}
