/* vtgplugin.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgplugin.vala, do not modify */

/*
 *  vtgplugin.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas-gtk/peas-gtk.h>
#include <girepository.h>
#include <gmodule.h>
#include <libpeas/peas.h>
#include <gedit/gedit-window-activatable.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-app-activatable.h>
#include <valagee.h>
#include <gedit/gedit-app.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gedit/gedit-commands.h>
#include <vbf.h>
#include <gedit/gedit-tab.h>


#define VTG_TYPE_PLUGIN_WINDOW_ADAPTER (vtg_plugin_window_adapter_get_type ())
#define VTG_PLUGIN_WINDOW_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_WINDOW_ADAPTER, VtgPluginWindowAdapter))
#define VTG_PLUGIN_WINDOW_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_WINDOW_ADAPTER, VtgPluginWindowAdapterClass))
#define VTG_IS_PLUGIN_WINDOW_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_WINDOW_ADAPTER))
#define VTG_IS_PLUGIN_WINDOW_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_WINDOW_ADAPTER))
#define VTG_PLUGIN_WINDOW_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_WINDOW_ADAPTER, VtgPluginWindowAdapterClass))

typedef struct _VtgPluginWindowAdapter VtgPluginWindowAdapter;
typedef struct _VtgPluginWindowAdapterClass VtgPluginWindowAdapterClass;
typedef struct _VtgPluginWindowAdapterPrivate VtgPluginWindowAdapterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VTG_TYPE_PLUGIN (vtg_plugin_get_type ())
#define VTG_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN, VtgPlugin))
#define VTG_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN, VtgPluginClass))
#define VTG_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN))
#define VTG_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN))
#define VTG_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN, VtgPluginClass))

typedef struct _VtgPlugin VtgPlugin;
typedef struct _VtgPluginClass VtgPluginClass;
typedef struct _VtgPluginPrivate VtgPluginPrivate;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;

#define VTG_TYPE_CONFIGURATION (vtg_configuration_get_type ())
#define VTG_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_CONFIGURATION, VtgConfiguration))
#define VTG_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))
#define VTG_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_CONFIGURATION))
#define VTG_IS_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_CONFIGURATION))
#define VTG_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_CONFIGURATION, VtgConfigurationClass))

typedef struct _VtgConfiguration VtgConfiguration;
typedef struct _VtgConfigurationClass VtgConfigurationClass;

#define VTG_TYPE_PROJECTS (vtg_projects_get_type ())
#define VTG_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECTS, VtgProjects))
#define VTG_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECTS, VtgProjectsClass))
#define VTG_IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECTS))
#define VTG_IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECTS))
#define VTG_PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECTS, VtgProjectsClass))

typedef struct _VtgProjects VtgProjects;
typedef struct _VtgProjectsClass VtgProjectsClass;

#define VTG_PLUGIN_TYPE_DEACTIVATE_MODULE_OPTIONS (vtg_plugin_deactivate_module_options_get_type ())
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_SOURCE_OUTLINER (vtg_source_outliner_get_type ())
#define VTG_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutliner))
#define VTG_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))
#define VTG_IS_SOURCE_OUTLINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_IS_SOURCE_OUTLINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SOURCE_OUTLINER))
#define VTG_SOURCE_OUTLINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SOURCE_OUTLINER, VtgSourceOutlinerClass))

typedef struct _VtgSourceOutliner VtgSourceOutliner;
typedef struct _VtgSourceOutlinerClass VtgSourceOutlinerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())

#define VTG_TYPE_PLUGIN_CONFIG (vtg_plugin_config_get_type ())
#define VTG_PLUGIN_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_CONFIG, VtgPluginConfig))
#define VTG_PLUGIN_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_CONFIG, VtgPluginConfigClass))
#define VTG_IS_PLUGIN_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_CONFIG))
#define VTG_IS_PLUGIN_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_CONFIG))
#define VTG_PLUGIN_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_CONFIG, VtgPluginConfigClass))

typedef struct _VtgPluginConfig VtgPluginConfig;
typedef struct _VtgPluginConfigClass VtgPluginConfigClass;
typedef struct _VtgPluginConfigPrivate VtgPluginConfigPrivate;

struct _VtgPluginWindowAdapter {
	PeasExtensionBase parent_instance;
	VtgPluginWindowAdapterPrivate * priv;
};

struct _VtgPluginWindowAdapterClass {
	PeasExtensionBaseClass parent_class;
};

struct _VtgPluginWindowAdapterPrivate {
	GeditWindow* _window;
};

struct _VtgPlugin {
	PeasExtensionBase parent_instance;
	VtgPluginPrivate * priv;
	gboolean saving;
};

struct _VtgPluginClass {
	PeasExtensionBaseClass parent_class;
};

struct _VtgPluginPrivate {
	ValaList* _instances;
	VtgConfiguration* _config;
	VtgProjects* _projects;
	GeditApp* _app;
};

typedef enum  {
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL,
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET,
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL,
	VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER
} VtgPluginDeactivateModuleOptions;

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	gchar* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	gchar* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};

struct _VtgPluginConfig {
	PeasExtensionBase parent_instance;
	VtgPluginConfigPrivate * priv;
};

struct _VtgPluginConfigClass {
	PeasExtensionBaseClass parent_class;
};


static gpointer vtg_plugin_window_adapter_parent_class = NULL;
extern VtgPlugin* vtg_plugin_main_instance;
static GeditWindowActivatableInterface* vtg_plugin_window_adapter_gedit_window_activatable_parent_iface = NULL;
static GType vtg_plugin_window_adapter_type_id = 0;
static gpointer vtg_plugin_parent_class = NULL;
VtgPlugin* vtg_plugin_main_instance = NULL;
static GeditAppActivatableInterface* vtg_plugin_gedit_app_activatable_parent_iface = NULL;
static GType vtg_plugin_type_id = 0;
static gpointer vtg_plugin_config_parent_class = NULL;
static PeasGtkConfigurableInterface* vtg_plugin_config_peas_gtk_configurable_parent_iface = NULL;
static GType vtg_plugin_config_type_id = 0;

GType vtg_plugin_window_adapter_get_type (void) G_GNUC_CONST;
GType vtg_plugin_window_adapter_register_type (GTypeModule * module);
#define VTG_PLUGIN_WINDOW_ADAPTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PLUGIN_WINDOW_ADAPTER, VtgPluginWindowAdapterPrivate))
enum  {
	VTG_PLUGIN_WINDOW_ADAPTER_DUMMY_PROPERTY,
	VTG_PLUGIN_WINDOW_ADAPTER_WINDOW
};
VtgPluginWindowAdapter* vtg_plugin_window_adapter_new (void);
VtgPluginWindowAdapter* vtg_plugin_window_adapter_construct (GType object_type);
static void vtg_plugin_window_adapter_real_activate (GeditWindowActivatable* base);
GType vtg_plugin_get_type (void) G_GNUC_CONST;
GType vtg_plugin_register_type (GTypeModule * module);
void vtg_plugin_activate_for_window (VtgPlugin* self, GeditWindow* window);
static void vtg_plugin_window_adapter_real_deactivate (GeditWindowActivatable* base);
static void vtg_plugin_window_adapter_real_update_state (GeditWindowActivatable* base);
void vtg_plugin_update_state_for_window (VtgPlugin* self, GeditWindow* window);
GeditWindow* vtg_plugin_window_adapter_get_window (VtgPluginWindowAdapter* self);
static void vtg_plugin_window_adapter_set_window (VtgPluginWindowAdapter* self, GeditWindow* value);
static void vtg_plugin_window_adapter_finalize (GObject* obj);
static void _vala_vtg_plugin_window_adapter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vtg_plugin_window_adapter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
GType vtg_configuration_get_type (void) G_GNUC_CONST;
GType vtg_configuration_register_type (GTypeModule * module);
GType vtg_projects_get_type (void) G_GNUC_CONST;
GType vtg_projects_register_type (GTypeModule * module);
#define VTG_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_PLUGIN, VtgPluginPrivate))
enum  {
	VTG_PLUGIN_DUMMY_PROPERTY,
	VTG_PLUGIN_INSTANCES,
	VTG_PLUGIN_PROJECTS,
	VTG_PLUGIN_CONFIG,
	VTG_PLUGIN_APP
};
static void vtg_plugin_on_project_opened (VtgPlugin* self, VtgProjects* sender, GObject* pm);
static void _vtg_plugin_on_project_opened_vtg_projects_project_opened (VtgProjects* _sender, GObject* project, gpointer self);
static void vtg_plugin_on_project_closed (VtgPlugin* self, VtgProjects* sender, GObject* pm);
static void _vtg_plugin_on_project_closed_vtg_projects_project_closed (VtgProjects* _sender, GObject* project, gpointer self);
static GType vtg_plugin_deactivate_module_options_get_type (void) G_GNUC_UNUSED;
static void vtg_plugin_deactivate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options);
VtgPlugin* vtg_plugin_new (void);
VtgPlugin* vtg_plugin_construct (GType object_type);
static VtgPluginInstance* vtg_plugin_get_plugin_instance_for_window (VtgPlugin* self, GeditWindow* window);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
VtgPluginInstance* vtg_plugin_instance_new (GeditWindow* window);
VtgPluginInstance* vtg_plugin_instance_construct (GType object_type, GeditWindow* window);
static void vtg_plugin_real_activate (GeditAppActivatable* base);
VtgConfiguration* vtg_configuration_new (void);
VtgConfiguration* vtg_configuration_construct (GType object_type);
static void vtg_plugin_on_configuration_property_changed (VtgPlugin* self, GObject* sender, GParamSpec* param);
static void _vtg_plugin_on_configuration_property_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
VtgProjects* vtg_projects_new (VtgPlugin* plugin);
VtgProjects* vtg_projects_construct (GType object_type, VtgPlugin* plugin);
static void vtg_plugin_real_deactivate (GeditAppActivatable* base);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_projects_get_project_manager_for_document (VtgProjects* self, GeditDocument* document, GError** error);
gboolean vtg_utils_is_vala_doc (GeditDocument* doc);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
void vtg_project_view_set_current_project (VtgProjectView* self, VtgProjectManager* value);
GType vtg_source_outliner_get_type (void) G_GNUC_CONST;
GType vtg_source_outliner_register_type (GTypeModule * module);
VtgSourceOutliner* vtg_plugin_instance_get_source_outliner (VtgPluginInstance* self);
void vtg_source_outliner_set_active_view (VtgSourceOutliner* self, GeditView* value);
gboolean vtg_configuration_get_bracket_enabled (VtgConfiguration* self);
static void vtg_plugin_activate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options);
gboolean vtg_configuration_get_sourcecode_outliner_enabled (VtgConfiguration* self);
void vtg_plugin_instance_deactivate_symbols (VtgPluginInstance* self);
void vtg_plugin_instance_deactivate_brackets (VtgPluginInstance* self);
void vtg_plugin_instance_deactivate_sourcecode_outliner (VtgPluginInstance* self);
void vtg_plugin_instance_initialize_views (VtgPluginInstance* self);
gboolean vtg_plugin_project_need_save (VtgPlugin* self, VtgProjectManager* project);
gboolean vtg_project_manager_contains_filename (VtgProjectManager* self, const gchar* filename);
gchar* vtg_utils_get_document_name (GeditDocument* doc);
static void vtg_plugin_on_document_saved (GeditDocument* doc, void* arg1, VtgPlugin* self);
static void vtg_plugin_save_doc_sync (VtgPlugin* self, VtgPluginInstance* instance, GeditDocument* doc);
void vtg_plugin_project_save_all (VtgPlugin* self, VtgProjectManager* project);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
void vtg_project_view_remove_project (VtgProjectView* self, VbfProject* project);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
void vtg_project_view_add_project (VtgProjectView* self, VbfProject* project);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void gtk_recent_data_destroy (GtkRecentData* self);
ValaList* vtg_plugin_get_instances (VtgPlugin* self);
VtgProjects* vtg_plugin_get_projects (VtgPlugin* self);
VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self);
GeditApp* vtg_plugin_get_app (VtgPlugin* self);
static void vtg_plugin_set_app (VtgPlugin* self, GeditApp* value);
static GObject * vtg_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void vtg_plugin_finalize (GObject* obj);
static void _vala_vtg_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vtg_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType vtg_plugin_config_get_type (void) G_GNUC_CONST;
GType vtg_plugin_config_register_type (GTypeModule * module);
enum  {
	VTG_PLUGIN_CONFIG_DUMMY_PROPERTY
};
VtgPluginConfig* vtg_plugin_config_new (void);
VtgPluginConfig* vtg_plugin_config_construct (GType object_type);
static GtkWidget* vtg_plugin_config_real_create_configure_widget (PeasGtkConfigurable* base);
GtkWidget* vtg_configuration_get_configuration_dialog (VtgConfiguration* self);
void peas_register_types (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


VtgPluginWindowAdapter* vtg_plugin_window_adapter_construct (GType object_type) {
	VtgPluginWindowAdapter * self = NULL;
	self = (VtgPluginWindowAdapter*) g_object_new (object_type, NULL);
	return self;
}


VtgPluginWindowAdapter* vtg_plugin_window_adapter_new (void) {
	return vtg_plugin_window_adapter_construct (VTG_TYPE_PLUGIN_WINDOW_ADAPTER);
}


static void vtg_plugin_window_adapter_real_activate (GeditWindowActivatable* base) {
	VtgPluginWindowAdapter * self;
	self = (VtgPluginWindowAdapter*) base;
	vtg_plugin_activate_for_window (vtg_plugin_main_instance, self->priv->_window);
}


static void vtg_plugin_window_adapter_real_deactivate (GeditWindowActivatable* base) {
	VtgPluginWindowAdapter * self;
	self = (VtgPluginWindowAdapter*) base;
}


static void vtg_plugin_window_adapter_real_update_state (GeditWindowActivatable* base) {
	VtgPluginWindowAdapter * self;
	self = (VtgPluginWindowAdapter*) base;
	vtg_plugin_update_state_for_window (vtg_plugin_main_instance, self->priv->_window);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeditWindow* vtg_plugin_window_adapter_get_window (VtgPluginWindowAdapter* self) {
	GeditWindow* result;
	GeditWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->_window);
	result = _tmp0_;
	return result;
}


static void vtg_plugin_window_adapter_set_window (VtgPluginWindowAdapter* self, GeditWindow* value) {
	GeditWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_window);
	self->priv->_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static void vtg_plugin_window_adapter_class_init (VtgPluginWindowAdapterClass * klass) {
	vtg_plugin_window_adapter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgPluginWindowAdapterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_plugin_window_adapter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vtg_plugin_window_adapter_set_property;
	G_OBJECT_CLASS (klass)->finalize = vtg_plugin_window_adapter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_WINDOW_ADAPTER_WINDOW, g_param_spec_object ("window", "window", "window", gedit_window_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vtg_plugin_window_adapter_gedit_window_activatable_interface_init (GeditWindowActivatableInterface * iface) {
	vtg_plugin_window_adapter_gedit_window_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(GeditWindowActivatable*)) vtg_plugin_window_adapter_real_activate;
	iface->deactivate = (void (*)(GeditWindowActivatable*)) vtg_plugin_window_adapter_real_deactivate;
	iface->update_state = (void (*)(GeditWindowActivatable*)) vtg_plugin_window_adapter_real_update_state;
}


static void vtg_plugin_window_adapter_instance_init (VtgPluginWindowAdapter * self) {
	self->priv = VTG_PLUGIN_WINDOW_ADAPTER_GET_PRIVATE (self);
}


static void vtg_plugin_window_adapter_finalize (GObject* obj) {
	VtgPluginWindowAdapter * self;
	self = VTG_PLUGIN_WINDOW_ADAPTER (obj);
	_g_object_unref0 (self->priv->_window);
	G_OBJECT_CLASS (vtg_plugin_window_adapter_parent_class)->finalize (obj);
}


GType vtg_plugin_window_adapter_get_type (void) {
	return vtg_plugin_window_adapter_type_id;
}


GType vtg_plugin_window_adapter_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgPluginWindowAdapterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_plugin_window_adapter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgPluginWindowAdapter), 0, (GInstanceInitFunc) vtg_plugin_window_adapter_instance_init, NULL };
	static const GInterfaceInfo gedit_window_activatable_info = { (GInterfaceInitFunc) vtg_plugin_window_adapter_gedit_window_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vtg_plugin_window_adapter_type_id = g_type_module_register_type (module, PEAS_TYPE_EXTENSION_BASE, "VtgPluginWindowAdapter", &g_define_type_info, 0);
	g_type_module_add_interface (module, vtg_plugin_window_adapter_type_id, gedit_window_activatable_get_type (), &gedit_window_activatable_info);
	return vtg_plugin_window_adapter_type_id;
}


static void _vala_vtg_plugin_window_adapter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgPluginWindowAdapter * self;
	self = VTG_PLUGIN_WINDOW_ADAPTER (object);
	switch (property_id) {
		case VTG_PLUGIN_WINDOW_ADAPTER_WINDOW:
		g_value_take_object (value, vtg_plugin_window_adapter_get_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vtg_plugin_window_adapter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgPluginWindowAdapter * self;
	self = VTG_PLUGIN_WINDOW_ADAPTER (object);
	switch (property_id) {
		case VTG_PLUGIN_WINDOW_ADAPTER_WINDOW:
		vtg_plugin_window_adapter_set_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vtg_plugin_on_project_opened_vtg_projects_project_opened (VtgProjects* _sender, GObject* project, gpointer self) {
	vtg_plugin_on_project_opened (self, _sender, project);
}


static void _vtg_plugin_on_project_closed_vtg_projects_project_closed (VtgProjects* _sender, GObject* project, gpointer self) {
	vtg_plugin_on_project_closed (self, _sender, project);
}


static GType vtg_plugin_deactivate_module_options_get_type (void) {
	static volatile gsize vtg_plugin_deactivate_module_options_type_id__volatile = 0;
	if (g_once_init_enter (&vtg_plugin_deactivate_module_options_type_id__volatile)) {
		static const GEnumValue values[] = {{VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL", "all"}, {VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET", "bracket"}, {VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL", "symbol"}, {VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER, "VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER", "sourcecode-outliner"}, {0, NULL, NULL}};
		GType vtg_plugin_deactivate_module_options_type_id;
		vtg_plugin_deactivate_module_options_type_id = g_enum_register_static ("VtgPluginDeactivateModuleOptions", values);
		g_once_init_leave (&vtg_plugin_deactivate_module_options_type_id__volatile, vtg_plugin_deactivate_module_options_type_id);
	}
	return vtg_plugin_deactivate_module_options_type_id__volatile;
}


VtgPlugin* vtg_plugin_construct (GType object_type) {
	VtgPlugin * self = NULL;
	self = (VtgPlugin*) g_object_new (object_type, NULL);
	return self;
}


VtgPlugin* vtg_plugin_new (void) {
	return vtg_plugin_construct (VTG_TYPE_PLUGIN);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static VtgPluginInstance* vtg_plugin_get_plugin_instance_for_window (VtgPlugin* self, GeditWindow* window) {
	VtgPluginInstance* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	{
		ValaList* _tmp0_;
		ValaList* _instance_list;
		gint _tmp1_;
		gint _instance_size;
		gint _instance_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_instances);
		_instance_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp1_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgPluginInstance* instance;
			GeditWindow* _tmp3_ = NULL;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp2_;
			_tmp3_ = vtg_plugin_instance_get_window (instance);
			if (_tmp3_ == window) {
				result = instance;
				_vala_iterable_unref0 (_instance_list);
				return result;
			}
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
	result = NULL;
	return result;
}


void vtg_plugin_activate_for_window (VtgPlugin* self, GeditWindow* window) {
	VtgPluginInstance* _tmp0_ = NULL;
	VtgPluginInstance* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = vtg_plugin_get_plugin_instance_for_window (self, window);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		VtgPluginInstance* _tmp3_ = NULL;
		VtgPluginInstance* instance;
		_tmp3_ = vtg_plugin_instance_new (window);
		instance = _tmp3_;
		vala_collection_add ((ValaCollection*) self->priv->_instances, instance);
		_g_object_unref0 (instance);
	}
}


static void _vtg_plugin_on_configuration_property_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_plugin_on_configuration_property_changed (self, _sender, pspec);
}


static void vtg_plugin_real_activate (GeditAppActivatable* base) {
	VtgPlugin * self;
	VtgConfiguration* _tmp0_ = NULL;
	VtgProjects* _tmp1_ = NULL;
	self = (VtgPlugin*) base;
	_tmp0_ = vtg_configuration_new ();
	_g_object_unref0 (self->priv->_config);
	self->priv->_config = _tmp0_;
	g_signal_connect_object ((GObject*) self->priv->_config, "notify", (GCallback) _vtg_plugin_on_configuration_property_changed_g_object_notify, self, 0);
	bindtextdomain (GETTEXT_PACKAGE, NULL);
	_tmp1_ = vtg_projects_new (self);
	_g_object_unref0 (self->priv->_projects);
	self->priv->_projects = _tmp1_;
	g_signal_connect_object (self->priv->_projects, "project-opened", (GCallback) _vtg_plugin_on_project_opened_vtg_projects_project_opened, self, 0);
	g_signal_connect_object (self->priv->_projects, "project-closed", (GCallback) _vtg_plugin_on_project_closed_vtg_projects_project_closed, self, 0);
}


static void vtg_plugin_real_deactivate (GeditAppActivatable* base) {
	VtgPlugin * self;
	self = (VtgPlugin*) base;
	vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL);
	vala_collection_clear ((ValaCollection*) self->priv->_instances);
}


void vtg_plugin_update_state_for_window (VtgPlugin* self, GeditWindow* window) {
	GeditView* _tmp0_ = NULL;
	GeditView* _tmp1_;
	GeditView* view;
	VtgPluginInstance* _tmp2_ = NULL;
	VtgPluginInstance* instance;
	GeditDocument* doc;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = gedit_window_get_active_view (window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	view = _tmp1_;
	_tmp2_ = vtg_plugin_get_plugin_instance_for_window (self, window);
	instance = _tmp2_;
	doc = NULL;
	if (view != NULL) {
		GtkTextBuffer* _tmp3_ = NULL;
		GeditDocument* _tmp4_;
		_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) view);
		_tmp4_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp3_));
		_g_object_unref0 (doc);
		doc = _tmp4_;
		if (doc != NULL) {
			VtgProjectManager* _tmp5_ = NULL;
			VtgProjectManager* prj;
			gboolean _tmp6_ = FALSE;
			VtgSourceOutliner* _tmp9_ = NULL;
			_tmp5_ = vtg_projects_get_project_manager_for_document (self->priv->_projects, doc, &_inner_error_);
			prj = _tmp5_;
			if (_inner_error_ != NULL) {
				goto __catch51_g_error;
			}
			if (prj != NULL) {
				gboolean _tmp7_;
				_tmp7_ = vtg_utils_is_vala_doc (doc);
				_tmp6_ = _tmp7_;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				VtgProjectView* _tmp8_ = NULL;
				_tmp8_ = vtg_plugin_instance_get_project_view (instance);
				vtg_project_view_set_current_project (_tmp8_, prj);
			}
			_tmp9_ = vtg_plugin_instance_get_source_outliner (instance);
			if (_tmp9_ != NULL) {
				VtgSourceOutliner* _tmp10_ = NULL;
				_tmp10_ = vtg_plugin_instance_get_source_outliner (instance);
				vtg_source_outliner_set_active_view (_tmp10_, view);
			}
			_g_object_unref0 (prj);
			goto __finally51;
			__catch51_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				g_critical ("vtgplugin.vala:160: error: %s", err->message);
				_g_error_free0 (err);
			}
			__finally51:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (doc);
				_g_object_unref0 (instance);
				_g_object_unref0 (view);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if (view == NULL) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = doc == NULL;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp13_;
		_tmp13_ = vtg_utils_is_vala_doc (doc);
		_tmp11_ = !_tmp13_;
	}
	if (_tmp11_) {
		VtgSourceOutliner* _tmp14_ = NULL;
		_tmp14_ = vtg_plugin_instance_get_source_outliner (instance);
		vtg_source_outliner_set_active_view (_tmp14_, NULL);
	}
	_g_object_unref0 (doc);
	_g_object_unref0 (instance);
	_g_object_unref0 (view);
}


static void vtg_plugin_on_configuration_property_changed (VtgPlugin* self, GObject* sender, GParamSpec* param) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = g_param_spec_get_name (param);
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	if (g_strcmp0 (name, "bracket-enabled") == 0) {
		gboolean _tmp2_;
		_tmp2_ = vtg_configuration_get_bracket_enabled (self->priv->_config);
		if (_tmp2_) {
			vtg_plugin_activate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET);
		} else {
			vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET);
		}
	} else {
		if (g_strcmp0 (name, "symbol-enabled") == 0) {
			gboolean _tmp3_;
			_tmp3_ = vtg_configuration_get_bracket_enabled (self->priv->_config);
			if (_tmp3_) {
				vtg_plugin_activate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL);
			} else {
				vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL);
			}
		} else {
			if (g_strcmp0 (name, "sourcecode-outliner-enabled") == 0) {
				gboolean _tmp4_;
				_tmp4_ = vtg_configuration_get_sourcecode_outliner_enabled (self->priv->_config);
				if (_tmp4_) {
					vtg_plugin_activate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER);
				} else {
					vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER);
				}
			}
		}
	}
	_g_free0 (name);
}


static void vtg_plugin_deactivate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	if (options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SYMBOL;
	}
	if (_tmp0_) {
		{
			ValaList* _tmp1_;
			ValaList* _instance_list;
			gint _tmp2_;
			gint _instance_size;
			gint _instance_index;
			_tmp1_ = _vala_iterable_ref0 (self->priv->_instances);
			_instance_list = _tmp1_;
			_tmp2_ = vala_collection_get_size ((ValaCollection*) _instance_list);
			_instance_size = _tmp2_;
			_instance_index = -1;
			while (TRUE) {
				gpointer _tmp3_ = NULL;
				VtgPluginInstance* instance;
				_instance_index = _instance_index + 1;
				if (!(_instance_index < _instance_size)) {
					break;
				}
				_tmp3_ = vala_list_get (_instance_list, _instance_index);
				instance = (VtgPluginInstance*) _tmp3_;
				vtg_plugin_instance_deactivate_symbols (instance);
				_g_object_unref0 (instance);
			}
			_vala_iterable_unref0 (_instance_list);
		}
	}
	if (options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_BRACKET;
	}
	if (_tmp4_) {
		{
			ValaList* _tmp5_;
			ValaList* _instance_list;
			gint _tmp6_;
			gint _instance_size;
			gint _instance_index;
			_tmp5_ = _vala_iterable_ref0 (self->priv->_instances);
			_instance_list = _tmp5_;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _instance_list);
			_instance_size = _tmp6_;
			_instance_index = -1;
			while (TRUE) {
				gpointer _tmp7_ = NULL;
				VtgPluginInstance* instance;
				_instance_index = _instance_index + 1;
				if (!(_instance_index < _instance_size)) {
					break;
				}
				_tmp7_ = vala_list_get (_instance_list, _instance_index);
				instance = (VtgPluginInstance*) _tmp7_;
				vtg_plugin_instance_deactivate_brackets (instance);
				_g_object_unref0 (instance);
			}
			_vala_iterable_unref0 (_instance_list);
		}
	}
	if (options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = options == VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_SOURCECODE_OUTLINER;
	}
	if (_tmp8_) {
		{
			ValaList* _tmp9_;
			ValaList* _instance_list;
			gint _tmp10_;
			gint _instance_size;
			gint _instance_index;
			_tmp9_ = _vala_iterable_ref0 (self->priv->_instances);
			_instance_list = _tmp9_;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _instance_list);
			_instance_size = _tmp10_;
			_instance_index = -1;
			while (TRUE) {
				gpointer _tmp11_ = NULL;
				VtgPluginInstance* instance;
				_instance_index = _instance_index + 1;
				if (!(_instance_index < _instance_size)) {
					break;
				}
				_tmp11_ = vala_list_get (_instance_list, _instance_index);
				instance = (VtgPluginInstance*) _tmp11_;
				vtg_plugin_instance_deactivate_sourcecode_outliner (instance);
				_g_object_unref0 (instance);
			}
			_vala_iterable_unref0 (_instance_list);
		}
	}
}


static void vtg_plugin_activate_modules (VtgPlugin* self, VtgPluginDeactivateModuleOptions options) {
	g_return_if_fail (self != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _instance_list;
		gint _tmp1_;
		gint _instance_size;
		gint _instance_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_instances);
		_instance_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp1_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgPluginInstance* instance;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp2_;
			vtg_plugin_instance_initialize_views (instance);
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
}


gboolean vtg_plugin_project_need_save (VtgPlugin* self, VtgProjectManager* project) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (project != NULL, FALSE);
	{
		ValaList* _tmp0_;
		ValaList* _instance_list;
		gint _tmp1_;
		gint _instance_size;
		gint _instance_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_instances);
		_instance_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp1_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgPluginInstance* instance;
			GeditWindow* _tmp3_ = NULL;
			GList* _tmp4_ = NULL;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp2_;
			_tmp3_ = vtg_plugin_instance_get_window (instance);
			_tmp4_ = gedit_window_get_unsaved_documents (_tmp3_);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = _tmp4_;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					GeditDocument* _tmp5_;
					GeditDocument* doc;
					_tmp5_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
					doc = _tmp5_;
					{
						gchar* _tmp6_ = NULL;
						gchar* _tmp7_;
						gboolean _tmp8_;
						gboolean _tmp9_;
						_tmp6_ = vtg_utils_get_document_name (doc);
						_tmp7_ = _tmp6_;
						_tmp8_ = vtg_project_manager_contains_filename (project, _tmp7_);
						_tmp9_ = _tmp8_;
						_g_free0 (_tmp7_);
						if (_tmp9_) {
							result = TRUE;
							_g_object_unref0 (doc);
							_g_list_free0 (doc_collection);
							_g_object_unref0 (instance);
							_vala_iterable_unref0 (_instance_list);
							return result;
						}
						_g_object_unref0 (doc);
					}
				}
				_g_list_free0 (doc_collection);
			}
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
	result = FALSE;
	return result;
}


static void vtg_plugin_on_document_saved (GeditDocument* doc, void* arg1, VtgPlugin* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	self->saving = FALSE;
}


static void vtg_plugin_save_doc_sync (VtgPlugin* self, VtgPluginInstance* instance, GeditDocument* doc) {
	gulong _tmp0_;
	gulong id;
	GeditWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (instance != NULL);
	g_return_if_fail (doc != NULL);
	self->saving = TRUE;
	_tmp0_ = g_signal_connect (doc, "saved", (GCallback) vtg_plugin_on_document_saved, self);
	id = _tmp0_;
	_tmp1_ = vtg_plugin_instance_get_window (instance);
	gedit_commands_save_document (_tmp1_, doc);
	while (TRUE) {
		GMainContext* _tmp2_ = NULL;
		if (!self->saving) {
			break;
		}
		_tmp2_ = g_main_context_default ();
		g_main_context_iteration (_tmp2_, FALSE);
	}
	g_signal_handler_disconnect ((GObject*) doc, id);
}


void vtg_plugin_project_save_all (VtgPlugin* self, VtgProjectManager* project) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _instance_list;
		gint _tmp1_;
		gint _instance_size;
		gint _instance_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->_instances);
		_instance_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp1_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VtgPluginInstance* instance;
			GeditWindow* _tmp3_ = NULL;
			GList* _tmp4_ = NULL;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp2_;
			_tmp3_ = vtg_plugin_instance_get_window (instance);
			_tmp4_ = gedit_window_get_unsaved_documents (_tmp3_);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = _tmp4_;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					GeditDocument* _tmp5_;
					GeditDocument* doc;
					_tmp5_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
					doc = _tmp5_;
					{
						gchar* _tmp6_ = NULL;
						gchar* filename;
						gboolean _tmp7_ = FALSE;
						gboolean _tmp8_;
						_tmp6_ = vtg_utils_get_document_name (doc);
						filename = _tmp6_;
						_tmp8_ = vtg_string_utils_is_null_or_empty (filename);
						if (!_tmp8_) {
							gboolean _tmp9_;
							_tmp9_ = vtg_project_manager_contains_filename (project, filename);
							_tmp7_ = _tmp9_;
						} else {
							_tmp7_ = FALSE;
						}
						if (_tmp7_) {
							vtg_plugin_save_doc_sync (self, instance, doc);
						}
						_g_free0 (filename);
						_g_object_unref0 (doc);
					}
				}
				_g_list_free0 (doc_collection);
			}
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
}


static void vtg_plugin_on_project_closed (VtgPlugin* self, VtgProjects* sender, GObject* pm) {
	VtgProjectManager* _tmp0_;
	VtgProjectManager* project;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pm != NULL);
	_tmp0_ = _g_object_ref0 (VTG_PROJECT_MANAGER (pm));
	project = _tmp0_;
	g_return_if_fail (!project->is_default);
	{
		ValaList* _tmp1_;
		ValaList* _instance_list;
		gint _tmp2_;
		gint _instance_size;
		gint _instance_index;
		_tmp1_ = _vala_iterable_ref0 (self->priv->_instances);
		_instance_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp2_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			VtgPluginInstance* instance;
			GeditWindow* _tmp4_ = NULL;
			GList* _tmp5_ = NULL;
			VtgProjectView* _tmp14_ = NULL;
			VbfProject* _tmp15_ = NULL;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp3_;
			_tmp4_ = vtg_plugin_instance_get_window (instance);
			_tmp5_ = gedit_window_get_documents (_tmp4_);
			{
				GList* doc_collection;
				GList* doc_it;
				doc_collection = _tmp5_;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					GeditDocument* _tmp6_;
					GeditDocument* doc;
					_tmp6_ = _g_object_ref0 ((GeditDocument*) doc_it->data);
					doc = _tmp6_;
					{
						gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						gboolean _tmp9_;
						gboolean _tmp10_;
						_tmp7_ = vtg_utils_get_document_name (doc);
						_tmp8_ = _tmp7_;
						_tmp9_ = vtg_project_manager_contains_filename (project, _tmp8_);
						_tmp10_ = _tmp9_;
						_g_free0 (_tmp8_);
						if (_tmp10_) {
							GeditTab* _tmp11_ = NULL;
							GeditTab* _tmp12_;
							GeditTab* tab;
							GeditWindow* _tmp13_ = NULL;
							_tmp11_ = gedit_tab_get_from_document (doc);
							_tmp12_ = _g_object_ref0 (_tmp11_);
							tab = _tmp12_;
							_tmp13_ = vtg_plugin_instance_get_window (instance);
							gedit_window_close_tab (_tmp13_, tab);
							_g_object_unref0 (tab);
						}
						_g_object_unref0 (doc);
					}
				}
				_g_list_free0 (doc_collection);
			}
			_tmp14_ = vtg_plugin_instance_get_project_view (instance);
			_tmp15_ = vtg_project_manager_get_project (project);
			vtg_project_view_remove_project (_tmp14_, _tmp15_);
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
	_g_object_unref0 (project);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mime_type);
	_g_free0 ((*self).app_name);
	_g_free0 ((*self).app_exec);
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
}


static void vtg_plugin_on_project_opened (VtgPlugin* self, VtgProjects* sender, GObject* pm) {
	VtgProjectManager* _tmp0_;
	VtgProjectManager* project_manager;
	VbfProject* _tmp1_ = NULL;
	VbfProject* _tmp2_;
	VbfProject* project;
	GtkRecentManager* _tmp7_ = NULL;
	GtkRecentManager* recent;
	GtkRecentData recent_data = {0};
	gchar* _tmp8_;
	gchar* name;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pm != NULL);
	_tmp0_ = _g_object_ref0 (VTG_PROJECT_MANAGER (pm));
	project_manager = _tmp0_;
	_tmp1_ = vtg_project_manager_get_project (project_manager);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	project = _tmp2_;
	{
		ValaList* _tmp3_;
		ValaList* _instance_list;
		gint _tmp4_;
		gint _instance_size;
		gint _instance_index;
		_tmp3_ = _vala_iterable_ref0 (self->priv->_instances);
		_instance_list = _tmp3_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _instance_list);
		_instance_size = _tmp4_;
		_instance_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			VtgPluginInstance* instance;
			VtgProjectView* _tmp6_ = NULL;
			_instance_index = _instance_index + 1;
			if (!(_instance_index < _instance_size)) {
				break;
			}
			_tmp5_ = vala_list_get (_instance_list, _instance_index);
			instance = (VtgPluginInstance*) _tmp5_;
			_tmp6_ = vtg_plugin_instance_get_project_view (instance);
			vtg_project_view_add_project (_tmp6_, project);
			_g_object_unref0 (instance);
		}
		_vala_iterable_unref0 (_instance_list);
	}
	_tmp7_ = gtk_recent_manager_get_default ();
	recent = _tmp7_;
	memset (&recent_data, 0, sizeof (GtkRecentData));
	_tmp8_ = g_strdup (project->name);
	name = _tmp8_;
	_tmp9_ = g_strdup ("vtg");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	groups = _tmp10_;
	groups_length1 = 1;
	_groups_size_ = 1;
	_tmp11_ = g_strdup (name);
	_g_free0 (recent_data.display_name);
	recent_data.display_name = _tmp11_;
	_tmp12_ = (_tmp13_ = groups, (_tmp13_ == NULL) ? ((gpointer) _tmp13_) : _vala_array_dup1 (_tmp13_, groups_length1));
	recent_data.groups = (_vala_array_free (recent_data.groups, _vala_array_length (recent_data.groups), (GDestroyNotify) g_free), NULL);
	recent_data.groups = _tmp12_;
	recent_data.is_private = TRUE;
	_tmp14_ = g_strdup ("text/plain");
	_g_free0 (recent_data.mime_type);
	recent_data.mime_type = _tmp14_;
	_tmp15_ = g_strdup ("vtg");
	_g_free0 (recent_data.app_name);
	recent_data.app_name = _tmp15_;
	_tmp16_ = g_strdup ("gedit %u");
	_g_free0 (recent_data.app_exec);
	recent_data.app_exec = _tmp16_;
	_tmp17_ = g_strconcat (project->id, "/configure.ac", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_filename_to_uri (_tmp18_, NULL, &_inner_error_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	_tmp21_ = _tmp20_;
	if (_inner_error_ != NULL) {
		goto __catch52_g_error;
	}
	_tmp22_ = _tmp21_;
	_tmp23_ = gtk_recent_manager_add_full (recent, _tmp22_, &recent_data);
	_tmp24_ = !_tmp23_;
	_g_free0 (_tmp22_);
	if (_tmp24_) {
		g_warning ("vtgplugin.vala:303: cannot add project %s to recently used list", project->id);
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("vtgplugin.vala:306: error %s converting file configure.ac to uri", e->message);
		_g_error_free0 (e);
	}
	__finally52:
	if (_inner_error_ != NULL) {
		groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (name);
		gtk_recent_data_destroy (&recent_data);
		_g_object_unref0 (project);
		_g_object_unref0 (project_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
	gtk_recent_data_destroy (&recent_data);
	_g_object_unref0 (project);
	_g_object_unref0 (project_manager);
}


ValaList* vtg_plugin_get_instances (VtgPlugin* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_instances;
	return result;
}


VtgProjects* vtg_plugin_get_projects (VtgPlugin* self) {
	VtgProjects* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_projects;
	return result;
}


VtgConfiguration* vtg_plugin_get_config (VtgPlugin* self) {
	VtgConfiguration* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_config;
	return result;
}


GeditApp* vtg_plugin_get_app (VtgPlugin* self) {
	GeditApp* result;
	GeditApp* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 (self->priv->_app);
	result = _tmp0_;
	return result;
}


static void vtg_plugin_set_app (VtgPlugin* self, GeditApp* value) {
	GeditApp* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_app);
	self->priv->_app = _tmp0_;
	g_object_notify ((GObject *) self, "app");
}


static GObject * vtg_plugin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	VtgPlugin * self;
	parent_class = G_OBJECT_CLASS (vtg_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VTG_PLUGIN (obj);
	vtg_plugin_main_instance = self;
	return obj;
}


static void vtg_plugin_class_init (VtgPluginClass * klass) {
	vtg_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgPluginPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vtg_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vtg_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = vtg_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = vtg_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_INSTANCES, vala_param_spec_iterable ("instances", "instances", "instances", VALA_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_PROJECTS, g_param_spec_object ("projects", "projects", "projects", VTG_TYPE_PROJECTS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_CONFIG, g_param_spec_object ("config", "config", "config", VTG_TYPE_CONFIGURATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VTG_PLUGIN_APP, g_param_spec_object ("app", "app", "app", gedit_app_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void vtg_plugin_gedit_app_activatable_interface_init (GeditAppActivatableInterface * iface) {
	vtg_plugin_gedit_app_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(GeditAppActivatable*)) vtg_plugin_real_activate;
	iface->deactivate = (void (*)(GeditAppActivatable*)) vtg_plugin_real_deactivate;
}


static void vtg_plugin_instance_init (VtgPlugin * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VTG_PLUGIN_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (VTG_TYPE_PLUGIN_INSTANCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->_instances = (ValaList*) _tmp0_;
	self->priv->_config = NULL;
	self->priv->_projects = NULL;
	self->saving = FALSE;
}


static void vtg_plugin_finalize (GObject* obj) {
	VtgPlugin * self;
	guint _tmp0_;
	guint _tmp1_;
	self = VTG_PLUGIN (obj);
	g_signal_parse_name ("project-opened", VTG_TYPE_PROJECTS, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_projects, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _vtg_plugin_on_project_opened_vtg_projects_project_opened, self);
	g_signal_parse_name ("project-closed", VTG_TYPE_PROJECTS, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_projects, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _vtg_plugin_on_project_closed_vtg_projects_project_closed, self);
	vtg_plugin_deactivate_modules (self, VTG_PLUGIN_DEACTIVATE_MODULE_OPTIONS_ALL);
	vtg_plugin_main_instance = NULL;
	_vala_iterable_unref0 (self->priv->_instances);
	_g_object_unref0 (self->priv->_config);
	_g_object_unref0 (self->priv->_projects);
	_g_object_unref0 (self->priv->_app);
	G_OBJECT_CLASS (vtg_plugin_parent_class)->finalize (obj);
}


GType vtg_plugin_get_type (void) {
	return vtg_plugin_type_id;
}


GType vtg_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgPlugin), 0, (GInstanceInitFunc) vtg_plugin_instance_init, NULL };
	static const GInterfaceInfo gedit_app_activatable_info = { (GInterfaceInitFunc) vtg_plugin_gedit_app_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vtg_plugin_type_id = g_type_module_register_type (module, PEAS_TYPE_EXTENSION_BASE, "VtgPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, vtg_plugin_type_id, gedit_app_activatable_get_type (), &gedit_app_activatable_info);
	return vtg_plugin_type_id;
}


static void _vala_vtg_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VtgPlugin * self;
	self = VTG_PLUGIN (object);
	switch (property_id) {
		case VTG_PLUGIN_INSTANCES:
		vala_value_set_iterable (value, vtg_plugin_get_instances (self));
		break;
		case VTG_PLUGIN_PROJECTS:
		g_value_set_object (value, vtg_plugin_get_projects (self));
		break;
		case VTG_PLUGIN_CONFIG:
		g_value_set_object (value, vtg_plugin_get_config (self));
		break;
		case VTG_PLUGIN_APP:
		g_value_take_object (value, vtg_plugin_get_app (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vtg_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	VtgPlugin * self;
	self = VTG_PLUGIN (object);
	switch (property_id) {
		case VTG_PLUGIN_APP:
		vtg_plugin_set_app (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


VtgPluginConfig* vtg_plugin_config_construct (GType object_type) {
	VtgPluginConfig * self = NULL;
	self = (VtgPluginConfig*) g_object_new (object_type, NULL);
	return self;
}


VtgPluginConfig* vtg_plugin_config_new (void) {
	return vtg_plugin_config_construct (VTG_TYPE_PLUGIN_CONFIG);
}


static GtkWidget* vtg_plugin_config_real_create_configure_widget (PeasGtkConfigurable* base) {
	VtgPluginConfig * self;
	GtkWidget* result = NULL;
	VtgConfiguration* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	self = (VtgPluginConfig*) base;
	_tmp0_ = vtg_plugin_get_config (vtg_plugin_main_instance);
	_tmp1_ = vtg_configuration_get_configuration_dialog (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vtg_plugin_config_class_init (VtgPluginConfigClass * klass) {
	vtg_plugin_config_parent_class = g_type_class_peek_parent (klass);
}


static void vtg_plugin_config_peas_gtk_configurable_interface_init (PeasGtkConfigurableInterface * iface) {
	vtg_plugin_config_peas_gtk_configurable_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_configure_widget = (GtkWidget* (*)(PeasGtkConfigurable*)) vtg_plugin_config_real_create_configure_widget;
}


static void vtg_plugin_config_instance_init (VtgPluginConfig * self) {
}


GType vtg_plugin_config_get_type (void) {
	return vtg_plugin_config_type_id;
}


GType vtg_plugin_config_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgPluginConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_plugin_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgPluginConfig), 0, (GInstanceInitFunc) vtg_plugin_config_instance_init, NULL };
	static const GInterfaceInfo peas_gtk_configurable_info = { (GInterfaceInitFunc) vtg_plugin_config_peas_gtk_configurable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vtg_plugin_config_type_id = g_type_module_register_type (module, PEAS_TYPE_EXTENSION_BASE, "VtgPluginConfig", &g_define_type_info, 0);
	g_type_module_add_interface (module, vtg_plugin_config_type_id, PEAS_GTK_TYPE_CONFIGURABLE, &peas_gtk_configurable_info);
	return vtg_plugin_config_type_id;
}


void peas_register_types (GTypeModule* module) {
	GTypeModule* _tmp0_;
	PeasObjectModule* _tmp1_;
	PeasObjectModule* objmodule;
	g_return_if_fail (module != NULL);
	vtg_vcs_backends_vcs_base_register_type (module);
	vtg_vcs_backends_item_register_type (module);
	vtg_vcs_backends_git_register_type (module);
	vtg_vcs_backends_bzr_register_type (module);
	vtg_vcs_backends_svn_register_type (module);
	vtg_interaction_parameters_dialog_register_type (module);
	vtg_bracket_completion_register_type (module);
	vtg_symbol_completion_register_type (module);
	vtg_symbol_completion_provider_register_type (module);
	vtg_project_manager_ui_register_type (module);
	vtg_filtered_list_dialog_data_register_type (module);
	vtg_project_view_register_type (module);
	vtg_project_builder_register_type (module);
	vtg_project_executer_register_type (module);
	vtg_project_executer_dialog_register_type (module);
	vtg_project_search_register_type (module);
	vtg_project_search_results_view_register_type (module);
	vtg_project_search_dialog_register_type (module);
	vtg_process_watch_info_register_type (module);
	vtg_output_view_register_type (module);
	vtg_build_log_view_register_type (module);
	vtg_project_manager_register_type (module);
	vtg_projects_register_type (module);
	vtg_filtered_list_dialog_register_type (module);
	vtg_change_log_register_type (module);
	vtg_configuration_register_type (module);
	vtg_source_bookmark_register_type (module);
	vtg_source_bookmarks_register_type (module);
	vtg_plugin_instance_register_type (module);
	vtg_data_register_type (module);
	vtg_source_outliner_view_register_type (module);
	vtg_source_outliner_register_type (module);
	vtg_plugin_window_adapter_register_type (module);
	vtg_plugin_register_type (module);
	vtg_plugin_config_register_type (module);
	vtg_caches_register_type (module);
	vtg_utils_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (PEAS_IS_OBJECT_MODULE (_tmp0_) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, gedit_app_activatable_get_type (), VTG_TYPE_PLUGIN);
	peas_object_module_register_extension_type (objmodule, gedit_window_activatable_get_type (), VTG_TYPE_PLUGIN_WINDOW_ADAPTER);
	peas_object_module_register_extension_type (objmodule, PEAS_GTK_TYPE_CONFIGURABLE, VTG_TYPE_PLUGIN_CONFIG);
	_g_object_unref0 (objmodule);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



