#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "user.h"
#include "entry.h"


const WClass Entry::wclass(ENTRY_TYPE, "Entry", Entry::creator);


/* entry creation from a file */
void Entry::creator(char *l)
{
  new Entry(l);
}

Entry::Entry(char *l)
{
  parsePosition(l, this);
  initializeObject(this, ENTRY_TYPE, VR_INVISIBLE);

  worlds->plocaluser->entry = 1;
  worlds->plocaluser->pos.x = pos.x;
  worlds->plocaluser->pos.y = pos.y;
  worlds->plocaluser->pos.az = pos.az;
} 

void Entry::quit()
{
  worlds->plocaluser->entry = 0;
}

void entryInitFuncList(void) { }

#endif /* !VRENGD */
