#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "user.h"
#include "lift.h"

#include "zv.h"		/* parseGeometry */
#include "payload.h"	/* Payload */


const WClass Lift::wclass(LIFT_TYPE, "Lift", Lift::creator);

static u_int16 oid = 1;


/* lift creation from a file */
void Lift::creator(char *l)
{
  new Lift(l);
}

Lift::Lift(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  org_l = atoi(l); l = strtok(NULL, SEP);
  levels = atoi(l); l = strtok(NULL, SEP);
  height = (float) atof(l); l = strtok(NULL, SEP);
  speed = (float) atof(l); l = strtok(NULL, SEP);
  soh = parseGeometry(l);

  initializeObject(this, LIFT_TYPE, VR_MOBILE);
  maxlasting[LIFT_TYPE] = LIFT_LASTING;

  initializeNetObject(this, oid++, LIFT_PROPS, VR_PERMANENT);

  move.ttl = height / speed;
  dest = pos.z;
  nature.persistency = TRUE;
}

/* lift update towards the network */
boolean Lift::updateToNetwork(const Pos &oldpos)
{
  boolean change = FALSE;
  
  if (this->pos.z != oldpos.z) {
    declareObjDelta(&(this->noh), LIFT_PROPZ);
    trace(DBG_WMGT, "declareObjDelta: z=%.2f", this->pos.z);
#if 0
    oldpos.z = this->pos.z;
#endif
    change = TRUE;
  }
  return change;
}

boolean Lift::change()
{
  return (dest > pos.z /* + LIFT_INCRZ */) ||
         (dest < pos.z /* - LIFT_INCRZ */);
  /* trace(DBG_FORCE, "list remain: %.2f", po->move.ttl); */
  /* return (po->move.ttl > 0.0005) ? TRUE : FALSE; */
}

void Lift::updateTime(time_t sec, time_t usec, float *lasting)
{
  float tlast = (dest - pos.z) / speed;
  
  *lasting = (tlast < 0.0) ? -tlast : tlast;
/***
  if (*lasting < move.ttl) {
    move.ttl -= *lasting;
    move.sec = sec;
    move.usec = usec;
  }
  else {
    *lasting = move.ttl;
    move.ttl = 0;
    move.sec = move.usec = 0;
  }
***/
}

void Lift::changePosition(float lasting)
{
  if (dest == pos.z) {
    return;
  }
  if (dest < pos.z) {
    pos.z -= lasting * speed /*- LIFT_INCRZ*/;
    /* not necessary because gravity */
    if (user)
      user->pos.z -= lasting * speed;
  }
  else {
    if (user) {
      /* not sure if puser->z updated */
      user->pos.z += 2 * (lasting * speed);
    }
    pos.z += lasting * speed /*+ LIFT_INCRZ*/;
  }
  if (user)
    trace(DBG_FORCE, "userChangePosition: feet=%.2f", user->pos.z-USER_DEFAULTHEIGHT/2);
  trace(DBG_FORCE, "liftChangePosition: z=%.2f dest=%.2f", pos.z, dest);
}

/* lift up */
static
void liftUp(Lift *po, void *data, time_t sec, time_t usec)
{
  /*
     int level;
     level = ((po->pos.z - po->org_h) / po->height) +
     po->org_l;
   */
  po->dest = po->pos.z + po->height;
  trace(DBG_FORCE, "liftUp: z=%.2f dest=%.2f", po->pos.z, po->dest);
}

/* lift down */
static
void liftDown(Lift *po, void *data, time_t sec, time_t usec)
{
  po->dest = po->pos.z - po->height;
  trace(DBG_FORCE, "liftDown: z=%.2f dest=%.2f", po->pos.z, po->dest);
}

/* object intersects: like step */
void Lift::whenIntersect(WObject *pcur, WObject *pold)
{
  if (user == NULL) {	/* user is outside */
    if (pcur->pos.z >= pold->pos.z) {	/* same level */
      trace(DBG_FORCE, "Horizontal: feet=%.2f-%.2f l=%.2f", pcur->pos.z-USER_DEFAULTHEIGHT/2, pold->pos.z-USER_DEFAULTHEIGHT/2, pos.z);
      pcur->pos.z += height + 0.05;	/* going on top */
      trace(DBG_FORCE, "Go up: feet=%.2f", pcur->pos.z-USER_DEFAULTHEIGHT/2);
      updateObjectIn3D(pcur);
      updateBB(pcur);
    }
    else {	/* inside from up */
     trace(DBG_FORCE, "Vertical: feet=%.2f", pcur->pos.z-USER_DEFAULTHEIGHT/2);
     copyPositionAndBB(pold, pcur);
     user = (User *) pcur;
    }
  }
  else {	/* already inside */
   trace(DBG_FORCE, "Inside: feet=%.2f", pcur->pos.z-USER_DEFAULTHEIGHT/2);
   copyPositionAndBB(pold, pcur);
  }
}

void Lift::whenNoIntersect(WObject *pcur, WObject *pold)
{
 /* trace(DBG_FORCE, "Outside: user=%.2f-%.2f l=%.2f", pcur->pos.z-USER_DEFAULTHEIGHT/2, pold->pos.z-USER_DEFAULTHEIGHT/2, pos.z); */
 user = NULL;
}

void Lift::quit()
{
  oid = 1;
}

void liftInitFuncList(void)
{
  setFuncList[LIFT_PROPZ][LIFT_TYPE].pf = WO_PAYLOAD set_z;
  setFuncList[LIFT_PROPHNAME][LIFT_TYPE].pf = WO_PAYLOAD set_hname;
  getFuncList[LIFT_PROPZ][LIFT_TYPE].pf = WO_PAYLOAD get_z;
  getFuncList[LIFT_PROPHNAME][LIFT_TYPE].pf = WO_PAYLOAD get_hname;

  setMethodFunc(LIFT_TYPE, 0, WO_ACTION liftUp, "Up");
  setMethodFunc(LIFT_TYPE, 1, WO_ACTION liftDown, "Down");
  /* setMethodFunc(LIFT_TYPE, 2, WO_ACTION liftCall, "Call"); */
}

#endif /* !VRENGD */
