/*----------------------------------------------------
 * prognames.h Tom Green Wed Feb 23 10:07:20 1994
 *
 * Copyright 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * static char prognames_rcsid[]="$Id: prognames.h,v 1.2 1998/10/27 14:58:33 kerce Exp $";
 *
 * $Log: prognames.h,v $
 * Revision 1.2  1998/10/27 14:58:33  kerce
 * Removed QIDLE_BIN* definitions.
 *
 * Revision 1.1.1.1  1998/08/18 14:39:14  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.3  1997/11/04 18:56:21  decker
 * Cosmetic Changes for 3.2
 *
 * Revision 1.2  1997/08/13 17:34:29  decker
 * Changes made to reflect version number 3.1.8
 *
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.6  1996/11/20 23:05:03  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.5  1996/03/27  15:40:57  nrl
 * appended 313 to installationnames
 *
 * Revision 3.4  1994/06/18  14:15:38  green
 * make dqs_random use prognames.h like everybody else
 *
 * Revision 3.3  1994/06/06  23:29:42  green
 * fixed bug in generating Makefile.h(actually not a bug - but AIX
 * couldn't dijest it...)
 *
 * added dqs_parse_exec_str.c(and added in Makefile.proto)
 *
 * built a more "generic" conf_file and resolve_file
 *
 * updated dqs_execd.c and dqs_start_p4.c to utilize dqs_parse_exec_str()
 *
 * had DQS_DSHD_BIN and DQS_DSH_BIN misnamed in prognames.h
 *
 * Revision 3.2  1994/05/31  00:52:42  green
 * added dsh.c dshd.c to Makefile.proto
 *
 * added MAXNAMELEN and NCARGS to def.h
 *
 * type casting in dqs_reauth.c, dqs_sec.c, dqs_setup.c to hush gcc
 * warnings
 *
 * added jmp_buf to globals.h, changed Revision number in globals.h
 *
 * added dsh and dshd tp prognames.h
 *
 * Revision 3.1  1994/04/01  02:59:38  green
 * added "qalter" support
 *
 * Revision 3.0  1994/03/07  04:15:11  green
 * 3.0 freeze
 *
 * Revision 1.4  1994/02/24  20:40:56  green
 * modified Makefile to allow parallel execution of all commands
 *
 * Revision 1.3  1994/02/23  17:19:43  green
 * moved the rcsid into the commented section as some versions
 * of make choked on it otherwise
 *
 * modified the spacing of the 3rd/4th fields of the #defs.
 * seems some cpp's take the spacing literally...
 *
 * Revision 1.2  1994/02/23  16:18:22  green
 * resolved def conflicts in "prognames.h"
 *
 * added "QUSAGE" to globals.h
 *
 * Revision 1.1  1994/02/23  15:48:21  green
 * Added "prognames.h" which defines the installed binary names.
 *
 * Modified "Makefile.proto" accordingly.
 *
 *
 *--------------------------------------------------*/

/* prognames.h allows the SM to redefine the default names
 * for DQS binaries.
 *
 * for example if you wanted to rename "qsub" to "dqs_qsub"
 * to avoid NQS name conflict:
 *
 *        #define QSUB_BIN dqs_qsub
 *        #define QSUB_BINARY "dqs_qsub"
 *
 * NOTE:
 * THERE CAN ONLY BE 1 WHITE SPACE BETWEEN THE 2nd AND 3RD FIELD!
 * 
 * Why you ask?  You don't want to know...
 *
 */

#define DSH_BIN dsh32
#define DSH_BINARY "dsh32"

#define DSHD_BIN dshd32
#define DSHD_BINARY "dshd32"

#define DQS_EXECD_BIN dqs_execd32
#define DQS_EXECD_BINARY "dqs_execd32"

#define DQS_OPTIONS_BIN dqs_options32
#define DQS_OPTIONS_BINARY "dqs_options32"

#define DQS_RANDOM_BIN dqs_random32
#define DQS_RANDOM_BINARY "dqs_random32"

#define QACCT_BIN qacct32
#define QACCT_BINARY "qacct32"

#define QALTER_BIN qalter32
#define QALTER_BINARY "qalter32"

#define QCONF_BIN qconf32
#define QCONF_BINARY "qconf32"

#define QDEL_BIN qdel32
#define QDEL_BINARY "qdel32"

#define QHOLD_BIN qhold32
#define QHOLD_BINARY "qhold32"

#define QMASTER_BIN qmaster32
#define QMASTER_BINARY "qmaster32"

#define QMOD_BIN qmod32
#define QMOD_BINARY "qmod32"

#define QMON_BIN qmon32
#define QMON_BINARY "qmon32"

#define QMOVE_BIN qmove32
#define QMOVE_BINARY "qmove32"

#define QMSG_BIN qmsg32
#define QMSG_BINARY "qmsg32"

#define QRERUN_BIN qrerun32
#define QRERUN_BINARY "qrerun32"

#define QRLS_BIN qrls32
#define QRLS_BINARY "qrls32"

#define QSELECT_BIN qselect32
#define QSELECT_BINARY "qselect32"

#define QSH_BIN qsh32
#define QSH_BINARY "qsh32"

#define QSIG_BIN qsig32
#define QSIG_BINARY "qsig32"

#define QSTAT_BIN qstat32
#define QSTAT_BINARY "qstat32"

#define QSUB_BIN qsub32
#define QSUB_BINARY "qsub32"

#define QUSAGE_BIN qusage32
#define QUSAGE_BINARY "qusage32"

