static char qselect_rcsid[]="qselect.c,v 1.2 1994/11/28 16:55:59 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qselect.c,v
 * Revision 1.2  1994/11/28  16:55:59  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qselect_popup;
static Widget           widget_qselectrc;
static Widget           widget_qselectlabel;
static Widget           widget_qselectframe;
static Widget           widget_qselectmenu;
static Widget           widget_qselectmain;
static Widget           widget_qselectexec;
static Widget           widget_qselectclear;
static Widget           widget_qselectclose;
static Widget           widget_qselectseparator;
static Widget           widget_qselectopt;

struct optionstruct qselectmenu[]={
  0,"Date/Time        ","-a",   INPUTTYPE,NULL,NULL,
  0,"Account List     ","-A",   INPUTTYPE,NULL,NULL,
  0,"Server           ","-B", FLAGTYPE,"False",NULL,
  0,"Interval         ","-c",   INPUTTYPE,NULL,NULL,
  0,"Hold User        ","-h u",  FLAGTYPE,"False",NULL,
  0,"Hold System      ","-h s",  FLAGTYPE,"False",NULL,
  0,"Hold Other       ","-h o",  FLAGTYPE,"False",NULL,
  0,"No Hold          ","-h n",  FLAGTYPE,"False",NULL,
  0,"Help             ","-help", FLAGTYPE,"False",NULL,
  0,"Resource List    ","-l",  INPUTTYPE,NULL,NULL,
  0,"Job Name         ","-N",  INPUTTYPE,NULL,NULL,
  0,"Priority         ","-p",   INPUTTYPE,NULL,NULL,
  0,"Cell             ","-cell",   INPUTTYPE,NULL,NULL,
  0,"Std. Error Path  ","-e",   INPUTTYPE,NULL,NULL,
  0,"Execute File     ","-exec",   INPUTTYPE,NULL,NULL,
  0,"Destination List ","-q",   INPUTTYPE,NULL,NULL,
  0,"Rerunable        ","-r", FLAGTYPE,"False",NULL,
  0,"States           ","-s",   INPUTTYPE,NULL,NULL,
  0,"User List        ","-u",   INPUTTYPE,NULL,NULL,
  0,"Verify           ","-verify",   FLAGTYPE,"FALSE",NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qselectexec - Activate callback for exec
 */
XtCallbackProc pb_qselectexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QSELECT_BINARY,qselectmenu,0);
  sleep(2);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qselectclear - Activate callback for clear
 */
XtCallbackProc pb_qselectclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qselectmenu);
}


/***********************************************************
 * pb_qselectclose - Activate callback for close
 */

XtCallbackProc pb_qselectclose(Widget w, caddr_t client_data, caddr_t call_data)


{
  closemainmenuwin();
}


/***********************************************************
 * create_qselect_dialog - Create widgets used for the qselect menu
 */
int create_qselect_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qselect_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qselect_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qselect_form = XtCreateManagedWidget("form", formWidgetClass, qselect_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qselectlabel=
        XtCreateManagedWidget("Qselect",labelWidgetClass,qselect_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qselectlabel); ii++;
  widget_qselectmain=XtCreateManagedWidget("box",formWidgetClass,qselect_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qselectmain,NULL,"Exec",(XtCallbackProc)pb_qselectexec,NULL);
 clear=QmonAddButtonN(widget_qselectmain,exec,"Clear",(XtCallbackProc)pb_qselectclear,NULL);
 close=QmonAddButtonN(widget_qselectmain,clear,"Close",(XtCallbackProc)pb_qselectclose,NULL);

  widget_qselectopt=createmenuoptions(qselect_form,widget_qselectmain,qselectmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qselect - Open the qselect menu
 */
int openwidget_qselect()
{
  XtPopup(qselect_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qselect - Close the qselect menu
 */
int closewidget_qselect()
{
   XtPopdown(qselect_popup);
}
