static char cpu_c_rcsid[]="cpu.c,v 1.3 1994/12/01 14:45:54 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * cpu.c,v
 * Revision 1.3  1994/12/01  14:45:54  kerce
 * Solaris 2.x mods
 *
 * Revision 1.2  1994/06/22  15:47:59  kerce
 * For "CPU Usage Options" window, allow insertion/removal of defaults
 *   with the mere click of a button
 *
 * Better sanity checking for qusage/qacct's options
 *
 * Revision 1.1.1.1  1994/06/18  19:43:26  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/AsciiText.h>
#include "errorpop.h"
#include "cpuusage.h"
#include "acctfile.h"
#include "util.h"
#include "help.h"
#include "cpu.h"

extern char *CmdLineAcctFileName;
extern char *EnvAcctFileName;

static Widget DQSUsageCPUAcctFileNameTextW;
static Widget DQSUsageCPUStartTextW;
static Widget DQSUsageCPUDaysTextW;
static Widget DQSUsageCPUQComplexTextW;
static Widget DQSUsageCPUQNameTextW;
static Widget DQSUsageCPUHostNameTextW;
static Widget DQSUsageCPUGroupTextW;
static Widget DQSUsageCPUOwnerTextW;
static Widget DQSUsageCPUJobNameTextW;
static Widget DQSUsageCPUBinSizeTextW;

static Widget DQSUsageCPUDefaultsButtonW;
static Boolean DefaultsSet;

static void
DQSUsageSetDefaults ()
{
  Arg wargs[2];
  unsigned int n;
  char *AcctFileName;
  char DefaultStartDaysAgo[MAX_STRING_SIZE], DefaultDays[MAX_STRING_SIZE];
  char DefaultJobName[MAX_STRING_SIZE], DefaultBinSize[MAX_STRING_SIZE];

  DENTER ((DQS_EVENT, "DQSUsageSetDefaults"));
  
  n = 0;
  AcctFileName = BuildFileName (ACCTF);
  if (AcctFileName != NULL)
    XtSetArg (wargs[n], XtNstring, AcctFileName);
  if (EnvAcctFileName != NULL)
    XtSetArg (wargs[n], XtNstring, EnvAcctFileName);
  if (CmdLineAcctFileName != NULL)
    XtSetArg (wargs[n], XtNstring, CmdLineAcctFileName);
  n++;
  XtSetValues (DQSUsageCPUAcctFileNameTextW, wargs, n);
  
  n = 0;
  sprintf (DefaultStartDaysAgo, "%u", DEFAULTSTARTDAYSAGO);
  XtSetArg (wargs[n], XtNstring, DefaultStartDaysAgo);
  n++;
  XtSetValues (DQSUsageCPUStartTextW, wargs, n);

  n = 0;
  sprintf (DefaultDays, "%u", DEFAULTDAYS);
  XtSetArg (wargs[n], XtNstring, DefaultDays);
  n++;
  XtSetValues (DQSUsageCPUDaysTextW, wargs, n);

  n = 0;
  sprintf (DefaultJobName, "%s", "*");
  XtSetArg (wargs[n], XtNstring, DefaultJobName);
  n++;
  XtSetValues (DQSUsageCPUJobNameTextW, wargs, n);

  n = 0;
  sprintf (DefaultBinSize, "%u", DEFAULTBINSIZE);
  XtSetArg (wargs[n], XtNstring, DefaultBinSize);
  n++;
  XtSetValues (DQSUsageCPUBinSizeTextW, wargs, n);

  DEXIT;
}

static void
DQSUsageResetDefaults ()
{
  Arg wargs[2];
  unsigned int n;
  char *AcctFileName;
  char DefaultStartDaysAgo[MAX_STRING_SIZE], DefaultDays[MAX_STRING_SIZE];
  char DefaultJobName[MAX_STRING_SIZE], DefaultBinSize[MAX_STRING_SIZE];

  DENTER ((DQS_EVENT, "DQSUsageResetDefaults"));

  n = 0;
  XtSetArg (wargs[n], XtNstring, "");
  n++;
  XtSetValues (DQSUsageCPUAcctFileNameTextW, wargs, n);
  
  n = 0;
  XtSetArg (wargs[n], XtNstring, "");
  n++;
  XtSetValues (DQSUsageCPUStartTextW, wargs, n);

  n = 0;
  XtSetArg (wargs[n], XtNstring, "");
  n++;
  XtSetValues (DQSUsageCPUDaysTextW, wargs, n);

  n = 0;
  XtSetArg (wargs[n], XtNstring, "");
  n++;
  XtSetValues (DQSUsageCPUJobNameTextW, wargs, n);

  n = 0;
  XtSetArg (wargs[n], XtNstring, "");
  n++;
  XtSetValues (DQSUsageCPUBinSizeTextW, wargs, n);

  DEXIT;
}

static void
DQSUsageCPUDefaults (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  Arg args[2];

  DENTER ((DQS_EVENT, "DQSUsageCPUDefaults"));
  
  if (DefaultsSet == True)
    {
      DQSUsageResetDefaults ();
      DefaultsSet = False;
      XtSetArg (args[0], XtNlabel, "Use Defaults");
    }
  else
    {
      DQSUsageSetDefaults ();
      DefaultsSet = True;
      XtSetArg (args[0], XtNlabel, "Remove Defaults");
    }

  XtSetValues (DQSUsageCPUDefaultsButtonW, args, 1);

  DEXIT;
}

static void
DQSUsageCPUAccept (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  Arg args[1];
  String Str;
  unsigned int Start, Days, BinSize;
  char AcctFileName[MAX_STRING_SIZE], QName[MAX_STRING_SIZE];
  char HostName[MAX_STRING_SIZE], QComplexStr[MAX_STRING_SIZE];
  char Group[MAX_STRING_SIZE], Owner[MAX_STRING_SIZE];
  char JobName[MAX_STRING_SIZE], ErrMsg[MAX_STRING_SIZE];
  int scanfResult;
  off_t AcctFileSize;
  
  DENTER ((DQS_EVENT, "DQSUsageCPUAccept"));
  
  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUStartTextW, args, ONE);
  if (strlen (Str) != 0)
    {
      scanfResult = sscanf (Str, "%u", &Start);
      if (scanfResult != 1)
	{
	  ErrorPopup (W, "Start field cannot be parsed.");
	  DEXIT;
	  return;
	}
    }
  else
    {
      sprintf (ErrMsg, "Start unspecified.");
      ErrorPopup (W, ErrMsg);
      DEXIT;
      return;
    }
  
  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUDaysTextW, args, ONE);
  if (strlen (Str) != 0)
    {
      scanfResult = sscanf (Str, "%u", &Days);
      if (scanfResult != 1)
	{
	  ErrorPopup (W, "Days field cannot be parsed.");
	  DEXIT;
	  return;
	}
    }
  else
    {
      sprintf (ErrMsg, "Days unspecified.");
      ErrorPopup (W, ErrMsg);
      DEXIT;
      return;
    }
  
  /*
   *  Validate Start and Days.
   */
  if (Days > Start)
    {
      ErrorPopup (W, "Days must be less than\nor equal to Start.");
      DEXIT;
      return;
    }

  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUAcctFileNameTextW, args, ONE);
  strncpy (AcctFileName, Str, MAX_STRING_SIZE);

  if (strlen (AcctFileName) == 0)
    {
      sprintf (ErrMsg, "Accounting file name unspecified.");
      ErrorPopup (W, ErrMsg);
      DEXIT;
      return;
    }

  {
    struct stat FileStat;
    int statResult;
    
    statResult = stat (AcctFileName, &FileStat);
    if (statResult != 0)
      {
	sprintf (ErrMsg,
		 "Cannot open accounting file named:\n%s\nPossible reason:\n%s",
		 AcctFileName, ErrorMessage (errno));
	ErrorPopup (W, ErrMsg);
	DEXIT;
	return;
      }
  }
  
  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUQNameTextW, args, ONE);
  strncpy (QName, Str, MAX_STRING_SIZE);
  
  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUHostNameTextW, args, ONE);
  strncpy (HostName, Str, MAX_STRING_SIZE);
  
  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUQComplexTextW, args, ONE);
  strncpy (QComplexStr, Str, MAX_STRING_SIZE);

  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUGroupTextW, args, ONE);
  strncpy (Group, Str, MAX_STRING_SIZE);
  
  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUOwnerTextW, args, ONE);
  strncpy (Owner, Str, MAX_STRING_SIZE);

  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUJobNameTextW, args, ONE);
  strncpy (JobName, Str, MAX_STRING_SIZE);

  XtSetArg (args[0], XtNstring, &Str);
  XtGetValues (DQSUsageCPUBinSizeTextW, args, ONE);
  if (strlen (Str) != 0)
    {
      scanfResult = sscanf (Str, "%u", &BinSize);
      if (scanfResult != 1)
	{
	  ErrorPopup (W, "Bin Size field cannot be parsed.");
	  DEXIT;
	  return;
	}
    }
  else
    {
      sprintf (ErrMsg, "Bin Size unspecified.");
      ErrorPopup (W, ErrMsg);
      DEXIT;
      return;
    }
  
  if (BinSize < 1)
    {
      ErrorPopup (W, "Bin Size must be greater than 0.");
      DEXIT;
      return;
    }
  
  if ((strcmp (QName, "") == 0)
      && (strcmp (HostName, "") == 0)
      && (strcmp (QComplexStr, "") == 0)
      && (strcmp (Group, "") == 0)
      && (strcmp (Owner, "") == 0)
      && (strcmp (JobName, "") == 0))
    {
      ErrorPopup (W,
		  "At least one of Queue, Host, Complex, Group,\nOwner, or Job must be given; otherwise, no jobs will be matched.");
      DEXIT;
      return;
    }

  AcctFileSize = 
    CPUUsageBegin (W, Start, Days, BinSize, AcctFileName, QName, HostName,
		   QComplexStr, Group, Owner, JobName);

  if (AcctFileSize > 0)
    {
      if (AcctFileSize > 50000)
	DQSUsageWorkingPopup (W);

      CPUUsageAddWorkProc ();
    }

  DEXIT;
}

static void
DQSUsageCPUHelp (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageCPUHelp"));

  Help ("Usage Options");

  DEXIT;
}

static void
DQSUsageCPUCancel (W, ParentW, CallData)
     Widget W;
     Widget ParentW;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageCPUCancel"));

  XtPopdown (ParentW);

  DEXIT;
}

void
DQSUsageCPU (W, ClientData, CallData)
     Widget W;
     caddr_t ClientData;
     caddr_t CallData;
{
  static Widget DQSUsageCPUParentW;
  static Widget DQSUsageCPUFormW;
  static Widget DQSUsageCPUOptFormW;
  static Widget DQSUsageCPUTitleLabelW;
  static Widget DQSUsageCPUAcctFileNameLabelW;
  static Widget DQSUsageCPUStartLabelW;
  static Widget DQSUsageCPUDaysLabelW;
  static Widget DQSUsageCPUQComplexLabelW;
  static Widget DQSUsageCPUQNameLabelW;
  static Widget DQSUsageCPUHostNameLabelW;
  static Widget DQSUsageCPUGroupLabelW;
  static Widget DQSUsageCPUOwnerLabelW;
  static Widget DQSUsageCPUJobNameLabelW;
  static Widget DQSUsageCPUBinSizeLabelW;
  static Widget DQSUsageCPUAcceptButtonW;
  static Widget DQSUsageCPUHelpButtonW;
  static Widget DQSUsageCPUCancelButtonW;
  static int DejaVu = 0;
  Arg wargs[10];
  unsigned int n;

  DENTER ((DQS_EVENT, "DQSUsageCPU"));

  if (DejaVu == 0)
    {
      DefaultsSet = True;

      DQSUsageCPUParentW =
	XtCreatePopupShell ("DQSUsageCPUParent", transientShellWidgetClass, W,
			    NULL, ZERO);
      
      DQSUsageCPUFormW =
	XtCreateManagedWidget ("DQSUsageCPUForm", formWidgetClass,
			       DQSUsageCPUParentW, NULL, ZERO);
      
      DQSUsageCPUTitleLabelW =
	XtCreateManagedWidget ("DQSUsageCPUTitle", labelWidgetClass,
			       DQSUsageCPUFormW, NULL, ZERO);
      
      DQSUsageCPUOptFormW =
	XtCreateManagedWidget ("DQSUsageCPUOptForm", formWidgetClass,
			       DQSUsageCPUFormW, NULL, ZERO);
      
      /* AcctFileName */
      DQSUsageCPUAcctFileNameLabelW =
	XtCreateManagedWidget ("DQSUsageCPUAcctFileNameL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUAcctFileNameTextW =
	XtCreateManagedWidget ("DQSUsageCPUAcctFileNameT",
			       asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUAcctFileNameTextW, wargs, n);
      
      /* Start */
      DQSUsageCPUStartLabelW =
	XtCreateManagedWidget ("DQSUsageCPUStartL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUStartTextW =
	XtCreateManagedWidget ("DQSUsageCPUStartT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUStartTextW, wargs, n);
      
      /* Days */
      DQSUsageCPUDaysLabelW =
	XtCreateManagedWidget ("DQSUsageCPUDaysL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUDaysTextW =
	XtCreateManagedWidget ("DQSUsageCPUDaysT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUDaysTextW, wargs, n);
      
      /* QName */
      DQSUsageCPUQNameLabelW =
	XtCreateManagedWidget ("DQSUsageCPUQNameL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUQNameTextW =
	XtCreateManagedWidget ("DQSUsageCPUQNameT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUQNameTextW, wargs, n);
      
      /* HostName */
      DQSUsageCPUHostNameLabelW =
	XtCreateManagedWidget ("DQSUsageCPUHostNameL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUHostNameTextW =
	XtCreateManagedWidget ("DQSUsageCPUHostNameT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUHostNameTextW, wargs, n);
      
      /* QComplex */
      DQSUsageCPUQComplexLabelW =
	XtCreateManagedWidget ("DQSUsageCPUQComplexL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUQComplexTextW =
	XtCreateManagedWidget ("DQSUsageCPUQComplexT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUQComplexTextW, wargs, n);
      
      /* Group */
      DQSUsageCPUGroupLabelW =
	XtCreateManagedWidget ("DQSUsageCPUGroupL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUGroupTextW =
	XtCreateManagedWidget ("DQSUsageCPUGroupT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUGroupTextW, wargs, n);
      
      /* Owner */
      DQSUsageCPUOwnerLabelW =
	XtCreateManagedWidget ("DQSUsageCPUOwnerL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUOwnerTextW =
	XtCreateManagedWidget ("DQSUsageCPUOwnerT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUOwnerTextW, wargs, n);
      
      /* JobName */
      DQSUsageCPUJobNameLabelW =
	XtCreateManagedWidget ("DQSUsageCPUJobNameL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUJobNameTextW =
	XtCreateManagedWidget ("DQSUsageCPUJobNameT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUJobNameTextW, wargs, n);
      
      /* BinSize */
      DQSUsageCPUBinSizeLabelW =
	XtCreateManagedWidget ("DQSUsageCPUBinSizeL", labelWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      DQSUsageCPUBinSizeTextW =
	XtCreateManagedWidget ("DQSUsageCPUBinSizeT", asciiTextWidgetClass,
			       DQSUsageCPUOptFormW, NULL, ZERO);
      
      n = 0;
      XtSetArg (wargs[n], XtNeditType, XawtextEdit);
      n++;
      XtSetValues (DQSUsageCPUBinSizeTextW, wargs, n);
      
      DQSUsageCPUDefaultsButtonW =
	XtCreateManagedWidget ("DQSUsageCPUDefaults", commandWidgetClass,
			       DQSUsageCPUFormW, NULL, ZERO);
      XtAddCallback (DQSUsageCPUDefaultsButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsageCPUDefaults, DQSUsageCPUParentW);
      
      DQSUsageCPUAcceptButtonW =
	XtCreateManagedWidget ("DQSUsageCPUAccept", commandWidgetClass,
			       DQSUsageCPUFormW, NULL, ZERO);
      XtAddCallback (DQSUsageCPUAcceptButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsageCPUAccept, DQSUsageCPUParentW);
      
      DQSUsageCPUHelpButtonW =
	XtCreateManagedWidget ("DQSUsageCPUHelp", commandWidgetClass,
			       DQSUsageCPUFormW, NULL, ZERO);
      XtAddCallback (DQSUsageCPUHelpButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsageCPUHelp, DQSUsageCPUParentW);
      
      DQSUsageCPUCancelButtonW =
	XtCreateManagedWidget ("DQSUsageCPUCancel", commandWidgetClass,
			       DQSUsageCPUFormW, NULL, ZERO);
      XtAddCallback (DQSUsageCPUCancelButtonW, XtNcallback,
		     (XtCallbackProc) DQSUsageCPUCancel, DQSUsageCPUParentW);
      
      DQSUsageSetDefaults ();

      DejaVu = 1;
    }
  
  XtPopup (DQSUsageCPUParentW, XtGrabNone);

  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
