static char qusage_c_rcsid[]="qusage.c,v 1.2 1994/06/25 16:25:20 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * qusage.c,v
 * Revision 1.2  1994/06/25  16:25:20  kerce
 * changed version numbers from 3.05 to 3.1.0
 *
 * Revision 1.1.1.1  1994/06/18  19:43:26  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define MAINPROGRAM
#include <assert.h>
#include <stdlib.h>
#include "acctfile.h"
#include "xgui.h"
#include "stdstuff.h"
#include "util.h"
#include "cpyright.h"

char *ProgramName = NULL;
void (*FatalErrorHook)();
char *Title = "DQS Usage";

#ifndef __DATE__
char *Version = " v3.1.0 beta\n\
  Graphical display of DQS queue utilization";
#else
char *Version = " v3.1.0 beta (compiled " __DATE__ " " __TIME__ ")\n\
  Graphical display of DQS queue utilization";
#endif

char *AboutTextString = COPYRIGHT;

char *CmdLineAcctFileName = NULL;
char *EnvAcctFileName = NULL;

unsigned long int StartupTimeOfDayInSecs;

static void
ShowUsage ()
{
  DENTER ((DQS_EVENT, "ShowUsage"));

  fprintf (stderr, "Usage: %s [-f AcctFileName]\n", ProgramName);
  fprintf (stderr, "   or: %s -help\n", ProgramName);
  fprintf (stderr, "   or: %s -version\n", ProgramName);

  DEXIT;
}

static void
ShowHelp ()
{
  DENTER ((DQS_EVENT, "ShowHelp"));

  ShowUsage ();
  fprintf (stderr, "\n");
  fprintf (stderr, "where: AcctFileName is the name of a DQS accounting");
  fprintf (stderr, " file\n");

  DEXIT;
}

static void
ShowVersion ()
{
  DENTER ((DQS_EVENT, "ShowHelp"));

  fprintf (stderr, BuildAboutTextString (Title, Version, AboutTextString));

  DEXIT;
}

static void
ProcessCmdLine (argc, argv)
     int *argc;
     char **argv;
{
  char c;
  BOOLEAN NextOption;

  DENTER ((DQS_EVENT, "ProcessCmdLine"));

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);
  
  while ((--*argc > 0) && ((*++argv)[0] == '-'))
    {
      NextOption = FALSE;
      while ((c = *++argv[0]) && (NextOption == FALSE))
	switch (c)
	  {
	  case 'f':
	    --*argc;
	    if (*argc > 0)
	      {
		argv++;
		if (EnvAcctFileName != NULL)
		  Error (NULL, 0, 0,
			 "WARNING: overriding environment variable %s",
			 ACCTFILEENVVARNAME);

		CmdLineAcctFileName = argv[0];
		NextOption = TRUE;
	      }
	    else
	      {
		Error (NULL, 0, 0,
		       "-f option must be followed by a file name");
		ShowUsage ();
		DEXIT;
		exit (EXIT_FAILURE);
	      }
	    break;
	    
	  case 'h':
	  case '?':
	    ShowHelp ();
	    DEXIT;
	    exit (EXIT_SUCCESS);
	    break;
	    
	  case 'v':
	    ShowVersion ();
	    DEXIT;
	    exit (EXIT_SUCCESS);
	    break;
	    
	  default:
	    Error (NULL, 0, 0, "unknown option `%c'", c);
	    break;
	  }
    }

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);

  if (*argc > 0)
    {
      Error (NULL, 0, 0,
	     "WARNING: the following command line arguments were unused:");

      while (--*argc > 0)
	{
	  fprintf (stderr, "%s ", argv[*argc]);
	}

      fputc ('\n', stderr);
    }

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);

  fflush (stderr);

  DEXIT;
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  DENTER_MAIN ((DQS_EVENT, "qusage"));
  dqs_setup (QUSAGE, "qusage");

  FatalErrorHook = NULL;
  ProgramName = argv[0];

  if (DEBUG_ON == 1)
    DisplayArgs (argc, argv);

  StartupTimeOfDayInSecs = TimeOfDayInSecs ();

  InitializeGUI (&argc, argv);

  EnvAcctFileName = getenv (ACCTFILEENVVARNAME);

  ProcessCmdLine (&argc, argv);

  HandleEvents ();

  DEXIT;
  exit (EXIT_SUCCESS);
}     


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
