/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include "floater.h"
#include "br.h"
#include "comm.h"
#include "UI.h"

#define FLOATER_EXECUTIONLOG 15
#define EXECUTIONLOG_MAXLEN 200

static int exlogged = 0;
static char *exlog[FLOATER_EXECUTIONLOG];

void executionlog(char *label, char *event)
{
  int i;

  if (exlogged++ == 0)
    for (i = 0; i < FLOATER_EXECUTIONLOG - 1; i++) exlog[i] = NULL;

  if (exlog[0] != NULL) reset(exlog[0]);
  for (i = 0; i < FLOATER_EXECUTIONLOG - 1; i++) exlog[i] = exlog[i + 1];
  exlog[i] = STRCAT(label, event);
}

void dumpexecutionlog(char *s)
{
  int i;
  
  for (i = 0; i < FLOATER_EXECUTIONLOG; i++)
    if (strexists(exlog[i])) {
      if (strlen(exlog[i]) > EXECUTIONLOG_MAXLEN)
	exlog[i][EXECUTIONLOG_MAXLEN] = '\0';
      sprintf(s + strlen(s), "log%d: %s\n",
	      exlogged + i - (FLOATER_EXECUTIONLOG - 1),
	      exlog[i]);
    }    
}

/* generate some text that is included in all bug report emails */
static char *dumpvars(void)
{
  char *s = markgarbage(salloc(10000));

#define CKNULL(w) ((w) == NULL ? "NULL" : (w))
#define NULL_OR_NOT(w) ((w) == NULL ? "NULL" : "not NULL")

  extern char *fatal_error_message;

  /* from br.c */
  extern int handcounter;
  extern char *curhandname;
  extern char *curhandID ;
  extern char *curastate ;
  extern char *curpstate ;
  extern char *curprettyauction ;
  extern int curdealer ;
  extern int curdeclarer ;
  extern char curcontract[10];
  extern int curtrump ;
  extern int curdeck[];
  extern char initialcards[4][35];
  extern int currestricks, currespoints;
  extern bool claiming;
  extern int curclaimtricks;
  extern char *claimaccept;
  extern char *northname, *southname, *eastname, *westname;

  /* from comm.c */
  extern char *localIPaddr;
  extern char *localport, *mynote, *mytabledesc;
  extern char tablehostname[];
  extern char tablehostaddr[];
  extern char tablehostport[];
  extern char tablerootname[];
  extern char tablerootaddr[];
  extern char tablerootport[];
  extern char loginservername[];
  extern char loginserveraddr[];
  extern char loginserverport[];
  extern bool triedtologin;
  extern bool loggedin;
  extern bool tablerootmode;
  extern int state;

  /* from UI.c */
  extern bool kibitzing1 ;
  extern int kibitzingseat;
  extern char displayhandID[];
  extern char displayhandname[];
  extern char statushandvul[];
  extern char statushanddlr[];
  extern char displayhandastate[];
  extern char displayhandpstate[];
  extern int displaypov;
  extern int dealercolumn;
  extern int displaycalls;
  extern int displayplays;
  extern bool displayseated ;
  extern bool displayshowbuttonbar ;
  extern char statustolead[];
  extern char statuscontract[];
  extern char statusresult[];
  extern char statusclaim[];
  extern char displaycontract[];
  extern char displaytrickswon[];
  extern int leadercolumn;
  extern int declarercolumn;
  extern int displaytrump;
  extern bool displayhandisover;
  extern bool caughtup;

  dumpexecutionlog(s);
  sprintf(s + strlen(s), "fatal_error_message=%s\n"
	  "version=%s\n"
	  "uname=%s\n"
	  "tclversion=%s\n"
	  "comp=%d\n"                  
	  "new_comp=%d\n"		  
	  "seated=%d\n"			  
	  "myseat=%d\n"			  
	  "myname=%s\n"			  
	  "northname=%s\n"		  
	  "southname=%s\n"		  
	  "eastname=%s\n"		  
	  "westname=%s\n"		  
	  "handcounter=%d\n"		  
	  "curhandname=%s\n"		  
	  "curhandID=%s\n"		  
	  "curastate=%s\n"		  
	  "curpstate=%s\n"		  
	  "curprettyauction=%s\n"	  
	  "curdealer=%d\n"		  
	  "curdeclarer=%d\n"		  
	  "curcontract=%s\n"		  
	  "curtrump=%d\n"		  
	  "curdeck=%s\n"		  
	  "initialcards[North]=%s\n"	  
	  "initialcards[South]=%s\n"	  
	  "initialcards[East]=%s\n"	  
	  "initialcards[West]=%s\n"	  
	  "currestricks=%d\n"		  
	  "currespoints=%d\n"		  
	  "claiming=%d\n"		  
	  "curclaimtricks=%d\n"		  
	  "claimaccept=%s\n"		  
	  "tablehostmode=%d\n"		  
	  "localIPaddr=%s\n"		  
	  "localport=%s\n"		  
	  "mynote=%s\n"			  
	  "mytabledesc=%s\n"		  
	  "tablehostname=%s\n"		  
	  "tablehostaddr=%s\n"		  
	  "tablehostport=%s\n"		  
	  "tablerootname=%s\n",
	  CKNULL(fatal_error_message),
	  TclGet("floater_version"),
	  TclDo("catch {exec uname -a} uname; set uname"),
	  (hasWindows ? TclDo("set s [info tclversion]/[global tk_version; set tk_version]") : TclDo("info tclversion")),
	  competitive,
	  new_competitive,
	  seated,
	  myseat,
	  CKNULL(myname),
	  CKNULL(northname),
	  CKNULL(southname),
	  CKNULL(eastname),
	  CKNULL(westname),
	  handcounter,
	  CKNULL(curhandname),
	  CKNULL(curhandID),
	  CKNULL(curastate),
	  CKNULL(curpstate),
	  CKNULL(curprettyauction),
	  curdealer,
	  curdeclarer,
	  CKNULL(curcontract),
	  curtrump,
	  NULL_OR_NOT(curdeck),
	  CKNULL(initialcards[North]),
	  CKNULL(initialcards[South]),
	  CKNULL(initialcards[East]),
	  CKNULL(initialcards[West]),
	  currestricks,
	  currespoints,
	  claiming,
	  curclaimtricks,
	  CKNULL(claimaccept),
	  tablehostmode,
	  CKNULL(localIPaddr),
	  CKNULL(localport),
	  CKNULL(mynote),
	  CKNULL(mytabledesc),
	  CKNULL(tablehostname),
	  CKNULL(tablehostaddr),
	  CKNULL(tablehostport),
	  CKNULL(tablerootname));

  sprintf(s + strlen(s), 
	  "tablerootaddr=%s\n"		  
	  "tablerootport=%s\n"		  
	  "loginservername=%s\n"	  
	  "loginserveraddr=%s\n"	  
	  "loginserverport=%s\n",
	  CKNULL(tablerootaddr),
	  CKNULL(tablerootport),
	  CKNULL(loginservername),
	  CKNULL(loginserveraddr),
	  CKNULL(loginserverport));

  sprintf(s + strlen(s),
	  "triedtologin=%d\n"		  
	  "loggedin=%d\n"		  
	  "state=%d\n",
	  triedtologin,
	  loggedin,
	  state);

  sprintf(s + strlen(s),
	  "tablerootmode=%d\n",
	  tablerootmode);
  
  sprintf(s + strlen(s),
	  "kibitzing1=%d\n"		  
	  "kibitzingseat=%d\n"		  
	  "displayhandID=%s\n",
	  kibitzing1,
	  kibitzingseat,
	  CKNULL(displayhandID));

  sprintf(s + strlen(s),
	  "displayhandname=%s\n"	  
	  "statushandvul=%s\n"		  
	  "statushanddlr=%s\n"		  
	  "displayhandastate=%s\n"	  
	  "displayhandpstate=%s\n"	  
	  "displaypov=%d\n"		  
	  "dealercolumn=%d\n"		  
	  "displaycalls=%d\n"		  
	  "displayplays=%d\n"		  
	  "displayseated=%d\n"		  
	  "displayshowbuttonbar=%d\n",
	  CKNULL(displayhandname),
	  CKNULL(statushandvul),
	  CKNULL(statushanddlr),
	  CKNULL(displayhandastate),
	  CKNULL(displayhandpstate),
	  displaypov,
	  dealercolumn,
	  displaycalls,
	  displayplays,
	  displayseated,
	  displayshowbuttonbar);

  sprintf(s + strlen(s),
	  "statustolead=%s\n"		  
	  "statuscontract=%s\n"		  
	  "statusresult=%s\n"		  
	  "statusclaim=%s\n"		  
	  "displaycontract=%s\n"	  
	  "displaytrickswon=%s\n"	  
	  "leadercolumn=%d\n"		  
	  "declarercolumn=%d\n"		  
	  "displaytrump=%d\n"		  
	  "displayhandisover=%d\n"	  
	  "caughtup=%d\n",	  	  
	  CKNULL(statustolead),
	  CKNULL(statuscontract),
	  CKNULL(statusresult),
	  CKNULL(statusclaim),
	  CKNULL(displaycontract),
	  CKNULL(displaytrickswon),
	  leadercolumn,
	  declarercolumn,
	  displaytrump,
	  displayhandisover,
	  caughtup);

  return s;
}

/* Email a bug report. */
void mail_bug(char *s, char *filename, int line)
{
  char *t;
  static int inside = 0; /* prevent reentry */

  if (inside != 0) return;

  inside++;
  t = salloc(sizeof(char) * (strlen(s) + 20));
  sprintf(t, s, filename, line);
  fputs(t, stderr);
  fputs("\nEmailing bug report... ", stderr);
  TclDo3("mail_bug {", tclclean(t), "}");
  TclDo3("mail_bug {", destructivebracketclean(braceclean(dumpvars())), "}");
  fputs("done\n", stderr);
  free(t);
#ifdef LOGINSERVER
  TclDo("catch flush_permseenfiles");
#endif
  inside--;
}

/* Handles user request to email a bug report. */
void userbug(char *t)
{
  static int inside = 0; /* prevent reentry */

  if (inside != 0) return;

  inside++;
  status("Emailing bug report...");
  TclDo("update");
  TclDo3("mail_bug {", tclclean(t), "}");
  TclDo3("mail_bug {", destructivebracketclean(braceclean(dumpvars())), "}");
  status("Done reporting bug");
  inside--;
}

