/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include "floater.h"
#include "calendar.h"
#include <time.h>
#include <sys/types.h>
#ifdef TIME_H
#include <time.h>
#else
#include <sys/time.h>
#endif
#include "deal.h"
#include "br.h"

static void setpreviousglobaldate(void);
char previousglobaldate[100];

static char *months[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
			     "Aug", "Sep", "Oct", "Nov", "Dec"};

/* Returns whether we are in a new week.  If so, modifies globaldate
   and globalseed and clears seen as a side effect. NB: a new week is
   defined to start 8AM GMT on Sunday. */
bool checknewweek(void)
{
  struct tm *t;
  time_t tloc;
  char s[100];

  /* get Greenwich Mean Time */
  time(&tloc);
  t = gmtime(&tloc);

  /* turn the clock back to Sunday */
  if (t->tm_wday > 0 || (t->tm_wday == 0 && t->tm_hour < 8)) {
    tloc -= 24 * 60 * 60 * ((t->tm_wday == 0) ? 7 : t->tm_wday);
    t = gmtime(&tloc);
  }

  sprintf(s, "%d%s%02d", t->tm_mday, months[t->tm_mon], t->tm_year % 100);
  if (streq(s, globaldate)) return FALSE;

  setglobaldate(s);
  setpreviousglobaldate();
  TclSet("globaldate", s);
  TclSet("previousglobaldate", previousglobaldate);

#ifdef LOGINSERVER
  /* after 30 min, copy results and password file to rawresults directory */
  TclDo3("after [expr 1800 * 1000] { dumppw; copyresultfiles ",
	 previousglobaldate, "}");
#endif

#ifdef LOGINSERVER
  /* after 1 hour, discard info from the previous week (e.g. who's
     seen what hands) */
  TclDo3("after [expr 3600 * 1000] {discard_data_except_from ",
	 globaldate, "}");
#else
  /* Note that the s represents the current week, but *t
     represents the previous week (because of the call to
     setpreviousglobaldate()).  Unintended, but OK. */
  reseed(s, t->tm_mday * 10000 + t->tm_mon * 100 + t->tm_year);
  setglobalseed(getseed());
  resetseen();
#endif
  return TRUE;
}

static void setpreviousglobaldate(void)
{
  struct tm *t;
  time_t tloc;

  /* get Greenwich Mean Time */
  time(&tloc);
  t = gmtime(&tloc);
  tloc -= 24 * 60 * 60 * 7; /* go back a week */

  /* turn the clock back to Sunday */
  if (t->tm_wday > 0 || (t->tm_wday == 0 && t->tm_hour < 8))
    tloc -= 24 * 60 * 60 * ((t->tm_wday == 0) ? 7 : t->tm_wday);
  t = gmtime(&tloc);

  sprintf(previousglobaldate,
	  "%d%s%02d", t->tm_mday, months[t->tm_mon], t->tm_year % 100);
}

#ifdef RES2HTML
/* Return the global date of i weeks ago. */
char *pastglobaldate(int i)
{
  struct tm *t;
  time_t tloc;
  static char s[100];

  /* get Greenwich Mean Time */
  time(&tloc);
  t = gmtime(&tloc);
  tloc -= 24 * 60 * 60 * 7 * i; /* go back i weeks */

  /* turn the clock back to Sunday */
  if (t->tm_wday > 0 || (t->tm_wday == 0 && t->tm_hour < 8))
    tloc -= 24 * 60 * 60 * ((t->tm_wday == 0) ? 7 : t->tm_wday);
  t = gmtime(&tloc);

  sprintf(s, "%d%s%02d", t->tm_mday, months[t->tm_mon], t->tm_year % 100);
  return s;
}
#endif

/* Returns, in a static character string, the GM date and time */
/* Currently used only for generating random number seeds */
char *date_and_time(void)
{
  struct tm *t;
  time_t tloc;
  static char s[100];

  /* get Greenwich Mean Time */
  time(&tloc);
  t = gmtime(&tloc);

  sprintf(s, "%d%s%d %2d:%2d:%2d", t->tm_mday, months[t->tm_mon], t->tm_year,
	  t->tm_hour, t->tm_min, t->tm_sec);
  return s;
}

#ifdef SERVER
char *localtime_as_string(void)
{
  time_t tloc;
  time(&tloc);
  return asctime(localtime(&tloc));
}
#endif
