/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include <stdlib.h>
#include <sys/types.h>
#ifdef TIME_H
#include <time.h>
#else
#include <sys/time.h>
#endif
#include "floater.h"

#ifdef USE_RAND
#define random rand
#define srandom srand
#endif

/* generate a random number modulo mod */
long unifmod(long mod)
{
  static char inited = FALSE;
  long mask, t;

  assert(mod > 0);

  if (!inited) {
    srandom((int) time(NULL));
    inited = TRUE;
  }

  /* create bitmask with leftmost one at (mod - 1)'s leftmost one */
  /* e.g. if mod is 237, mask should be 255; mod = 4 => mask = 3 */
  mask = 0;
  t = mod - 1;
  while (t > 0) {
    t >>= 1;
    mask = mask * 2 + 1;
  }
  
  while ((t = (random() & mask)) >= mod);
  return t;
}

/* reseed, using s to help us churn */
void churnsimpleseed(char *s)
{
  int i = 0, j;

  while (*s++ != '\0') i = 3 * i + *s + unifmod(1000);
  j = unifmod(20);
  srandom(i);
  while (j-- > 0) unifmod(111);
}

#if 0
  {
    int i;

    printf("testing unifmod(4): ");
    for (i=0; i<20; i++) printf("%d ", unifmod(4));
    printf("\ntesting unifmod(10): ");
    for (i=0; i<20; i++) printf("%d ", unifmod(10));
    puts("");
  }
#endif
