/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.sun.jsr239.NIOConfiguration;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

abstract class ByteBufferImpl
extends ByteBuffer {
    static native int _allocNative(int var0);

    static native void _freeNative(int var0);

    static native void _copyBytes(int var0, int var1, int var2);

    static native byte _getByte(int var0);

    static native void _getBytes(int var0, byte[] var1, int var2, int var3);

    static native void _putByte(int var0, byte var1);

    static native void _putBytes(int var0, byte[] var1, int var2, int var3);

    static native short _getShort(int var0);

    static native void _getShorts(int var0, short[] var1, int var2, int var3);

    static native void _putShort(int var0, short var1);

    static native void _putShorts(int var0, short[] var1, int var2, int var3);

    static native int _getInt(int var0);

    static native void _getInts(int var0, int[] var1, int var2, int var3);

    static native void _putInt(int var0, int var1);

    static native void _putInts(int var0, int[] var1, int var2, int var3);

    static native float _getFloat(int var0);

    static native void _getFloats(int var0, float[] var1, int var2, int var3);

    static native void _putFloat(int var0, float var1);

    static native void _putFloats(int var0, float[] var1, int var2, int var3);

    ByteBufferImpl(int n, byte[] byArray, int n2) {
        this.array = byArray;
        this.arrayOffset = n2;
        this.capacity = n;
        this.limit = n;
        this.position = 0;
        this.isDirect = byArray == null;
    }

    public byte get() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.get(this.position++);
    }

    public byte get(int n) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isDirect) {
            return ByteBufferImpl._getByte(this.arrayOffset + n);
        }
        return this.array[this.arrayOffset + n];
    }

    public ByteBuffer put(byte by) {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.put(this.position++, by);
    }

    public ByteBuffer put(int n, byte by) {
        if (n < 0 || n >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isDirect) {
            ByteBufferImpl._putByte(this.arrayOffset + n, by);
        } else {
            this.array[this.arrayOffset + n] = by;
        }
        return this;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }

    public int getInt() {
        if (this.position >= this.limit - 3) {
            throw new BufferUnderflowException();
        }
        int n = this.getInt(this.position);
        this.position += 4;
        return n;
    }

    public int getInt(int n) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        if (n < 0 || n >= this.limit - 3) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isDirect) {
            n += this.arrayOffset;
            by4 = ByteBufferImpl._getByte(n++);
            by3 = ByteBufferImpl._getByte(n++);
            by2 = ByteBufferImpl._getByte(n++);
            by = ByteBufferImpl._getByte(n);
        } else {
            n += this.arrayOffset;
            by4 = this.array[n++];
            by3 = this.array[n++];
            by2 = this.array[n++];
            by = this.array[n++];
        }
        if (NIOConfiguration.IS_BIG_ENDIAN) {
            return by4 << 24 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 8 | by & 0xFF;
        }
        return by << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    public short getShort() {
        if (this.position >= this.limit - 1) {
            throw new BufferUnderflowException();
        }
        short s = this.getShort(this.position);
        this.position += 2;
        return s;
    }

    public short getShort(int n) {
        byte by;
        byte by2;
        if (n < 0 || n >= this.limit - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isDirect) {
            n += this.arrayOffset;
            by2 = ByteBufferImpl._getByte(n++);
            by = ByteBufferImpl._getByte(n++);
        } else {
            n += this.arrayOffset;
            by2 = this.array[n++];
            by = this.array[n++];
        }
        if (NIOConfiguration.IS_BIG_ENDIAN) {
            return (short)((by2 & 0xFF) << 8 | by & 0xFF);
        }
        return (short)((by & 0xFF) << 8 | by2 & 0xFF);
    }

    public ByteBuffer putFloat(float f) {
        return this.putInt(Float.floatToIntBits(f));
    }

    public ByteBuffer putFloat(int n, float f) {
        return this.putInt(n, Float.floatToIntBits(f));
    }

    public ByteBuffer putInt(int n) {
        if (this.position >= this.limit - 3) {
            throw new BufferOverflowException();
        }
        this.putInt(this.position, n);
        this.position += 4;
        return this;
    }

    public ByteBuffer putInt(int n, int n2) {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        if (n < 0 || n >= this.limit - 3) {
            throw new IndexOutOfBoundsException();
        }
        if (NIOConfiguration.IS_BIG_ENDIAN) {
            by4 = (byte)(n2 >> 24);
            by3 = (byte)(n2 >> 16);
            by2 = (byte)(n2 >> 8);
            by = (byte)n2;
        } else {
            by = (byte)(n2 >> 24);
            by2 = (byte)(n2 >> 16);
            by3 = (byte)(n2 >> 8);
            by4 = (byte)n2;
        }
        if (this.isDirect) {
            n += this.arrayOffset;
            ByteBufferImpl._putByte(n++, by4);
            ByteBufferImpl._putByte(n++, by3);
            ByteBufferImpl._putByte(n++, by2);
            ByteBufferImpl._putByte(n, by);
        } else {
            n += this.arrayOffset;
            this.array[n++] = by4;
            this.array[n++] = by3;
            this.array[n++] = by2;
            this.array[n] = by;
        }
        return this;
    }

    public ByteBuffer putShort(short s) {
        if (this.position >= this.limit - 1) {
            throw new BufferOverflowException();
        }
        this.putShort(this.position, s);
        this.position += 2;
        return this;
    }

    public ByteBuffer putShort(int n, short s) {
        byte by;
        byte by2;
        if (n < 0 || n >= this.limit - 1) {
            throw new IndexOutOfBoundsException();
        }
        if (NIOConfiguration.IS_BIG_ENDIAN) {
            by2 = (byte)(s >> 8);
            by = (byte)s;
        } else {
            by = (byte)(s >> 8);
            by2 = (byte)s;
        }
        if (this.isDirect) {
            n += this.arrayOffset;
            ByteBufferImpl._putByte(n++, by2);
            ByteBufferImpl._putByte(n, by);
        } else {
            n += this.arrayOffset;
            this.array[n++] = by2;
            this.array[n] = by;
        }
        return this;
    }

    public int nativeAddress() {
        return this.arrayOffset;
    }

    public static boolean isBigEndian() {
        return NIOConfiguration.IS_BIG_ENDIAN;
    }

    public void dispose() {
        this.disposed = true;
    }

    static void memoryToByteArray(int n, byte[] byArray, int n2, int n3) {
        ByteBufferImpl._getBytes(n, byArray, n2, n3);
    }

    static void byteArrayToMemory(byte[] byArray, int n, int n2, int n3) {
        ByteBufferImpl._putBytes(n2, byArray, n, n3);
    }

    static void floatArrayToMemory(float[] fArray, int n, int n2, int n3) {
        ByteBufferImpl._putFloats(n2, fArray, n, n3);
    }

    static void memoryToFloatArray(int n, float[] fArray, int n2, int n3) {
        ByteBufferImpl._getFloats(n, fArray, n2, n3);
    }

    static void intArrayToMemory(int[] nArray, int n, int n2, int n3) {
        ByteBufferImpl._putInts(n2, nArray, n, n3);
    }

    static void memoryToIntArray(int n, int[] nArray, int n2, int n3) {
        ByteBufferImpl._getInts(n, nArray, n2, n3);
    }

    static void shortArrayToMemory(short[] sArray, int n, int n2, int n3) {
        ByteBufferImpl._putShorts(n2, sArray, n, n3);
    }

    static void memoryToShortArray(int n, short[] sArray, int n2, int n3) {
        ByteBufferImpl._getShorts(n, sArray, n2, n3);
    }
}

