/*
 *   win32io.c -- platform specific I/O routines
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "dspmgr.h"

#include "dspio.h"                     // Include function prototypes
#include "dsppcmem.h"                  // Include memory calls


/* #define _MAX_PATH 260
#define _MAX_DRIVE 3
#define _MAX_DIR  256
#define _MAX_FNAME 256
#define _MAX_EXT   256 */
/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  DspChgFilePtr                                          */
/*                                                                          */
/* DISCRIPTIVE NAME: Change the file pointer within a file.                 */
/*                                                                          */
/* FUNCTION:         Same                                                   */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES:   NONE                                                   */
/*                                                                          */
/*   RESTRICTIONS:   NONE                                                   */
/*                                                                          */
/* ENTRY POINTS:     DspChgFilePtr                                          */
/*                                                                          */
/* INPUT:            hfile   - handle to the filename.                      */
/*                   ulFileOffset - Offset to move.                         */
/*                                                                          */
/* EXIT-NORMAL:      File pointer changed.                                  */
/*                                                                          */
/* EXTERNAL REFERENCES: System Calls                                        */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

RC DspChgFilePtr(HANDLE hfile,ULONG ulFileOffset,USHORT usMoveType)

{
  ULONG      ulRC;
  DWORD  	  dwMoveMethod;
  
  MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspChgFilePtr entry hfile %x\n",(int)hfile);
  switch(usMoveType){
  case 0:
    dwMoveMethod = SEEK_SET;
    break;
  case 1:
    dwMoveMethod = SEEK_CUR;
    break;
  case 2:
    dwMoveMethod = SEEK_END;
    break;
  default:
    return DSP_INV_PARAMETER;
  }
  ulRC = lseek(hfile,ulFileOffset,dwMoveMethod);
  MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspChgFilePtr exit ulRC %lx\n",ulRC);
  
  if (ulRC != 0xFFFFFFFF)
    return DSP_NOERROR;
  else
    return DSP_IO_ERROR;
}                                      /* End DspChgFilePtr                 */

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  DspCloseFile                                           */
/*                                                                          */
/* DISCRIPTIVE NAME: Close the .DSP file.                                   */
/*                                                                          */
/* FUNCTION:         This Routine will Close the Handle passed to it.       */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES:   NONE                                                   */
/*                                                                          */
/*   RESTRICTIONS:   NONE                                                   */
/*                                                                          */
/* ENTRY POINTS:     DspCloseFile                                           */
/*                                                                          */
/* INPUT:            hfile   - handle to the filename                       */
/*                                                                          */
/* EXIT-NORMAL:      File Closed                                            */
/*                                                                          */
/* EXTERNAL REFERENCES: System Calls                                        */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

RC DspCloseFile(HANDLE hfile)
{
  ULONG      ulRC;
  
  MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspCloseFile entry hfile %x\n",(int)hfile);
  ulRC = close(hfile);
  MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspChgFilePtr exit ulRC %lx\n",ulRC);
  if (ulRC == DSP_NOERROR)
    return (ulRC);
  else
    return (DSP_IO_ERROR);
  
}

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  DspOpenFile                                            */
/*                                                                          */
/* DISCRIPTIVE NAME: Open the .DSP file.                                    */
/*                                                                          */
/* FUNCTION:         This Routine will find and Open the File Requested and */
/*                   return a file handle.                                  */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES:   MWPATH environment contains the .DSP file.             */
/*                                                                          */
/*   RESTRICTIONS:   NONE                                                   */
/*                                                                          */
/* ENTRY POINTS:     DspOpenFile                                            */
/*                                                                          */
/* INPUT:            pszFilename - pointer to the filename                  */
/*                                                                          */
/* EXIT-NORMAL:      hfile    - Handle to filename.                         */
/*                                                                          */
/* EXTERNAL REFERENCES: System Calls                                        */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/************************** END OF SPECIFICATIONS ***************************/

RC DspOpenFile(PSZ pszFilename,HANDLE* phfile,USHORT usFlags)
{
   DWORD	  fdwAccess=0;

   MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspOpenFile entry pszFilename %s\n",pszFilename);
   if (usFlags&DSPOPENWRONLY) {
      fdwAccess = O_WRONLY;
   }
   else if (usFlags&DSPOPENRDWR) {
      fdwAccess = O_RDWR;
   }
   else if (usFlags&DSPOPENRDONLY) {
      fdwAccess = O_RDONLY;
   }

   if (usFlags&DSPOPENCREATE)
     fdwAccess |= O_CREAT;
   else if (usFlags&DSPOPENTRUNC)
     fdwAccess |= O_TRUNC;


   MW_SYSLOG_3(TRACE_MANAGER_CORE,"win32io::DspOpenFIle pszFilename %s fdwAccess %lx\n",pszFilename,fdwAccess);
   *phfile = open(pszFilename,fdwAccess);

   MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspOpenFile exit hfile %x\n",(int)*phfile);
   if (*phfile != -1) {
     return DSP_NOERROR;
   } else {
     MW_SYSLOG_ERROR(LOG_ERR,"Mwave - Unabled to open file %s\n",pszFilename);
     return (DSP_FILE_NOT_FOUND);
   }
   
}                                      

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  DspReadFile                                            */
/*                                                                          */
/* DISCRIPTIVE NAME: Read a number of bytes from a file.                    */
/*                                                                          */
/* FUNCTION:         Same                                                   */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES:   NONE                                                   */
/*                                                                          */
/*   RESTRICTIONS:   NONE                                                   */
/*                                                                          */
/* ENTRY POINTS:     DspReadFile                                            */
/*                                                                          */ 
/* INPUT:            hfile   - handle to the filename.                      */
/*                   ulSize - Number of bytes to read.                      */
/*                                                                          */
/* EXIT-NORMAL:      pBuffer - points the data read.                        */
/*                                                                          */
/* EXTERNAL REFERENCES: System Calls                                        */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

RC DspReadFile(HANDLE hfile,ULONG ulSize,PVOID pBuffer)
{
  DWORD      dwBytesRead;
  
  
  MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspReadFile entry hfile %x\n",(int)hfile);
  dwBytesRead = read(hfile,pBuffer,ulSize);
  
  MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspReadFile exit dwBytesRead %lx\n",dwBytesRead);
  
  if (dwBytesRead == ulSize)
    return (DSP_NOERROR);            /* everything is OK (normal exit)    */
  else {
    return (DSP_IO_ERROR);           
  }                                
}



/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SUBROUTINE NAME:  DspWriteFile                                           */
/*                                                                          */
/* DISCRIPTIVE NAME: Write a number of bytes to a file.                     */
/*                                                                          */
/* FUNCTION:         Same                                                   */
/*                                                                          */
/* NOTE:                                                                    */
/*   DEPENDENCIES:   NONE                                                   */
/*                                                                          */
/*   RESTRICTIONS:   NONE                                                   */
/*                                                                          */
/* ENTRY POINTS:     DspWriteFile                                           */
/*                                                                          */
/* INPUT:            hfile   - handle to the filename.                      */
/*                   ulSize - Number of bytes to read.                      */
/*                   pBuffer - points to data to write.                     */
/*                                                                          */
/* EXIT-NORMAL:      Bytes written to file successfully.                    */
/*                                                                          */
/* EXTERNAL REFERENCES: System Calls                                        */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

RC DspWriteFile(HANDLE hfile,ULONG ulSize,PVOID pBuffer)
{
   DWORD      dwBytesWritten;


   MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspWriteFile entry hfile %x\n",(int)hfile);
   dwBytesWritten = write(hfile,pBuffer,ulSize);
   MW_SYSLOG_2(TRACE_MANAGER_CORE,"win32io::DspWriteFile exit dwBytesWritten %lx\n",dwBytesWritten);

   if (dwBytesWritten == ulSize)
     return (DSP_NOERROR);
   else
     return DSP_IO_ERROR;
}                                      
