/*
 *   mwmpumps.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmspcfc.h>
#include <mwmcntnd.h>
#include <mwqservr.h>

#include <unidiagx.h>

#define AUXSEGADDRESS aulSegAddress      //$1

#define ALL_DATA_SEGMENTS   0x0000
#define NO_DATAMODEDATA1    0x0001
#define NO_DATAMODEDATA2    0x0002
#define NO_DATAMODEDATA3    0x0004
#define NO_V34CONSTEL       0x0008

static char szThisFile[] = "MWMPUMPS.C";

ULONG mwmPumpsLoadV34DataSegments(PMWM_DSPINFO pmwmDspInfo, USHORT usSegmentFlag);


ULONG mwmPumpsFreeV34Segments(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeV34Segments entry\n");  }


  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODE1", OFFSET_DATAMODE1,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODE2", OFFSET_DATAMODE2,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODE3", OFFSET_DATAMODE3,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeV34Segments exit\n");  }


  return 0;
}

ULONG mwmPumpsFreeV34DataSegments(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeV34DataSegments entry\n");  }


  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODEDATA1", OFFSET_DATAMODEDATA1,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODEDATA2", OFFSET_DATAMODEDATA2,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODEDATA3", OFFSET_DATAMODEDATA3,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "V34CONSTEL", OFFSET_V34CONSTEL,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeV34DataSegments exit\n");  }


  return 0;

}

ULONG mwmPumpsFreeX2DataSegments(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeX2DataSegments entry\n");  }


  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMINIT", OFFSET_X2DMINIT,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

//  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DM1", OFFSET_X2DM1,
//                                 szThisFile, __LINE__ );
//  if (ulRC) {
//    return(ulRC);
//  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMDATA1", OFFSET_X2DMDATA1,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

  ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMDATA2", OFFSET_X2DMDATA2,
                                 szThisFile, __LINE__ );
  if (ulRC) {
    return(ulRC);
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeX2DataSegments exit\n");  }


  return 0;

}





ULONG mwmPumpsFreeVDPSegments(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;
  HSEG  hsegDATAMODE1 = 0;
  HSEG  hsegDATAMODE2 = 0;


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeVDPSegments entry\n");  }


  /***************************************************************************/
  /* Get segment handles to the freeable DP segments..                       */
  /***************************************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hvdpTask, "DATAMODE1", &hsegDATAMODE1 );
  if (ulRC != DSP_NOERROR)
  {
    if (ulRC == DSP_NAME_NOT_FOUND)
      hsegDATAMODE1 = 0;
    else
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hvdpTask, "DATAMODE2", &hsegDATAMODE2 );
  if (ulRC != DSP_NOERROR)
  {
    if (ulRC == DSP_NAME_NOT_FOUND)
      hsegDATAMODE2 = 0;
    else
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }


  /***************************************************************************/
  /* Free the DP segments..                                                  */
  /***************************************************************************/
  if (hsegDATAMODE1)
  {
    ulRC = dspFreeSegment( hsegDATAMODE1 );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if (hsegDATAMODE2)
  {
    ulRC = dspFreeSegment( hsegDATAMODE2 );
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeVDPSegments exit\n");  }


  return 0;
}






ULONG mwmPumpsLoadV34Segments(PMWM_DSPINFO pmwmDspInfo, USHORT usSegmentFlag)
{
  ULONG ulRC;
  USHORT ausSegAddress[22];
  ULONG ulAddress = 0;
  char  achBuffer[60];
  int   i;

  ULONG aulSegAddress[22];

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadV34Segments entry\n");  }


  /***************************************************************************/
  /* Load the 3 required segments.                                           */
  /***************************************************************************/
  if (!(usSegmentFlag & NO_DATAMODE1)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODE1", OFFSET_DATAMODE1, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */


  if (!(usSegmentFlag & NO_DATAMODE2)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODE2", OFFSET_DATAMODE2, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */

  if (!(usSegmentFlag & NO_DATAMODE3)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODE3", OFFSET_DATAMODE3, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */

  if (GetPrivateProfileInt("DEBUG", "V34FIXUPS", 0, INIFile)) {

    for (i=0; i<22; i++) {
      ausSegAddress[i] = 0;
    } /* endfor */

    /***************************************************************************/
    /* Query the Addresses of each segment inside V.34                         */
    /***************************************************************************/
    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "D_DATA", (PULONG)&AUXSEGADDRESS[0]);   //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "WARPDOFF", (PULONG)&AUXSEGADDRESS[1]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "NODEWARP", (PULONG)&AUXSEGADDRESS[2]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "WARPDON", (PULONG)&AUXSEGADDRESS[3]);  //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "DEWARP", (PULONG)&AUXSEGADDRESS[4]);   //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "TEP_CONV", (PULONG)&AUXSEGADDRESS[5]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "TEP_OFF", (PULONG)&AUXSEGADDRESS[6]);  //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "DECSTAT0", (PULONG)&AUXSEGADDRESS[7]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "IP4GR8", (PULONG)&AUXSEGADDRESS[8]);   //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "IP4GR9", (PULONG)&AUXSEGADDRESS[9]);   //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "IP4GR11", (PULONG)&AUXSEGADDRESS[10]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "IP4GRDEF", (PULONG)&AUXSEGADDRESS[11]);//$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "V34ENC", (PULONG)&AUXSEGADDRESS[12]);  //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "V34ERTN", (PULONG)&AUXSEGADDRESS[13]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "WARP_OFF", (PULONG)&AUXSEGADDRESS[14]);//$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "WARP_ON", (PULONG)&AUXSEGADDRESS[15]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "P4GR8", (PULONG)&AUXSEGADDRESS[16]);   //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "P4GR9", (PULONG)&AUXSEGADDRESS[17]);   //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "P4GR11", (PULONG)&AUXSEGADDRESS[18]);  //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE3)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "P4GRDEF", (PULONG)&AUXSEGADDRESS[19]); //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE2)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "VFINDS", (PULONG)&AUXSEGADDRESS[20]);  //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    if (!(usSegmentFlag & NO_DATAMODE1)) {
      ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "V4D16S", (PULONG)&AUXSEGADDRESS[21]);  //$1
      if (ulRC!=DSP_NOERROR)
      {
        mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                       MWM_DSP_ERROR, ulRC);
        return(ulRC);
      }
    } /* endif */

    for (i=0; i<22; i++)
      ausSegAddress[i] = (SHORT)aulSegAddress[i];


    ulRC = dspLabelToAddress(pmwmDspInfo->hmtV34, "DATAMODE_CODE_PTRS", &ulAddress);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }


    ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                          ausSegAddress, 22,
                          DSP_MEMXFER_DATA_WRITE);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */

  if (hMWQueryClient)
  {
    GetPrivateProfileString("MWQUERY","V34DATAMODE", "0",
                             achBuffer,
                             60,
                             INIFile);
    if (strlen(achBuffer))
    {
      /*******************************************************************/
      /* Request mwquery to execute script command                       */
      /*******************************************************************/
    }
  }

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadV34Segments exit\n");  }


  return 0;
}

ULONG mwmPumpsLoadV34DataSegments(PMWM_DSPINFO pmwmDspInfo, USHORT usSegmentFlag)
{
  ULONG ulRC;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadV34DataSegments entry\n");  }


  if (!(usSegmentFlag & NO_DATAMODEDATA1)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODEDATA1", OFFSET_DATAMODEDATA1, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */

  if (!(usSegmentFlag & NO_DATAMODEDATA2)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODEDATA2", OFFSET_DATAMODEDATA2, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */

  if (!(usSegmentFlag & NO_DATAMODEDATA3)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODEDATA3", OFFSET_DATAMODEDATA3, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */

  if (!(usSegmentFlag & NO_V34CONSTEL)) {
    ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "V34CONSTEL", OFFSET_V34CONSTEL, szThisFile , __LINE__, MWM_MUSTHAVE);
    if (ulRC)
      return (ulRC);
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadV34DataSegments exit\n");  }


  return 0;
}



ULONG mwmPumpsLoadVDPSegments(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;
  HSEG  hsegDATAMODE1 = 0;
  HSEG  hsegDATAMODE2 = 0;
  USHORT ausSegAddress[16];
  ULONG ulAddress = 0;
  ULONG aulSegAddress[16];
  int   i;



	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadVDPSegments entry\n");  }


  /***************************************************************************/
  /* Load the 2 required segments.                                           */
  /***************************************************************************/
  ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                             "DATAPUMP1",
                             "DATAMODE1",
                             "DATAMODE1",
                             pmwmDspInfo->hvdpTask,
                             &hsegDATAMODE1,
                             ulAddress,
                             szThisFile , __LINE__, MWM_MUSTHAVE );
  if (ulRC)
    return (ulRC);



  ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                             "DATAPUMP1",
                             "DATAMODE2",
                             "DATAMODE2",
                             pmwmDspInfo->hvdpTask,
                             &hsegDATAMODE2,
                             ulAddress,
                             szThisFile , __LINE__, MWM_MUSTHAVE );
  if (ulRC)
    return (ulRC);


  /***************************************************************************/
  /* Query the Addresses of each segment inside V.32bis                      */
  /***************************************************************************/
  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "FDX_UPD", (PULONG)&AUXSEGADDRESS[0]);   //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "D_DATA", (PULONG)&AUXSEGADDRESS[1]);    //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "I_D96TCM", (PULONG)&AUXSEGADDRESS[2]);  //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "SSDEC", (PULONG)&AUXSEGADDRESS[3]);     //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "INTERPA", (PULONG)&AUXSEGADDRESS[4]);   //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "COSSIN", (PULONG)&AUXSEGADDRESS[5]);    //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "CLOGLIN", (PULONG)&AUXSEGADDRESS[6]);   //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "D_72TCM", (PULONG)&AUXSEGADDRESS[7]);   //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "D_96TCM", (PULONG)&AUXSEGADDRESS[8]);   //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "D_120TCM", (PULONG)&AUXSEGADDRESS[9]);  //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "D_144TCM", (PULONG)&AUXSEGADDRESS[10]); //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "DESCR", (PULONG)&AUXSEGADDRESS[11]);    //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "DIFF_ENC", (PULONG)&AUXSEGADDRESS[12]); //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "UFECPHI", (PULONG)&AUXSEGADDRESS[13]);  //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "EFECPHI", (PULONG)&AUXSEGADDRESS[14]);  //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "S_DATA", (PULONG)&AUXSEGADDRESS[15]);   //$1
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  ulRC = dspLabelToAddress(pmwmDspInfo->hvdpTask, "DATAMODE_CODE_PTRS", &ulAddress);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  for( i = 0; i < 16; i++)
    ausSegAddress[i] = (USHORT)aulSegAddress[i];

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP, ulAddress,
                        ausSegAddress, 16,
                        DSP_MEMXFER_DATA_WRITE);
  if (ulRC!=DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadVDPSegments exit\n");  }


  return 0;
}










/*****************************************************************************/
/* This routine makes the connections required by the Datapump(s) when       */
/* Initially loaded.                                                         */
/* This routine must be called AFTER the conditional loading of V.42bis, V.42*/
/* MNP, and MNP5.                                                            */
/*****************************************************************************/
ULONG mwmPumpsMakeV22Connections(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;
  USHORT usFCLASS = 1;
  USHORT usSubMode = 0;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsMakeV22Connections entry\n");  }


  ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"MCDPITCB",pmwmDspInfo->hmctlTask,"MCDP_V22");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"VDETECT",pmwmDspInfo->hv22Task,"VDETECT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V80)               //$2
  {
    ulRC = mwmFaxGetFCLASS(pmwmDspInfo, &usFCLASS, &usSubMode);
    if (ulRC!=DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */

  if (!(usFCLASS == 0 && usSubMode == 1))                         //$2 if not v.80 mode
  {
//    DPF("  Connect new ASYNC itcbs!!!\n");
    ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPITCB",pmwmDspInfo->hasyTask,"DPITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(ulRC);
    }
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPV8ITCB",
                      pmwmDspInfo->hmctlTask,"DPV8ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_V34 )
  {
    ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPV8ITCB",
                        pmwmDspInfo->hmtV34,"DPV8ITCBS");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }

  if ( pmwmDspInfo->ulFeaturesToLoad & FEATURE_AUTOMODE )
  {
    ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPV8ITCB",
                        pmwmDspInfo->hvdpTask,"DPV8ITCBS");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  }




  /***************************************************************************/
  /* Connect GPC's                                                           */
  /***************************************************************************/

  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hv22Task,"SIGIN",0,NULL,
                          pmwmDspInfo,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);


  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hv22Task,"SIGOUT",NULL,"TAIO_INPUT",0,NULL,
                          pmwmDspInfo,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  if (!(usFCLASS == 0 && usSubMode == 1))                         //$2 if not v.80 mode
  {
    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"XMITDATA",
                            pmwmDspInfo->hv22Task,"XMITDATA",0,NULL,
                            pmwmDspInfo,szThisFile,__LINE__);
    if (ulRC)
      return(ulRC);

    ulRC=mwmCntndConnectGPC(pmwmDspInfo->hv22Task,"RCVDATA",
                            pmwmDspInfo->hasyTask,"RCVDATA",0,NULL,
                            pmwmDspInfo,szThisFile,__LINE__);
    if (ulRC)
      return(ulRC);
  }
//  else
//  {
//    DPF("  WARNING:  V80 does not have an XMITDATA itcb.  Itcb not connected to V22.\n");
//    DPF("  WARNING:  V80 does not have an RCVDATA itcb.  Itcb not connected to V22.\n");
//  }



	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsMakeV22Connections exit\n");  }


  return 0;
}









ULONG mwmPumpsMakeVDPConnections(PMWM_DSPINFO pmwmDspInfo, BOOL bStubTask)
{
  ULONG ulRC;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsMakeVDPConnections entry\n");  }


  if (!bStubTask) {
    ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"VDETECT",pmwmDspInfo->hvdpTask,"VDETECT");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"BLKPTR_ITCB",pmwmDspInfo->hvdpTask,"BLKPTR_ITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }

    ulRC=dspConnectITCB(pmwmDspInfo->hmctlTask,"V34ITCB",pmwmDspInfo->hvdpTask,"BERITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */

  ulRC=dspConnectITCB(pmwmDspInfo->hvdpTask,"MCDPITCB",pmwmDspInfo->hmctlTask,"MCDP_V32");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /*****************************************************************************/
  /* Attempt to connect to DPV8ITCB.  V.22 may have already connected this     */
  /* ITCB                                                                      */
  /*****************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPV8ITCB",
                      pmwmDspInfo->hvdpTask,"DPV8ITCBS");
  if ((ulRC != DSP_NOERROR) && (ulRC != DSP_ITCB_CONNECTED ) )
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  if (!bStubTask) {
    ulRC=dspConnectITCB(NULL,"TAIOITCB",pmwmDspInfo->hvdpTask,"TAIOITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR,
                     ulRC);
      return(FALSE);
    }
  } /* endif */

  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hvdpTask,"SIGIN",0,NULL,
                          pmwmDspInfo,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

//  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hvdpTask,"ADBUF",0,NULL,
//                          pmwmDspInfo,__FILE__,__LINE__);
//  if (ulRC)
//    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hvdpTask,"SIGOUT",NULL,"TAIO_INPUT",0,NULL,
                          pmwmDspInfo,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsMakeVDPConnections exit\n");  }


  return 0;
}



ULONG mwmPumpsMakeV34Connections(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsMakeV34Connections entry\n");  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"VDETECT",pmwmDspInfo->hmtV34,"VDETECT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"BLKPTR_ITCB",pmwmDspInfo->hmtV34,"BLKPTR_ITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(pmwmDspInfo->hmctlTask,"V34ITCB",pmwmDspInfo->hmtV34,"BERITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtV34,"MCDPITCB",pmwmDspInfo->hmctlTask,"MCDP_V34");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  /***************************************************************
  ** Only make this connection if the new V.34 with Enhanced Mode
  ** support is present.
  ****************************************************************/
  if (pmwmDspInfo->ulDSPAddrV34EMCtrl) {
    ulRC=dspConnectITCB(pmwmDspInfo->hmtProtSupr,"V42CTL",pmwmDspInfo->hmtV34,"V42ITCB");
    if (ulRC != DSP_NOERROR)
    {
      mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                     MWM_DSP_ERROR, ulRC);
      return(ulRC);
    }
  } /* endif */

  /***************************************************************************/
  /* Attempt to connect to DPV8ITCB.  V.22 may have already connected this   */
  /* ITCB                                                                    */
  /***************************************************************************/
  ulRC=dspConnectITCB(pmwmDspInfo->hv22Task,"DPV8ITCB",
                      pmwmDspInfo->hmtV34,"DPV8ITCBS");
  if ((ulRC != DSP_NOERROR) && (ulRC != DSP_ITCB_CONNECTED ) )
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC=dspConnectITCB(NULL,"TAIOITCB",pmwmDspInfo->hmtV34,"TAIOITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(FALSE);
  }


  ulRC=mwmCntndConnectGPC(NULL,"TAIO_OUTPUT",pmwmDspInfo->hmtV34,"SIGIN",0,NULL,
                          pmwmDspInfo,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hmtV34,"SIGOUT",NULL,"TAIO_INPUT",0,NULL,
                          pmwmDspInfo,szThisFile,__LINE__);
  if (ulRC)
    return(ulRC);


	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsMakeV34Connections exit\n");  }


  return 0;
}




ULONG MWM_ENTRY mwmPumpsV34IPC(PMWM_DSPINFO pmwmDspInfo, ULONG ulParm1, ULONG ulParm2 )
{
  ULONG  ulRC = 0;
  USHORT usValue;
  ULONG  ulAddress;
  USHORT usV34EMConnection = 0;
  ULONG  ulCurrentCPF = 0;
  ULONG  ulMaxCPF = 0;
  ULONG  ulDeltaCPF = 0;
  ULONG  ulDesiredCPF = 0;
  LONG   lCPFDelta = 0;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsV34IPC entry\n");  }


  ulParm1 = ulParm1;
  ulParm2 = ulParm2;

  /***************************************************************************/
  /* Execute the command.                                                    */
  /***************************************************************************/
  switch(ulParm1)
  {

    /**********************************************************************
    ** IPC 80: CMD_TRAIN
    ***********************************************************************/
    case 80:

      /***************************************************
      ** Free PHASE2SUB
      ****************************************************/
      ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "PHASE2SUB", OFFSET_PHASE2SUB,
                                     szThisFile, __LINE__ );
      if (ulRC) {
        return(ulRC);
      } /* endif */

      /***************************************************
      ** If DYNASEGM=1, load up the needed segments now
      ***************************************************/
      if (pmwmDspInfo->usDynaSegmValue != 2) {

        /***************************************************
        ** Load DATAMODEDATA1,2,3 and V34CONSTEL
        ****************************************************/
        ulRC = mwmPumpsLoadV34DataSegments(pmwmDspInfo, ALL_DATA_SEGMENTS);
        if (ulRC)
          return (ulRC);

      } /* endif */

      /***************************************************
      ** Load DATAMODEINIT
      ****************************************************/
      ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "DATAMODEINIT", OFFSET_DATAMODEINIT, szThisFile , __LINE__, MWM_MUSTHAVE);
      if (ulRC) {
        return(ulRC);
      } /* endif */

      /**************************************************************
      ** Determine if a PCM connection has been established by
      ** reading PCMRESP from V.34PCMC if PCM is enabled.
      ***************************************************************/
      if (pmwmDspInfo->ulDSPAddrV34EMCtrl) {

        if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {

          ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                                 pmwmDspInfo->ulDSPAddrV34EMCtrl+6,
                                 &pmwmDspInfo->usPCMConnection, 1,
                                 DSP_MEMXFER_DATA_READ);

          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC);
            return(ulRC);
          } else {

            pmwmDspInfo->bPCMResponseReceived = TRUE;

            if (pmwmDspInfo->usPCMConnection) {
              DPF("PCM Connection detected. PCMRESP = %xh", pmwmDspInfo->usPCMConnection);
            } /* endif */
          } /* endif */
        } /* endif */

        /*************************************************************
        ** PCM Connection not established. This was the default
        ** value set at the start of the call.
        **************************************************************/
        if (pmwmDspInfo->usPCMConnection == 0) {

          /***************************************************
          ** Read V34EMRESP
          ****************************************************/
          ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                                 pmwmDspInfo->ulDSPAddrV34EMCtrl+2,
                                 &usV34EMConnection, 1,
                                 DSP_MEMXFER_DATA_READ);

          if (ulRC == DSP_NOERROR) {
            pmwmDspInfo->bV34EMResponseReceived = TRUE;

            if (usV34EMConnection) {
              pmwmDspInfo->bV34EMConnectionEstablished = TRUE;
              DPF("V34EM Connection detected.");
            } else {
              DPF("V34EM Connection not detected.");
            } /* endif */
          } /* endif */
        } /* endif */

        /*************************************************************
        ** Adjust the cycles for the connection:
        **   - Get the current CPF of the task
        **   - Get the MAX CPF of the task
        **   - Get the Delta CPF for either the PCM mode or
        **     Enhanced mode
        **   - Calculate the delta between the current and the desired
        ** - If non-zero, make the call to adjust the cycles
        **************************************************************/
        if (pmwmDspInfo->usPCMConnection || usV34EMConnection) {

          /* Get the current CPF value */
          ulRC = mwmSpcfcGetTaskCPF( pmwmDspInfo,
                                     pmwmDspInfo->hmtV34,
                                     &ulCurrentCPF,
                                     szThisFile,__LINE__);
          if (ulRC)
            return ulRC;

          /* Get the Max CPF value used by the task */
          if (!pmwmDspInfo->us17MIPS) {
            ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                      "MAXCPF",
                                      &ulAddress);
          } else {
            ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                      "MAXCPF17",
                                      &ulAddress);
          } /* endif */

          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC );
            return ulRC;
          } /* endif */

          ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                                 ulAddress,
                                 &ulMaxCPF, 1,
                                 DSP_MEMXFER_DATA_READ);

          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC );
            return ulRC;
          } /* endif */

          /* Get the Delta CPF needed for Enhanced Mode */
          if (pmwmDspInfo->usPCMConnection) {
            ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                      "DELTACPFX2",
                                      &ulAddress);
          } else {
            ulRC = dspLabelToAddress( pmwmDspInfo->hmtV34,
                                      "DELTACPFEM",
                                      &ulAddress);
          } /* endif */

          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC );
            return ulRC;
          }

          ulRC = dspMemTransfer( pmwmDspInfo->hDSP,
                                 ulAddress,
                                 &ulDeltaCPF, 1,
                                 DSP_MEMXFER_DATA_READ);

          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC );
            return ulRC;
          } /* endif */

          /* Calculate the desired number of CPF */
          ulDesiredCPF = ulMaxCPF + ulDeltaCPF;

          /* Calculate the change needed to the current CPF count */
          lCPFDelta = (LONG) (((LONG)ulDesiredCPF) - ((LONG)ulCurrentCPF));

          /* If an adjustment is needed, change the CPF count */
          if (lCPFDelta != 0) {
            ulRC=mwmCntndChangeCPF( pmwmDspInfo,
                                    pmwmDspInfo->hmtV34,
                                    lCPFDelta, MWM_MUSTHAVE); /* MTS RADD */

            if (ulRC != DSP_NOERROR) {
              mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                             MWM_DSP_ERROR, ulRC );
              return ulRC;
            } /* endif */
          } /* endif */
        } /* endif */
      } /* endif */

      /************************************************************
      ** Modem control needs to know if we have a PCM connection
      ** or not. Write the value given to us from the pump into
      ** modem control.
      *************************************************************/
      ulRC = mwmSpcfcAccessDSPData( pmwmDspInfo->hDSP, pmwmDspInfo->hmctlTask,
                                    "PCMFLAG", DSP_MEMXFER_DATA_WRITE, 1,
                                    &pmwmDspInfo->usPCMConnection,
                                    szThisFile, __LINE__);
      if (ulRC) {
        return(ulRC);
      } /* endif */

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
      {
        (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"ipc80.snp");
      }

    break;

    /**********************************************************************
    ** IPC 81: CMD_LINEPROBING
    ***********************************************************************/
    case 81:

      /***************************************************
      ** Free DATAMODEINIT
      ****************************************************/
      ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODEINIT",
                                     OFFSET_DATAMODEINIT, szThisFile, __LINE__ );
      if (ulRC) {
        return(ulRC);
      } /* endif */

      /*************************************************************
      ** PCM Connection not established
      **************************************************************/
      if (pmwmDspInfo->usPCMConnection == 0) {

        /***************************************************
        ** Free DATAMODEDATA1,2,3 and V34CONSTEL
        ****************************************************/
        ulRC = mwmPumpsFreeV34DataSegments(pmwmDspInfo);
        if (ulRC)
          return(ulRC);

      /*************************************************************
      ** x2/V.90 Connection established
      **************************************************************/
      } else if (pmwmDspInfo->usPCMConnection) {

//        /***************************************************
//        ** Free X2DMDATA1
//        ****************************************************/
//        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMDATA1", OFFSET_X2DMDATA1,
//                                       szThisFile, __LINE__ );
//        if (ulRC) {
//          return(ulRC);
//        } /* endif */
//
//        /***************************************************
//        ** Free V34CONSTEL
//        ****************************************************/
//        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "V34CONSTEL", OFFSET_V34CONSTEL,
//                                       szThisFile, __LINE__ );
//        if (ulRC) {
//          return(ulRC);
//        } /* endif */
//
//        /***************************************************
//        ** Load X2DMDATA2
//        ****************************************************/
//        ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "X2DMDATA2", OFFSET_X2DMDATA2, szThisFile , __LINE__);
//        if (ulRC) {
//          return (ulRC);
//        } /* endif */
//
//        /***************************************************
//        ** Load DATAMODEDATA2,3
//        ****************************************************/
//        ulRC = mwmPumpsLoadV34DataSegments(pmwmDspInfo, NO_DATAMODEDATA1 | NO_V34CONSTEL);
//        if (ulRC)
//          return (ulRC);
//
      } /* endif */


      /***************************************************
      ** Load PHASE2SUB
      ****************************************************/
      ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "PHASE2SUB", OFFSET_PHASE2SUB, szThisFile , __LINE__, MWM_MUSTHAVE);
      if (ulRC) {
        return (ulRC);
      } /* endif */

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
      {
        (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"ipc81.snp");
      }

    break;

    /**********************************************************************
    ** IPC 82: CMD_RETRAIN
    ***********************************************************************/
    case 82:

      /*************************************************************
      ** PCM Connection not established
      **************************************************************/
      if (pmwmDspInfo->usPCMConnection == 0) {

        /***************************************************
        ** Free DATAMODE1,2,3
        ****************************************************/
        ulRC = mwmPumpsFreeV34Segments(pmwmDspInfo);
        if (ulRC)
          return ulRC;

        /***************************************************
        ** Free DATAMODEDATA1,2,3 and V34CONSTEL
        ****************************************************/
        ulRC = mwmPumpsFreeV34DataSegments(pmwmDspInfo);
        if (ulRC)
          return ulRC;

      /*************************************************************
      ** x2/V.90 Connection established
      **************************************************************/
      } else if (pmwmDspInfo->usPCMConnection) {

//        /***************************************************
//        ** Free X2DM1
//        ****************************************************/
//        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DM1", OFFSET_X2DM1,
//                                       szThisFile, __LINE__ );
//        if (ulRC) {
//          return(ulRC);
//        } /* endif */

        /***************************************************
        ** Free DATAMODE3
        ****************************************************/
//        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODE1", OFFSET_DATAMODE1,
//                                       szThisFile, __LINE__ );
//        if (ulRC) {
//          return(ulRC);
//        } /* endif */

        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODE3", OFFSET_DATAMODE3,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        /***************************************************
        ** Free X2DMINIT
        ****************************************************/
        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMINIT", OFFSET_X2DMINIT,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        /***************************************************
        ** Free X2DMDATA1
        ****************************************************/
        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMDATA1", OFFSET_X2DMDATA1,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        /***************************************************
        ** Free X2DMDATA2
        ****************************************************/
        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2DMDATA2", OFFSET_X2DMDATA2,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        /***************************************************************
        ** Free DATAMODEDATA1,2,3 and V34CONSTEL
        ****************************************************************/
//        ulRC = mwmPumpsFreeV34DataSegments( pmwmDspInfo );
//        if (ulRC) {
//          return(ulRC);
//        } /* endif */
        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODEDATA2", OFFSET_DATAMODEDATA2,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "DATAMODEDATA3", OFFSET_DATAMODEDATA3,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "V34CONSTEL", OFFSET_V34CONSTEL,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        /***************************************************
        ** If we have not yet reached DATAMODES, then we
        ** will be dropping back to a regular V.34
        ** connection.
        ** Do this for x2 only. V.90 does not retrain back
        ** to V.34.
        ** 11/10/98 - Fallback for V.90 as well.
        ****************************************************/
        if ( pmwmDspInfo->usPCMConnection == 1 ||
             (pmwmDspInfo->usPCMConnection == 4 &&
              GetPrivateProfileInt("OPTIONS", "V90TOV34", 0, INIFile)) ) {

          ulRC = dspMemTransfer(pmwmDspInfo->hDSP, pmwmDspInfo->ulDSPAddrX2Datamodes,
                                &usValue, 1, DSP_MEMXFER_DATA_READ);

          if (ulRC != DSP_NOERROR) {
            mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                           MWM_DSP_ERROR, ulRC);
            return(ulRC);
          } /* endif */

          if (!usValue) {
            ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2PHASE34", OFFSET_X2PHASE34,
                                           szThisFile, __LINE__ );
            if (ulRC)
              return(ulRC);

            ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2PHASE34D", OFFSET_X2PHASE34D,
                                           szThisFile, __LINE__ );
            if (ulRC)
              return(ulRC);

            ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "PHASE34", OFFSET_PHASE34, szThisFile , __LINE__, MWM_MUSTHAVE);
            if (ulRC)
              return (ulRC);
          } /* endif */
        } /* endif */
      } /* endif */

      /***********************************************************************
      ** Load PHASE2, PHASE2DATA1 and PHASE2DATA2
      ** 09/24/97 - We're going to ignore return codes here if any of these
      ** segment loads fail. If any of the loads fail, the pump should
      ** just give up and the line will be dropped.
      ************************************************************************/
      ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "PHASE2DATA2", OFFSET_PHASE2DATA2, szThisFile , __LINE__, MWM_NOTREQD);
      if (ulRC) {
        if (ulRC != DSP_INSUFF_DATA_MEM) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } else {
          DPF("Unable to load PHASE2DATA2 segment.");
        } /*endif */
      } /* endif */

      ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "PHASE2DATA1", OFFSET_PHASE2DATA1, szThisFile , __LINE__, MWM_NOTREQD);
      if (ulRC) {
        if (ulRC != DSP_INSUFF_DATA_MEM) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } else {
          DPF("Unable to load PHASE2DATA1 segment.");
        } /*endif */
      } /* endif */

      ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "PHASE2", OFFSET_PHASE2, szThisFile , __LINE__, MWM_NOTREQD);
      if (ulRC) {
        if (ulRC != DSP_INSUFF_INST_MEM) {
          mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                         MWM_DSP_ERROR, ulRC);
          return(ulRC);
        } else {
          DPF("Unable to load PHASE2 segment.");
        } /*endif */
      } /* endif */

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
      {
        (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"ipc82.snp");
      }

    break;

    /**********************************************************************
    ** IPC 83: CMD_DATAMODES
    ***********************************************************************/
    case 83:

      UniDiagsSaveInfoBits(pmwmDspInfo);

      /***************************************************
      ** Free PHASE2
      ****************************************************/
      ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "PHASE2", OFFSET_PHASE2,
                                     szThisFile, __LINE__ );
      if (ulRC) {
        return(ulRC);
      } /* endif */

      /***************************************************
      ** Free PHASE2DATA1
      ****************************************************/
      ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "PHASE2DATA1", OFFSET_PHASE2DATA1,
                                     szThisFile, __LINE__ );
      if (ulRC) {
        return(ulRC);
      } /* endif */

      /***************************************************
      ** Free PHASE2DATA2
      ****************************************************/
      ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "PHASE2DATA2", OFFSET_PHASE2DATA2,
                                     szThisFile, __LINE__ );
      if (ulRC) {
        return(ulRC);
      } /* endif */

      /*************************************************************
      ** PCM Connection not established
      **************************************************************/
      if (pmwmDspInfo->usPCMConnection == 0) {

        /*********************************************************
        ** PCM Enabled in the INI file
        **********************************************************/
        if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM) {

          /***************************************************
          ** Free X2PHASE34
          ****************************************************/
          ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2PHASE34", OFFSET_X2PHASE34,
                                         szThisFile, __LINE__ );
          if (ulRC) {
            return(ulRC);
          } /* endif */

          /***************************************************
          ** Free X2PHASE34D
          ****************************************************/
          ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "X2PHASE34D", OFFSET_X2PHASE34D,
                                         szThisFile, __LINE__ );
          if (ulRC) {
            return(ulRC);
          } /* endif */
        } /* endif */

        /***************************************************
        ** Load DATAMODEDATA1,2,3 and V34CONSTEL
        ****************************************************/
        ulRC = mwmPumpsLoadV34DataSegments(pmwmDspInfo, ALL_DATA_SEGMENTS);
        if (ulRC)
          return (ulRC);

        /***************************************************
        ** Load DATAMODE1,2,3
        ****************************************************/
        ulRC = mwmPumpsLoadV34Segments(pmwmDspInfo, ALL_CODE_SEGMENTS);
        if (ulRC)
          return ulRC;

      /*************************************************************
      ** X2 Connection established
      **************************************************************/
      } else if (pmwmDspInfo->usPCMConnection) {

        /***************************************************
        ** Free PHASE34
        ****************************************************/
        ulRC = mwmPumpsFreeV34DynaSeg( pmwmDspInfo, "PHASE34", OFFSET_PHASE34,
                                       szThisFile, __LINE__ );
        if (ulRC) {
          return(ulRC);
        } /* endif */

        /***************************************************
        ** Load X2DMDATA1
        ****************************************************/
        ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "X2DMDATA1", OFFSET_X2DMDATA1, szThisFile , __LINE__, MWM_MUSTHAVE);
        if (ulRC)
          return (ulRC);

        /***************************************************
        ** Load X2DMDATA2
        ****************************************************/
        ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "X2DMDATA2", OFFSET_X2DMDATA2, szThisFile , __LINE__, MWM_MUSTHAVE);
        if (ulRC)
          return (ulRC);

        /***************************************************
        ** Load DATAMODEDATA2,3 and V34CONSTEL
        ****************************************************/
        ulRC = mwmPumpsLoadV34DataSegments(pmwmDspInfo, NO_DATAMODEDATA1);
        if (ulRC)
          return (ulRC);

        /***************************************************
        ** Load DATAMODE3
        ****************************************************/
        ulRC = mwmPumpsLoadV34Segments(pmwmDspInfo, NO_DATAMODE1 | NO_DATAMODE2);
        if (ulRC)
          return (ulRC);

        /***************************************************
        ** Load X2DMINIT
        ****************************************************/
        ulRC = mwmPumpsLoadV34DynaSeg(pmwmDspInfo, "X2DMINIT", OFFSET_X2DMINIT, szThisFile , __LINE__, MWM_MUSTHAVE);
        if (ulRC)
          return (ulRC);

//        /***************************************************
//        ** Load X2DM1.
//        ** Note that this code segment must be loaded
//        ** after all of the data segments have been loaded
//        ** as it assumes they're all present when it runs.
//        ****************************************************/
//        ulRC = mwmCntndLoadSegment(pmwmDspInfo,
//                                   pmwmDspInfo->achV34ModuleName,
//                                   "X2DM1",
//                                   "X2DM1",
//                                   pmwmDspInfo->hmtV34,
//                                   &hsegX2DM1,
//                                   pmwmDspInfo->ulDSPAddrV34DYNASEG_TABLE+OFFSET_X2DM1,
//                                   szThisFile , __LINE__ );
//        if (ulRC)
//          return (ulRC);

      } /* endif */

      /***************************************************
      ** If PCM is enabled, then let's load MNP now.
      ****************************************************/
      if (!pmwmDspInfo->bFirstIPC83Received) {
        pmwmDspInfo->bFirstIPC83Received = TRUE;

        if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_PCM &&
            pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNP &&
            !(pmwmDspInfo->ulFeaturesToLoad & FEATURE_MNPPRELOAD) ) {

          ulRC = mwmLoadMNP(pmwmDspInfo, pmwmDspInfo->hmtV34, MWM_NOTREQD);
          if (ulRC)
            return ulRC;

        } /* endif */
      } /* endif */

      if (pmwmDspInfo->ulFeaturesToLoad & FEATURE_GETSIZE)
      {
        (*pfnWriteDSPSnapshot)(pmwmDspInfo->hDSP,"ipc83.snp");
      }
    break;

    default:
      break;
  }

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsV34IPC exit\n");  }


  return 0;
}

ULONG mwmPumpsLoadV34DynaSeg(PMWM_DSPINFO pmwmDspInfo, char *pszSegmentName,
                             ULONG ulDynasegsTableOffset, char *pszFilename,
                             SHORT sLine, USHORT usMustHave)
{

  ULONG  ulRC = 0;
  HSEG   hSegment;
  char   achDebug[128];

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadV34DynaSeg entry\n");  }


  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV34, pszSegmentName, &hSegment);

  if (ulRC == DSP_NAME_NOT_FOUND) {

    ulRC = mwmCntndLoadSegment(pmwmDspInfo,
                               pmwmDspInfo->achV34ModuleName,
                               pszSegmentName,
                               pszSegmentName,
                               pmwmDspInfo->hmtV34,
                               &hSegment,
                               pmwmDspInfo->ulDSPAddrV34DYNASEG_TABLE+ulDynasegsTableOffset,
                               pszFilename, sLine, usMustHave );
    if (ulRC) {
      return (ulRC);
    } /* ndif */

  } else if (ulRC != DSP_NOERROR) {
    mwmHandleErrorWithSubcode(pInstanceInfo, pszFilename, sLine,
                              MWM_DSP_ERROR, ulRC, MWM_SUBCODE_2);
  } else {
    sprintf(achDebug, "Segment already loaded: %s", pszSegmentName);
    DPF(achDebug);
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsLoadV34DynaSeg exit\n");  }


  return(ulRC);

}


ULONG mwmPumpsFreeV34DynaSeg(PMWM_DSPINFO pmwmDspInfo, char *pszSegmentName,
                             ULONG ulDynasegsTableOffset, char *pszFilename,
                             SHORT sLine)
{

  ULONG  ulRC = 0;
  HSEG   hSegment;
  USHORT usValue = 0;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeV34DynaSeg entry\n");  }


  /***************************************************
  ** Free the segment.
  ****************************************************/
  ulRC = dspNameToSegmentHandle(pmwmDspInfo->hmtV34, pszSegmentName, &hSegment);
  if (ulRC != DSP_NOERROR) {
    if (ulRC == DSP_NAME_NOT_FOUND) {
      DPF("Warning: %s segment not found.", pszSegmentName);
      hSegment = 0;
      ulRC = 0;
    } else {
      mwmHandleErrorWithSubcode(pInstanceInfo, pszFilename, sLine,
                                MWM_DSP_ERROR, ulRC, MWM_SUBCODE_1);
      return(ulRC);
    } /* endif */
  } /* endif */

  if (hSegment) {
    ulRC = dspMemTransfer(pmwmDspInfo->hDSP,
                          pmwmDspInfo->ulDSPAddrV34DYNASEG_TABLE+ulDynasegsTableOffset,
                          &usValue, 1, DSP_MEMXFER_DATA_WRITE);

    if (ulRC != DSP_NOERROR) {
      mwmHandleErrorWithSubcode(pInstanceInfo, pszFilename, sLine,
                                MWM_DSP_ERROR, ulRC, MWM_SUBCODE_2);
      return(ulRC);
    } /* endif */

    ulRC = dspFreeSegment( hSegment );
    if (ulRC != DSP_NOERROR) {
      mwmHandleErrorWithSubcode(pInstanceInfo, pszFilename, sLine,
                                MWM_DSP_ERROR, ulRC, MWM_SUBCODE_3);
      return(ulRC);
    } /* endif */
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsFreeV34DynaSeg exit\n");  }


  return(ulRC);

}

ULONG MWM_ENTRY mwmPumpsGetBitrates(PMWM_DSPINFO pmwmDspInfo, USHORT *pusSendRate, USHORT *pusReceiveRate)
{
  ULONG ulRC = 0;

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsGetBitrates entry\n");  }


  ulRC = dspMemTransfer(pmwmDspInfo->hDSP,
                        pmwmDspInfo->ulDSPAddrBitrateX,
                        pusSendRate, 1, DSP_MEMXFER_DATA_READ);

  if (ulRC != DSP_NOERROR) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  } /* endif */

  ulRC = dspMemTransfer(pmwmDspInfo->hDSP,
                        pmwmDspInfo->ulDSPAddrBitrateR,
                        pusReceiveRate, 1, DSP_MEMXFER_DATA_READ);

  if (ulRC != DSP_NOERROR) {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  } /* endif */

	 { MW_SYSLOG_1(TRACE_MWMLW32,"mwmpumps::mwmPumpsGetBitrates exit\n");  }


  return(0);
}

