/*
 *   mwmperc.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmparse.h>
#include <mwmparsi.h>

static char szThisFile[] = "MWMPLUS.C";

USHORT  mwmPlusMSCommand(STATEINFO *psi);

USHORT  mwmPlusA8ECommand(STATEINFO *psi);            //$1
USHORT  mwmPlusA8EQuestionCommand(STATEINFO *psi);    //$1
USHORT  mwmPlusESCommand(STATEINFO *psi);             //$1
USHORT  mwmPlusESQuestionCommand(STATEINFO *psi);     //$1
USHORT  mwmPlusESACommand(STATEINFO *psi);            //$1
USHORT  mwmPlusESAQuestionCommand(STATEINFO *psi);    //$1
USHORT  mwmPlusIBCCommand(STATEINFO *psi);            //$1
USHORT  mwmPlusIBCQuestionCommand(STATEINFO *psi);    //$1
USHORT  mwmPlusITFCommand(STATEINFO *psi);            //$1
USHORT  mwmPlusITFQuestionCommand(STATEINFO *psi);    //$1
USHORT  mwmPlusConvertParmValues(USHORT * Parms,      //$8
                                  char * achString,
                                  USHORT NumParmsSupported,
                                  USHORT Radix);

USHORT mwmPlusCommand(STATEINFO *psi)
{

  USHORT  usParserStatus = 0;
  USHORT  usCommandLength=0;
  USHORT  usParm = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusCommand entry\n");
  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FAA=",strlen("FAA=")))
  {
    /*************************************************************************/
    /* This is a +FAA= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FAA=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FAACommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FBOR=",strlen("FBOR=")))
  {
    /*************************************************************************/
    /* This is a +FBOR= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FBOR=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss2FBORCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FBUF?",strlen("FBUF?")))
  {
    /*************************************************************************/
    /* This is a +FBUF? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FBUF?");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss2FBUFCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FBUG=",strlen("FBUG=")))
  {
    /*************************************************************************/
    /* This is a +FBUG= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FBUG=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FDFFC=", strlen("FDFFC=")))
  {
    /*************************************************************************/
    /* This is a +FDFFC= command....                                         */
    /*************************************************************************/
    usCommandLength = strlen("FDFFC=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FWDFC=", strlen("FWDFC=")))
  {
    /*************************************************************************/
    /* This is a +FWDFC= command....                                         */
    /*************************************************************************/
    usCommandLength = strlen("FWDFC=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FLNFC=", strlen("FLNFC=")))
  {
    /*************************************************************************/
    /* This is a +FLNFC= command....                                         */
    /*************************************************************************/
    usCommandLength = strlen("FLNFC=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FVRFC=", strlen("FVRFC=")))
  {
    /*************************************************************************/
    /* This is a +FVRFC= command....                                         */
    /*************************************************************************/
    usCommandLength = strlen("FVRFC=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FECM=", strlen("FECM=")))
  {
    /*************************************************************************/
    /* This is a +FECM= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FECM=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FTBC=", strlen("FTBC=")))
  {
    /*************************************************************************/
    /* This is a +FTBC= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FTBC=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FRBC=", strlen("FRBC=")))
  {
    /*************************************************************************/
    /* This is a +FRBC= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FRBC=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FBADLIN=", strlen("FBADLIN=")))
  {
    /*************************************************************************/
    /* This is a +FBADLIN= command....                                       */
    /*************************************************************************/
    usCommandLength = strlen("FBADLIN=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm > 255)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex], "FBADMUL=", strlen("FBADMUL=")))
  {
    /*************************************************************************/
    /* This is a +FBADMUL= command....                                       */
    /*************************************************************************/
    usCommandLength = strlen("FBADMUL=");
    psi->usNextATIndex += usCommandLength;

    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    if (usParm > 255)
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FCLASS=",strlen("FCLASS=")))
  {
    /*************************************************************************/
    /* This is a +FCLASS= command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("FCLASS=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmPlusFCLASSCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FCLASS?",strlen("FCLASS?")))
  {
    /*************************************************************************/
    /* This is a +FCLASS? command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("FCLASS?");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmPlusFCLASSQuestionCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FCR=",strlen("FCR=")))
  {
    /*************************************************************************/
    /* This is a +FCR= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FCR=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FCRCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDCC=",strlen("FDCC=")))
  {
    /*************************************************************************/
    /* This is a +FDCC= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FDCC=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDCCCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDCC?",strlen("FDCC?")))
  {
    /*************************************************************************/
    /* This is a +FDCC? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FDCC?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDCCQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDCS?",strlen("FDCS?")))
  {
    /*************************************************************************/
    /* This is a +FDCS? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FDCS?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDCSCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDIS=",strlen("FDIS=")))
  {
    /*************************************************************************/
    /* This is a +FDIS= command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FDIS=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDISCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDIS?",strlen("FDIS?")))
  {
    /*************************************************************************/
    /* This is a +FDIS? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FDIS?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDISQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDR",strlen("FDR")))
  {
    /*************************************************************************/
    /* This is a +FDR command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("FDR");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDRCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDT",strlen("FDT")))
  {
    /*************************************************************************/
    /* This is a +FDT command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("FDT");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDTCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FDVPS",strlen("FDVPS")))
  {
    /*************************************************************************/
    /* This is a +FDVPS command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FDVPS");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FDVPSCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FET=",strlen("FET=")))
  {
    /*************************************************************************/
    /* This is a +FET= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FET=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FETCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FK",strlen("FK")))
  {
    /*************************************************************************/
    /* This is a +FK command....                                             */
    /*************************************************************************/
    usCommandLength = strlen("FK");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FKCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FLID=",strlen("FLID=")))
  {
    /*************************************************************************/
    /* This is a +FLID= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FLID=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FLIDCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FCIG=",strlen("FCIG=")))
  {
    /*************************************************************************/
    /* This is a +FCIG= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FCIG=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FCIGCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FMDL?",strlen("FMDL?")))
  {
    /*************************************************************************/
    /* This is a +FMDL? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FMDL?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus = mwmCmdI4Command(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FMM?",strlen("FMM?")))
  {
    /*************************************************************************/
    /* This is a +FMM? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FMM?");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FMFR?",strlen("FMFR?")))
  {
    /*************************************************************************/
    /* This is a +FMFR? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FMFR?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FMFRCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FMI?",strlen("FMI?")))
  {
    /*************************************************************************/
    /* This is a +FMI? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FMI?");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FREV?",strlen("FREV?")))
  {
    /*************************************************************************/
    /* This is a +FREV? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FREV?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if we are in fax mode.                        */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
    {
      usParserStatus  = mwmClss2FREVCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FSPL=",strlen("FSPL=")))
  {
    /*************************************************************************/
    /* This is a +FSPL command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FSPL=");
    psi->usNextATIndex += usCommandLength;

    if (psi->ulFeaturesToLoad & FEATURE_CLASS2) {
      usParserStatus  = mwmClss2FSPLCommand(psi);
    } else {
      usParserStatus = MWM_ATCMD_ERROR;
    } /* endif */
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FLPL=",strlen("FLPL=")))
  {
    /*************************************************************************/
    /* This is a +FLPL command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FLPL=");
    psi->usNextATIndex += usCommandLength;

    if (psi->ulFeaturesToLoad & FEATURE_CLASS2) {
      usParserStatus  = mwmClss2FLPLCommand(psi);
    } else {
      usParserStatus = MWM_ATCMD_ERROR;
    } /* endif */
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FPTS=",strlen("FPTS=")))
  {
    /*************************************************************************/
    /* This is a +FPTS command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FPTS=");
    psi->usNextATIndex += usCommandLength;

    if (psi->ulFeaturesToLoad & FEATURE_CLASS2) {
      usParserStatus  = mwmClss2FPTSCommand(psi);
    } else {
      usParserStatus = MWM_ATCMD_ERROR;
    } /* endif */
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FCQ=",strlen("FCQ=")))
  {
    /*************************************************************************/
    /* This is a +FCQ command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("FCQ=");
    psi->usNextATIndex += usCommandLength;

    if (psi->ulFeaturesToLoad & FEATURE_CLASS2) {
      usParserStatus  = mwmClss2FCQCommand(psi);
    } else {
      usParserStatus = MWM_ATCMD_ERROR;
    } /* endif */
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FMINSP=",strlen("FMINSP=")))
  {
    /*************************************************************************/
    /* This is a +FMINSP command....                                         */
    /*************************************************************************/
    usCommandLength = strlen("FMINSP=");
    psi->usNextATIndex += usCommandLength;

    if (psi->ulFeaturesToLoad & FEATURE_CLASS2) {
      usParserStatus  = mwmClss2FMINSPCommand(psi);
    } else {
      usParserStatus = MWM_ATCMD_ERROR;
    } /* endif */
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FAXERR",strlen("FAXERR")))
  {
    /*************************************************************************/
    /* This is a +FAXERR command....                                         */
    /*************************************************************************/
    usCommandLength = strlen("FAXERR");
    psi->usNextATIndex += usCommandLength;

    if (psi->ulFeaturesToLoad & FEATURE_CLASS2) {
      usParserStatus  = mwmClss2FAXERRCommand(psi);
    } else {
      usParserStatus = MWM_ATCMD_ERROR;
    } /* endif */
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FMR?",strlen("FMR?")))
  {
    /*************************************************************************/
    /* This is a +FMR? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FMR?");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FTS=",strlen("FTS=")))
  {
    /*************************************************************************/
    /* 10/14/95 Class 1                                                      */
    /* This is a +FTS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FTS=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss1FTSCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FRS=",strlen("FRS=")))
  {
    /*************************************************************************/
    /* 10/14/95 Class 1                                                      */
    /* This is a +FRS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FRS=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss1FRSCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FTM=",strlen("FTM=")))
  {
    /*************************************************************************/
    /* 10/14/95 Class 1                                                      */
    /* This is a +FTM= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FTM=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss1FTMCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FRM=",strlen("FRM=")))
  {
    /*************************************************************************/
    /* 10/14/95 Class 1                                                      */
    /* This is a +FRM= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FRM=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss1FRMCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FTH=",strlen("FTH=")))
  {
    /*************************************************************************/
    /* 10/14/95 Class 1                                                      */
    /* This is a +FTH= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FTH=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss1FTHCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FRH=",strlen("FRH=")))
  {
    /*************************************************************************/
    /* 10/14/95 Class 1                                                      */
    /* This is a +FRH= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FRH=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmClss1FRHCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FLO=",strlen("FLO=")))
  {
    /*************************************************************************/
    /* This is a +FLO= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FLO=");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FLO?",strlen("FLO?")))
  {
    /*************************************************************************/
    /* This is a +FLO? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FLO?");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FPR=",strlen("FPR=")))
  {
    /*************************************************************************/
    /* This is a +FPR= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("FPR=");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"FPR?",strlen("FPR?")))
  {
    /*************************************************************************/
    /* This is a +FPR? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("FPR?");
    psi->usNextATIndex += usCommandLength;

      usParserStatus = MWM_ATCMD_ERROR;
  }
  else  //$3
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"MS=",strlen("MS=")))
  {
    /*************************************************************************/
    /* This is a +FPR? command....                                          */
    /*************************************************************************/
    usCommandLength = strlen("MS=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmPlusMSCommand(psi);
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"A8E=",strlen("A8E=")))
  {
    /*************************************************************************/
    /* This is a +A8E= command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("A8E=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusA8ECommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"A8E?",strlen("A8E?")))
  {
    /*************************************************************************/
    /* This is a +A8E? command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("A8E?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusA8EQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"ES=",strlen("ES=")))
  {
    /*************************************************************************/
    /* This is a +ES= command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("ES=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusESCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"ES?",strlen("ES?")))
  {
    /*************************************************************************/
    /* This is a +ES? command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("ES?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusESQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"ESA=",strlen("ESA=")))
  {
    /*************************************************************************/
    /* This is a +ESA= command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("ESA=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusESACommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"ESA?",strlen("ESA?")))
  {
    /*************************************************************************/
    /* This is a +ESA? command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("ESA?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusESAQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"IBC=",strlen("IBC=")))
  {
    /*************************************************************************/
    /* This is a +IBC= command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("IBC=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusIBCCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"IBC?",strlen("IBC?")))
  {
    /*************************************************************************/
    /* This is a +IBC? command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("IBC?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusIBCQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"ITF=",strlen("ITF=")))
  {
    /*************************************************************************/
    /* This is a +ITF= command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("ITF=");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusITFCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else //$1
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"ITF?",strlen("ITF?")))
  {
    /*************************************************************************/
    /* This is a +ITF? command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("ITF?");
    psi->usNextATIndex += usCommandLength;
    /*************************************************************************/
    /* Only allow this command if v.80 is enabled.                           */
    /*************************************************************************/
    if (psi->ulFeaturesToLoad & FEATURE_V80)
    {
      usParserStatus  = mwmPlusITFQuestionCommand(psi);
    }
    else
      usParserStatus = MWM_ATCMD_ERROR;
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;


  /***************************************************************************/
  /* If this command was valid (accepted by the parser)                      */
  /***************************************************************************/
  if (!usParserStatus)
  {
    /*************************************************************************/
    /* If we are pointing at whitespace or a semicolon,                      */
    /* move the pointer forward until we are past the whitespace and         */
    /* semicolons.                                                           */
    /*************************************************************************/
    while ((psi->achCommandBuffer[psi->usNextATIndex] == ' ') ||
           (psi->achCommandBuffer[psi->usNextATIndex] == ';'))
      psi->usNextATIndex++;
  }



  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex-= usCommandLength;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;

}

USHORT  mwmPlusFCLASSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
  USHORT usFCLASS = 0;
  USHORT usSUBCLASS = 0;       //$4
  USHORT usSaveSUBCLASS = 0;   //$7
  ULONG  ulRC;
  char   achCapabilities[20] = "0";
  REGISTERS Registers;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusFCLASSCommand entry\n");
  DPF("mwmPlusFCLASSCommand\n");

  ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrFCLASS,
                        &usFCLASS, 1,
                        DSP_MEMXFER_DATA_READ);
  if (ulRC!=DSP_NOERROR)
  {
    mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                      MWM_DSP_ERROR, ulRC );
    return MWM_ATCMD_ERROR;
  }

  if (psi->ulFeaturesToLoad & FEATURE_V80)  //$4
  {
    ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.dspaddrSUBCLASS,
                          &usSUBCLASS, 1,
                          DSP_MEMXFER_DATA_READ);
    if (ulRC!=DSP_NOERROR)
    {
      mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                        MWM_DSP_ERROR, ulRC );
      return MWM_ATCMD_ERROR;
    }
  }

  if ( (psi->usNextPPIndex + PP_FCLASS_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                    &psi->usNextATIndex);

    /*************************************************************************/
    /* If the fax is installed, and the parameter is 0 or 2, send the        */
    /* appropriate PP Command.                                               */
    /*************************************************************************/
//     if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
//     {
      if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
      {
        /********************************************************************/
        /* This is the +FCLASS=? command.  It is handled here because       */
        /* of the similarities to the +FCLASS= command.                     */
        /* The +FCLASS? command will be handled separately in the           */
        /* FCLASSQuestion Routine.                                          */
        /********************************************************************/
        /* First, build the capabilities string...                          */
        /********************************************************************/
        if (psi->ulFeaturesToLoad & FEATURE_CLASS1)
          strcat(achCapabilities,",1");
        if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
          strcat(achCapabilities,",2");

        usParserStatus = mwmParseEchoString(psi,achCapabilities);

        /********************************************************************/
        /* Since this was a question mark, step the AT Command pointer over */
        /* it to position it for the next command.                          */
        /* Also, don't step this forward if the buffer is full...we must be */
        /* able to back up to the beginning of the FCLASS command.          */
        /********************************************************************/
        if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
          psi->usNextATIndex++;
      }
      else
      {
        if (  usParm != usFCLASS || ( (usParm == usFCLASS) && (usSUBCLASS == 1) )  ) //$7 or v.80 mode
        {
          if (usFCLASS == 0 && usSUBCLASS == 1)   //$7 if in v.80 mode
            usSaveSUBCLASS = usSUBCLASS;          //   save the subclass because
                                                  //   it will be reset in
                                                  //   ClassxDiscrimToDiscrim
          /******************************************************************/
          /* 03/08/96                                                       */
          /* Warn MCTL with this PP Cmd that we are about to switch         */
          /* classes.                                                       */
          /* 9, <Old Class>, <New Class>                                    */
          /******************************************************************/
          if (!psi->usLeaveClass2Loaded)
          {
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0x09;
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usFCLASS;
            psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
          }

          switch(usParm)
          {
            case 0:
              /****************************************************************/
              /* Query DEBUG setting...                                       */
              /****************************************************************/
              if (!psi->usLeaveClass2Loaded)
              {
                /**************************************************************/
                /* Only process +FCLASS=0 if DEBUG CLASS2 is turned off.      */
                /* This allows the CLASS 2 DSP code to stay loaded even after */
                /* a phone call.                                              */
                /**************************************************************/
//////             psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2D | psi->usParserMode);
//////             psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
                psi->bVoiceModeEntered = FALSE;
                psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
                psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 36;
              }
              break;
            case 1:
              /****************************************************************/
              /* usParm == 1....only allow this if class 1 is installed       */
              /****************************************************************/
              if (psi->ulFeaturesToLoad & FEATURE_CLASS1)
              {
                psi->bVoiceModeEntered = FALSE;
                psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
                psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 37;
              }
              else
                usParserStatus = MWM_ATCMD_ERROR;

              break;
            case 2:
//////           psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2D | psi->usParserMode);
//////           psi->ausPPcmdBuffer[psi->usNextPPIndex++] = usParm;
              if (psi->ulFeaturesToLoad & FEATURE_CLASS2)
              {
                psi->bVoiceModeEntered = FALSE;
                psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
                psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 38;
              }
              else
                usParserStatus = MWM_ATCMD_ERROR;
              break;
            case 8:
                usParserStatus = MWM_ATCMD_ERROR;
              break;
            case 80:
                usParserStatus = MWM_ATCMD_ERROR;
              break;
            default:
              usParserStatus = MWM_ATCMD_ERROR;
          } /* switch */

          /*****************************************************************
          ** If leaving V.80 mode, reset the ES parameters. If the INI
          ** flag indicates it, then save off the ES values before resetting
          ** them.
          ******************************************************************/
          if (usFCLASS == 0 && usSaveSUBCLASS == 1)    //$7 if we were in V80 mode
          {

            if (psi->usClass0RestoreV80State) {
              DPF("Storing ES and A8E parms");
              mwmParseQueryModemRegisters(&Registers);
              memcpy(psi->ausStoredESRegs, Registers.PlusES, sizeof(USHORT)*PLUS_ES_PARMS_SUPPORTED);
              psi->usV80StateSaved = TRUE;
            } /* endif */

            DPF("Resetting ES parms");
            /******************************************************************
            ** Reset A8E, ES command parameters                             $5
            *******************************************************************/
            mwmv80PESCommand(psi,psi->ModemMemory.aStoredRegs[0].PlusES, TRUE);
//            mwmv80PA8ECommand(psi,psi->ModemMemory.aStoredRegs[0].PlusA8E);
            /******************************************************************
            ** Reset the flag indicating that we are saving the V.80 state
            ** because the reset above cleared the flag.
            *******************************************************************/
            if (psi->usClass0RestoreV80State) {
              psi->usV80StateSaved = TRUE;
            } /* endif */
            usSaveSUBCLASS = 0;

          }

          /*****************************************************************
          ** If we're going into Class 0 and we have some saved ES
          ** parameters, restore those.
          ******************************************************************/
          if (usParm == 0 && psi->usClass0RestoreV80State && psi->usV80StateSaved) {
            DPF("Restoring saved ES parms");
            mwmv80PESCommand(  psi, psi->ausStoredESRegs, FALSE );
          } /* endif */

        }  //if the class has changed....
      } /* else */
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusFCLASSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmPlusFCLASSQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusFCLASSQuestionCommand entry\n");
  /*****************************************************************************/
  /* I cannot be sure which mode the parser will be in at this point.          */
  /* Consider the following AT Command from Modem Mode.                        */
  /*                                                                           */
  /* AT+FCLASS=2+FCLASS?                                                       */
  /*                                                                           */
  /* In this case, I would return the wrong information, because the mode      */
  /* would not change until the PP command buffer is processed.                */
  /* This is why MDMCTL is handling the processing of this command.            */
  /*****************************************************************************/
  if ( (psi->usNextPPIndex + PP_FCLASSQUESTION_CMD_SPACE) < PP_BUFFER_THRESHOLD)
  {
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x2E | psi->usParserMode);
    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 0;    // Offset for FCLASS?
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusFCLASSQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* 04/30/96                                                                  */
/* MTS 6129 Implement V.23                                                   */
/*                                                                           */
/* The +MS Command is used to turn V.23 off and on.                          */
/* I will try to map as much of this command as possible to our current      */
/* setup.  Some parameters, <automode>, and <min_rate> do not map easily     */
/* to our platform.                                                          */
/* I will selectively "ignore" those situations that don't map easily.       */
/*                                                                           */
/* Issuing the +MS Command will update the related registers (S28,S59 etc).  */
/*****************************************************************************/
USHORT  mwmPlusMSCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  char   *achCapabilities = "+MS: (2,3,10,11),(0,1),(300-28800),(300-28800)";

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusMSCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achCapabilities)) < PP_BUFFER_THRESHOLD)
  {
    /***************************************************************************/
    /* 10/11/94                                                                */
    /* Before we try to handle the list of parameters, look to see if the      */
    /* first parm is a '?'.  If so, this command is querying the capabilities  */
    /* rather than setting them...                                             */
    /***************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
    {
      psi->usNextATIndex++;
      usParserStatus = mwmParseEchoString(psi,achCapabilities);
      return usParserStatus;
    }



    /***************************************************************************/
    /* Do the parsing work before we ever write anything to the PP command     */
    /* buffer.                                                                 */
    /***************************************************************************/

    /***************************************************************************/
    /* At this point, the pointer is just past the =                           */
    /* We should be at the beginning of the parameter list.                    */
    /* Copy the rest of the AT command buffer string to a temporary buffer     */
    /***************************************************************************/
    strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);


    /***************************************************************************/
    /***************************************************************************/
    achParm = mwmParseGetNextArgument( achString, &usParmNumber );
    while (achParm != NULL)
    {

//    #ifdef DEBUG
//      if (psi->usDebugWindow)
//        OutputDebugString(achDebugString);
//    #endif


      if (strlen(achParm))
      {

        sscanf(achParm,"%hu",&usParm);


      DPF("Parameter %u = %u\n",usParmNumber,usParm);
        /*********************************************************************/
        /* Check to see if this is a valid parameter.                        */
        /*********************************************************************/
        switch (usParmNumber)
        {
          case 0:
            /*****************************************************************/
            /* Modulation                                                    */
            /*****************************************************************/
            switch (usParm)
            {
              case 3:
                if ( psi->ulInstalledFeatures & FEATURE_V23 ) {
                  if (!(psi->ulFeaturesToLoad & FEATURE_V23))
                  {
                    /* Turn on V.23 */
                    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
                    psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 75;
                  }
                } else {
                  return MWM_ATCMD_ERROR;
                } /* endif */
                break;
              case 2:
              case 10:
              case 11:
                if (psi->ulFeaturesToLoad & FEATURE_V23)
                {
                  /* Turn off V.23 */
                  psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
                  psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 76;
                }
                break;
              default:
                return MWM_ATCMD_ERROR;
            } /* endswitch */
            break;
          case 1:
            /*****************************************************************/
            /* Automode.....check for 0 or 1, then ignore                    */
            /*****************************************************************/
            if (usParm > 1)
              return MWM_ATCMD_ERROR;
            break;
          case 2:
            /*****************************************************************/
            /* Minimum speed...                                              */
            /*****************************************************************/
            switch (usParm)
            {
              case 300:
              case 1200:
              case 2400:
              case 4800:
              case 7200:
              case 9600:
              case 12000:
              case 14400:
              case 16800:
              case 19200:
              case 21600:
              case 24000:
              case 26400:
              case 28800:
              case 31200:
              case 33600:
                break;
              default:
                return MWM_ATCMD_ERROR;
            } /* endswitch */

            break;
          case 3:
            /*****************************************************************/
            /* Maximum speed...                                              */
            /*****************************************************************/
            switch (usParm)
            {
              case 300:
              case 1200:
              case 2400:
              case 4800:
              case 7200:
              case 9600:
              case 12000:
              case 14400:
              case 16800:
              case 19200:
              case 21600:
              case 24000:
              case 26400:
              case 28800:
              case 31200:
              case 33600:
                break;
              default:
                return MWM_ATCMD_ERROR;
            } /* endswitch */
            break;
        }
      }
      /***********************************************************************/
      /* Increment to prepare for the next parameter.                        */
      /***********************************************************************/
      usParmNumber++;
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );
    }

//    psi->usNextATIndex += strlen(achString);
    mwmParseMoveATIndex( psi, achString );
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusMSCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmPlusA8ECommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  char   *achCapabilities = "+A8E: (1,6),(1,5),(61,c1)";
  USHORT PlusA8E[PLUS_A8E_PARMS_SUPPORTED] = {' ',' ',' '}; //$2
  DPF("mwmPlusA8ECommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusA8ECommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achCapabilities)) < PP_BUFFER_THRESHOLD)
  {
    /***************************************************************************/
    /* Before we try to handle the list of parameters, look to see if the      */
    /* first parm is a '?'.  If so, this command is querying the capabilities  */
    /* rather than setting them...                                             */
    /***************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
    {
      psi->usNextATIndex++;
      usParserStatus = mwmParseEchoString(psi,achCapabilities);
      return usParserStatus;
    }

    /***************************************************************************/
    /* Do the parsing work before we ever write anything to the PP command     */
    /* buffer.                                                                 */
    /***************************************************************************/

    /***************************************************************************/
    /* At this point, the pointer is just past the =                           */
    /* We should be at the beginning of the parameter list.                    */
    /* Copy the rest of the AT command buffer string to a temporary buffer     */
    /***************************************************************************/
    strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    while (achParm != NULL)
    {

//    #ifdef DEBUG
//      if (psi->usDebugWindow)
//        OutputDebugString(achDebugString);
//    #endif

      if (strlen(achParm))
      {
        sscanf(achParm,"%hx",&usParm);

        DPF("Parameter %u = %x\n",usParmNumber,usParm);
        /*********************************************************************/
        /* Check to make sure number of parms supported hasn't been exceeded */
        /*********************************************************************/
        if (usParmNumber <= PLUS_A8E_PARMS_SUPPORTED)
        {
           PlusA8E[usParmNumber] = usParm;
        } else {
          return MWM_ATCMD_ERROR;
        }
      }

      /***********************************************************************/
      /* Increment to prepare for the next parameter.                        */
      /***********************************************************************/
      usParmNumber++;
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    }

//    psi->usNextATIndex += strlen(achString);
    mwmParseMoveATIndex( psi, achString );
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

  if (usParserStatus == 0)
     usParserStatus = mwmv80PA8ECommand(psi, PlusA8E);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusA8ECommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusA8EQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  char   achString[20] = "?,?,?";
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusA8EQuestionCommand entry\n");
  DPF("mwmPlusA8EQuestionCommand\n");

  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
    {                                             /* if query fails      */
       DPF("mwmParseQueryModemRegisters ERROR\n");
       usParserStatus = MWM_ATCMD_ERROR;                                  //$8 beg
       return usParserStatus;
    } /* endif */

    mwmPlusConvertParmValues(Registers.PlusA8E,
                              achString,
                              PLUS_A8E_PARMS_SUPPORTED,
                              16);                                        //$8 end

    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusA8EQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusESCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  char   *achCapabilities = "+ES: (0,6),(0),(0,8)";
  USHORT PlusES[PLUS_ES_PARMS_SUPPORTED] = {' ',' ',' '}; //$2
  DPF("mwmPlusESCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusESCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achCapabilities)) < PP_BUFFER_THRESHOLD)
  {
    /***************************************************************************/
    /* Before we try to handle the list of parameters, look to see if the      */
    /* first parm is a '?'.  If so, this command is querying the capabilities  */
    /* rather than setting them...                                             */
    /***************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
    {
      psi->usNextATIndex++;
      usParserStatus = mwmParseEchoString(psi,achCapabilities);
      return usParserStatus;
    }

    /***************************************************************************/
    /* Do the parsing work before we ever write anything to the PP command     */
    /* buffer.                                                                 */
    /***************************************************************************/

    /***************************************************************************/
    /* At this point, the pointer is just past the =                           */
    /* We should be at the beginning of the parameter list.                    */
    /* Copy the rest of the AT command buffer string to a temporary buffer     */
    /***************************************************************************/
    strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    while (achParm != NULL)
    {

//    #ifdef DEBUG
//      if (psi->usDebugWindow)
//        OutputDebugString(achDebugString);
//    #endif

      if (strlen(achParm))
      {
        sscanf(achParm,"%hu",&usParm);

        DPF("Parameter %u = %u\n",usParmNumber,usParm);
        /*********************************************************************/
        /* Check to make sure number of parms supported hasn't been exceeded */
        /*********************************************************************/
        if (usParmNumber <= PLUS_ES_PARMS_SUPPORTED)
        {
           PlusES[usParmNumber] = usParm;
        } else {
          return MWM_ATCMD_ERROR;
        }
      }

      /***********************************************************************/
      /* Increment to prepare for the next parameter.                        */
      /***********************************************************************/
      usParmNumber++;
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    }

//    psi->usNextATIndex += strlen(achString);
    mwmParseMoveATIndex( psi, achString );
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

  if (usParserStatus == 0)
     usParserStatus = mwmv80PESCommand(psi, PlusES, TRUE);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusESCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusESQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  char   achString[20] = "?,?,?";
  DPF("mwmPlusESQuestionCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusESQuestionCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
    {                                             /* if query fails      */
       DPF("mwmParseQueryModemRegisters ERROR\n");
       usParserStatus = MWM_ATCMD_ERROR;                                  //$8 beg
       return usParserStatus;
    } /* endif */

    mwmPlusConvertParmValues(Registers.PlusES,
                              achString,
                              PLUS_ES_PARMS_SUPPORTED,
                              10);                                        //$8 end

    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusESQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusESACommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  char   *achCapabilities = "+ESA: (0-2),(0-1),(0-1),(0-1),(0-2),(0-1)";
  USHORT PlusESA[PLUS_ESA_PARMS_SUPPORTED] = {' ',' ',' ',' ',' ',' '}; //$2
  DPF("mwmPlusESACommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusESACommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achCapabilities)) < PP_BUFFER_THRESHOLD)
  {
    /***************************************************************************/
    /* Before we try to handle the list of parameters, look to see if the      */
    /* first parm is a '?'.  If so, this command is querying the capabilities  */
    /* rather than setting them...                                             */
    /***************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
    {
      psi->usNextATIndex++;
      usParserStatus = mwmParseEchoString(psi,achCapabilities);
      return usParserStatus;
    }

    /***************************************************************************/
    /* Do the parsing work before we ever write anything to the PP command     */
    /* buffer.                                                                 */
    /***************************************************************************/

    /***************************************************************************/
    /* At this point, the pointer is just past the =                           */
    /* We should be at the beginning of the parameter list.                    */
    /* Copy the rest of the AT command buffer string to a temporary buffer     */
    /***************************************************************************/
    strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    while (achParm != NULL)
    {

//    #ifdef DEBUG
//      if (psi->usDebugWindow)
//        OutputDebugString(achDebugString);
//    #endif

      if (strlen(achParm))
      {
        sscanf(achParm,"%hu",&usParm);

        DPF("Parameter %u = %u\n",usParmNumber,usParm);
        /*********************************************************************/
        /* Check to make sure number of parms supported hasn't been exceeded */
        /*********************************************************************/
        if (usParmNumber <= PLUS_ESA_PARMS_SUPPORTED)
        {
           PlusESA[usParmNumber] = usParm;
        } else {
          return MWM_ATCMD_ERROR;
        }
      }

      /***********************************************************************/
      /* Increment to prepare for the next parameter.                        */
      /***********************************************************************/
      usParmNumber++;
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    }

//    psi->usNextATIndex += strlen(achString);
    mwmParseMoveATIndex( psi, achString );
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

  if (usParserStatus == 0)
     usParserStatus = mwmv80PESACommand(psi, PlusESA);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusESACommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusESAQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  char   achString[20] = "?,?,?,?,?,?";
  DPF("mwmPlusESAQuestionCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusESAQuestionCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
    {                                             /* if query fails      */
       DPF("mwmParseQueryModemRegisters ERROR\n");
       usParserStatus = MWM_ATCMD_ERROR;                                  //$8 beg
       return usParserStatus;
    } /* endif */

    mwmPlusConvertParmValues(Registers.PlusESA,
                              achString,
                              PLUS_ESA_PARMS_SUPPORTED,
                              10);                                        //$8 end

    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusESAQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusIBCCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  char   *achCapabilities = "+IBC: (0,2)";
  USHORT PlusIBC[PLUS_IBC_PARMS_SUPPORTED] = {' '}; //$2
  DPF("mwmPlusIBCCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusIBCCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achCapabilities)) < PP_BUFFER_THRESHOLD)
  {
    /***************************************************************************/
    /* Before we try to handle the list of parameters, look to see if the      */
    /* first parm is a '?'.  If so, this command is querying the capabilities  */
    /* rather than setting them...                                             */
    /***************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
    {
      psi->usNextATIndex++;
      usParserStatus = mwmParseEchoString(psi,achCapabilities);
      return usParserStatus;
    }

    /***************************************************************************/
    /* Do the parsing work before we ever write anything to the PP command     */
    /* buffer.                                                                 */
    /***************************************************************************/

    /***************************************************************************/
    /* At this point, the pointer is just past the =                           */
    /* We should be at the beginning of the parameter list.                    */
    /* Copy the rest of the AT command buffer string to a temporary buffer     */
    /***************************************************************************/
    strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    while (achParm != NULL)
    {

//    #ifdef DEBUG
//      if (psi->usDebugWindow)
//        OutputDebugString(achDebugString);
//    #endif

      if (strlen(achParm))
      {
        sscanf(achParm,"%hu",&usParm);

        DPF("Parameter %u = %u\n",usParmNumber,usParm);
        /*********************************************************************/
        /* Check to make sure number of parms supported hasn't been exceeded */
        /*********************************************************************/
        if (usParmNumber <= PLUS_IBC_PARMS_SUPPORTED)
        {
           PlusIBC[usParmNumber] = usParm;
        } else {
          return MWM_ATCMD_ERROR;
        }
      }

      /***********************************************************************/
      /* Increment to prepare for the next parameter.                        */
      /***********************************************************************/
      usParmNumber++;
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    }

//    psi->usNextATIndex += strlen(achString);
    mwmParseMoveATIndex( psi, achString );
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

  if (usParserStatus == 0)
     usParserStatus = mwmv80PIBCCommand(psi, PlusIBC);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusIBCCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusIBCQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  char   achString[20] = "?";
  DPF("mwmPlusIBCQuestionCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusIBCQuestionCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
    {                                             /* if query fails      */
       DPF("mwmParseQueryModemRegisters ERROR\n");
       usParserStatus = MWM_ATCMD_ERROR;                                  //$8 beg
       return usParserStatus;
    } /* endif */

    mwmPlusConvertParmValues(Registers.PlusIBC,
                              achString,
                              PLUS_IBC_PARMS_SUPPORTED,
                              10);                                        //$8 end

    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusIBCQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusITFCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParmNumber = 0;
  USHORT usParm = 0;
  char   achString[AT_CMD_BUFFER_SIZE];
  char   *achParm;
  char   *achCapabilities = "+ITF: (154),(38),(0)";
  USHORT PlusITF[PLUS_ITF_PARMS_SUPPORTED] = {' ',' ',' '}; //$2
  DPF("mwmPlusITFCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusITFCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achCapabilities)) < PP_BUFFER_THRESHOLD)
  {
    /***************************************************************************/
    /* Before we try to handle the list of parameters, look to see if the      */
    /* first parm is a '?'.  If so, this command is querying the capabilities  */
    /* rather than setting them...                                             */
    /***************************************************************************/
    if (psi->achCommandBuffer[psi->usNextATIndex] == '?')
    {
      psi->usNextATIndex++;
      usParserStatus = mwmParseEchoString(psi,achCapabilities);
      return usParserStatus;
    }

    /***************************************************************************/
    /* Do the parsing work before we ever write anything to the PP command     */
    /* buffer.                                                                 */
    /***************************************************************************/

    /***************************************************************************/
    /* At this point, the pointer is just past the =                           */
    /* We should be at the beginning of the parameter list.                    */
    /* Copy the rest of the AT command buffer string to a temporary buffer     */
    /***************************************************************************/
    strcpy(achString,&psi->achCommandBuffer[psi->usNextATIndex]);

    achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    while (achParm != NULL)
    {

//    #ifdef DEBUG
//      if (psi->usDebugWindow)
//        OutputDebugString(achDebugString);
//    #endif

      if (strlen(achParm))
      {
        sscanf(achParm,"%hu",&usParm);

        DPF("Parameter %u = %u\n",usParmNumber,usParm);
        /*********************************************************************/
        /* Check to make sure number of parms supported hasn't been exceeded */
        /*********************************************************************/
        if (usParmNumber <= PLUS_ITF_PARMS_SUPPORTED)
        {
           PlusITF[usParmNumber] = usParm;
        } else {
          return MWM_ATCMD_ERROR;
        }
      }

      /***********************************************************************/
      /* Increment to prepare for the next parameter.                        */
      /***********************************************************************/
      usParmNumber++;
      achParm = mwmParseGetNextArgument( achString, &usParmNumber );

    }

//    psi->usNextATIndex += strlen(achString);
    mwmParseMoveATIndex( psi, achString );
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

  if (usParserStatus == 0)
     usParserStatus = mwmv80PITFCommand(psi, PlusITF);

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusITFCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*****************************************************************************/
/* $1                                                                        */
/*****************************************************************************/
USHORT  mwmPlusITFQuestionCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  REGISTERS Registers;
  char   achString[20] = "?,?,?";
  DPF("mwmPlusITFQuestionCommand\n");
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusITFQuestionCommand entry\n");
  if ( (psi->usNextPPIndex + strlen(achString)) < PP_BUFFER_THRESHOLD)
  {
    if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
    {                                             /* if query fails      */
       DPF("mwmParseQueryModemRegisters ERROR\n");
       usParserStatus = MWM_ATCMD_ERROR;                                  //$8 beg
       return usParserStatus;
    } /* endif */

    mwmPlusConvertParmValues(Registers.PlusITF,
                              achString,
                              PLUS_ITF_PARMS_SUPPORTED,
                              10);                                        //$8 end

    usParserStatus = mwmParseEchoString(psi,achString);
  }
  else
  {
    /*************************************************************************/
    /* There is not enough room left in this PP Command buffer to process    */
    /* this command....                                                      */
    /*************************************************************************/
    usParserStatus = MWM_GET_MORE_BUFFERS;
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmplus::mwmPlusITFQuestionCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/*******************************************************************************/
/* Convert "NumParmsSupported" parm values beginning at address "Parms" from   */
/* integer (base "Radix") to ASCII.  Concatenate the result of each conversion */
/* to the string beginning at address "achString".  Store a "," after each     */
/* result, except for the last one.                                          $8*/
/*******************************************************************************/
USHORT mwmPlusConvertParmValues(USHORT * Parms,
                                 char * achString,
                                 USHORT NumParmsSupported,
                                 USHORT Radix)
{
  USHORT i;
  char   TemString[4];
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusConvertParmValues entry\n");
  * achString = '\0';
  for (i = 0; i < NumParmsSupported; i++)
  {
    /*paulsch
     * itoa( *(Parms + i), TemString, Radix );
     */

    if(Radix == 10)
	  sprintf(TemString, "%hu", *(Parms + i));
    else
	  sprintf(TemString, "%x", *(Parms + i));

    strcat(achString, TemString);
    if (i < NumParmsSupported - 1)
      strcat(achString, ",");
  }
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmplus::mwmPlusConvertParmValues exit ulRC 0\n");
    return 0;
}

