open Tk
;;

let addition () =
  let top = openTk () in
  (* The widgets. They all have "top" as parent widget. *)
  let entry1 = Entry.create top [TextWidth 6; Relief Sunken] in
  let label1 = Label.create top [Text "+"] in
  let entry2 = Entry.create top [TextWidth 6 ; Relief Sunken] in
  let label2 = Label.create top [Text "="] in
  let result_display = Label.create top [] in
  (* References holding values of entry widgets *)
  let n1 = ref 0
  and n2 = ref 0  in
  (* Refresh result *)
  let refresh () =
    Label.configure result_display [Text (string_of_int (!n1 + !n2))]  in
  (* Electric *)
  let get_and_refresh (w, r) =
    fun _ _ ->
      try
       r := int_of_string (Entry.get w);
       refresh ()
      with
      	Failure "int_of_string" ->
          Label.configure result_display [Text "error"] in
  (* Set the callbacks *)
  Entry.configure entry1 [XScrollCommand (get_and_refresh (entry1, n1))];
  Entry.configure entry2 [XScrollCommand (get_and_refresh (entry2, n2))];
  let quit_button =
    Button.create top
      [Text "Quit"; Command closeTk] in
  (* Map the widgets *)
  pack [entry1; label1; entry2; label2; result_display] [Side Side_Left];
  pack [quit_button] [];
  (* Make the window resizable *)
  Wm.minsize_set top 1 1;
  (* Start interaction (event-driven program) *)
  mainLoop ()
;;

if !Sys.interactive then () else Printexc.catch addition ();;
