/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.plugin;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.plaf.*;

import org.jvnet.lafplugin.LafComponentPlugin;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.fonts.FontSet;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.*;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;

import contrib.ch.randelshofer.quaqua.ButtonStateIcon;
import contrib.ch.randelshofer.quaqua.util.Images;

/**
 * Core plugin for additional UI delegates. Contains information on Quaqua and
 * Xoetrope color chooser panels. This class is <b>for internal use only</b>.
 * 
 * @author Kirill Grouchnikov
 */
public class BasePlugin implements LafComponentPlugin {

	/**
	 * Common directory for Quaqua images.
	 */
	protected final static String commonDir = "/contrib/ch/randelshofer/quaqua/images/";

	/**
	 * Color chooser class name from Quaqua.
	 */
	protected final static String quaquaColorChooserClassName = "contrib.ch.randelshofer.quaqua.Quaqua14ColorChooserUI";

	/**
	 * Indication whether the Quaqua color chooser is available. The lite
	 * version strips away the Quaqua color chooser.
	 */
	protected boolean hasQuaquaColorChooser;

	/**
	 * Creates the base plugin.
	 */
	public BasePlugin() {
		try {
			Class.forName(quaquaColorChooserClassName);
			this.hasQuaquaColorChooser = true;
		} catch (ClassNotFoundException cnfe) {
			this.hasQuaquaColorChooser = false;
		}
	}

	/**
	 * From Quaqua
	 */
	protected Icon createButtonStateIcon(final String location, final int states) {
		BufferedImage[] images = Images.split(Toolkit.getDefaultToolkit()
				.getImage(this.getClass().getResource(location)), states, true);

		return new ButtonStateIcon(images);
	}

	/**
	 * From Quaqua
	 */
	protected Object makeImage(String location) {
		return new UIDefaults.ProxyLazyValue(
				"contrib.ch.randelshofer.quaqua.QuaquaIconFactory",
				"createImage", new Object[] { location });
	}

	protected static Object makeButtonStateIcon(String location, int states) {
		return new UIDefaults.ProxyLazyValue(
				"contrib.ch.randelshofer.quaqua.QuaquaIconFactory",
				"createButtonStateIcon", new Object[] { location,
						new Integer(states) });
	}

	protected Object makeBufferedImage(String location) {
		return new UIDefaults.ProxyLazyValue(
				"contrib.ch.randelshofer.quaqua.QuaquaIconFactory",
				"createBufferedImage", new Object[] { location });
	}

	public static Object makeIcon(Class baseClass, String location) {
		return new UIDefaults.ProxyLazyValue(
				"contrib.ch.randelshofer.quaqua.QuaquaIconFactory",
				"createIcon", new Object[] { baseClass, location });
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.lafplugin.LafComponentPlugin#getDefaults(java.lang.Object)
	 */
	public Object[] getDefaults(Object mTheme) {
		ResourceBundle bundle = ResourceBundle
				.getBundle("contrib.ch.randelshofer.quaqua.Labels");
		List labelsList = new LinkedList();
		for (Enumeration i = bundle.getKeys(); i.hasMoreElements();) {
			String key = (String) i.nextElement();
			labelsList.add(key);
			labelsList.add(bundle.getObject(key));
		}
		if (this.hasQuaquaColorChooser) {
			SubstanceTheme theme = (SubstanceTheme) mTheme;
			InsetsUIResource visualMargin = new InsetsUIResource(0, 0, 0, 0);
			ColorScheme colorScheme = theme.getColorScheme();
			Color foregroundColor = new ColorUIResource(colorScheme
					.getForegroundColor());
			Object[] mainDefaults = new Object[] {
					// quaqua
					"Slider.upThumbSmall",
					new UIDefaults.LazyValue() {
						public Object createValue(UIDefaults table) {
							return SubstanceIconFactory
									.getSliderHorizontalIcon(
											SubstanceSizeUtils
													.getSliderIconSize(SubstanceSizeUtils
															.getControlFontSize()) - 2,
											true);
						}
					},

					// quaqua
					"Slider.leftThumbSmall",
					new UIDefaults.LazyValue() {
						public Object createValue(UIDefaults table) {
							return SubstanceIconFactory
									.getSliderVerticalIcon(
											SubstanceSizeUtils
													.getSliderIconSize(SubstanceSizeUtils
															.getControlFontSize()) - 2,
											true);
						}
					},

					// quaqua
					"Component.visualMargin",
					visualMargin,

					// quaqua
					// "ColorChooser.swatchesSwatchSize",
					// new DimensionUIResource(5, 5),
					//
					// // quaqua
					// "ColorChooser.resetMnemonic",
					// new Integer(-1),
					//
					// // class names of default choosers for quaqua
					// "ColorChooser.defaultChoosers",
					// new String[] {
					// "contrib.ch.randelshofer.quaqua.colorchooser.ColorWheelChooser",
					// "contrib.ch.randelshofer.quaqua.colorchooser.ColorSlidersChooser",
					// "contrib.ch.randelshofer.quaqua.colorchooser.ColorPalettesChooser",
					// "contrib.ch.randelshofer.quaqua.colorchooser.SwatchesChooser",
					// "contrib.ch.randelshofer.quaqua.colorchooser.CrayonsChooser",
					// "contrib.ch.randelshofer.quaqua.colorchooser.ColorPicker",
					// "contrib.net.xoetrope.editor.color.ColorWheelPanel" },
					//
					// quaqua
					"ColorChooser.foreground",
					foregroundColor,
					//
					// // quaqua
					// "ColorChooser.swatchesSwatchSize",
					// new DimensionUIResource(5, 5),
					//
					// // quaqua
					// "ColorChooser.resetMnemonic",
					// new Integer(-1),
					//
					// // quaqua
					// "ColorChooser.crayonsImage",
					// new UIDefaults.LazyValue() {
					// public Object createValue(UIDefaults table) {
					// return Toolkit
					// .getDefaultToolkit()
					// .createImage(
					// this
					// .getClass()
					// .getResource(
					// commonDir
					// + "ColorChooser.crayons.png"));
					// }
					// },

					// quaqua
					// "ColorChooser.textSliderGap",
					// new Integer(3),
					//
					// // quaqua
					// "ColorChooser.colorPalettesIcon",
					// makeButtonStateIcon(commonDir
					// + "ColorChooser.colorPalettesIcons.png", 3),
					//
					// // quaqua
					// "ColorChooser.colorSlidersIcon",
					// makeButtonStateIcon(commonDir
					// + "ColorChooser.colorSlidersIcons.png", 3),
					//
					// // quaqua
					// "ColorChooser.colorSwatchesIcon",
					// makeButtonStateIcon(commonDir
					// + "ColorChooser.colorSwatchesIcons.png", 3),
					//
					// // quaqua
					// "ColorChooser.colorWheelIcon",
					// makeButtonStateIcon(commonDir
					// + "ColorChooser.colorWheelIcons.png", 3),
					//
					// // quaqua
					// "ColorChooser.crayonsIcon",
					// makeButtonStateIcon(commonDir
					// + "ColorChooser.crayonsIcons.png", 3),
					//
					// // quaqua
					// "ColorChooser.imagePalettesIcon",
					// makeButtonStateIcon(commonDir
					// + "ColorChooser.imagePalettesIcons.png", 3),
					//
					// // Note: The following colors are used in color lists.
					// // It is important that these colors are neutral (black,
					// // white
					// // or a shade of gray with saturation 0).
					// // If they aren't neutral, human perception of the color
					// // is negatively affected.
					// "ColorChooser.listSelectionBackground",
					// new ColorUIResource(0xd4d4d4),
					//
					// "ColorChooser.listSelectionForeground",
					// new ColorUIResource(0x000000),
					//
					// // Icon of the color picker tool
					// "ColorChooser.colorPickerIcon",
					// makeIcon(this.getClass(), commonDir
					// + "ColorChooser.colorPickerIcon.png"),
					// // Magnifying glass used as the cursor image
					// "ColorChooser.colorPickerMagnifier",
					// this.makeBufferedImage(commonDir
					// + "ColorChooser.colorPickerMagnifier.png"),
					// // Hot spot of the magnifier cursor
					// "ColorChooser.colorPickerHotSpot",
					// new UIDefaults.ProxyLazyValue("java.awt.Point",
					// new Object[] { new Integer(29), new Integer(29) }),
					// // Pick point relative to hot spot
					// "ColorChooser.colorPickerPickOffset",
					// new UIDefaults.ProxyLazyValue("java.awt.Point",
					// new Object[] { new Integer(-13), new Integer(-13) }),
					// // Rectangle used for drawing the mask of the magnifying
					// // glass
					// "ColorChooser.colorPickerGlassRect",
					// new UIDefaults.ProxyLazyValue("java.awt.Rectangle",
					// new Object[] { new Integer(2), new Integer(2),
					// new Integer(29), new Integer(29) }),
					// // Capture rectangle. Width and height must be equal
					// sized
					// // and must be odd.
					// // The position of the capture rectangle is relative to
					// the
					// // hot spot.
					// "ColorChooser.colorPickerCaptureRect",
					// new UIDefaults.ProxyLazyValue("java.awt.Rectangle",
					// new Object[] { new Integer(-15), new Integer(-15),
					// new Integer(5), new Integer(5) }),
					// // Zoomed (magnified) capture image. Width and height
					// must
					// // be a multiple of the capture rectangles size.
					// "ColorChooser.colorPickerZoomRect",
					// new UIDefaults.ProxyLazyValue("java.awt.Rectangle",
					// new Object[] { new Integer(4), new Integer(4),
					// new Integer(25), new Integer(25) }),

					// class names of default choosers
					"ColorChooser.defaultChoosers",
					new String[] {
							"contrib.ch.randelshofer.quaqua.colorchooser.ColorWheelChooser",
							"contrib.ch.randelshofer.quaqua.colorchooser.ColorSlidersChooser",
							"contrib.ch.randelshofer.quaqua.colorchooser.ColorPalettesChooser",
							"contrib.ch.randelshofer.quaqua.colorchooser.SwatchesChooser",
							"contrib.ch.randelshofer.quaqua.colorchooser.CrayonsChooser",
							"contrib.ch.randelshofer.quaqua.colorchooser.Quaqua15ColorPicker",
							"contrib.net.xoetrope.editor.color.ColorWheelPanel" },
					// "ColorChooser.swatchesDefaultRecentColor", ...,
					// "ColorChooser.swatchesRecentSwatchSize", ...,
					"ColorChooser.swatchesSwatchSize",
					new DimensionUIResource(5, 5),
					"ColorChooser.resetMnemonic",
					new Integer(-1),
					"ColorChooser.crayonsImage",
					makeImage(commonDir + "ColorChooser.crayons.png"),
					"ColorChooser.textSliderGap",
					new Integer(0),
					"ColorChooser.colorPalettesIcon",
					makeButtonStateIcon(commonDir
							+ "ColorChooser.colorPalettesIcons.png", 3),
					"ColorChooser.colorSlidersIcon",
					makeButtonStateIcon(commonDir
							+ "ColorChooser.colorSlidersIcons.png", 3),
					"ColorChooser.colorSwatchesIcon",
					makeButtonStateIcon(commonDir
							+ "ColorChooser.colorSwatchesIcons.png", 3),
					"ColorChooser.colorWheelIcon",
					makeButtonStateIcon(commonDir
							+ "ColorChooser.colorWheelIcons.png", 3),
					"ColorChooser.crayonsIcon",
					makeButtonStateIcon(commonDir
							+ "ColorChooser.crayonsIcons.png", 3),
					"ColorChooser.imagePalettesIcon",
					makeButtonStateIcon(commonDir
							+ "ColorChooser.imagePalettesIcons.png", 3),

					// Icon of the color picker tool
					"ColorChooser.colorPickerIcon",
					// makeIcon(getClass(), commonDir
					// + "ColorChooser.colorPickerIcon.png"),
					new IconUIResource(SubstanceImageCreator.getSearchIcon(15,
							SubstanceThemeUtilities.getTheme(null,
									ComponentState.ACTIVE), true)),

					// Magnifying glass used as the cursor image
					"ColorChooser.colorPickerMagnifier",
					makeBufferedImage(commonDir
							+ "ColorChooser.colorPickerMagnifier.png"),
					// Hot spot of the magnifier cursor
					"ColorChooser.colorPickerHotSpot",
					new UIDefaults.ProxyLazyValue("java.awt.Point",
							new Object[] { new Integer(29), new Integer(29) }),
					// Pick point relative to hot spot
					"ColorChooser.colorPickerPickOffset",
					new UIDefaults.ProxyLazyValue("java.awt.Point",
							new Object[] { new Integer(-13), new Integer(-13) }),
					// Rectangle used for drawing the mask of the magnifying
					// glass
					"ColorChooser.colorPickerGlassRect",
					new UIDefaults.ProxyLazyValue("java.awt.Rectangle",
							new Object[] { new Integer(2), new Integer(2),
									new Integer(29), new Integer(29) }),
					// Capture rectangle. Width and height must be equal sized
					// and must be odd.
					// The position of the capture rectangle is relative to the
					// hot spot.
					"ColorChooser.colorPickerCaptureRect",
					new UIDefaults.ProxyLazyValue("java.awt.Rectangle",
							new Object[] { new Integer(-15), new Integer(-15),
									new Integer(5), new Integer(5) }),
					// Zoomed (magnified) capture image. Width and height must
					// be a multiple of the capture rectangles size.
					"ColorChooser.colorPickerZoomRect",
					new UIDefaults.ProxyLazyValue("java.awt.Rectangle",
							new Object[] { new Integer(4), new Integer(4),
									new Integer(25), new Integer(25) }),

			// // Localization support
			// "Labels",
			// ResourceBundleUtil
			// .getBundle("contrib.ch.randelshofer.quaqua.Labels"),

			};

			Object[] colorDefaults = null;
			FontSet substanceFontSet = SubstanceLookAndFeel.getFontPolicy()
					.getFontSet("Substance", null);
			Font controlFont = substanceFontSet.getControlFont();

			Font fontBoldBaseP1 = new FontUIResource(controlFont.deriveFont(
					Font.BOLD, controlFont.getSize() + 1));

			Font fontPlainBaseM2 = new FontUIResource(controlFont
					.deriveFont((float) (controlFont.getSize() - 2)));

			colorDefaults = new Object[] { "ColorChooserUI",
					"org.jvnet.substance.SubstanceColorChooserUI",

					"ColorChooser.font", controlFont,

					"ColorChooser.smallFont", fontPlainBaseM2,

					"ColorChooser.crayonsFont", fontBoldBaseP1 };

			Object[] labelDefaults = new Object[mainDefaults.length
					+ labelsList.size()];
			for (int i = 0; i < mainDefaults.length; i++)
				labelDefaults[i] = mainDefaults[i];
			int start = mainDefaults.length;
			for (int i = 0; i < labelsList.size(); i++)
				labelDefaults[start + i] = labelsList.get(i);
			mainDefaults = labelDefaults;

			if (colorDefaults != null) {
				Object[] defaults = new Object[mainDefaults.length
						+ colorDefaults.length];
				for (int i = 0; i < mainDefaults.length; i++)
					defaults[i] = mainDefaults[i];
				start = mainDefaults.length;
				for (int i = 0; i < colorDefaults.length; i++)
					defaults[start + i] = colorDefaults[i];
				return defaults;
			}
			return mainDefaults;
		} else {
			Object[] defaults = new Object[labelsList.size()];
			for (int i = 0; i < labelsList.size(); i++)
				defaults[i] = labelsList.get(i);
			return defaults;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.lafplugin.LafPlugin#uninitialize()
	 */
	public void uninitialize() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.lafplugin.LafPlugin#initialize()
	 */
	public void initialize() {
		try {
			if (System.getProperty("substancelaf.useDecorations") != null) {
				JFrame.setDefaultLookAndFeelDecorated(true);
				JDialog.setDefaultLookAndFeelDecorated(true);
			}
		} catch (Exception exc) {
			// probably running in unsecure JNLP - ignore
		}
	}
}
