package test;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TestBug291 extends JFrame {
	public TestBug291() {
		super("Test bug 291");
		final DefaultTableModel model = new DefaultTableModel(0, 3);

		this.setLayout(new BorderLayout());
		final JTable table = new JTable(model);
		this.add(new JScrollPane(table), BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		this.add(controls, BorderLayout.SOUTH);

		JButton populate = new JButton("populate");
		populate.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				for (int i = 0; i < 10; i++) {
					model.addRow(new Object[] { "quick" + i, "brown" + i,
							"fox" + i });
				}
			}
		});
		controls.add(populate);
		JButton select = new JButton("select");
		select.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				table.getSelectionModel().setSelectionInterval(3, 5);
			}
		});
		controls.add(select);
		JButton delete = new JButton("delete");
		delete.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				model.removeRow(5);
				model.removeRow(4);
				model.removeRow(3);
			}
		});
		controls.add(delete);
		JButton add = new JButton("add");
		add.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				model.insertRow(3, new Object[] { "new quick", "new brown",
						"new fox" });
			}
		});
		controls.add(add);

		this.setSize(400, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TestBug291().setVisible(true);
			}
		});
	}
}
