package test.contrib;

import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.event.KeyEvent;

import javax.swing.*;

import org.jvnet.substance.SubstanceDefaultLookAndFeel;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class DemoLAFApp {

	private JFrame jFrame = null;

	private JPanel jContentPane = null;

	private JMenuBar jJMenuBar = null;

	private JMenu fileMenu = null;

	private JMenu editMenu = null;

	private JMenu helpMenu = null;

	private JMenuItem exitMenuItem = null;

	private JMenuItem saveMenuItem = null;

	private JMenu themeMenu = null;

	private ButtonGroup buttonGroup = null;
	private JRadioButtonMenuItem defaultRadioButtonMenuItem = null;

	private JRadioButtonMenuItem systemRadioButtonMenuItem = null;

	private JRadioButtonMenuItem substanceBlackRadioButtonMenuItem = null;

	private JRadioButtonMenuItem substanceBlueRadioButtonMenuItem = null;

	/**
	 * This method initializes jFrame
	 * 
	 * @return javax.swing.JFrame
	 */
	private JFrame getJFrame() {
		if (jFrame == null) {
			jFrame = new JFrame();
			jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			jFrame.setJMenuBar(getJJMenuBar());
			jFrame.setSize(300, 200);
			jFrame.setContentPane(getJContentPane());
			jFrame.setTitle("Application");
		}
		return jFrame;
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
		}
		return jContentPane;
	}

	/**
	 * This method initializes jJMenuBar
	 * 
	 * @return javax.swing.JMenuBar
	 */
	private JMenuBar getJJMenuBar() {
		if (jJMenuBar == null) {
			jJMenuBar = new JMenuBar();
			jJMenuBar.add(getFileMenu());
			jJMenuBar.add(getThemeMenu());
		}
		return jJMenuBar;
	}

	/**
	 * This method initializes jMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu();
			fileMenu.setText("File");
			fileMenu.add(getSaveMenuItem());
		}
		return fileMenu;
	}

	/**
	 * This method initializes jMenuItem
	 * 
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getSaveMenuItem() {
		if (saveMenuItem == null) {
			saveMenuItem = new JMenuItem();
			saveMenuItem.setText("Save");
			saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S,
					Event.CTRL_MASK, true));
		}
		return saveMenuItem;
	}

	/**
	 * This method initializes themeMenu
	 * 
	 * @return javax.swing.JMenu
	 */
	private JMenu getThemeMenu() {
		if (themeMenu == null) {
			themeMenu = new JMenu();
			if (buttonGroup == null) {
				buttonGroup = new ButtonGroup();
			}
			themeMenu.setText("Theme");
			themeMenu.add(getDefaultRadioButtonMenuItem());
			themeMenu.add(getSystemRadioButtonMenuItem());
			themeMenu.add(getSubstanceBlackRadioButtonMenuItem());
			themeMenu.add(getSubstanceBlueRadioButtonMenuItem());
			buttonGroup.add(defaultRadioButtonMenuItem);
			buttonGroup.add(systemRadioButtonMenuItem);
			buttonGroup.add(substanceBlackRadioButtonMenuItem);
			buttonGroup.add(substanceBlueRadioButtonMenuItem);

		}
		return themeMenu;
	}

	/**
	 * This method initializes defaultRadioButtonMenuItem
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getDefaultRadioButtonMenuItem() {
		if (defaultRadioButtonMenuItem == null) {
			defaultRadioButtonMenuItem = new JRadioButtonMenuItem();
			defaultRadioButtonMenuItem.setMnemonic(KeyEvent.VK_UNDEFINED);
			defaultRadioButtonMenuItem.setText("Java");
			defaultRadioButtonMenuItem
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							SwingUtilities.invokeLater(new Runnable() {
								public void run() {
									try {
										UIManager
												.setLookAndFeel(UIManager
														.getCrossPlatformLookAndFeelClassName());
										SwingUtilities
												.updateComponentTreeUI(jFrame);
									} catch (Exception e1) {
										e1.printStackTrace();
									}
								}
							});
						}
					});
		}
		return defaultRadioButtonMenuItem;
	}

	/**
	 * This method initializes systemRadioButtonMenuItem
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getSystemRadioButtonMenuItem() {
		if (systemRadioButtonMenuItem == null) {
			systemRadioButtonMenuItem = new JRadioButtonMenuItem();
			systemRadioButtonMenuItem.setText("System");
			systemRadioButtonMenuItem
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							SwingUtilities.invokeLater(new Runnable() {
								public void run() {
									try {
										UIManager
												.setLookAndFeel(UIManager
														.getSystemLookAndFeelClassName());
										SwingUtilities
												.updateComponentTreeUI(jFrame);
									} catch (Exception e1) {
										e1.printStackTrace();
									}
								}
							});
						}
					});
		}
		return systemRadioButtonMenuItem;
	}

	/**
	 * This method initializes substanceBlackRadioButtonMenuItem
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getSubstanceBlackRadioButtonMenuItem() {
		if (substanceBlackRadioButtonMenuItem == null) {
			substanceBlackRadioButtonMenuItem = new JRadioButtonMenuItem();
			substanceBlackRadioButtonMenuItem.setText("SUbstance Black");
			substanceBlackRadioButtonMenuItem
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							SwingUtilities.invokeLater(new Runnable() {
								public void run() {
									try {
										UIManager
												.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
										SwingUtilities
												.updateComponentTreeUI(jFrame);
									} catch (UnsupportedLookAndFeelException e1) {
										e1.printStackTrace();
									}
								}
							});
						}
					});
		}
		return substanceBlackRadioButtonMenuItem;
	}

	/**
	 * This method initializes substanceBlueRadioButtonMenuItem
	 * 
	 * @return javax.swing.JRadioButtonMenuItem
	 */
	private JRadioButtonMenuItem getSubstanceBlueRadioButtonMenuItem() {
		if (substanceBlueRadioButtonMenuItem == null) {
			substanceBlueRadioButtonMenuItem = new JRadioButtonMenuItem();
			substanceBlueRadioButtonMenuItem.setText("Substance Blue");
			substanceBlueRadioButtonMenuItem
					.addActionListener(new java.awt.event.ActionListener() {
						public void actionPerformed(java.awt.event.ActionEvent e) {
							SwingUtilities.invokeLater(new Runnable() {
								public void run() {
									try {
										UIManager
												.setLookAndFeel(new SubstanceDefaultLookAndFeel());
										SwingUtilities
												.updateComponentTreeUI(jFrame);
									} catch (UnsupportedLookAndFeelException e1) {
										e1.printStackTrace();
									}
								}
							});
						}
					});
		}
		return substanceBlueRadioButtonMenuItem;
	}

	/**
	 * Launches this application
	 */
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				DemoLAFApp application = new DemoLAFApp();
				application.getJFrame().setVisible(true);
			}
		});
	}

}
