package test.contrib;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.jvnet.substance.SubstanceLookAndFeel;

/**
 * This class demonstrates a obscure bug in substances 'rollover' handling. To
 * reproduce the bug:
 * 
 * 1 - click the button labeled 'click here' 2 - click the 'ok' button on the
 * modal dialog. 3 - click the button titled 'Now click here to go back and see
 * the bug'
 * 
 * AND NOW THE BUG ...
 * 
 * 4 - The original button labeled 'click here' will remain in a rollover state.
 * 
 * @author lukesleeman Date 22/11/2007
 */
public class SubstanceButtonTest extends JFrame {
	private PanelOne panelOne = new PanelOne();
	private PanelTwo panelTwo = new PanelTwo();

	private JPanel currentPanel;

	public SubstanceButtonTest() {
		setLayout(new BorderLayout());

		displayPanel(panelOne);
		setSize(640, 480);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	private void displayPanel(JPanel toShow) {
		if (currentPanel != null) {
			remove(currentPanel);
		}
		add(BorderLayout.CENTER, toShow);
		currentPanel = toShow;

		validate();
		repaint();
	}

	private class PanelOne extends JPanel {
		public PanelOne() {
			setLayout(new FlowLayout(FlowLayout.LEFT));

			JButton goToPanel = new JButton("Click here");
			final ButtonModel model = goToPanel.getModel();
			model.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					System.out.println("en:" + model.isEnabled() + ", " + "ro:"
							+ model.isRollover() + ", " + "se:"
							+ model.isSelected() + ", " + "pr:"
							+ model.isPressed() + ", " + "ar:"
							+ model.isArmed());
				}
			});
			goToPanel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							// If you comment out the modal dialog you don't get
							// the bug
							JOptionPane
									.showMessageDialog(
											SubstanceButtonTest.this,
											"The button you just pressed will not have "
													+ "ButtonModel.setRollover(false) called on it, and "
													+ "will remain in a rollover state");
							displayPanel(panelTwo);
						}
					});
				}
			});
			add(goToPanel);
		}
	}

	private class PanelTwo extends JPanel {
		public PanelTwo() {
			setLayout(new FlowLayout(FlowLayout.RIGHT));

			JButton goToPanel = new JButton(
					"Now click here to go back and see the bug");
			goToPanel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					displayPanel(panelOne);
				}
			});
			add(goToPanel);
		}
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());

		SubstanceButtonTest app = new SubstanceButtonTest();
		app.setVisible(true);
	}
}
