package test.contrib;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

public class SubstanceComboBoxMain {
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel("org.jvnet.substance.SubstanceLookAndFeel");
		// Display Dialog with Fonts ComboBox in EDT
		SwingUtilities.invokeAndWait(new Runnable() {
			public void run() {
				// Get list of existing fonts
				GraphicsEnvironment env = GraphicsEnvironment
						.getLocalGraphicsEnvironment();
				String[] fonts = env.getAvailableFontFamilyNames();
				_combo = new JComboBox(fonts);
				// Use special renderer to see the real font
				_combo.setRenderer(new DefaultListCellRenderer() {
					@Override
					public Component getListCellRendererComponent(JList list,
							Object value, int index, boolean isSelected,
							boolean cellHasFocus) {
						super.getListCellRendererComponent(list, value, index,
								isSelected, cellHasFocus);
						setFont(SubstanceComboBoxMain.getFont((String) value));
						return this;
					}
				});
				// Listen to font changes to update the real font used by the
				// combo box
				_combo.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						SwingUtilities.invokeLater(new Runnable() {
							public void run() {
								_combo.setFont(getFont((String) _combo
										.getSelectedItem()));
							}
						});
					}
				});

				JDialog dialog = new JDialog((JFrame) null, true);
				dialog.add(_combo);

				_combo.setSelectedItem(fonts[0]);
				// If we remove the following line, then the problem disappears
				_combo.setSelectedItem(fonts[1]);

				dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
				dialog.pack();
				dialog.setVisible(true);
			}
		});
	}

	static private Font getFont(String face) {
		return new Font(face, Font.PLAIN, 14);
	}

	static private JComboBox _combo = null;
}
