package test.contrib;

import java.awt.BorderLayout;
import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.*;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.watermark.SubstanceMagneticFieldWatermark;

public class TreeWithLongNames {
    public TreeWithLongNames() {
	try {
	    UIManager.setLookAndFeel(new SubstanceLookAndFeel());
	    UIManager.put(SubstanceLookAndFeel.ENABLE_NEGATED_THEMES,
		    Boolean.TRUE);
	    SubstanceLookAndFeel.setCurrentTheme(new SubstanceMixTheme(
		    new SubstanceBlendBiTheme(new SubstanceBottleGreenTheme(),
			    new SubstanceLimeGreenTheme(), 0.8),
		    new SubstanceBlendBiTheme(new SubstanceSteelBlueTheme(),
			    new SubstanceAquaTheme(), 0.6)));
	    SubstanceLookAndFeel
		    .setCurrentWatermark(new SubstanceMagneticFieldWatermark());
	    UIManager
		    .put(SubstanceLookAndFeel.WATERMARK_TO_BLEED, Boolean.TRUE);

	    UIManager.setLookAndFeel(new SubstanceLookAndFeel());
	} catch (UnsupportedLookAndFeelException ulafe) {
	    System.out.println("Substance failed to set");
	}
	JFrame.setDefaultLookAndFeelDecorated(true);
	JDialog.setDefaultLookAndFeelDecorated(true);
	System.setProperty("sun.awt.noerasebackground", "true");

	JFrame frame = new JFrame();

	JPanel panel = new JPanel(new BorderLayout());
	File[] files = File.listRoots();
	JTree.DynamicUtilTreeNode root = new JTree.DynamicUtilTreeNode("root",
		files);

	/* Allow each root file to have children. */
	for (Enumeration kids = root.children(); kids.hasMoreElements();) {
	    JTree.DynamicUtilTreeNode node = (JTree.DynamicUtilTreeNode) kids
		    .nextElement();
	    node.setAllowsChildren(true);
	}

	JTree tree = new JTree(root);
	tree.setRootVisible(false);
	tree.setShowsRootHandles(true);
	tree.getSelectionModel().setSelectionMode(
		TreeSelectionModel.SINGLE_TREE_SELECTION);
	final DefaultTreeModel treeModel = (DefaultTreeModel) tree.getModel();

	tree.addTreeExpansionListener(new TreeExpansionListener() {
	    public void treeCollapsed(TreeExpansionEvent event) {
	    }

	    public void treeExpanded(TreeExpansionEvent event) {
		TreePath path = event.getPath();
		JTree.DynamicUtilTreeNode node = (JTree.DynamicUtilTreeNode) path
			.getLastPathComponent();
		if (node.getChildCount() == 0) {
		    File file = (File) node.getUserObject();
		    File[] subs = file.listFiles(new FileFilter() {
			public boolean accept(File file) {
			    return (file.isDirectory() && !file.isHidden()) ? true
				    : false;
			}
		    });
		    if ((subs != null) && (subs.length > 0)) {
			java.util.Arrays.sort(subs);
			JTree.DynamicUtilTreeNode.createChildren(node, subs);
			for (Enumeration kids = node.children(); kids
				.hasMoreElements();) {
			    JTree.DynamicUtilTreeNode subnode = (JTree.DynamicUtilTreeNode) kids
				    .nextElement();
			    File subfile = (File) subnode.getUserObject();
			    if (subfile.isDirectory())
				subnode.setAllowsChildren(true);
			    else
				subnode.setAllowsChildren(false);
			}
			treeModel.reload(node);
		    }
		}
	    }
	});

	panel.add(new JScrollPane(tree), BorderLayout.CENTER);
	frame.add(panel);
	frame.setSize(150, 400);
	frame.setVisible(true);
    }

    public static void main(String args[]) {
	new TreeWithLongNames();
    }
}