package test.contrib.bug282;

// Program initialization. Calls TestWindow.java

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Hashtable;

import javax.swing.*;
import javax.swing.text.*;

public class Test {
	/** Retourne une action par nom,  partir de actionHash */
	public static Action getHashedAction(String name,
			Hashtable<String, Action> table) {
		return table.get(name);
	}

	public static void main(String[] args) {
		boolean substance = false;

		if (args.length > 0 && args[0].startsWith("S"))
			substance = true;

		if (substance) {
			try {
				UIManager
						.setLookAndFeel("org.jvnet.substance.skin.SubstanceCremeCoffeeLookAndFeel");
			} catch (Exception ex) {
				System.out
						.println("org.jvnet.substance.skin.SubstanceCremeCoffeeLookAndFeel not found!");
				System.exit(1);
			}
		} else {
			try {
				UIManager.setLookAndFeel(UIManager
						.getSystemLookAndFeelClassName());
			} catch (Exception ex) {
				System.out.println("System look & fell not found!");
				System.exit(1);
			}
		}

		// create new actions for JTextField
		JTextField tf = new JTextField();
		Hashtable<String, Action> actionHash = new Hashtable<String, Action>();

		Action[] actions = tf.getActions();

		for (int i = 0; i < actions.length; ++i) {
			String name = (String) actions[i].getValue(Action.NAME);
			actionHash.put(name, actions[i]);
		}

		// cut, paste, copy actions
		KeyStroke cut = KeyStroke.getKeyStroke(KeyEvent.VK_DELETE,
				InputEvent.SHIFT_MASK, false);
		KeyStroke paste = KeyStroke.getKeyStroke(KeyEvent.VK_INSERT,
				InputEvent.SHIFT_MASK, false);
		KeyStroke copy = KeyStroke.getKeyStroke(KeyEvent.VK_INSERT,
				InputEvent.CTRL_MASK, false);

		// enter key inserts a '\n' in the JTextField
		Keymap kmaptf2 = JTextComponent.addKeymap("TextFieldScannableMap", tf
				.getKeymap());

		kmaptf2.addActionForKeyStroke(cut, getHashedAction(
				DefaultEditorKit.cutAction, actionHash));
		kmaptf2.addActionForKeyStroke(paste, getHashedAction(
				DefaultEditorKit.pasteAction, actionHash));
		kmaptf2.addActionForKeyStroke(copy, getHashedAction(
				DefaultEditorKit.copyAction, actionHash));

		KeyStroke enter = KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0, false);
		kmaptf2.addActionForKeyStroke(enter, getHashedAction(
				DefaultEditorKit.insertBreakAction, actionHash));

		JDialog.setDefaultLookAndFeelDecorated(true);
		JFrame.setDefaultLookAndFeelDecorated(true);

		new TestWindow();
	}
}