package test.perf;

import java.awt.Graphics;
import java.awt.image.BufferedImage;

import javax.swing.*;

import test.Check;

public class PerformanceSuite {

	public static void main(final String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				String lafName = args[0];
				String simpleLafName = lafName.substring(lafName
						.lastIndexOf('.') + 1);
				int repaints = Integer.valueOf(args[1]);

				String[] tabs = new String[] { "Buttons", "Combo box",
						"Slider", "Table", "List" };

				JFrame.setDefaultLookAndFeelDecorated(true);
				try {
					// for (int i = 0; i < lafs.length; i++) {
					long startLaf = System.nanoTime();
					UIManager.setLookAndFeel(lafName);
					long endLaf = System.nanoTime();
					System.out.println("Switch to " + simpleLafName + " in "
							+ (endLaf - startLaf) / 1000000 + " ms");

					Check check = new Check(false);
					check.setSize(800, 600);
					check.setLocationRelativeTo(null);
					check.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
					check.setVisible(true);

					BufferedImage bi = new BufferedImage(check.getWidth(),
							check.getHeight(), BufferedImage.TYPE_INT_ARGB);
					Graphics g = bi.getGraphics();

					long total = 0;
					for (String tabTitle : tabs) {
						int tabIndex = check.getMainTabbedPane().indexOfTab(
								tabTitle);
						check.getMainTabbedPane().setSelectedIndex(tabIndex);

						for (int j = 0; j < 10; j++) {
							check.paint(g);
						}
						System.out.println("**** Starting '" + tabTitle
								+ "' ****");
						long totalCurr = 0;
						for (int j = 0; j < repaints; j++) {
							long startPaint = System.nanoTime();
							check.paint(g);
							long endPaint = System.nanoTime();
							total += (endPaint - startPaint);
							totalCurr += (endPaint - startPaint);
							// System.out.println("\tPaint in "
							// + (endPaint - startPaint) / 1000000
							// + " ms");
						}
						System.out.println("**** Ending '" + tabTitle + "' in "
								+ (totalCurr / (repaints * 1000000))
								+ " ms ****");
					}
					System.out.println("\tAverage paint under " + simpleLafName
							+ " is "
							+ (total / (tabs.length * repaints * 1000000))
							+ " ms");

					long heapSize = Runtime.getRuntime().totalMemory();
					long heapFreeSize = Runtime.getRuntime().freeMemory();
					int heapSizeKB = (int) (heapSize / 1024);
					int takenHeapSizeKB = (int) ((heapSize - heapFreeSize) / 1024);
					System.out.println(takenHeapSizeKB + " out of "
							+ heapSizeKB);

					System.gc();

					heapSize = Runtime.getRuntime().totalMemory();
					heapFreeSize = Runtime.getRuntime().freeMemory();
					heapSizeKB = (int) (heapSize / 1024);
					takenHeapSizeKB = (int) ((heapSize - heapFreeSize) / 1024);
					System.out.println(takenHeapSizeKB + " out of "
							+ heapSizeKB);
					// }
				} catch (Exception exc) {
					exc.printStackTrace();
				}
				System.exit(0);
			}
		});
	}
}
