=begin
#Error Tracking REST API

#This schema describes the API endpoints for the error tracking feature

The version of the OpenAPI document: 0.0.1

Generated by: https://openapi-generator.tech
OpenAPI Generator version: 6.0.0

=end

require 'cgi'

module ErrorTrackingOpenAPI
  class ErrorsV2Api
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # Stats of events received for the group
    # @param group_id [Integer] ID of the group
    # @param [Hash] opts the optional parameters
    # @return [Array<StatsObject>]
    def get_stats_v2(group_id, opts = {})
      data, _status_code, _headers = get_stats_v2_with_http_info(group_id, opts)
      data
    end

    # Stats of events received for the group
    # @param group_id [Integer] ID of the group
    # @param [Hash] opts the optional parameters
    # @return [Array<(Array<StatsObject>, Integer, Hash)>] Array<StatsObject> data, response status code and response headers
    def get_stats_v2_with_http_info(group_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsV2Api.get_stats_v2 ...'
      end
      # verify the required parameter 'group_id' is set
      if @api_client.config.client_side_validation && group_id.nil?
        fail ArgumentError, "Missing the required parameter 'group_id' when calling ErrorsV2Api.get_stats_v2"
      end
      # resource path
      local_var_path = '/api/0/organizations/{groupId}/stats_v2'.sub('{' + 'groupId' + '}', CGI.escape(group_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<StatsObject>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsV2Api.get_stats_v2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsV2Api#get_stats_v2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List of errors(V2)
    # @param project [Array<Integer>] ID of the project where the error was created
    # @param group_id [Integer] ID of the group
    # @param [Hash] opts the optional parameters
    # @option opts [String] :status  (default to 'unresolved')
    # @option opts [String] :query 
    # @option opts [String] :start Optional start of the stat period in format 2006-01-02T15:04:05
    # @option opts [String] :_end Optional end of the stat period in format 2006-01-02T15:04:05
    # @option opts [String] :environment 
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @option opts [String] :sort Optional sorting column of the entries (default to 'date')
    # @return [Array<ErrorV2>]
    def list_errors_v2(project, group_id, opts = {})
      data, _status_code, _headers = list_errors_v2_with_http_info(project, group_id, opts)
      data
    end

    # List of errors(V2)
    # @param project [Array<Integer>] ID of the project where the error was created
    # @param group_id [Integer] ID of the group
    # @param [Hash] opts the optional parameters
    # @option opts [String] :status  (default to 'unresolved')
    # @option opts [String] :query 
    # @option opts [String] :start Optional start of the stat period in format 2006-01-02T15:04:05
    # @option opts [String] :_end Optional end of the stat period in format 2006-01-02T15:04:05
    # @option opts [String] :environment 
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @option opts [String] :sort Optional sorting column of the entries (default to 'date')
    # @return [Array<(Array<ErrorV2>, Integer, Hash)>] Array<ErrorV2> data, response status code and response headers
    def list_errors_v2_with_http_info(project, group_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsV2Api.list_errors_v2 ...'
      end
      # verify the required parameter 'project' is set
      if @api_client.config.client_side_validation && project.nil?
        fail ArgumentError, "Missing the required parameter 'project' when calling ErrorsV2Api.list_errors_v2"
      end
      # verify the required parameter 'group_id' is set
      if @api_client.config.client_side_validation && group_id.nil?
        fail ArgumentError, "Missing the required parameter 'group_id' when calling ErrorsV2Api.list_errors_v2"
      end
      allowable_values = ["unresolved", "resolved", "ignored"]
      if @api_client.config.client_side_validation && opts[:'status'] && !allowable_values.include?(opts[:'status'])
        fail ArgumentError, "invalid value for \"status\", must be one of #{allowable_values}"
      end
      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] > 10000
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling ErrorsV2Api.list_errors_v2, must be smaller than or equal to 10000.'
      end

      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] < 1
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling ErrorsV2Api.list_errors_v2, must be greater than or equal to 1.'
      end

      allowable_values = ["date", "new", "priority", "freq", "user"]
      if @api_client.config.client_side_validation && opts[:'sort'] && !allowable_values.include?(opts[:'sort'])
        fail ArgumentError, "invalid value for \"sort\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/api/0/organizations/{groupId}/issues/'.sub('{' + 'groupId' + '}', CGI.escape(group_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'project'] = @api_client.build_collection_param(project, :multi)
      query_params[:'status'] = opts[:'status'] if !opts[:'status'].nil?
      query_params[:'query'] = opts[:'query'] if !opts[:'query'].nil?
      query_params[:'start'] = opts[:'start'] if !opts[:'start'].nil?
      query_params[:'end'] = opts[:'_end'] if !opts[:'_end'].nil?
      query_params[:'environment'] = opts[:'environment'] if !opts[:'environment'].nil?
      query_params[:'limit'] = opts[:'limit'] if !opts[:'limit'].nil?
      query_params[:'sort'] = opts[:'sort'] if !opts[:'sort'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<ErrorV2>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsV2Api.list_errors_v2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsV2Api#list_errors_v2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List of projects
    # @param group_id [Integer] ID of the group
    # @param [Hash] opts the optional parameters
    # @return [Array<Project>]
    def list_projects(group_id, opts = {})
      data, _status_code, _headers = list_projects_with_http_info(group_id, opts)
      data
    end

    # List of projects
    # @param group_id [Integer] ID of the group
    # @param [Hash] opts the optional parameters
    # @return [Array<(Array<Project>, Integer, Hash)>] Array<Project> data, response status code and response headers
    def list_projects_with_http_info(group_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsV2Api.list_projects ...'
      end
      # verify the required parameter 'group_id' is set
      if @api_client.config.client_side_validation && group_id.nil?
        fail ArgumentError, "Missing the required parameter 'group_id' when calling ErrorsV2Api.list_projects"
      end
      # resource path
      local_var_path = '/api/0/organizations/{groupId}/projects/'.sub('{' + 'groupId' + '}', CGI.escape(group_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<Project>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsV2Api.list_projects",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsV2Api#list_projects\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
