//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomation_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/automation/armautomation"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteConnection.json
func ExampleConnectionClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewConnectionClient().Delete(ctx, "rg", "myAutomationAccount28", "myConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getConnection.json
func ExampleConnectionClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectionClient().Get(ctx, "rg", "myAutomationAccount28", "myConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Connection = armautomation.Connection{
	// 	Name: to.Ptr("myConnection"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection"),
	// 	Properties: &armautomation.ConnectionProperties{
	// 		Description: to.Ptr("my description goes here"),
	// 		ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
	// 			Name: to.Ptr("Azure"),
	// 		},
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:29.290Z"); return t}()),
	// 		FieldDefinitionValues: map[string]*string{
	// 			"AutomationCertificateName": to.Ptr("myCertificateName"),
	// 			"SubscriptionID": to.Ptr("b5e4748c-f69a-467c-8749-e2f9c8cd3007"),
	// 		},
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:33.617Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/createOrUpdateConnection.json
func ExampleConnectionClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectionClient().CreateOrUpdate(ctx, "rg", "myAutomationAccount28", "mysConnection", armautomation.ConnectionCreateOrUpdateParameters{
		Name: to.Ptr("mysConnection"),
		Properties: &armautomation.ConnectionCreateOrUpdateProperties{
			Description: to.Ptr("my description goes here"),
			ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
				Name: to.Ptr("Azure"),
			},
			FieldDefinitionValues: map[string]*string{
				"AutomationCertificateName": to.Ptr("mysCertificateName"),
				"SubscriptionID":            to.Ptr("subid"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Connection = armautomation.Connection{
	// 	Name: to.Ptr("mysConnection"),
	// 	Properties: &armautomation.ConnectionProperties{
	// 		Description: to.Ptr("my description goes here"),
	// 		ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
	// 			Name: to.Ptr("Azure"),
	// 		},
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:29.290Z"); return t}()),
	// 		FieldDefinitionValues: map[string]*string{
	// 			"AutomationCertificateName": to.Ptr("mysCertificateName"),
	// 			"SubscriptionID": to.Ptr("subid"),
	// 		},
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:29.290Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateConnection.json
func ExampleConnectionClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewConnectionClient().Update(ctx, "rg", "myAutomationAccount28", "myConnection", armautomation.ConnectionUpdateParameters{
		Name: to.Ptr("myConnection"),
		Properties: &armautomation.ConnectionUpdateProperties{
			Description: to.Ptr("my description goes here"),
			FieldDefinitionValues: map[string]*string{
				"AutomationCertificateName": to.Ptr("myCertificateName"),
				"SubscriptionID":            to.Ptr("b5e4748c-f69a-467c-8749-e2f9c8cd3009"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Connection = armautomation.Connection{
	// 	Name: to.Ptr("myConnection"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount29/connections/myConnection"),
	// 	Properties: &armautomation.ConnectionProperties{
	// 		Description: to.Ptr("my description goes here"),
	// 		ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
	// 			Name: to.Ptr("Azure"),
	// 		},
	// 		CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T08:21:29.313Z"); return t}()),
	// 		FieldDefinitionValues: map[string]*string{
	// 			"AutomationCertificateName": to.Ptr("myCertificateName"),
	// 			"SubscriptionID": to.Ptr("b5e4748c-f69a-467c-8749-e2f9c8cd3009"),
	// 		},
	// 		LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T08:21:30.093Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listConnectionsByAutomationAccount_First100.json
func ExampleConnectionClient_NewListByAutomationAccountPager_listConnectionsByAutomationAccountFirst100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConnectionClient().NewListByAutomationAccountPager("rg", "myAutomationAccount28", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectionListResult = armautomation.ConnectionListResult{
		// 	Value: []*armautomation.Connection{
		// 		{
		// 			Name: to.Ptr("myConnection"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:29.290Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:33.617Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection0"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection0"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:36.493Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:36.493Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection1"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection1"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:36.760Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:36.760Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection10"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection10"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.117Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.117Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection100"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection100"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.527Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.527Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection101"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection101"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.777Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.777Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection102"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection102"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.027Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.027Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection103"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection103"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.277Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.277Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection104"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection104"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.527Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.527Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection105"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection105"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.820Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:05.820Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection106"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection106"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.070Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.070Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection107"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection107"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection108"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection108"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.620Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection109"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection109"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:06.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection11"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection11"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.367Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.367Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection110"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection110"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.167Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection111"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection111"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.463Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.463Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection112"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection112"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.730Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.730Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection113"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection113"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.963Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:07.963Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection114"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection114"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:08.213Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:08.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection115"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection115"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:08.527Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:08.527Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection116"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection116"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:08.760Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:08.760Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection117"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection117"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.103Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.103Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection118"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection118"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection119"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection119"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.650Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection12"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection12"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.617Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.617Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection120"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection120"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.883Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:09.883Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection121"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection121"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.167Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection122"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection122"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.430Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection123"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection123"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.680Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.680Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection124"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection124"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.930Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:10.930Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection125"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection125"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.180Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.180Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection126"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection126"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.430Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection127"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection127"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.667Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.667Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection128"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection128"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.917Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:11.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection129"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection129"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.180Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.180Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection13"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection13"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.883Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:39.883Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection130"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection130"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.430Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection131"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection131"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.667Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.667Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection132"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection132"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.917Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:12.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection133"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection133"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:13.213Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:13.213Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection134"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection134"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:13.463Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:13.463Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection135"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection135"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:13.730Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:13.730Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection136"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection136"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.010Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.010Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection137"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection137"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.290Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.290Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection138"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection138"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.540Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.540Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection139"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection139"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.807Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:14.807Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection14"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection14"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.133Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.133Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection140"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection140"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.057Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection141"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection141"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.307Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.307Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection142"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection142"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.603Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.603Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection143"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection143"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.853Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:15.853Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection144"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection144"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.120Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.120Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection145"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection145"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection146"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection146"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.633Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.633Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection147"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection147"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.900Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:16.900Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection148"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection148"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.167Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection149"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection149"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.430Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection15"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection15"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection150"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection150"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.680Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.680Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection151"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection151"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.963Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:17.963Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection152"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection152"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:18.527Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:18.527Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection153"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection153"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:18.790Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:18.790Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection154"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection154"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.073Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.073Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection155"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection155"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.353Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection156"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection156"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.680Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.680Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection157"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection157"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.930Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:19.930Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection158"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection158"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:20.243Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:20.243Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection159"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection159"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:20.557Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:20.557Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection16"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection16"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.620Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection160"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection160"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:20.823Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:20.823Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection161"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection161"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.150Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.150Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection162"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection162"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.417Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.417Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection163"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection163"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.650Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.650Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection164"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection164"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.993Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:21.993Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection165"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection165"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:22.323Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:22.323Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection166"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection166"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:22.680Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:22.680Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection167"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection167"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.057Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection168"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection168"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.417Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.417Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection169"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection169"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.697Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.697Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection17"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection17"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:40.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection170"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection170"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.963Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:23.963Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection171"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection171"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:24.243Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:24.243Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection172"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection172"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:24.510Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:24.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection173"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection173"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:24.777Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:24.777Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection174"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection174"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:25.057Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:25.057Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection175"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection175"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:25.340Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:25.340Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection18"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection18"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:41.197Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:41.197Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection19"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection19"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:41.570Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:41.570Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection2"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection2"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.010Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.010Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection20"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection20"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:41.913Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:41.913Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection21"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection21"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:42.273Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:42.273Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection22"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection22"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:42.663Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:42.663Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection23"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection23"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:42.993Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:42.993Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection24"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection24"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:43.260Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:43.260Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection25"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection25"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:43.587Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:43.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection26"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection26"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:43.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:43.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection27"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection27"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:44.227Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:44.227Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection28"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection28"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:44.557Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:44.557Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection29"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection29"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:44.807Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:44.807Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listConnectionsByAutomationAccount_Next100.json
func ExampleConnectionClient_NewListByAutomationAccountPager_listConnectionsByAutomationAccountNext100() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armautomation.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewConnectionClient().NewListByAutomationAccountPager("rg", "myAutomationAccount28", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectionListResult = armautomation.ConnectionListResult{
		// 	Value: []*armautomation.Connection{
		// 		{
		// 			Name: to.Ptr("myConnection3"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection3"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.290Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.290Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection30"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection30"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.040Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.040Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection31"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection31"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.307Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.307Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection32"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection32"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.557Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.557Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection33"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection33"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.853Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:45.853Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection34"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection34"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.087Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.087Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection35"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection35"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.353Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection36"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection36"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.603Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.603Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection37"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection37"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.853Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:46.853Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection38"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection38"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.103Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.103Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection39"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection39"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.353Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection4"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection4"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.540Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.540Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection40"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection40"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.620Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection41"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection41"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.883Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:47.883Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection42"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection42"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:48.167Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:48.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection43"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection43"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:48.430Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:48.430Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection44"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection44"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:48.820Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:48.820Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection45"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection45"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:49.180Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:49.180Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection46"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection46"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:49.477Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:49.477Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection47"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection47"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:49.773Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:49.773Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection48"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection48"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:50.197Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:50.197Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection49"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection49"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:50.603Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:50.603Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection5"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection5"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.790Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:37.790Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection50"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection50"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:50.837Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:50.837Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection51"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection51"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.087Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.087Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection52"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection52"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.337Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.337Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection53"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection53"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.587Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection54"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection54"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:51.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection55"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection55"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.150Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.150Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection56"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection56"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.400Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.400Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection57"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection57"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.667Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.667Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection58"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection58"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.917Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:52.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection59"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection59"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:53.167Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:53.167Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection6"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection6"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.103Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.103Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection60"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection60"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:53.463Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:53.463Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection61"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection61"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:53.727Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:53.727Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection62"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection62"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.010Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.010Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection63"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection63"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.273Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.273Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection64"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection64"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.523Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.523Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection65"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection65"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.807Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:54.807Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection66"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection66"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.103Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.103Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection67"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection67"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection68"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection68"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.620Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection69"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection69"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.883Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:55.883Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection7"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection7"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.353Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection70"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection70"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.133Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.133Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection71"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection71"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.383Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.383Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection72"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection72"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.633Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.633Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection73"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection73"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:56.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection74"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection74"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.120Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.120Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection75"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection75"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection76"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection76"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.620Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection77"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection77"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:57.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection78"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection78"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.120Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.120Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection79"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection79"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.370Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.370Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection8"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection8"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.587Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection80"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection80"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.633Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.633Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection81"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection81"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.917Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:58.917Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection82"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection82"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:59.180Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:59.180Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection83"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection83"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:59.477Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:59.477Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection84"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection84"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:59.713Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:59.713Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection85"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection85"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.010Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.010Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection86"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection86"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.260Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.260Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection87"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection87"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.620Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.620Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection88"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection88"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.980Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:00.980Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection89"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection89"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:01.353Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:01.353Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection9"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection9"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.867Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:52:38.867Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection90"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection90"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:01.697Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:01.697Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection91"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection91"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:01.963Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:01.963Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection92"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection92"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:02.290Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:02.290Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection93"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection93"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:02.587Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:02.587Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection94"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection94"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:02.870Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:02.870Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection95"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection95"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:03.260Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:03.260Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection96"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection96"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:03.510Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:03.510Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection97"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection97"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:03.760Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:03.760Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection98"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection98"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.027Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.027Z"); return t}()),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myConnection99"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg/providers/Microsoft.Automation/automationAccounts/myAutomationAccount28/connections/myConnection99"),
		// 			Properties: &armautomation.ConnectionProperties{
		// 				ConnectionType: &armautomation.ConnectionTypeAssociationProperty{
		// 					Name: to.Ptr("Azure"),
		// 				},
		// 				CreationTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.260Z"); return t}()),
		// 				LastModifiedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-27T07:53:04.260Z"); return t}()),
		// 			},
		// 	}},
		// }
	}
}
