//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmaintenance

import "time"

// ApplyUpdate - Apply Update request
type ApplyUpdate struct {
	// Properties of the apply update
	Properties *ApplyUpdateProperties

	// READ-ONLY; Fully qualified identifier of the resource
	ID *string

	// READ-ONLY; Name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of the resource
	Type *string
}

// ApplyUpdateProperties - Properties for apply update
type ApplyUpdateProperties struct {
	// Last Update time
	LastUpdateTime *time.Time

	// The resourceId
	ResourceID *string

	// The status
	Status *UpdateStatus
}

// Configuration - Maintenance configuration record type
type Configuration struct {
	// Gets or sets location of the resource
	Location *string

	// Gets or sets properties of the resource
	Properties *ConfigurationProperties

	// Gets or sets tags of the resource
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier of the resource
	ID *string

	// READ-ONLY; Name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of the resource
	Type *string
}

// ConfigurationAssignment - Configuration Assignment
type ConfigurationAssignment struct {
	// Location of the resource
	Location *string

	// Properties of the configuration assignment
	Properties *ConfigurationAssignmentProperties

	// READ-ONLY; Fully qualified identifier of the resource
	ID *string

	// READ-ONLY; Name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of the resource
	Type *string
}

// ConfigurationAssignmentFilterProperties - Azure query for the update configuration.
type ConfigurationAssignmentFilterProperties struct {
	// List of locations to scope the query to.
	Locations []*string

	// List of allowed operating systems.
	OSTypes []*string

	// List of allowed resource groups.
	ResourceGroups []*string

	// List of allowed resources.
	ResourceTypes []*string

	// Tag settings for the VM.
	TagSettings *TagSettingsProperties
}

// ConfigurationAssignmentProperties - Properties for configuration assignment
type ConfigurationAssignmentProperties struct {
	// Properties of the configuration assignment
	Filter *ConfigurationAssignmentFilterProperties

	// The maintenance configuration Id
	MaintenanceConfigurationID *string

	// The unique resourceId
	ResourceID *string
}

// ConfigurationProperties - Properties for maintenance configuration
type ConfigurationProperties struct {
	// Gets or sets extensionProperties of the maintenanceConfiguration
	ExtensionProperties map[string]*string

	// The input parameters to be passed to the patch run operation.
	InstallPatches *InputPatchConfiguration

	// Gets or sets maintenanceScope of the configuration
	MaintenanceScope *MaintenanceScope

	// Definition of a MaintenanceWindow
	MaintenanceWindow *Window

	// Gets or sets namespace of the resource
	Namespace *string

	// Gets or sets the visibility of the configuration. The default value is 'Custom'
	Visibility *Visibility
}

// Error - An error response received from the Azure Maintenance service.
type Error struct {
	// Details of the error
	Error *ErrorDetails
}

// ErrorDetails - An error response details received from the Azure Maintenance service.
type ErrorDetails struct {
	// Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string

	// Human-readable representation of the error.
	Message *string
}

// InputLinuxParameters - Input properties for patching a Linux machine.
type InputLinuxParameters struct {
	// Classification category of patches to be patched
	ClassificationsToInclude []*string

	// Package names to be excluded for patching.
	PackageNameMasksToExclude []*string

	// Package names to be included for patching.
	PackageNameMasksToInclude []*string
}

// InputPatchConfiguration - Input configuration for a patch run
type InputPatchConfiguration struct {
	// Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
	LinuxParameters *InputLinuxParameters

	// Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after
	// the patch operation is completed.
	RebootSetting *RebootOptions

	// Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
	WindowsParameters *InputWindowsParameters
}

// InputWindowsParameters - Input properties for patching a Windows machine.
type InputWindowsParameters struct {
	// Classification category of patches to be patched
	ClassificationsToInclude []*string

	// Exclude patches which need reboot
	ExcludeKbsRequiringReboot *bool

	// Windows KBID to be excluded for patching.
	KbNumbersToExclude []*string

	// Windows KBID to be included for patching.
	KbNumbersToInclude []*string
}

// ListApplyUpdate - Response for ApplyUpdate list
type ListApplyUpdate struct {
	// The list of apply updates
	Value []*ApplyUpdate
}

// ListConfigurationAssignmentsResult - Response for ConfigurationAssignments list
type ListConfigurationAssignmentsResult struct {
	// The list of configuration Assignments
	Value []*ConfigurationAssignment
}

// ListMaintenanceConfigurationsResult - Response for MaintenanceConfigurations list
type ListMaintenanceConfigurationsResult struct {
	// The list of maintenance Configurations
	Value []*Configuration
}

// ListUpdatesResult - Response for Updates list
type ListUpdatesResult struct {
	// The pending updates
	Value []*Update
}

// Operation - Represents an operation returned by the GetOperations request
type Operation struct {
	// Display name of the operation
	Display *OperationInfo

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Name of the operation
	Name *string

	// Origin of the operation
	Origin *string

	// Properties of the operation
	Properties any
}

// OperationInfo - Information about an operation
type OperationInfo struct {
	// Description of the operation
	Description *string

	// Name of the operation
	Operation *string

	// Name of the provider
	Provider *string

	// Name of the resource type
	Resource *string
}

// OperationsListResult - Result of the List Operations operation
type OperationsListResult struct {
	// A collection of operations
	Value []*Operation
}

// Resource - Definition of a Resource
type Resource struct {
	// READ-ONLY; Fully qualified identifier of the resource
	ID *string

	// READ-ONLY; Name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; Type of the resource
	Type *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagSettingsProperties - Tag filter information for the VM.
type TagSettingsProperties struct {
	// Filter VMs by Any or All specified tags.
	FilterOperator *TagOperators

	// Dictionary of tags with its list of values.
	Tags map[string][]*string
}

// Update - Maintenance update on a resource
type Update struct {
	// Duration of impact in seconds
	ImpactDurationInSec *int32

	// The impact type
	ImpactType *ImpactType

	// The impact area
	MaintenanceScope *MaintenanceScope

	// Time when Azure will start force updates if not self-updated by customer before this time
	NotBefore *time.Time

	// Properties of the apply update
	Properties *UpdateProperties

	// The status
	Status *UpdateStatus
}

// UpdateProperties - Properties for update
type UpdateProperties struct {
	// The resourceId
	ResourceID *string
}

// Window - Definition of a MaintenanceWindow
type Window struct {
	// Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope
	// provided. Example: 05:00.
	Duration *string

	// Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time
	// zone provided and adjusted to daylight savings according to that time zone.
	// Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
	ExpirationDateTime *string

	// Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules.
	// Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)'].
	// If no frequency is provided, the default frequency is 1. Daily schedule examples are recurEvery: Day, recurEvery: 3Days.
	// Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)']
	// [Optional comma separated list of weekdays Monday-Sunday]. Weekly schedule examples are recurEvery: 3Weeks, recurEvery:
	// Week Saturday,Sunday. Monthly schedules are formatted as [Frequency as
	// integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First,
	// Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No. of
	// days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months,
	// recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery:
	// Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
	RecurEvery *string

	// Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current
	// date or future date. The window will be created in the time zone provided and
	// adjusted to daylight savings according to that time zone.
	StartDateTime *string

	// Name of the timezone. List of timezones can be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
	// Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea
	// Standard Time, Cen. Australia Standard Time.
	TimeZone *string
}
