; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32
; RUN: llc -global-isel -O0 -mtriple=mips64el-linux-gnuabi64 < %s | FileCheck %s -check-prefixes=MIPS64

declare void @f_i32(i32)
define void @g_i32() nounwind {
; MIPS32-LABEL: g_i32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    # implicit-def: $a0
; MIPS32-NEXT:    jal f_i32
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop

; MIPS64-LABEL: g_i32:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    # implicit-def: $a0_64
; MIPS64-NEXT:    jal f_i32
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
entry:
  call void @f_i32(i32 undef)
  ret void
}

declare void @f_i64(i64)
define void @g_i64() nounwind {
; MIPS32-LABEL: g_i64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    # implicit-def: $a1
; MIPS32-NEXT:    move $4, $5
; MIPS32-NEXT:    jal f_i64
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop

; MIPS64-LABEL: g_i64:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    # implicit-def: $a0_64
; MIPS64-NEXT:    jal f_i64
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
entry:
  call void @f_i64(i64 undef)
  ret void
}

declare void @f_float(float)
define void @g_float() nounwind {
; MIPS32-LABEL: g_float:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    # implicit-def: $f12
; MIPS32-NEXT:    jal f_float
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop

; MIPS64-LABEL: g_float:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    # implicit-def: $f12
; MIPS64-NEXT:    jal f_float
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
entry:
  call void @f_float(float undef)
  ret void
}

declare void @f_double(double)
define void @g_double() nounwind {
; MIPS32-LABEL: g_double:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    # implicit-def: $d6
; MIPS32-NEXT:    jal f_double
; MIPS32-NEXT:    nop
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    addiu $sp, $sp, 24
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop

; MIPS64-LABEL: g_double:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-NEXT:    # implicit-def: $d12_64
; MIPS64-NEXT:    jal f_double
; MIPS64-NEXT:    nop
; MIPS64-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
entry:
  call void @f_double(double undef)
  ret void
}
