; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv7m-eabi  %s -o - | FileCheck %s --check-prefix V7M
; RUN: llc -mtriple=armv7a-eabi  %s -o -   | FileCheck %s --check-prefix V7A
; RUN: llc -mtriple=thumbv7a-eabi  %s -o -   | FileCheck %s --check-prefix V7A-T
; RUN: llc -mtriple=armv6m-eabi  %s -o -   | FileCheck %s --check-prefix V6M

define i32 @mask_pair(i32 %x, i32 %y) {
; V7M-LABEL: mask_pair:
; V7M:       @ %bb.0:
; V7M-NEXT:    lsrs r0, r1
; V7M-NEXT:    lsls r0, r1
; V7M-NEXT:    bx lr
;
; V7A-LABEL: mask_pair:
; V7A:       @ %bb.0:
; V7A-NEXT:    lsr r0, r0, r1
; V7A-NEXT:    lsl r0, r0, r1
; V7A-NEXT:    bx lr
;
; V7A-T-LABEL: mask_pair:
; V7A-T:       @ %bb.0:
; V7A-T-NEXT:    lsrs r0, r1
; V7A-T-NEXT:    lsls r0, r1
; V7A-T-NEXT:    bx lr
;
; V6M-LABEL: mask_pair:
; V6M:       @ %bb.0:
; V6M-NEXT:    lsrs r0, r1
; V6M-NEXT:    lsls r0, r1
; V6M-NEXT:    bx lr
  %shl = shl nsw i32 -1, %y
  %and = and i32 %shl, %x
  ret i32 %and
}

define i64 @mask_pair_64(i64 %x, i64 %y) {
; V7M-LABEL: mask_pair_64:
; V7M:       @ %bb.0:
; V7M-NEXT:    mov.w r3, #-1
; V7M-NEXT:    lsl.w r12, r3, r2
; V7M-NEXT:    subs r2, #32
; V7M-NEXT:    it pl
; V7M-NEXT:    movpl.w r12, #0
; V7M-NEXT:    it pl
; V7M-NEXT:    lslpl r3, r2
; V7M-NEXT:    and.w r0, r0, r12
; V7M-NEXT:    ands r1, r3
; V7M-NEXT:    bx lr
;
; V7A-LABEL: mask_pair_64:
; V7A:       @ %bb.0:
; V7A-NEXT:    subs r12, r2, #32
; V7A-NEXT:    mvn r3, #0
; V7A-NEXT:    lsl r2, r3, r2
; V7A-NEXT:    lslpl r3, r3, r12
; V7A-NEXT:    movwpl r2, #0
; V7A-NEXT:    and r1, r3, r1
; V7A-NEXT:    and r0, r2, r0
; V7A-NEXT:    bx lr
;
; V7A-T-LABEL: mask_pair_64:
; V7A-T:       @ %bb.0:
; V7A-T-NEXT:    mov.w r3, #-1
; V7A-T-NEXT:    lsl.w r12, r3, r2
; V7A-T-NEXT:    subs r2, #32
; V7A-T-NEXT:    it pl
; V7A-T-NEXT:    movpl.w r12, #0
; V7A-T-NEXT:    it pl
; V7A-T-NEXT:    lslpl r3, r2
; V7A-T-NEXT:    and.w r0, r0, r12
; V7A-T-NEXT:    ands r1, r3
; V7A-T-NEXT:    bx lr
;
; V6M-LABEL: mask_pair_64:
; V6M:       @ %bb.0:
; V6M-NEXT:    .save {r4, r5, r7, lr}
; V6M-NEXT:    push {r4, r5, r7, lr}
; V6M-NEXT:    mov r4, r1
; V6M-NEXT:    mov r5, r0
; V6M-NEXT:    movs r0, #0
; V6M-NEXT:    mvns r0, r0
; V6M-NEXT:    mov r1, r0
; V6M-NEXT:    bl __aeabi_llsl
; V6M-NEXT:    ands r0, r5
; V6M-NEXT:    ands r1, r4
; V6M-NEXT:    pop {r4, r5, r7, pc}
  %shl = shl nsw i64 -1, %y
  %and = and i64 %shl, %x
  ret i64 %and
}
