; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc -mtriple=armv6t2-eabi %s -o - | FileCheck %s

define i64 @f1(i64 %a, i64 %b) {
; CHECK-LABEL: f1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    subs r0, r0, r2
; CHECK-NEXT:    sbc r1, r1, r3
; CHECK-NEXT:    bx lr
entry:
  %tmp = sub i64 %a, %b
  ret i64 %tmp
}

define i64 @f2(i64 %a, i64 %b) {
; CHECK-LABEL: f2:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    lsl r1, r1, #1
; CHECK-NEXT:    orr r1, r1, r0, lsr #31
; CHECK-NEXT:    rsbs r0, r2, r0, lsl #1
; CHECK-NEXT:    sbc r1, r1, r3
; CHECK-NEXT:    bx lr
entry:
  %tmp1 = shl i64 %a, 1
  %tmp2 = sub i64 %tmp1, %b
  ret i64 %tmp2
}

; add with live carry
define i64 @f3(i32 %al, i32 %bl) {
; CHECK-LABEL: f3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    adds r0, r0, r1
; CHECK-NEXT:    mov r2, #0
; CHECK-NEXT:    adcs r0, r1, #0
; CHECK-NEXT:    adc r1, r2, #0
; CHECK-NEXT:    bx lr
entry:
  ; unsigned wide add
  %aw = zext i32 %al to i64
  %bw = zext i32 %bl to i64
  %cw = add i64 %aw, %bw
  ; ch == carry bit
  %ch = lshr i64 %cw, 32
  %dw = add i64 %ch, %bw
  ret i64 %dw
}

; rdar://10073745
define i64 @f4(i64 %x) nounwind readnone {
; CHECK-LABEL: f4:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    rsbs r0, r0, #0
; CHECK-NEXT:    rsc r1, r1, #0
; CHECK-NEXT:    bx lr
entry:
  %0 = sub nsw i64 0, %x
  ret i64 %0
}

; rdar://12559385
define i64 @f5(i32 %vi) {
; CHECK-LABEL: f5:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movw r1, #19493
; CHECK-NEXT:    movw r2, #29433
; CHECK-NEXT:    movt r1, #57191
; CHECK-NEXT:    eor r0, r0, r1
; CHECK-NEXT:    movw r3, #46043
; CHECK-NEXT:    movt r2, #65535
; CHECK-NEXT:    adds r0, r0, r0
; CHECK-NEXT:    movw r1, #36102
; CHECK-NEXT:    sbc r2, r2, r1
; CHECK-NEXT:    movt r3, #8344
; CHECK-NEXT:    adds r0, r0, r3
; CHECK-NEXT:    adc r1, r2, r1
; CHECK-NEXT:    bx lr
entry:
  %v0 = zext i32 %vi to i64
  %v1 = xor i64 %v0, -155057456198619
  %v4 = add i64 %v1, 155057456198619
  %v5 = add i64 %v4, %v1
  ret i64 %v5
}
