; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 6
; RUN: llc --mtriple=armv7-eabihf %s -o - | FileCheck %s --enable-var-scope

%struct.S0 = type { [4 x float] }
%struct.S1 = type { [2 x float] }
%struct.S2 = type { [4 x float] }
%struct.D0 = type { [2 x double] }
%struct.D1 = type { [2 x double] }
%struct.D2 = type { [4 x double] }

; pass in regs
declare dso_local float @f0_0(double, double, double, double, double, double, %struct.S0) local_unnamed_addr #0
define dso_local float @f0_0_call() local_unnamed_addr #0 {
; CHECK-LABEL: f0_0_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldr s13, .LCPI0_5
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    vmov.f32 s14, s13
; CHECK-NEXT:    vldr d1, .LCPI0_0
; CHECK-NEXT:    vmov.f32 s15, s13
; CHECK-NEXT:    vldr d2, .LCPI0_1
; CHECK-NEXT:    vldr d3, .LCPI0_2
; CHECK-NEXT:    vldr d4, .LCPI0_3
; CHECK-NEXT:    vldr s12, .LCPI0_4
; CHECK-NEXT:    b f0_0
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI0_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI0_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI0_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI0_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI0_4:
; CHECK-NEXT:    .long 0x3f19999a @ float 0.600000024
; CHECK-NEXT:  .LCPI0_5:
; CHECK-NEXT:    .long 0x00000000 @ float 0
entry:
  %call = tail call float @f0_0(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, %struct.S0 { [4 x float] [float 0x3FE3333340000000, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00] }) #0
  ret float %call
}

; pass in memory, no split
declare dso_local float @f0_1(double, double, double, double, double, double, float, %struct.S0) local_unnamed_addr #0
define dso_local float @f0_1_call() local_unnamed_addr #0 {
; CHECK-LABEL: f0_1_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movw r1, #13107
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    movt r1, #16179
; CHECK-NEXT:    str r1, [sp]
; CHECK-NEXT:    str r0, [sp, #4]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI1_0
; CHECK-NEXT:    vldr d2, .LCPI1_1
; CHECK-NEXT:    vldr d3, .LCPI1_2
; CHECK-NEXT:    vldr d4, .LCPI1_3
; CHECK-NEXT:    vldr s12, .LCPI1_4
; CHECK-NEXT:    str r0, [sp, #8]
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    bl f0_1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI1_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI1_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI1_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI1_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI1_4:
; CHECK-NEXT:    .long 0x3f19999a @ float 0.600000024
entry:
  %call = tail call float @f0_1(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, float 0x3FE3333340000000, %struct.S0 { [4 x float] [float 0x3FE6666660000000, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00] }) #0
  ret float %call
}

; pass memory, alignment 4
declare dso_local float @f0_2(double, double, double, double, double, double, double, double, float, %struct.S0) local_unnamed_addr #0
define dso_local float @f0_2_call() local_unnamed_addr #0 {
; CHECK-LABEL: f0_2_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #24
; CHECK-NEXT:    sub sp, sp, #24
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movw r1, #26214
; CHECK-NEXT:    movw r2, #52429
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    movt r1, #16230
; CHECK-NEXT:    movt r2, #16204
; CHECK-NEXT:    str r2, [sp]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI2_0
; CHECK-NEXT:    vldr d2, .LCPI2_1
; CHECK-NEXT:    vldr d3, .LCPI2_2
; CHECK-NEXT:    vldr d4, .LCPI2_3
; CHECK-NEXT:    vldr d6, .LCPI2_4
; CHECK-NEXT:    vldr d7, .LCPI2_5
; CHECK-NEXT:    str r1, [sp, #4]
; CHECK-NEXT:    str r0, [sp, #8]
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    str r0, [sp, #16]
; CHECK-NEXT:    bl f0_2
; CHECK-NEXT:    add sp, sp, #24
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI2_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI2_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI2_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI2_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI2_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI2_5:
; CHECK-NEXT:    .long 1717986918 @ double 0.69999999999999996
; CHECK-NEXT:    .long 1072064102
entry:
  %call = tail call float @f0_2(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, float 0x3FE99999A0000000, %struct.S0 { [4 x float] [float 0x3FECCCCCC0000000, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00] }) #0
  ret float %call
}

; pass in regs
declare dso_local float @f1_0(double, double, double, double, double, double, double, %struct.S1 alignstack(8)) local_unnamed_addr #0
define dso_local float @f1_0_call() local_unnamed_addr #0 {
; CHECK-LABEL: f1_0_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI3_0
; CHECK-NEXT:    vldr d2, .LCPI3_1
; CHECK-NEXT:    vldr d3, .LCPI3_2
; CHECK-NEXT:    vldr d4, .LCPI3_3
; CHECK-NEXT:    vldr d6, .LCPI3_4
; CHECK-NEXT:    vldr s14, .LCPI3_5
; CHECK-NEXT:    vldr s15, .LCPI3_6
; CHECK-NEXT:    b f1_0
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI3_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI3_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI3_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI3_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI3_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI3_5:
; CHECK-NEXT:    .long 0x3f333333 @ float 0.699999988
; CHECK-NEXT:  .LCPI3_6:
; CHECK-NEXT:    .long 0x00000000 @ float 0
entry:
  %call = tail call float @f1_0(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, %struct.S1 alignstack(8) { [2 x float] [float 0x3FE6666660000000, float 0.000000e+00] }) #0
  ret float %call
}

; pass in memory, no split
declare dso_local float @f1_1(double, double, double, double, double, double, double, float, %struct.S1 alignstack(8)) local_unnamed_addr #0
define dso_local float @f1_1_call() local_unnamed_addr #0 {
; CHECK-LABEL: f1_1_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, sp, #8
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movw r0, #52429
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    movt r0, #16204
; CHECK-NEXT:    strd r0, r1, [sp]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI4_0
; CHECK-NEXT:    vldr d2, .LCPI4_1
; CHECK-NEXT:    vldr d3, .LCPI4_2
; CHECK-NEXT:    vldr d4, .LCPI4_3
; CHECK-NEXT:    vldr d6, .LCPI4_4
; CHECK-NEXT:    vldr s14, .LCPI4_5
; CHECK-NEXT:    bl f1_1
; CHECK-NEXT:    add sp, sp, #8
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI4_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI4_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI4_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI4_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI4_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI4_5:
; CHECK-NEXT:    .long 0x3f333333 @ float 0.699999988
entry:
  %call = tail call float @f1_1(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, float 0x3FE6666660000000, %struct.S1 alignstack(8) { [2 x float] [float 0x3FE99999A0000000, float 0.000000e+00] }) #0
  ret float %call
}

; pass in memory, alignment 8
declare dso_local float @f1_2(double, double, double, double, double, double, double, double, float, %struct.S1 alignstack(8)) local_unnamed_addr #0
define dso_local float @f1_2_call() local_unnamed_addr #0 {
; CHECK-LABEL: f1_2_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    movw r0, #26214
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    mov r1, #0
; CHECK-NEXT:    movt r0, #16230
; CHECK-NEXT:    strd r0, r1, [sp, #8]
; CHECK-NEXT:    movw r0, #52429
; CHECK-NEXT:    movt r0, #16204
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI5_0
; CHECK-NEXT:    vldr d2, .LCPI5_1
; CHECK-NEXT:    vldr d3, .LCPI5_2
; CHECK-NEXT:    vldr d4, .LCPI5_3
; CHECK-NEXT:    vldr d6, .LCPI5_4
; CHECK-NEXT:    vldr d7, .LCPI5_5
; CHECK-NEXT:    str r0, [sp]
; CHECK-NEXT:    bl f1_2
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI5_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI5_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI5_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI5_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI5_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI5_5:
; CHECK-NEXT:    .long 1717986918 @ double 0.69999999999999996
; CHECK-NEXT:    .long 1072064102
entry:
  %call = tail call float @f1_2(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, float 0x3FE99999A0000000, %struct.S1 alignstack(8) { [2 x float] [float 0x3FECCCCCC0000000, float 0.000000e+00] }) #0
  ret float %call
}

; pass in registers
declare dso_local float @f2_0(double, double, double, double, double, double, %struct.S2 alignstack(8)) local_unnamed_addr #0
define dso_local float @f2_0_call() local_unnamed_addr #0 {
; CHECK-LABEL: f2_0_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vldr s13, .LCPI6_5
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    vmov.f32 s14, s13
; CHECK-NEXT:    vldr d1, .LCPI6_0
; CHECK-NEXT:    vmov.f32 s15, s13
; CHECK-NEXT:    vldr d2, .LCPI6_1
; CHECK-NEXT:    vldr d3, .LCPI6_2
; CHECK-NEXT:    vldr d4, .LCPI6_3
; CHECK-NEXT:    vldr s12, .LCPI6_4
; CHECK-NEXT:    b f2_0
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI6_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI6_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI6_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI6_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI6_4:
; CHECK-NEXT:    .long 0x3f19999a @ float 0.600000024
; CHECK-NEXT:  .LCPI6_5:
; CHECK-NEXT:    .long 0x00000000 @ float 0
entry:
  %call = tail call float @f2_0(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, %struct.S2 alignstack(8) { [4 x float] [float 0x3FE3333340000000, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00] }) #0
  ret float %call
}

; pass in memory, no split
declare dso_local float @f2_1(double, double, double, double, double, double, float, %struct.S2 alignstack(8)) local_unnamed_addr #0
define dso_local float @f2_1_call() local_unnamed_addr #0 {
; CHECK-LABEL: f2_1_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movw r1, #13107
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    movt r1, #16179
; CHECK-NEXT:    str r1, [sp]
; CHECK-NEXT:    str r0, [sp, #4]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI7_0
; CHECK-NEXT:    vldr d2, .LCPI7_1
; CHECK-NEXT:    vldr d3, .LCPI7_2
; CHECK-NEXT:    vldr d4, .LCPI7_3
; CHECK-NEXT:    vldr s12, .LCPI7_4
; CHECK-NEXT:    str r0, [sp, #8]
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    bl f2_1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI7_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI7_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI7_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI7_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI7_4:
; CHECK-NEXT:    .long 0x3f19999a @ float 0.600000024
entry:
  %call = tail call float @f2_1(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, float 0x3FE3333340000000, %struct.S2 alignstack(8) { [4 x float] [float 0x3FE6666660000000, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00] }) #0
  ret float %call
}

; pass in memory, alignment 8
declare dso_local float @f2_2(double, double, double, double, double, double, double, double, float, %struct.S2 alignstack(8)) local_unnamed_addr #0
define dso_local float @f2_2_call() local_unnamed_addr #0 {
; CHECK-LABEL: f2_2_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #24
; CHECK-NEXT:    sub sp, sp, #24
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    movw r1, #26214
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    str r0, [sp, #16]
; CHECK-NEXT:    movt r1, #16230
; CHECK-NEXT:    str r0, [sp, #20]
; CHECK-NEXT:    movw r0, #52429
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI8_0
; CHECK-NEXT:    vldr d2, .LCPI8_1
; CHECK-NEXT:    movt r0, #16204
; CHECK-NEXT:    vldr d3, .LCPI8_2
; CHECK-NEXT:    vldr d4, .LCPI8_3
; CHECK-NEXT:    vldr d6, .LCPI8_4
; CHECK-NEXT:    vldr d7, .LCPI8_5
; CHECK-NEXT:    str r1, [sp, #8]
; CHECK-NEXT:    str r0, [sp]
; CHECK-NEXT:    bl f2_2
; CHECK-NEXT:    add sp, sp, #24
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI8_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI8_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI8_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI8_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI8_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI8_5:
; CHECK-NEXT:    .long 1717986918 @ double 0.69999999999999996
; CHECK-NEXT:    .long 1072064102
entry:
  %call = tail call float @f2_2(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, float 0x3FE99999A0000000, %struct.S2 alignstack(8) { [4 x float] [float 0x3FECCCCCC0000000, float 0.000000e+00, float 0.000000e+00, float 0.000000e+00] }) #0
  ret float %call
}

; pass in registers
declare dso_local double @g0_0(double, double, double, double, double, double, %struct.D0) local_unnamed_addr #0
define dso_local double @g0_0_call() local_unnamed_addr #0 {
; CHECK-LABEL: g0_0_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI9_0
; CHECK-NEXT:    vmov.i32 d7, #0x0
; CHECK-NEXT:    vldr d2, .LCPI9_1
; CHECK-NEXT:    vldr d3, .LCPI9_2
; CHECK-NEXT:    vldr d4, .LCPI9_3
; CHECK-NEXT:    vldr d6, .LCPI9_4
; CHECK-NEXT:    b g0_0
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI9_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI9_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI9_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI9_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI9_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
entry:
  %call = tail call double @g0_0(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, %struct.D0 { [2 x double] [double 6.000000e-01, double 0.000000e+00] }) #0
  ret double %call
}

; pass in memory, no split
declare dso_local double @g0_1(double, double, double, double, double, double, double, %struct.D0) local_unnamed_addr #0
define dso_local double @g0_1_call() local_unnamed_addr #0 {
; CHECK-LABEL: g0_1_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movw r0, #26214
; CHECK-NEXT:    movw r1, #26214
; CHECK-NEXT:    mov r2, #0
; CHECK-NEXT:    movt r0, #16358
; CHECK-NEXT:    movt r1, #26214
; CHECK-NEXT:    str r1, [sp]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI10_0
; CHECK-NEXT:    vldr d2, .LCPI10_1
; CHECK-NEXT:    vldr d3, .LCPI10_2
; CHECK-NEXT:    vldr d4, .LCPI10_3
; CHECK-NEXT:    vldr d6, .LCPI10_4
; CHECK-NEXT:    stmib sp, {r0, r2}
; CHECK-NEXT:    str r2, [sp, #12]
; CHECK-NEXT:    bl g0_1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI10_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI10_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI10_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI10_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI10_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
entry:
  %call = tail call double @g0_1(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, %struct.D0 { [2 x double] [double 0x3FE6666666666666, double 0.000000e+00] }) #0
  ret double %call
}

; pass in memory, alignment 8
declare dso_local double @g0_2(double, double, double, double, double, double, double, double, float, %struct.D0) local_unnamed_addr #0
define dso_local double @g0_2_call() local_unnamed_addr #0 {
; CHECK-LABEL: g0_2_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #24
; CHECK-NEXT:    sub sp, sp, #24
; CHECK-NEXT:    movw r0, #52428
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movt r0, #16364
; CHECK-NEXT:    movw r1, #52429
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    movw r0, #52429
; CHECK-NEXT:    mov r2, #0
; CHECK-NEXT:    movt r1, #52428
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI11_0
; CHECK-NEXT:    vldr d2, .LCPI11_1
; CHECK-NEXT:    movt r0, #16204
; CHECK-NEXT:    vldr d3, .LCPI11_2
; CHECK-NEXT:    vldr d4, .LCPI11_3
; CHECK-NEXT:    vldr d6, .LCPI11_4
; CHECK-NEXT:    vldr d7, .LCPI11_5
; CHECK-NEXT:    str r1, [sp, #8]
; CHECK-NEXT:    str r2, [sp, #16]
; CHECK-NEXT:    str r2, [sp, #20]
; CHECK-NEXT:    str r0, [sp]
; CHECK-NEXT:    bl g0_2
; CHECK-NEXT:    add sp, sp, #24
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI11_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI11_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI11_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI11_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI11_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI11_5:
; CHECK-NEXT:    .long 1717986918 @ double 0.69999999999999996
; CHECK-NEXT:    .long 1072064102
entry:
  %call = tail call double @g0_2(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, float 0x3FE99999A0000000, %struct.D0 { [2 x double] [double 9.000000e-01, double 0.000000e+00] }) #0
  ret double %call
}

; pass in registers
declare dso_local double @g1_0(double, double, double, double, double, double, %struct.D1 alignstack(8)) local_unnamed_addr #0
define dso_local double @g1_0_call() local_unnamed_addr #0 {
; CHECK-LABEL: g1_0_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI12_0
; CHECK-NEXT:    vmov.i32 d7, #0x0
; CHECK-NEXT:    vldr d2, .LCPI12_1
; CHECK-NEXT:    vldr d3, .LCPI12_2
; CHECK-NEXT:    vldr d4, .LCPI12_3
; CHECK-NEXT:    vldr d6, .LCPI12_4
; CHECK-NEXT:    b g1_0
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI12_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI12_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI12_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI12_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI12_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
entry:
  %call = tail call double @g1_0(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, %struct.D1 alignstack(8) { [2 x double] [double 6.000000e-01, double 0.000000e+00] }) #0
  ret double %call
}

; pass in memory, no split
declare dso_local double @g1_1(double, double, double, double, double, double, double, %struct.D1 alignstack(8)) local_unnamed_addr #0
define dso_local double @g1_1_call() local_unnamed_addr #0 {
; CHECK-LABEL: g1_1_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movw r0, #26214
; CHECK-NEXT:    movw r1, #26214
; CHECK-NEXT:    mov r2, #0
; CHECK-NEXT:    movt r0, #16358
; CHECK-NEXT:    movt r1, #26214
; CHECK-NEXT:    str r1, [sp]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI13_0
; CHECK-NEXT:    vldr d2, .LCPI13_1
; CHECK-NEXT:    vldr d3, .LCPI13_2
; CHECK-NEXT:    vldr d4, .LCPI13_3
; CHECK-NEXT:    vldr d6, .LCPI13_4
; CHECK-NEXT:    stmib sp, {r0, r2}
; CHECK-NEXT:    str r2, [sp, #12]
; CHECK-NEXT:    bl g1_1
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI13_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI13_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI13_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI13_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI13_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
entry:
  %call = tail call double @g1_1(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, %struct.D1 alignstack(8) { [2 x double] [double 0x3FE6666666666666, double 0.000000e+00] }) #0
  ret double %call
}

; pass in memory, alignment 8
declare dso_local double @g1_2(double, double, double, double, double, double, double, double, float, %struct.D1 alignstack(8)) local_unnamed_addr #0
define dso_local double @g1_2_call() local_unnamed_addr #0 {
; CHECK-LABEL: g1_2_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #24
; CHECK-NEXT:    sub sp, sp, #24
; CHECK-NEXT:    movw r0, #52428
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movt r0, #16364
; CHECK-NEXT:    movw r1, #52429
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    movw r0, #52429
; CHECK-NEXT:    mov r2, #0
; CHECK-NEXT:    movt r1, #52428
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI14_0
; CHECK-NEXT:    vldr d2, .LCPI14_1
; CHECK-NEXT:    movt r0, #16204
; CHECK-NEXT:    vldr d3, .LCPI14_2
; CHECK-NEXT:    vldr d4, .LCPI14_3
; CHECK-NEXT:    vldr d6, .LCPI14_4
; CHECK-NEXT:    vldr d7, .LCPI14_5
; CHECK-NEXT:    str r1, [sp, #8]
; CHECK-NEXT:    str r2, [sp, #16]
; CHECK-NEXT:    str r2, [sp, #20]
; CHECK-NEXT:    str r0, [sp]
; CHECK-NEXT:    bl g1_2
; CHECK-NEXT:    add sp, sp, #24
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI14_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI14_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI14_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI14_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI14_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI14_5:
; CHECK-NEXT:    .long 1717986918 @ double 0.69999999999999996
; CHECK-NEXT:    .long 1072064102
entry:
  %call = tail call double @g1_2(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, float 0x3FE99999A0000000, %struct.D1 alignstack(8) { [2 x double] [double 9.000000e-01, double 0.000000e+00] }) #0
  ret double %call
}

; pass in registers
declare dso_local double @g2_0(double, double, double, double, %struct.D2 alignstack(8)) local_unnamed_addr #0
define dso_local double @g2_0_call() local_unnamed_addr #0 {
; CHECK-LABEL: g2_0_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI15_0
; CHECK-NEXT:    vmov.i32 d5, #0x0
; CHECK-NEXT:    vldr d2, .LCPI15_1
; CHECK-NEXT:    vmov.i32 d6, #0x0
; CHECK-NEXT:    vldr d3, .LCPI15_2
; CHECK-NEXT:    vmov.i32 d7, #0x0
; CHECK-NEXT:    vldr d4, .LCPI15_3
; CHECK-NEXT:    b g2_0
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI15_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI15_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI15_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI15_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
entry:
  %call = tail call double @g2_0(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, %struct.D2 alignstack(8) { [4 x double] [double 4.000000e-01, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00] }) #0
  ret double %call
}

; pass in memory, no split
; [sp] [sp + 4] =  0x00000000 0x3fe00000 = .5
; [sp + 8] [sp + 12] = 0 0 = .0
; ...
declare dso_local double @g2_1(double, double, double, double, double, %struct.D2 alignstack(8)) local_unnamed_addr #0
define dso_local double @g2_1_call() local_unnamed_addr #0 {
; CHECK-LABEL: g2_1_call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, sp, #32
; CHECK-NEXT:    vmov.f64 d16, #5.000000e-01
; CHECK-NEXT:    mov r0, #0
; CHECK-NEXT:    str r0, [sp, #8]
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    str r0, [sp, #16]
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI16_0
; CHECK-NEXT:    vldr d2, .LCPI16_1
; CHECK-NEXT:    vldr d3, .LCPI16_2
; CHECK-NEXT:    vldr d4, .LCPI16_3
; CHECK-NEXT:    str r0, [sp, #20]
; CHECK-NEXT:    str r0, [sp, #24]
; CHECK-NEXT:    str r0, [sp, #28]
; CHECK-NEXT:    vstr d16, [sp]
; CHECK-NEXT:    bl g2_1
; CHECK-NEXT:    add sp, sp, #32
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI16_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI16_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI16_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI16_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
entry:
  %call = tail call double @g2_1(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, %struct.D2 alignstack(8) { [4 x double] [double 5.000000e-01, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00] }) #0
  ret double %call
}

; pass in memory, alignment 8
declare dso_local double @g2_2(double, double, double, double, double, double, double, double, float, %struct.D2 alignstack(8)) local_unnamed_addr #0
define dso_local double @g2_2call() local_unnamed_addr #0 {
; CHECK-LABEL: g2_2call:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #40
; CHECK-NEXT:    sub sp, sp, #40
; CHECK-NEXT:    movw r0, #52428
; CHECK-NEXT:    vmov.f64 d5, #5.000000e-01
; CHECK-NEXT:    movt r0, #16364
; CHECK-NEXT:    movw r1, #52429
; CHECK-NEXT:    str r0, [sp, #12]
; CHECK-NEXT:    movw r0, #52429
; CHECK-NEXT:    mov r2, #0
; CHECK-NEXT:    movt r1, #52428
; CHECK-NEXT:    vmov.i32 d0, #0x0
; CHECK-NEXT:    vldr d1, .LCPI17_0
; CHECK-NEXT:    vldr d2, .LCPI17_1
; CHECK-NEXT:    movt r0, #16204
; CHECK-NEXT:    vldr d3, .LCPI17_2
; CHECK-NEXT:    vldr d4, .LCPI17_3
; CHECK-NEXT:    vldr d6, .LCPI17_4
; CHECK-NEXT:    vldr d7, .LCPI17_5
; CHECK-NEXT:    str r1, [sp, #8]
; CHECK-NEXT:    str r2, [sp, #16]
; CHECK-NEXT:    str r2, [sp, #20]
; CHECK-NEXT:    str r2, [sp, #24]
; CHECK-NEXT:    str r2, [sp, #28]
; CHECK-NEXT:    str r2, [sp, #32]
; CHECK-NEXT:    str r2, [sp, #36]
; CHECK-NEXT:    str r0, [sp]
; CHECK-NEXT:    bl g2_2
; CHECK-NEXT:    add sp, sp, #40
; CHECK-NEXT:    pop {r11, pc}
; CHECK-NEXT:    .p2align 3
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI17_0:
; CHECK-NEXT:    .long 2576980378 @ double 0.10000000000000001
; CHECK-NEXT:    .long 1069128089
; CHECK-NEXT:  .LCPI17_1:
; CHECK-NEXT:    .long 2576980378 @ double 0.20000000000000001
; CHECK-NEXT:    .long 1070176665
; CHECK-NEXT:  .LCPI17_2:
; CHECK-NEXT:    .long 858993459 @ double 0.29999999999999999
; CHECK-NEXT:    .long 1070805811
; CHECK-NEXT:  .LCPI17_3:
; CHECK-NEXT:    .long 2576980378 @ double 0.40000000000000002
; CHECK-NEXT:    .long 1071225241
; CHECK-NEXT:  .LCPI17_4:
; CHECK-NEXT:    .long 858993459 @ double 0.59999999999999998
; CHECK-NEXT:    .long 1071854387
; CHECK-NEXT:  .LCPI17_5:
; CHECK-NEXT:    .long 1717986918 @ double 0.69999999999999996
; CHECK-NEXT:    .long 1072064102
entry:
  %call = tail call double @g2_2(double 0.000000e+00, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, float 0x3FE99999A0000000, %struct.D2 alignstack(8) { [4 x double] [double 9.000000e-01, double 0.000000e+00, double 0.000000e+00, double 0.000000e+00] }) #0
  ret double %call
}

attributes #0 = { nounwind "target-cpu"="generic" "target-features"="+armv7-a,+d32,+dsp,+fp64,+neon,+strict-align,+vfp2,+vfp2sp,+vfp3,+vfp3d16,+vfp3d16sp,+vfp3sp,-thumb-mode" }
