# Jasmine Core 4.0.0 Release Notes

## Summary

This is a major release. In addition to new features and bug fixes it contains
a number of breaking changes that are intended to diagnose common errors,
improve awkward or outdated APIs, and make Jasmine easier to maintain 
and contribute to. If you're upgrading from Jasmine 3.x, we recommend installing
3.99 and fixing any deprecation warnings that it emits before updating to 4.0.
Please see the [migration guide](https://jasmine.github.io/tutorials/upgrading_to_Jasmine_4.0)
for more information. If you use the `jasmine` or `jasmine-browser-runner` NPM
packages, please read the release notes for those packages as well.

## Highlights

* Obsolete environments, most notably Internet Explorer, are no longer
  supported. Jasmine now expects to run in an environment that provides most
  of ES2017 and, in the case of Node, good interoperability between CommonJS
  modules and ES modules.

* The Jasmine packages for Ruby and Python have been discontinued.

* Errors in `beforeAll` and `beforeEach` functions are handled better.

* Jasmine can optionally be used without creating globals in Node.

* Certain common async testing bugs are now reported  as errors.

* A new debug logging feature makes it easier to debug failing specs, 
  particularly intermittent failures.

See details below.

## Breaking changes

### Changes to supported environments

The following previously supported environments are no longer supported:

* Internet Explorer
* PhantomJS
* Safari 8-13
* Firefox 68 and 78
* Node 10 and 12.0-12.16
* Python
* Ruby
* Bower

Although Jasmine 4.0 may still work in some of those environments, we no longer
test against them and won't try to maintain compatibility with them in future
4.x releases.

The [`jasmine-browser-runner`](https://jasmine.github.io/setup/browser.html)
NPM package is the direct replacement for the `jasmine` Ruby and Python
packages.

### Changes that affect how specs are written

* When a `beforeAll` function fails in any way other than a failed expectation,
  Jasmine will not run the contents of the suite or any child suites except
  for any `afterAll` functions defined in the same suite as the failed
  `beforeAll` function. All affected specs will still be reported as failed.
  See [#1533](https://github.com/jasmine/jasmine/issues/1533).

* When a `beforeEach` function fails in any way other than a failed expectation,
  Jasmine will skip any subsequent `beforeEach` functions, the corresponding
  spec, and any `afterEach` functions defined in child suites. `afterEach`
  functions defined at the same or higher levels will still run. The spec will
  still be reported as failed. See [#1533](https://github.com/jasmine/jasmine/issues/1533).

* `MatchersUtil#contains` and the `toContain` matcher use deep equality rather
   than `===` to compare set members. This matches how arrays are handled but
   may cause some previously passing `.not.toContain()` expectations to fail.

* `jasmine.clock().mockDate()` throws if its argument is not a `Date`. Previous
   versions ignored non-`Date` arguments.

* Multiple calls to an asynchronous function's `done` callback are treated as
  errors.

* Any argument passed to a `done` callback (other than `undefined`) is treated
  as an error. Previous versions ignored any argument that wasn't an `Error`
  instance.

* Jasmine will report an error rather than a warning when a function tries to
  combine two different forms of async (e.g. taking a callback and also 
  returning a promise).

* `this` in `describe` functions is no longer a `Suite` object.

* Empty suites are treated as errors.
  * Merges [#1742](https://github.com/jasmine/jasmine/pull/1742) from @johnjbarton

* The current time value does not decrease when `jasmine.clock().tick()` is 
  called from a `setTimeout` or `setInterval` callback.
  * Merges [#1948](https://github.com/jasmine/jasmine/pull/1948) from @thw0rted
  * Fixes [#1929](https://github.com/jasmine/jasmine/issues/1929).

### Changes to how Jasmine is configured

* Individual configuration property getters and setters such as
  `Env#randomTests` and `Env#randomizeTests` have been removed. Use
  `Env#configuration` and `Env#configure` instead.

* The `failFast` and `oneFailurePerSpec` configuration properties have been
  removed. Use `stopOnSpecFailure` and `stopSpecOnExpectationFailure` instead.

* The `Promise` configuration property has been removed. Jasmine can still
  consume non-native promises but will always use the global `Promise` to
  create promises.

### Changes that affect custom matchers

* The old style of using custom equality testers, where matchers received them
  from Jasmine and had to pass them back to `matchersUtil` methods, is no longer
  supported.

* `matchersUtil` and `pp` are no longer available globally. Instead, use the 
  instances that are passed to custom matcher factories and to `jasmineToString`.

See the [migration guide](https://jasmine.github.io/tutorials/upgrading_to_Jasmine_4.0)
for more information about these changes and how to update custom matchers that
use the old APIs.

### Changes that affect custom reporters

* The [`Suite`](https://jasmine.github.io/api/4.0/Suite.html) and
  [`Spec`](https://jasmine.github.io/api/4.0/Spec.html) objects returned from
  `describe`, `it`, and `Env#topSuite` no longer expose private APIs.

### Other breaking changes

* `boot.js` is no longer included. Use `boot0.js` and `boot1.js` instead.
* Boot files in `lib/jasmine-core/boot` are no longer included in the NPM 
  package. Use the boot files in `lib/jasmine-core` instead.
* `json2.js` is no longer included, since all supported environments provide a
  JSON parser.

## Other new features and bug fixes

* Jasmine can optionally be used without creating globals in Node.js.
  * See https://jasmine.github.io/api/4.0/module-jasmine-core.html#.noGlobals
  * If you're using the `jasmine` package, see
    [its documentation](https://jasmine.github.io/api/npm/4.0/JasmineOptions.html#globals).
  * Fixes [#1235](https://github.com/jasmine/jasmine/issues/1235)

* Custom spy strategies are inherited from parent suites like other runnable
   resources.

* `pending()` can now be called from `beforeEach` functions.
    * Fixes [#1579](https://github.com/jasmine/jasmine/issues/1579)

* Removed duplicate message from errors (including. matcher failures) in
  V8-based environments.

* `Spy#withArgs` supports custom equality testers.
    * Fixes [#1836](https://github.com/jasmine/jasmine/issues/1836)

* The promise returned by `Env#execute` is resolved to the
  [jasmineDoneInfo](https://jasmine.github.io/api/4.0/global.html#JasmineDoneInfo).

* Fixed stack trace filtering on Safari 15.

* The HTML reporter includes top suite failures in the reported failure count.

* `afterAll` functions are run after a failure even if the `stopOnSpecFailure`
  config property is set.

* Added a debug logging feature to make it easier to debug failing specs.
  * Call `jasmine#debugLog` during spec execution to add a log entry.
  * If the spec fails, log entries are reported as part of the
    [specDone](https://jasmine.github.io/api/4.0/Reporter.html#specDone) reporter
    event.

* The HTML reporter no longer says that expectations occurring after the spec
  finishes are AfterAll errors. 

## Documentation updates

* Added a [4.0 migration guide](https://jasmine.github.io/tutorials/upgrading_to_Jasmine_4.0)

* Updated the README and contributing guide for 4.0

## Supported environments

jasmine-core 4.0.0 has been tested in the following environments.

| Environment       | Supported versions |
|-------------------|--------------------|
| Node              | 12.17+, 14, 16     |
| Safari            | 14-15              |
| Chrome            | 96                 |
| Firefox           | 91, 95             |
| Edge              | 96                 |
------

_Release Notes generated with _[Anchorman](http://github.com/infews/anchorman)_
