/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scidac.cmcs.tools.bse.IBasisSetToXml;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.ShellFilter;

public abstract class AbstractBasisSetToXml
implements IBasisSetToXml {
    public static final String CT_SEGMENTED = "segmented";
    public static final String CT_GENERAL = "general";
    public static final String CT_UNCONTRACTED = "uncontracted";
    public static final String BASIS_MIME = "chemical/x-emsl-gaussian-basisset";
    public static final String ECP_MIME = "chemical/x-emsl-ecp";
    public static final String ECP_POSTFIX = "-ecp";
    public static final String SO_POSTFIX = "-so";
    protected static final Namespace mDcNs = Namespace.getNamespace("dc", "http://purl.org/dc/elements/1.1/");
    protected static final Namespace mCmcsNs = Namespace.getNamespace("cmcs", "http://purl.oclc.org/NET/cmcs/schema/");
    protected static final Namespace mEmslNs = Namespace.getNamespace("", "http://purl.oclc.org/NET/EMSL/BSE");
    protected static final Namespace mCmlNs = Namespace.getNamespace("cml", "http://www.xml-cml.org/schema/cml2/core");
    protected static final Namespace mXlinkNs = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    protected static String[] mShells = new String[]{"UL", "S", "P", "SP", "D", "F", "G", "H", "I", "K", "L", "M"};

    protected Element createBasisRoot() {
        Element root = new Element("basisset", mEmslNs);
        root.addNamespaceDeclaration(mCmcsNs);
        root.addNamespaceDeclaration(mDcNs);
        root.addNamespaceDeclaration(mCmlNs);
        root.addNamespaceDeclaration(mXlinkNs);
        root.addContent(this.createConversionTag(false));
        root.addContent(this.createBasisSetType("orbital"));
        return root;
    }

    protected Element createEcpRoot() {
        Element root = new Element("effectivePotentials", mEmslNs);
        root.addNamespaceDeclaration(mCmcsNs);
        root.addNamespaceDeclaration(mDcNs);
        root.addNamespaceDeclaration(mCmlNs);
        root.addNamespaceDeclaration(mXlinkNs);
        root.addContent(this.createConversionTag(false));
        root.addContent(this.createEcpType("scalar"));
        return root;
    }

    protected Element createHarmonicType(String harmonicType) {
        Element ret = new Element("harmonicType", mEmslNs).addContent(harmonicType.toLowerCase());
        return ret;
    }

    protected Element createBasisSetType(String basisSetType) {
        Element ret = new Element("basisSetType", mEmslNs).addContent(basisSetType);
        return ret;
    }

    protected Element createEcpType(String ecpType) {
        Element ret = new Element("ecpType", mEmslNs).addContent(ecpType);
        return ret;
    }

    protected Element createContractions(String element) {
        Element ret = new Element("contractions", mEmslNs);
        ret.setAttribute("elementType", element);
        return ret;
    }

    protected boolean isValidShell(String shell) {
        boolean ret = false;
        for (int idx = 0; idx < mShells.length; ++idx) {
            if (!mShells[idx].equals(shell)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected String getMinimumShell() {
        return mShells[0];
    }

    protected String selectMaxShell(String shell, String maxShell) {
        int pos1 = 0;
        int pos2 = 0;
        for (int idx = 0; idx < mShells.length; ++idx) {
            if (mShells[idx].equals(shell)) {
                pos1 = idx;
            }
            if (!mShells[idx].equals(maxShell)) continue;
            pos2 = idx;
        }
        return pos1 > pos2 ? shell : maxShell;
    }

    protected Element createConversionTag(boolean fromEmslLib) {
        Element ret = new Element("conversion", mEmslNs).addContent(String.valueOf(fromEmslLib));
        return ret;
    }

    protected Element createContraction(String shell) {
        Element ret = new Element("contraction", mEmslNs);
        ret.setAttribute("shell", shell);
        return ret;
    }

    protected Element createMatrix(Vector matrix, int rows, int columns) {
        Element ret = new Element("matrix", mCmlNs);
        ret.setAttribute("rows", "" + rows);
        ret.setAttribute("columns", "" + columns);
        ret.setAttribute("dataType", "xs:double");
        StringBuffer text = new StringBuffer();
        for (int idx = 0; idx < matrix.size(); ++idx) {
            text.append((String)matrix.get(idx));
            if ((idx + 1) % columns == 0) {
                text.append("\n");
                continue;
            }
            if (idx != rows * columns - 1) {
                text.append(" ");
                continue;
            }
            text.append("\n");
        }
        ret.setText(new String(text));
        return ret;
    }

    protected Element createMatrix(Matrix matrix) {
        Element ret = new Element("matrix", mCmlNs);
        ret.setAttribute("rows", "" + matrix.getNumRows());
        ret.setAttribute("columns", "" + matrix.getNumColumns());
        ret.setAttribute("dataType", "xs:double");
        ret.setText(matrix.toString());
        return ret;
    }

    protected Element createPotentials(String atom, String nElectrons) {
        Element ret = new Element("potentials", mEmslNs);
        ret.setAttribute("elementType", atom);
        ret.setAttribute("numElectronsReplaced", nElectrons);
        return ret;
    }

    protected Element createPotential(String type, String shell) {
        Element ret = new Element("potential", mEmslNs);
        ret.setAttribute("potentialType", type);
        ret.setAttribute("shell", shell);
        return ret;
    }

    protected Element createBasisMime() {
        Element ret = new Element("format", mDcNs).addContent(BASIS_MIME);
        return ret;
    }

    protected Element createEcpMime() {
        Element ret = new Element("format", mDcNs).addContent(ECP_MIME);
        return ret;
    }

    protected Element createTitle(String title) {
        Element ret = new Element("title", mDcNs).addContent(title);
        return ret;
    }

    protected Element createAlternativeTitle(String altTitle) {
        Element ret = new Element("alternative", mDcNs).addContent(altTitle);
        return ret;
    }

    protected Element createDescription(String text) {
        Element ret = new Element("description", mDcNs).addContent(text);
        return ret;
    }

    protected Element createContractionType(String type) {
        Element ret = new Element("contractionType", mEmslNs);
        if (type.equals(CT_SEGMENTED)) {
            ret.addContent(CT_SEGMENTED);
        } else if (type.equals(CT_UNCONTRACTED)) {
            ret.addContent(CT_UNCONTRACTED);
        } else if (type.equals(CT_GENERAL)) {
            ret.addContent(CT_GENERAL);
        } else {
            ret.addContent(CT_SEGMENTED);
        }
        return ret;
    }

    protected Element createRefLink(String refLink) {
        Element ret = new Element("referencesLink", mEmslNs);
        ret.setAttribute("type", "simple", mXlinkNs);
        ret.setAttribute("href", refLink, mXlinkNs);
        return ret;
    }

    protected Element createEcpLink(String xmlFileName) {
        Element ret = new Element("effectivePotentialsLink", mEmslNs);
        ret.setAttribute("type", "simple", mXlinkNs);
        ret.setAttribute("href", xmlFileName + "-ECP.xml", mXlinkNs);
        return ret;
    }

    protected Element createSoLink(String xmlFileName) {
        Element ret = new Element("spinOrbitLink", mEmslNs);
        ret.setAttribute("type", "simple", mXlinkNs);
        ret.setAttribute("href", xmlFileName + "-SO.xml", mXlinkNs);
        return ret;
    }

    public static void makeFile(File file, Document doc) throws FormatException {
        Format format = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(format);
        try {
            FileOutputStream fis = new FileOutputStream(file);
            outputter.output(doc, (OutputStream)new FileOutputStream(file));
            fis.flush();
            fis.close();
        }
        catch (Exception jdome) {
            throw new FormatException(jdome.getMessage());
        }
    }

    protected String docToString(Document doc) throws FormatException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        return outputter.outputString(doc);
    }

    protected Vector tokenize(String line) {
        Vector<String> columns = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreTokens()) {
            columns.add(tokenizer.nextToken());
        }
        return columns;
    }

    protected Vector tokenize(String line, String delim) {
        Vector<String> columns = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, delim);
        while (tokenizer.hasMoreTokens()) {
            columns.add(tokenizer.nextToken());
        }
        return columns;
    }

    public static String generateContractionDescription(Element atom) throws FormatException {
        int[] expCnts = new int[mShells.length];
        int[] contrCnts = new int[mShells.length];
        for (int i = 0; i < mShells.length; ++i) {
            expCnts[i] = 0;
            contrCnts[i] = 0;
        }
        for (int sdx = 0; sdx < mShells.length; ++sdx) {
            ShellFilter filter = new ShellFilter("contraction", mEmslNs, mShells[sdx]);
            Iterator contractions = atom.getDescendants(filter);
            boolean numContractions = false;
            boolean numExp = false;
            while (contractions.hasNext()) {
                int columns;
                int rows;
                Element el = (Element)contractions.next();
                List matrices = el.getChildren("matrix", mCmlNs);
                Element matrix = (Element)matrices.get(0);
                String rowStr = matrix.getAttributeValue("rows");
                String colStr = matrix.getAttributeValue("columns");
                if (rowStr == null || colStr == null) {
                    throw new FormatException("Unable to determine matrix dimensions");
                }
                try {
                    rows = Integer.parseInt(rowStr);
                    columns = Integer.parseInt(colStr);
                }
                catch (Exception ex) {
                    throw new FormatException("Unable to parse matrix dimensions");
                }
                if (mShells[sdx].equals("SP")) {
                    contrCnts[1] = contrCnts[1] + 1;
                    expCnts[1] = expCnts[1] + rows;
                    contrCnts[2] = contrCnts[2] + 1;
                    expCnts[2] = expCnts[2] + rows;
                    continue;
                }
                if (mShells[sdx].equals("UL")) {
                    contrCnts[1] = contrCnts[1] + (columns - 1);
                    expCnts[1] = expCnts[1] + rows;
                    continue;
                }
                int n = sdx;
                contrCnts[n] = contrCnts[n] + (columns - 1);
                int n2 = sdx;
                expCnts[n2] = expCnts[n2] + rows;
            }
        }
        StringBuffer from = new StringBuffer("(");
        StringBuffer to = new StringBuffer("[");
        boolean isContracted = false;
        for (int i = 0; i < mShells.length; ++i) {
            if (i == 0 || i == 3 || expCnts[i] <= 0) continue;
            from.append("" + expCnts[i] + mShells[i].toLowerCase() + ",");
            to.append("" + contrCnts[i] + mShells[i].toLowerCase() + ",");
            if (expCnts[i] == contrCnts[i]) continue;
            isContracted = true;
        }
        from.setCharAt(from.length() - 1, ')');
        to.setCharAt(to.length() - 1, ']');
        String ret = isContracted ? new String(new String(from) + " -> " + new String(to)) : new String(new String(from));
        return ret;
    }

    public static void addContractionDescriptions(Document doc) throws FormatException {
        Element root = doc.getRootElement();
        List elements = root.getChildren("contractions", mEmslNs);
        int numElements = elements.size();
        int[] expCnts = new int[mShells.length];
        int[] contrCnts = new int[mShells.length];
        for (int idx = 0; idx < numElements; ++idx) {
            Element atom = (Element)elements.get(idx);
            String str = AbstractBasisSetToXml.generateContractionDescription(atom);
            CDATA desc = new CDATA(str);
            Element descEl = new Element("description", mDcNs);
            descEl.addContent(desc);
            atom.addContent(0, descEl);
        }
    }

    public String[] getContractionTypes(Document doc) throws FormatException {
        String[] ret = new String[]{CT_SEGMENTED, CT_GENERAL};
        Element root = doc.getRootElement();
        List elements = root.getChildren("contractions", mEmslNs);
        int numElements = elements.size();
        boolean uncontractedRuleHolds = true;
        Vector<Matrix> shellMatrices = new Vector<Matrix>();
        for (int idx = 0; idx < numElements; ++idx) {
            Element atom = (Element)elements.get(idx);
            block1: for (int sdx = 0; sdx < mShells.length; ++sdx) {
                ShellFilter filter = new ShellFilter("contraction", mEmslNs, mShells[sdx]);
                Iterator contractions = atom.getDescendants(filter);
                shellMatrices.clear();
                boolean numContractions = false;
                boolean numExp = false;
                while (contractions.hasNext()) {
                    if (mShells[sdx].equals("SP")) {
                        uncontractedRuleHolds = false;
                        ret[1] = CT_SEGMENTED;
                        ret[0] = CT_SEGMENTED;
                        continue block1;
                    }
                    Element el = (Element)contractions.next();
                    List matrices = el.getChildren("matrix", mCmlNs);
                    Element matrixEl = (Element)matrices.get(0);
                    Matrix matrix = new Matrix(matrixEl);
                    int rows = matrix.getNumRows();
                    int columns = matrix.getNumColumns();
                    if (uncontractedRuleHolds && (rows > 1 || columns > 2 || rows == 2 && columns == 2 && (double)matrix.getAsFloat(0, 1) != 1.0)) {
                        uncontractedRuleHolds = false;
                    }
                    shellMatrices.add(matrix);
                    if (columns > 2) {
                        ret[1] = CT_GENERAL;
                        ret[0] = CT_GENERAL;
                        continue block1;
                    }
                    boolean areEqual = false;
                    if (shellMatrices.size() > 1) {
                        areEqual = true;
                        Matrix thisMatrix = matrix;
                        Matrix prevMatrix = (Matrix)shellMatrices.get(shellMatrices.size() - 2);
                        int minRow = thisMatrix.getNumRows();
                        if (minRow > prevMatrix.getNumRows()) {
                            minRow = prevMatrix.getNumRows();
                        }
                        for (int row = 0; row < minRow; ++row) {
                            String v2;
                            String v1 = thisMatrix.getValue(row, 0);
                            if (v1.equals(v2 = prevMatrix.getValue(row, 0))) continue;
                            areEqual = false;
                            break;
                        }
                    }
                    if (!areEqual) continue;
                    ret[0] = CT_SEGMENTED;
                    ret[1] = CT_GENERAL;
                    continue block1;
                }
            }
        }
        if (uncontractedRuleHolds) {
            ret[0] = CT_SEGMENTED;
            ret[1] = CT_UNCONTRACTED;
        }
        return ret;
    }

    public void setContractionType(Document doc, String type) {
        Element root = doc.getRootElement();
        Element contraction = root.getChild("contractionType", mEmslNs);
        if (contraction != null) {
            contraction.setText(type);
        }
    }

    public void convertToGenerallyContracted(Document doc) throws FormatException {
        Element root = doc.getRootElement();
        List elements = root.getChildren("contractions", mEmslNs);
        int numElements = elements.size();
        Vector<Matrix> shellMatrices = new Vector<Matrix>();
        Vector<Element> contractionElements = new Vector<Element>();
        for (int idx = 0; idx < numElements; ++idx) {
            Element atom = (Element)elements.get(idx);
            for (int sdx = 0; sdx < mShells.length; ++sdx) {
                ShellFilter filter = new ShellFilter("contraction", mEmslNs, mShells[sdx]);
                Iterator contractions = atom.getDescendants(filter);
                shellMatrices.clear();
                contractionElements.clear();
                boolean numContractions = false;
                boolean numExp = false;
                while (contractions.hasNext()) {
                    Element el = (Element)contractions.next();
                    List matrices = el.getChildren("matrix", mCmlNs);
                    Element matrixEl = (Element)matrices.get(0);
                    Matrix matrix = new Matrix(matrixEl);
                    shellMatrices.add(matrix);
                    contractionElements.add(el);
                }
                if (shellMatrices.size() <= 1) continue;
                Matrix full = (Matrix)shellMatrices.get(0);
                for (int cdx = 1; cdx < shellMatrices.size(); ++cdx) {
                    full = full.merge((Matrix)shellMatrices.get(cdx));
                }
                Element first = (Element)contractionElements.get(0);
                first.removeContent();
                first.addContent(this.createMatrix(full));
                for (int cdx = 1; cdx < contractionElements.size(); ++cdx) {
                    atom.removeContent((Element)contractionElements.get(cdx));
                }
            }
        }
    }
}

