# Copyright (c) 2013-2020, SIB - Swiss Institute of Bioinformatics and
#                          Biozentrum - University of Basel
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


import os
from promod3 import loop
from ost import seq

# Path to StructureDB to which you want to assign the profile information.
# (relative to current working directory!)
db_path = "portable_structure_db_60.dat"

# Directory that contains the profile databases (and only profile databases)
# as generated by the create_structure_profiles.py script.
# (relative to current working directory)
profile_dir = "structure_profile_dbs"

# path to store the StructureDB with assigned_profiles
# (relative to current working directory!)
db_out_path = "portable_structure_db_60_with_structure_profiles.dat"

structure_db = loop.StructureDB.LoadPortable(db_path)

# lets gather all profiles in one ProfileDB
profile_db_files = os.listdir(profile_dir)
profile_db = seq.ProfileDB()

for f in profile_db_files:
  db_path = os.path.join(profile_dir, f)
  loaded_db = seq.ProfileDB.Load(db_path)
  entry_names = loaded_db.GetNames()
  for name in entry_names:
    profile_db.AddProfile(name, loaded_db.GetProfile(name))

# Assign the profiles
for coord_idx in range(structure_db.GetNumCoords()):
  coord_info = structure_db.GetCoordInfo(coord_idx)

  entry_id = coord_info.id
  entry_chain_name = coord_info.chain_name
  full_id = '_'.join([entry_id, entry_chain_name])

  structure_profile = None
  try:
    structure_profile = profile_db.GetProfile(full_id)
  except:
    print("Could not find structure profile for ", full_id, " skip...")
    continue
    
  structure_db.SetStructureProfile(coord_idx, structure_profile)

# DONE! 
structure_db.SavePortable(db_out_path)

