% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dualtree2D.R
\name{convolve2D}
\alias{convolve2D}
\title{Fast Column-wise Convolution of a Matrix}
\usage{
convolve2D(x, y, conj = TRUE, type = c("circular", "open"))
}
\arguments{
\item{x}{MxN matrix.}

\item{y}{numeric sequence of length N.}

\item{conj}{logical; if \code{TRUE}, take the complex \emph{conjugate}
before back-transforming (default, and used for usual convolution).}

\item{type}{character; one of \code{circular}, \code{open} (beginning of
word is ok).  For \code{circular}, the two sequences are treated as
\emph{circular}, i.e., periodic.

For \code{open} and \code{filter}, the sequences are padded with zeros (from
left and right) first; \code{filter} returns the middle sub-vector of
\code{open}, namely, the result of running a weighted mean of \code{x} with
weights \code{y}.}
}
\description{
Use the Fast Fourier Transform to perform convolutions between a sequence
and each column of a matrix.
}
\details{
This is a corrupted version of \code{convolve} made by replacing \code{fft}
with \code{mvfft} in a few places.  It would be nice to submit this to the R
Developers for inclusion.
}
\seealso{
\code{\link{convolve}}
}
\author{
B. Whitcher
}
\keyword{ts}
