/*
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "Supplementable.h"
#include <wtf/TZoneMalloc.h>

namespace WebCore {

class MediaCapabilities;
class Navigator;

class NavigatorMediaCapabilities final : public Supplement<Navigator> {
    WTF_MAKE_TZONE_ALLOCATED(NavigatorMediaCapabilities);
public:
    NavigatorMediaCapabilities();
    ~NavigatorMediaCapabilities();

    static MediaCapabilities& mediaCapabilities(Navigator&);
    static NavigatorMediaCapabilities& from(Navigator&);

    MediaCapabilities& mediaCapabilities() const;
private:
    static ASCIILiteral supplementName() { return "NavigatorMediaCapabilities"_s; }
    bool isNavigatorMediaCapabilities() const final { return true; }

    const Ref<MediaCapabilities> m_mediaCapabilities;
};

} // namespace WebCore

SPECIALIZE_TYPE_TRAITS_BEGIN(WebCore::NavigatorMediaCapabilities)
    static bool isType(const WebCore::SupplementBase& supplement) { return supplement.isNavigatorMediaCapabilities(); }
SPECIALIZE_TYPE_TRAITS_END()
